/**
 * @file ICcDbusIfCreateRuntimeProxy.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Create Runtime Proxy.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Create runtime proxy for CcDbusIf.
 */

#ifndef _I_CC_DBUS_IF_CREATE_RUNTIME_PROXY_H_
#define _I_CC_DBUS_IF_CREATE_RUNTIME_PROXY_H_

#include <string>

namespace ccdbusif {

/**
 *
 */
class ICcDbusIfCreateRuntimeProxy
{
public:
   /**
    * Destructor.
    */
   virtual ~ICcDbusIfCreateRuntimeProxy() {}

   /**
    * Create proxy.
    */
   virtual void createRuntimeProxy(const ::std::string& objPath) = 0;
};

} //ccdbusif

#endif //_I_CC_DBUS_IF_CREATE_RUNTIME_PROXY_H_
