/**
 * @file EvolutionGeniviDbusTypes.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Types.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Types.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_TYPES_H_
#define _EVOLUTION_GENIVI_DBUS_TYPES_H_

#include "CcDbusIfTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * Type definition for UUIDs.
 */
enum UUID
{
   UUID_BASE = 0,
   // -------------------------------------------------------------------------
   UUID_SDP,
   UUID_UDP,
   UUID_RFCOMM,
   UUID_TCP,
   UUID_TCS_BIN,
   UUID_TCS_AT,
   UUID_ATT,
   UUID_OBEX,
   UUID_IP,
   UUID_FTP,
   UUID_HTTP,
   UUID_WSP,
   UUID_BNEP,
   UUID_UPNP,
   UUID_HIDP,
   UUID_HARDCOPYCONTROLCHANNEL,
   UUID_HARDCOPYDATACHANNEL,
   UUID_HARDCOPYNOTIFICATION,
   UUID_AVCTP,
   UUID_AVDTP,
   UUID_CMTP,
   UUID_MCAPCONTROLCHANNEL,
   UUID_MCAPDATACHANNEL,
   UUID_L2CAP,
   // -------------------------------------------------------------------------
   UUID_SERVICEDISCOVERYSERVERSERVICECLASSID,
   UUID_BROWSEGROUPDESCRIPTORSERVICECLASSID,
   UUID_SERIALPORT,
   UUID_LANACCESSUSINGPPP,
   UUID_DIALUPNETWORKING,
   UUID_IRMCSYNC,
   UUID_OBEXOBJECTPUSH,
   UUID_OBEXFILETRANSFER,
   UUID_IRMCSYNCCOMMAND,
   UUID_HEADSET,
   UUID_CORDLESSTELEPHONY,
   UUID_AUDIOSOURCE,
   UUID_AUDIOSINK,
   UUID_A_V_REMOTECONTROLTARGET,
   UUID_ADVANCEDAUDIODISTRIBUTION,
   UUID_A_V_REMOTECONTROL,
   UUID_A_V_REMOTECONTROLCONTROLLER,
   UUID_INTERCOM,
   UUID_FAX,
   UUID_HEADSET_AUDIO_GATEWAY,
   UUID_WAP,
   UUID_WAP_CLIENT,
   UUID_PANU,
   UUID_NAP,
   UUID_GN,
   UUID_DIRECTPRINTING,
   UUID_REFERENCEPRINTING,
   UUID_BASIC_IMAGING_PROFILE,
   UUID_IMAGINGRESPONDER,
   UUID_IMAGINGAUTOMATICARCHIVE,
   UUID_IMAGINGREFERENCEDOBJECTS,
   UUID_HANDSFREE,
   UUID_HANDSFREEAUDIOGATEWAY,
   UUID_DIRECTPRINTINGREFERENCEOBJECTSSERVICE,
   UUID_REFLECTEDUI,
   UUID_BASICPRINTING,
   UUID_PRINTINGSTATUS,
   UUID_HUMANINTERFACEDEVICESERVICE,
   UUID_HARDCOPYCABLEREPLACEMENT,
   UUID_HCR_PRINT,
   UUID_HCR_SCAN,
   UUID_COMMON_ISDN_ACCESS,
   UUID_SIM_ACCESS,
   UUID_PHONEBOOK_ACCESS_PCE,
   UUID_PHONEBOOK_ACCESS_PSE,
   UUID_PHONEBOOK_ACCESS,
   UUID_HEADSET_HS,
   UUID_MESSAGE_ACCESS_SERVER,
   UUID_MESSAGE_NOTIFICATION_SERVER,
   UUID_MESSAGE_ACCESS_PROFILE,
   UUID_GNSS,
   UUID_GNSS_SERVER,
   UUID_3D_DISPLAY,
   UUID_3D_GLASSES,
   UUID_3D_SYNCHRONIZATION,
   UUID_MPS_PROFILE,
   UUID_MPS_SC,
   UUID_CTN_ACCESS_SERVICE,
   UUID_CTN_NOTIFICATION_SERVICE,
   UUID_CTN_PROFILE,
   UUID_PNPINFORMATION,
   UUID_GENERICNETWORKING,
   UUID_GENERICFILETRANSFER,
   UUID_GENERICAUDIO,
   UUID_GENERICTELEPHONY,
   UUID_UPNP_SERVICE,
   UUID_UPNP_IP_SERVICE,
   UUID_ESDP_UPNP_IP_PAN,
   UUID_ESDP_UPNP_IP_LAP,
   UUID_ESDP_UPNP_L2CAP,
   UUID_VIDEOSOURCE,
   UUID_VIDEOSINK,
   UUID_VIDEODISTRIBUTION,
   UUID_HDP,
   UUID_HDP_SOURCE,
   UUID_HDP_SINK,
   // -------------------------------------------------------------------------
   UUID_SYNCML,
   // -------------------------------------------------------------------------
   UUID_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for Adapter properties.
 */
enum AdapterProperty
{
   //------------------------------------------------------------------------------
   //    <property name="Address" type="s" access="read"/>
   // '   <property name=\"(.*)\" type=\".*\" access=\".*\".*' => '   ADAPTER_$1,'
   // then mark block and do CTRL+SHIFT+X
   //------------------------------------------------------------------------------
   ADAPTER_ADDRESS = 0,
   ADAPTER_CLASS,
   ADAPTER_ALIAS,
   ADAPTER_POWERED,
   ADAPTER_DISCOVERABLE,
   ADAPTER_DISCOVERABLETIMEOUT,
   ADAPTER_PAIRABLE,
   ADAPTER_PAIRABLETIMEOUT,
   ADAPTER_DISCOVERING,
   ADAPTER_UUIDS,
   ADAPTER_WBSMODE,
   ADAPTER_CONNECTABLE,
   ADAPTER_HCIMODE,
   ADAPTER_VERSION,
   ADAPTER_VERSION_CODE,
   ADAPTER_VERSION_GENIVI_VERSION,
   ADAPTER_VERSION_EVO_VERSION,
   ADAPTER_TRACELEVEL,
   ADAPTER_TRACECATEGORY,
   // -------------------------------------------------------------------------
   ADAPTER_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for AgentManager properties. Here we have no real properties. But we need this definition for parsing.
 */
enum AgentManagerCapabilitySuppValues
{
   AGENT_MANAGER_CAPABILITY_DISPLAYONLY = 0,
   AGENT_MANAGER_CAPABILITY_DISPLAYYESNO,
   AGENT_MANAGER_CAPABILITY_KEYBOARDONLY,
   AGENT_MANAGER_CAPABILITY_NOINPUTNOOUTPUT,
   AGENT_MANAGER_CAPABILITY_KEYBOARDDISPLAY,
   // -------------------------------------------------------------------------
   AGENT_MANAGER_CAPABILITY_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for Device properties.
 */
enum DeviceProperty
{
   DEVICE_ADDRESS = 0,
   DEVICE_CLASS,
   DEVICE_ICON,
   DEVICE_UUIDS,
   DEVICE_PAIRED,
   DEVICE_CONNECTED,
   DEVICE_TRUSTED,
   DEVICE_BLOCKED,
   DEVICE_ALIAS,
   DEVICE_ADAPTER,
   DEVICE_MODALIAS,
   DEVICE_RSSI,
   DEVICE_VENDOR,
   DEVICE_VENDORSOURCE,
   DEVICE_PRODUCT,
   DEVICE_MAPINFO,
   DEVICE_CONNECTEDSERVICE,
   DEVICE_VERSION,
   DEVICE_PBAPINFO,
   // -------------------------------------------------------------------------
   DEVICE_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for Service properties.
 */
enum ServiceProperty
{
   SERVICE_REMOTEUUID = 0,
   SERVICE_STATE,
   SERVICE_DEVICE,
   SERVICE_VERSION,
   // -------------------------------------------------------------------------
   SERVICE_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for service state.
 */
enum ServiceState
{
   SERVICE_STATE_DISCONNECTED = 0,
   SERVICE_STATE_CONNECTING,
   SERVICE_STATE_CONNECTED,
   SERVICE_STATE_DISCONNECTING,
   SERVICE_STATE_ERROR,
   // -------------------------------------------------------------------------
   SERVICE_STATE_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for ObexClient properties. Here we have no real properties. But we need this definition for parsing.
 */
enum ObexClientArgsSuppValues // TODO: separate session types and properties
{
   OBEX_CLIENT_ARGS_MAP = 0,
   OBEX_CLIENT_ARGS_PBAP,
   OBEX_CLIENT_ARGS_TARGET,
   OBEX_CLIENT_ARGS_SOURCE,
   OBEX_CLIENT_ARGS_CHANNEL,
   OBEX_CLIENT_ARGS_INSTANCE_ID,
   // -------------------------------------------------------------------------
   OBEX_CLIENT_ARGS_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for ObexSession properties.
 */
enum ObexSessionProperty
{
   OBEX_SESSION_SOURCE = 0,
   OBEX_SESSION_DESTINATION,
   OBEX_SESSION_CHANNEL,
   OBEX_SESSION_TARGET,
   OBEX_SESSION_INSTANCEID,
   // -------------------------------------------------------------------------
   OBEX_SESSION_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for ObexTransfer properties.
 */
enum ObexTransferProperty
{
   OBEX_TRANSFER_STATUS = 0,
   OBEX_TRANSFER_SESSION,
   OBEX_TRANSFER_NAME,
   OBEX_TRANSFER_TYPE,
   OBEX_TRANSFER_TIME,
   OBEX_TRANSFER_SIZE,
   OBEX_TRANSFER_TRANSFERRED,
   OBEX_TRANSFER_FILENAME,
   // -------------------------------------------------------------------------
   OBEX_TRANSFER_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for HfpCallVolume properties.
 */
enum HfpCallVolumeProperty
{
   HFP_CALL_VOLUME_SPEAKERVOLUME = 0,
   HFP_CALL_VOLUME_MICROPHONEVOLUME,
   // -------------------------------------------------------------------------
   HFP_CALL_VOLUME_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for HfpHandsfree properties.
 */
enum HfpHandsfreeProperty
{
   HFP_HANDSFREE_FEATURES = 0,
   HFP_HANDSFREE_INBANDRINGING,
   HFP_HANDSFREE_VOICERECOGNITION,
   HFP_HANDSFREE_ECHOCANCELINGNOISEREDUCTION,
   HFP_HANDSFREE_BATTERYCHARGELEVEL,
   HFP_HANDSFREE_AUDIO,
   HFP_HANDSFREE_SCOTYPE,
   HFP_HANDSFREE_AUDIOPATH,
   HFP_HANDSFREE_ALLCALLSTATUS,
   HFP_HANDSFREE_CHLDFEATURE,
   HFP_HANDSFREE_AUDIOINDICATOR,
   // -------------------------------------------------------------------------
   HFP_HANDSFREE_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for HFP Handsfree: Features.
 */
enum HfpHandsfreeFeatures
{
   HFP_HANDSFREE_FEATURES_VOICE_RECOGNITION = 0,
   HFP_HANDSFREE_FEATURES_ATTACH_VOICE_TAG,
   HFP_HANDSFREE_FEATURES_3WAY,
   HFP_HANDSFREE_FEATURES_ECNR,
   HFP_HANDSFREE_FEATURES_INBAND_RING,
   HFP_HANDSFREE_FEATURES_REJECT_INCOMING_CALL,
   HFP_HANDSFREE_FEATURES_ENHANCED_CALL_STATUS,
   HFP_HANDSFREE_FEATURES_ENHANCED_CALL_CONTROL,
   HFP_HANDSFREE_FEATURES_EXTENDED_ERROR_CODES,
   HFP_HANDSFREE_FEATURES_CODEC_NEGOTIATION,
   HFP_HANDSFREE_FEATURES_HF_INDICATORS,
   HFP_HANDSFREE_FEATURES_ESCO_S4_AND_T2_SETTING_SUPPORTED,
   // -------------------------------------------------------------------------
   HFP_HANDSFREE_FEATURES_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for HFP Handsfree: Features: supported values.
 */
enum HfpHandsfreeChldFeatureSuppValues
{
   HFP_HANDSFREE_CHLD_FEATURE_0 = 0,
   HFP_HANDSFREE_CHLD_FEATURE_1,
   HFP_HANDSFREE_CHLD_FEATURE_1X,
   HFP_HANDSFREE_CHLD_FEATURE_2,
   HFP_HANDSFREE_CHLD_FEATURE_2X,
   HFP_HANDSFREE_CHLD_FEATURE_3,
   HFP_HANDSFREE_CHLD_FEATURE_4,
   // -------------------------------------------------------------------------
   HFP_HANDSFREE_CHLD_FEATURE_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for HfpModem properties.
 */
enum HfpModemProperty
{
   HFP_MODEM_POWERED = 0,
   HFP_MODEM_NAME,
   HFP_MODEM_INTERFACES,
   HFP_MODEM_TYPE,
   HFP_MODEM_MANUFACTURER,
   HFP_MODEM_MODEL,
   HFP_MODEM_REVISION,
   HFP_MODEM_SERIAL,
   // -------------------------------------------------------------------------
   HFP_MODEM_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for HFP Modem: Interfaces.
 */
enum HfpModemInterfaces
{
   HFP_MODEM_INTERFACE_ORG_OFONO_EVO_SIRI = 0,
   HFP_MODEM_INTERFACE_ORG_OFONO_VOICE_CALL_MANAGER,
   HFP_MODEM_INTERFACE_ORG_OFONO_NETWORK_REGISTRATION,
   HFP_MODEM_INTERFACE_ORG_OFONO_HANDS_FREE,
   HFP_MODEM_INTERFACE_ORG_OFONO_CALL_VOLUME,
   // -------------------------------------------------------------------------
   HFP_MODEM_INTERFACE_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for HFP Modem: Types: supported values.
 */
enum HfpModemTypeSuppValues
{
   HFP_MODEM_TYPE_HFP = 0,
   HFP_MODEM_TYPE_SAP,
   HFP_MODEM_TYPE_HARDWARE,
   // -------------------------------------------------------------------------
   HFP_MODEM_TYPE_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for HfpNetworkOperator properties.
 */
enum HfpNetworkOperatorProperty
{
   HFP_NETWORK_OPERATOR_STATUS = 0,
   HFP_NETWORK_OPERATOR_NAME,
   // -------------------------------------------------------------------------
   HFP_NETWORK_OPERATOR_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for HfpNetworkRegistration properties.
 */
enum HfpNetworkRegistrationProperty
{
   HFP_NETWORK_REGISTRATION_STATUS = 0,
   HFP_NETWORK_REGISTRATION_MOBILECOUNTRYCODE,
   HFP_NETWORK_REGISTRATION_NAME,
   HFP_NETWORK_REGISTRATION_STRENGTH,
   HFP_NETWORK_REGISTRATION_CURRENTOPERATOR,
   // -------------------------------------------------------------------------
   HFP_NETWORK_REGISTRATION_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for HfpSiri properties.
 */
enum HfpSiriProperty
{
   HFP_SIRI_STATUS = 0,
   HFP_SIRI_NR,
   HFP_SIRI_EYESFREEMODE,
   HFP_SIRI_SUPPORTEDTYPE,
   // -------------------------------------------------------------------------
   HFP_SIRI_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for HfpVoiceCall properties.
 */
enum HfpVoiceCallProperty
{
   HFP_VOICE_CALL_LINEIDENTIFICATION = 0,
   HFP_VOICE_CALL_NAME,
   HFP_VOICE_CALL_MULTIPARTY,
   HFP_VOICE_CALL_STATE,
   HFP_VOICE_CALL_EMERGENCY,
   HFP_VOICE_CALL_DIRECTION,
   HFP_VOICE_CALL_MODE,
   HFP_VOICE_CALL_TYPE,
   // -------------------------------------------------------------------------
   HFP_VOICE_CALL_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for HfpVoiceCallManager properties.
 */
enum HfpVoiceCallManagerProperty
{
   HFP_VOICE_CALL_MANAGER_EMERGENCYNUMBERS = 0,
   // -------------------------------------------------------------------------
   HFP_VOICE_CALL_MANAGER_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for Serial properties.
 */
enum SerialProperty
{
   SERIAL_FLOWCTRLRECV = 0,
   // -------------------------------------------------------------------------
   SERIAL_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for LEAdapter properties.
 */
enum LEAdapterProperty
{
   LE_ADAPTER_ADDRESSTYPE = 0,
   LE_ADAPTER_ADDRESS,
   LE_ADAPTER_ALIAS,
   LE_ADAPTER_ADVERTISINGTIMEOUT,
   LE_ADAPTER_DISCOVERABLEMODE,
   LE_ADAPTER_ADVERTISINGDATA,
   LE_ADAPTER_ADVERTISEENABLE,
   // -------------------------------------------------------------------------
   LE_ADAPTER_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for LEDevice properties.
 */
enum LEDeviceProperty
{
   LE_DEVICE_ADDRESSTYPE = 0,
   LE_DEVICE_ADDRESS,
   LE_DEVICE_CONNECTED,
   // -------------------------------------------------------------------------
   LE_DEVICE_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for LESeamlessPairing properties.
 */
enum LESeamlessPairingProperty
{
   LE_SEAMLESS_PAIRING_PAIRINGDATA = 0,
   // -------------------------------------------------------------------------
   LE_SEAMLESS_PAIRING_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for error codes.
 */
enum ErrorCode
{
   ERROR_ORG_BLUEZ_ERROR_INVALIDARGUMENTS = 0,
   ERROR_ORG_BLUEZ_ERROR_INPROGRESS,
   ERROR_ORG_BLUEZ_ERROR_ALREADYEXISTS,
   ERROR_ORG_BLUEZ_ERROR_NOTSUPPORTED,
   ERROR_ORG_BLUEZ_ERROR_NOTCONNECTED,
   ERROR_ORG_BLUEZ_ERROR_ALREADYCONNECTED,
   ERROR_ORG_BLUEZ_ERROR_NOTAVAILABLE,
   ERROR_ORG_BLUEZ_ERROR_NOTAUTHORIZED,
   ERROR_ORG_BLUEZ_ERROR_AGENTNOTAVAILABLE,
   ERROR_ORG_BLUEZ_ERROR_NOTREADY,
   ERROR_ORG_BLUEZ_ERROR_FAILED,
   ERROR_ORG_OFONO_ERROR_INVALIDARGUMENTS,
   ERROR_ORG_OFONO_ERROR_INVALIDFORMAT,
   ERROR_ORG_OFONO_ERROR_NOTIMPLEMENTED,
   ERROR_ORG_OFONO_ERROR_FAILED,
   ERROR_ORG_OFONO_ERROR_INPROGRESS,
   ERROR_ORG_OFONO_ERROR_NOTFOUND,
   ERROR_ORG_OFONO_ERROR_NOTACTIVE,
   ERROR_ORG_OFONO_ERROR_NOTSUPPORTED,
   ERROR_ORG_OFONO_ERROR_NOTAVAILABLE,
   ERROR_ORG_OFONO_ERROR_TIMEDOUT,
   ERROR_ORG_OFONO_ERROR_INUSE,
   ERROR_ORG_OFONO_ERROR_HFP,
   ERROR_ORG_OFONO_ERROR_INTERFACEREMOVED,
   ERROR_ORG_OFONO_ERROR_ACCESSDENIED,
   ERROR_ORG_BLUEZ_OBEX_ERROR_INVALIDARGUMENTS,
   ERROR_ORG_BLUEZ_OBEX_ERROR_FAILED,
   ERROR_ORG_BLUEZ_OBEX_ERROR_FORBIDDEN,
   ERROR_ORG_BLUEZ_OBEX_NOTAUTHORIZED,
   ERROR_ORG_BLUEZ_OBEX_INPROGRESS,
   ERROR_ORG_BLUEZ_ERROR_CONNECTIONLOST,
   ERROR_ORG_BLUEZ_ERROR_AUTHENTICATIONERROR,
   ERROR_ORG_BLUEZ_ERROR_PAIRINGCANCELLED,
   ERROR_ORG_BLUEZ_ERROR_MISSINGPINORKEY,
   ERROR_ORG_BLUEZ_ERROR_UNKNOWNREASON,
   ERROR_ORG_FREEDESKTOP_ERROR_UNKNOWNOBJECT,
   ERROR_UNKNOWN_OPCODE,
   ERROR_ILLEGAL_FORMAT,
   ERROR_ILLEGAL_PARAM,
   ERROR_OPERATION_FAIL,
   ERROR_SYSTEM_BUSY,
   ERROR_ILLEGAL_OPERATION,
   ERROR_ILLEGAL_STATE,
   ERROR_SDP_FAILURE,
   ERROR_ABNORMAL,
   ERROR_ABORTED,
   ERROR_EXTENDED_ERROR,
   ERROR_SDP_CONNECTION_ERROR,
   ERROR_TIMEOUT_ERROR,
   ERROR_RESTRICTED_CONNECTION,
   ERROR_RAW_DATA_ILLEGAL,
   ERROR_SERVICE_NOT_SUPPORTED,
   ERROR_MORE_DATA_EXPECTED,
   ERROR_SESSION_BUSY,
   ERROR_REMOTE_REJECT,
   ERROR_LMP_RESPONSE_TIMEOUT,
   ERROR_CONNECT_TIMEOUT,
   ERROR_ROLE_CHANGE_NOT_ALLOWED,
   ERROR_CONNECT_REJECT_BDADDR,
   ERROR_ACL_EXISTS,
   ERROR_HW_FAILURE,
   ERROR_CONNECT_REJECT_LIMITED_RESOURCES,
   ERROR_CONNECT_REJECT_SECURITY_REASONS,
   ERROR_REMOTE_DISCONNECT_LOW_RESOURCE,
   ERROR_REMOTE_DISCONNECT_POWER_OFF,
   ERROR_PAIRING_NOT_ALLOWED,
   ERROR_CONNECTION_ACCEPT_TIMEOUT,
   ERROR_LOCAL_REJECT,
   ERROR_INTERFACE_REMOVED,
   ERROR_PS_FAILURE,
   ERROR_EMPTY,
   ERROR_ORG_FREEDESKTOP_ERROR_UNKNOWNMETHOD,
   ERROR_ORG_BLUEZ_ERROR_DOESNOTEXIST,
   ERROR_ORG_FREEDESKTOP_ERROR_NOSERVER,
   ERROR_ORG_BLUEZ_ERROR_DISCOVERSERVICESCANCELLED,
   ERROR_ORG_FREEDESKTOP_ERROR_NOREPLY,
   ERROR_NET_CONNMAN_ERROR_FAILED,
   ERROR_NET_CONNMAN_ERROR_INVALIDARGUMENTS,
   ERROR_NET_CONNMAN_ERROR_PERMISSIONDENIED,
   ERROR_NET_CONNMAN_ERROR_PASSPHRASEREQUIRED,
   ERROR_NET_CONNMAN_ERROR_NOTREGISTERED,
   ERROR_NET_CONNMAN_ERROR_NOTUNIQUE,
   ERROR_NET_CONNMAN_ERROR_NOTSUPPORTED,
   ERROR_NET_CONNMAN_ERROR_NOTIMPLEMENTED,
   ERROR_NET_CONNMAN_ERROR_NOTFOUND,
   ERROR_NET_CONNMAN_ERROR_NOCARRIER,
   ERROR_NET_CONNMAN_ERROR_INPROGRESS,
   ERROR_NET_CONNMAN_ERROR_ALREADYEXISTS,
   ERROR_NET_CONNMAN_ERROR_ALREADYENABLED,
   ERROR_NET_CONNMAN_ERROR_ALREADYDISABLED,
   ERROR_NET_CONNMAN_ERROR_ALREADYCONNECTED,
   ERROR_NET_CONNMAN_ERROR_NOTCONNECTED,
   ERROR_NET_CONNMAN_ERROR_OPERATIONABORTED,
   ERROR_NET_CONNMAN_ERROR_OPERATIONTIMEOUT,
   ERROR_NET_CONNMAN_ERROR_INVALIDSERVICE,
   ERROR_NET_CONNMAN_ERROR_INVALIDPROPERTY,
   ERROR_ORG_BLUEZ_OBEX_ALREADYCONNECTED,
   ERROR_ORG_BLUEZ_ERROR_SERVICEINCOMING,
   // -------------------------------------------------------------------------
   ERROR_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for interfaces.
 */
enum Interface
{
   IF_ADAPTER = 0,
   IF_AGENT_MANAGER,
   IF_DEVICE,
   IF_SERVICE,
   IF_TRACE,
   IF_GENIVI_TRACE,
   IF_DM,
   IF_SPP,
   IF_DID,
   IF_DUN,
   IF_PAN,
   IF_HANDSFREE,
   IF_MANAGER,
   IF_MODEM,
   IF_VOICE_CALL,
   IF_VOICE_CALL_MANAGER,
   IF_NETWORK_REGISTRATION,
   IF_NETWORK_OPERATOR,
   IF_CALL_VOLUME,
   IF_SIRI,
   IF_AVP,
   IF_MEDIA_FOLDER,
   IF_MEDIA_ITEM,
   IF_MEDIA_PLAYER,
   IF_MEDIA_TRANSPORT,
   IF_CLIENT,
   IF_PHONEBOOK_ACCESS,
   IF_SESSION,
   IF_TRANSFER,
   IF_MESSAGE,
   IF_MESSAGE_ACCESS,
   IF_NETWORK,
   IF_SERIAL,
   IF_LE_ADAPTER,
   IF_LE_DEVICE,
   IF_LE_SEAMLESS_PAIRING,
   // -------------------------------------------------------------------------
   IF_UNKNOWN /**< end marker, must be the last one */
};

void printTypeSizes(void);

const char* getAdapterProperty2String(const int value);

const char* getDeviceProperty2String(const int value);

const char* getServiceProperty2String(const int value);

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_TYPES_H_
