/**
 * @file EvolutionGeniviDbusInterfaces.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Interfaces.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Interfaces.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_INTERFACES_H_
#define _EVOLUTION_GENIVI_DBUS_INTERFACES_H_

#include "IDbusProperty2EnumMapping.h"
#include "EvolutionGeniviDbusTypes.h"
//#include "EvolutionGeniviDbusAdapterProperties.h"
//#include "EvolutionGeniviDbusAgentManagerProperties.h"
//#include "EvolutionGeniviDbusDeviceProperties.h"
//#include "EvolutionGeniviDbusServiceProperties.h"
#include "EvolutionGeniviDbusHfpCallVolumeProperties.h"
#include "EvolutionGeniviDbusHfpHandsfreeProperties.h"
#include "EvolutionGeniviDbusHfpModemProperties.h"
#include "EvolutionGeniviDbusHfpNetworkOperatorProperties.h"
#include "EvolutionGeniviDbusHfpNetworkRegistrationProperties.h"
#include "EvolutionGeniviDbusHfpSiriProperties.h"
#include "EvolutionGeniviDbusHfpVoiceCallManagerProperties.h"
#include "EvolutionGeniviDbusHfpVoiceCallProperties.h"
//#include "EvolutionGeniviDbusObexClientProperties.h"
//#include "EvolutionGeniviDbusObexSessionProperties.h"
//#include "EvolutionGeniviDbusObexTransferProperties.h"
//#include "EvolutionGeniviDbusSerialProperties.h"
//#include "EvolutionGeniviDbusLEAdapterProperties.h"
//#include "EvolutionGeniviDbusLEDeviceProperties.h"
//#include "EvolutionGeniviDbusLESeamlessPairingProperties.h"

//#include "EvolutionGeniviDbusUuids.h"
#include "EvolutionGeniviDbusComponents.h"
#include "EvolutionGeniviDbusErrorCodes.h"

namespace ccdbusif {
namespace evolution {

/**
 * Class for Evolution Genivi interfaces.
 */
class EvolutionGeniviDbusInterfaces : public IDbusProperty2EnumMapping
{
public:
   EvolutionGeniviDbusInterfaces();
   virtual ~EvolutionGeniviDbusInterfaces();
   virtual void getInterfaces(::std::vector<const ::std::map< std::string, int >*>& interfaceList, const ::std::vector< int >& matchingInterfaces) const override;
   ServiceState convertString2ServiceState(const ::std::string& value) const;

   //inline AdapterProperty getAdapterProperty2Enum(const ::std::string& value) const { return (AdapterProperty)_adapterProperties.convertString2Enum(value); }
   //inline const ::std::string& getAdapterProperty2String(const AdapterProperty value) const { return _adapterProperties.convertEnum2String((int)value); }

   //inline AgentManagerCapabilitySuppValues getAgentManagerCapability2Enum(const ::std::string& value) const { return (AgentManagerCapabilitySuppValues)_agentManagerProperties.getCapability2Enum(value); }
   //inline const ::std::string& getAgentManagerCapability2String(const AgentManagerCapabilitySuppValues value) const { return _agentManagerProperties.getCapability2String(value); }

   //inline DeviceProperty getDeviceProperty2Enum(const ::std::string& value) const { return (DeviceProperty)_deviceProperties.convertString2Enum(value); }
   //inline const ::std::string& getDeviceProperty2String(const DeviceProperty value) const { return _deviceProperties.convertEnum2String((int)value); }

   //inline ServiceProperty getServiceProperty2Enum(const ::std::string& value) const { return (ServiceProperty)_serviceProperties.convertString2Enum(value); }
   //inline const ::std::string& getServiceProperty2String(const ServiceProperty value) const { return _serviceProperties.convertEnum2String((int)value); }

   inline HfpHandsfreeProperty getHfpHandsfreeProperty2Enum(const ::std::string& value) const { return (HfpHandsfreeProperty)_hfpHandsfreeProperties.convertString2Enum(value); }
   inline const ::std::string& getHfpHandsfreeProperty2String(const HfpHandsfreeProperty value) const { return _hfpHandsfreeProperties.convertEnum2String((int)value); }

   inline const ::std::map< std::string, int >& getHfpHandsfreeFeatures2EnumList(void) const { return _hfpHandsfreeProperties.getFeatures2EnumList(); }
   inline const ::std::map< std::string, int >* getHfpHandsfreeFeatures2EnumListPtr(void) const { return _hfpHandsfreeProperties.getFeatures2EnumListPtr(); }

   inline const ::std::map< int, const std::string* >& getHfpHandsfreeFeatures2StringList(void) const { return _hfpHandsfreeProperties.getFeatures2StringList(); }
   inline const ::std::map< int, const std::string* >* getHfpHandsfreeFeatures2StringListPtr(void) const { return _hfpHandsfreeProperties.getFeatures2StringListPtr(); }

   inline HfpHandsfreeFeatures getHfpHandsfreeFeatures2Enum(const ::std::string& value) const { return (HfpHandsfreeFeatures)_hfpHandsfreeProperties.getFeatures2Enum(value); }
   inline const ::std::string& getHfpHandsfreeFeatures2String(const HfpHandsfreeFeatures value) const { return _hfpHandsfreeProperties.getFeatures2String(value); }

   inline HfpHandsfreeChldFeatureSuppValues getHfpHandsfreeChldFeature2Enum(const ::std::string& value) const { return (HfpHandsfreeChldFeatureSuppValues)_hfpHandsfreeProperties.getChldFeature2Enum(value); }
   inline const ::std::string& getHfpHandsfreeChldFeature2String(const HfpHandsfreeChldFeatureSuppValues value) const { return _hfpHandsfreeProperties.getChldFeature2String(value); }

   inline HfpCallVolumeProperty getHfpCallVolumeProperty2Enum(const ::std::string& value) const { return (HfpCallVolumeProperty)_hfpCallVolumeProperties.convertString2Enum(value); }
   inline const ::std::string& getHfpCallVolumeProperty2String(const HfpCallVolumeProperty value) const { return _hfpCallVolumeProperties.convertEnum2String((int)value); }

   inline HfpModemProperty getHfpModemProperty2Enum(const ::std::string& value) const { return (HfpModemProperty)_hfpModemProperties.convertString2Enum(value); }
   inline const ::std::string& getHfpModemProperty2String(const HfpModemProperty value) const { return _hfpModemProperties.convertEnum2String((int)value); }

   inline HfpModemInterfaces getHfpModemInterface2Enum(const ::std::string& value) const { return (HfpModemInterfaces)_hfpModemProperties.getInterface2Enum(value); }
   inline const ::std::string& getHfpModemInterface2String(const HfpModemInterfaces value) const { return _hfpModemProperties.getInterface2StringTrace(value); }

   inline HfpModemTypeSuppValues getHfpModemType2Enum(const ::std::string& value) const { return (HfpModemTypeSuppValues)_hfpModemProperties.getType2Enum(value); }
   inline const ::std::string& getHfpModemType2String(const HfpModemTypeSuppValues value) const { return _hfpModemProperties.getType2StringTrace(value); }

   inline HfpNetworkOperatorProperty getHfpNetworkOperatorProperty2Enum(const ::std::string& value) const { return (HfpNetworkOperatorProperty)_hfpNetworkOperatorProperties.convertString2Enum(value); }
   inline const ::std::string& getHfpNetworkOperatorProperty2String(const HfpNetworkOperatorProperty value) const { return _hfpNetworkOperatorProperties.convertEnum2String((int)value); }

   inline HfpNetworkRegistrationProperty getHfpNetworkRegistrationProperty2Enum(const ::std::string& value) const { return (HfpNetworkRegistrationProperty)_hfpNetworkRegistrationProperties.convertString2Enum(value); }
   inline const ::std::string& getHfpNetworkRegistrationProperty2String(const HfpNetworkRegistrationProperty value) const { return _hfpNetworkRegistrationProperties.convertEnum2String((int)value); }

   inline HfpSiriProperty getHfpSiriProperty2Enum(const ::std::string& value) const { return (HfpSiriProperty)_hfpSiriProperties.convertString2Enum(value); }
   inline const ::std::string& getHfpSiriProperty2String(const HfpSiriProperty value) const { return _hfpSiriProperties.convertEnum2String((int)value); }

   inline HfpVoiceCallManagerProperty getHfpVoiceCallManagerProperty2Enum(const ::std::string& value) const { return (HfpVoiceCallManagerProperty)_hfpVoiceCallManagerProperties.convertString2Enum(value); }
   inline const ::std::string& getHfpVoiceCallManagerProperty2String(const HfpVoiceCallManagerProperty value) const { return _hfpVoiceCallManagerProperties.convertEnum2String((int)value); }

   inline HfpVoiceCallProperty getHfpVoiceCallProperty2Enum(const ::std::string& value) const { return (HfpVoiceCallProperty)_hfpVoiceCallProperties.convertString2Enum(value); }
   inline const ::std::string& getHfpVoiceCallProperty2String(const HfpVoiceCallProperty value) const { return _hfpVoiceCallProperties.convertEnum2String((int)value); }

   //inline ObexClientArgsSuppValues getObexClientType2Enum(const ::std::string& value) const { return (ObexClientArgsSuppValues)_obexClientProperties.getType2Enum(value); }
   //inline const ::std::string& getObexClientType2String(const ObexClientArgsSuppValues value) const { return _obexClientProperties.getType2String(value); }

   //inline ObexSessionProperty getObexSessionProperty2Enum(const ::std::string& value) const { return (ObexSessionProperty)_obexSessionProperties.convertString2Enum(value); }
   //inline const ::std::string& getObexSessionProperty2String(const ObexSessionProperty value) const { return _obexSessionProperties.convertEnum2String((int)value); }

   //inline ObexTransferProperty getObexTransferProperty2Enum(const ::std::string& value) const { return (ObexTransferProperty)_obexTransferProperties.convertString2Enum(value); }
   //inline const ::std::string& getObexTransferProperty2String(const ObexTransferProperty value) const { return _obexTransferProperties.convertEnum2String((int)value); }

   //inline SerialProperty getSerialProperty2Enum(const ::std::string& value) const { return (SerialProperty)_serialProperties.convertString2Enum(value); }
   //inline const ::std::string& getSerialProperty2String(const SerialProperty value) const { return _serialProperties.convertEnum2String((int)value); }

   //inline LEAdapterProperty getLEAdapterProperty2Enum(const ::std::string& value) const { return (LEAdapterProperty)_leAdapterProperties.convertString2Enum(value); }
   //inline const ::std::string& getLEAdapterProperty2String(const LEAdapterProperty value) const { return _leAdapterProperties.convertEnum2String((int)value); }

   //inline LEDeviceProperty getLEDeviceProperty2Enum(const ::std::string& value) const { return (LEDeviceProperty)_leDeviceProperties.convertString2Enum(value); }
   //inline const ::std::string& getLEDeviceProperty2String(const LEDeviceProperty value) const { return _leDeviceProperties.convertEnum2String((int)value); }

   //inline LESeamlessPairingProperty getLESeamlessPairingProperty2Enum(const ::std::string& value) const { return (LESeamlessPairingProperty)_leSeamlessPairingProperties.convertString2Enum(value); }
   //inline const ::std::string& getLESeamlessPairingProperty2String(const LESeamlessPairingProperty value) const { return _leSeamlessPairingProperties.convertEnum2String((int)value); }

   //inline UUID getUuid2Enum(const ::std::string& value) const { return _uuids.getUuid2Enum(value); }
   //inline const ::std::string& getUuid2String(const UUID value) const { return _uuids.getUuid2String(value); }
   //inline const ::std::string& getUuid2StringTrace(const UUID value) const { return _uuids.getUuid2StringTrace(value); }
   //inline bool isValidUuid(const ::std::string& value, const bool ignoreCaseSensitive = true) const { return _uuids.isValidUuid(value, ignoreCaseSensitive); }
   //inline bool isShortUuid(UUID& uuid, const ::std::string& value) const { return _uuids.isShortUuid(uuid, value); }

   inline Interface getInterface2Enum(const ::std::string& value) const { return (Interface)_components.convertString2Enum(value); }
   inline const ::std::string& getInterface2String(const Interface value) const { return _components.convertEnum2String((int)value); }
   inline const ::std::string& getInterface2StringTrace(const Interface value) const { return _components.getInterface2StringTrace(value); }

   inline DbusBusType getInterface2BusType(const Interface value) const { return _components.getInterface2BusType(value); }
   inline const ::std::string& getInterface2BusName(const Interface value) const { return _components.getInterface2BusName(value); }
   inline const ::std::string& getInterface2ObjectPath(const Interface value) const { return _components.getInterface2ObjectPath(value); }
   inline const ::std::string& getRootObjectPath(void) const { return _components.getRootObjectPath(); }
   inline const ::std::string& getInterface2Port(const Interface value) const { return _components.getInterface2Port(value); }

   //inline DbusBusType getAgentBusType(void) const { return _components.getAgentBusType(); }
   //inline const ::std::string& getAgentBusName(void) const { return _components.getAgentBusName(); }
   //inline const ::std::string& getAgentObjectPath(void) const { return _components.getAgentObjectPath(); }

   inline ErrorCode getErrorCode2Enum(const ::std::string& value) const { return (ErrorCode)_errorCodes.convertString2Enum(value); }
   inline const ::std::string& getErrorCode2String(const ErrorCode value) const { return _errorCodes.convertEnum2String((int)value); }
   inline const ::std::string& getErrorCode2StringTrace(const ErrorCode value) const { return _errorCodes.getErrorCode2StringTrace(value); }
   inline ErrorCode getErrorCode2Enum(const ::std::string& errorName, const ::std::string& errorMessage) const { return _errorCodes.getErrorCode2Enum(errorName, errorMessage); }

private:
   //EvolutionGeniviDbusAdapterProperties _adapterProperties;
   //EvolutionGeniviDbusAgentManagerProperties _agentManagerProperties;
   //EvolutionGeniviDbusDeviceProperties _deviceProperties;
   //EvolutionGeniviDbusServiceProperties _serviceProperties;
   EvolutionGeniviDbusHfpHandsfreeProperties _hfpHandsfreeProperties;
   EvolutionGeniviDbusHfpCallVolumeProperties _hfpCallVolumeProperties;
   EvolutionGeniviDbusHfpModemProperties _hfpModemProperties;
   EvolutionGeniviDbusHfpNetworkOperatorProperties _hfpNetworkOperatorProperties;
   EvolutionGeniviDbusHfpNetworkRegistrationProperties _hfpNetworkRegistrationProperties;
   EvolutionGeniviDbusHfpSiriProperties _hfpSiriProperties;
   EvolutionGeniviDbusHfpVoiceCallManagerProperties _hfpVoiceCallManagerProperties;
   EvolutionGeniviDbusHfpVoiceCallProperties _hfpVoiceCallProperties;
   //EvolutionGeniviDbusObexClientProperties _obexClientProperties;
   //EvolutionGeniviDbusObexSessionProperties _obexSessionProperties;
   //EvolutionGeniviDbusObexTransferProperties _obexTransferProperties;
   //EvolutionGeniviDbusSerialProperties _serialProperties;
   //EvolutionGeniviDbusLEAdapterProperties _leAdapterProperties;
   //EvolutionGeniviDbusLEDeviceProperties _leDeviceProperties;
   //EvolutionGeniviDbusLESeamlessPairingProperties _leSeamlessPairingProperties;

   //EvolutionGeniviDbusUuids _uuids;
   EvolutionGeniviDbusComponents _components;
   EvolutionGeniviDbusErrorCodes _errorCodes;

   const ::std::string _serviceStateDisconnected; /**< service state disconnected */
   const ::std::string _serviceStateConnecting; /**< service state connecting */
   const ::std::string _serviceStateConnected; /**< service state connected */
   const ::std::string _serviceStateDisconnecting; /**< service state disconnecting */
   const ::std::string _serviceStateError; /**< service state error */
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_INTERFACES_H_
