/**
 * @file gtestunistd.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the declaration of utility functions used by PhoneCallManager
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef gtestunistd_h
#define gtestunistd_h

// Simply defining value 0 to F_OK
#define F_OK 0

enum
{
   FILEACCESS_FAILED = -1,
   FILEACCESS_SUCCESS = 0
};

static int accessReturnValue = 0;

/**
 * This method is used only for Gtest. Used to return the value "accessReturnValue".
 *
 * @param[in]
 * @param[out]
 * @param[in,out]
 *
 * @return
 */
int access(const char *pathname, int mode) throw ()
{
   (void)(pathname);
   (void)(mode);//gen4 warning fix
   return accessReturnValue;
}

/**
 * This method is used only for Gtest. Used to set the value "accessReturnValue".
 *
 * @param[in] telephoneNumber - Telephone to validate
 * @param[out] TelephoneNumber &validTelephoneNumber - Gives the valid telephone number.
 * @param[in,out]
 *
 * @return
 */
void setAccessReturnValue(int value)
{
   accessReturnValue = value;
}

#endif // gtestunistd_h

