/**
 * @file PmConfiguration.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the PmConfiguration class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "PmConfiguration.h"
#include "PmDefaultConfiguration.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/PmConfiguration.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace com
{
namespace bosch
{
namespace pmcommon
{
   PmConfiguration::PmConfiguration() :
      _holdTimeAfterSCODisconnection(HOLD_TIME_AFTER_SCO_DISCONNECTION),
      _holdTimeAfterEndingVRSession(HOLD_TIME_AFTER_ENDING_VR_SESSION),
      _waitTimeForArlResponse(WAIT_TIME_FOR_ARL_RESPONSE),
      _ecnrDataSetForNBSPhoneCall(ECNR_DATASET_PHONE_NB),
      _ecnrDataSetForWBSPhoneCall(ECNR_DATASET_PHONE_WB),
      _ecnrDataSetForNBSVR(ECNR_DATASET_VR_NB),
      _ecnrDataSetForWBSVR(ECNR_DATASET_VR_WB),
      _ecnrDataSetForNBSSIRI(ECNR_DATASET_SIRI_NB),
      _ecnrDataSetForWBSSIRI(ECNR_DATASET_SIRI_WB),
      _supportedTypeForSIRI(SUPPORTED_TYPE_FOR_SIRI),
      _autoRejectThirdIncomingCall(true),
      _waitTimeForAudioPlayerResponse(WAIT_TIME_FOR_AUDIOPLAYER_RESPONSE),
      _phoneSubstateSetForHandsetMode(PHONE_SUBSTATE_HANDSETMODE),
      _maxNumActiveDevices(MAX_NUM_ACTIVE_DEVICES),
      _remoteVolumeControl(true),
      _rvcResponseTimeout(RVC_RESPONSE_TIMEOUT),
      _minAMVolumeLevel(MIN_AM_VOLUME_LEVEL),
      _maxAMVolumeLevel(MAX_AM_VOLUME_LEVEL),
      _gamVoiceRecSourceID(GAM_VOICE_REC_SOURCE_ID),
      _gamDefaultPhoneSourceXID(GAM_DEF_PHONE_SOURCE_X_ID),
      _gamDefaultPhoneSourceOffsetID(GAM_DEF_PHONE_SOURCE_OFFSET_ID),
      _gamDefaultPhoneSourceID(GAM_DEF_PHONE_SOURCE_ID)
   {
   }

   PmConfiguration::~PmConfiguration()
   {
   }

} // namespace pmcommon
} // namespace bosch
} // namespace com

