/**
 * @file PmDefaultConfiguration.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the default configuration values for PM
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCommon
 */

#ifndef PmDefaultConfiguration_h
#define PmDefaultConfiguration_h

#include <string.h>

namespace com
{
namespace bosch
{
namespace pmcommon
{
/**
 * RULE 1: use a class instead of declaring a struct (avoiding problems with copy actions),
 *         implement copy constructor, assignment operator and equality/inequality operator
 *
 * keep following order:
 * - class forward declarations
 * - defines (if really necessary)
 * - typedefs
 * - enums
 * - structs => classes
 */
#define PM_CONFIG_FILEPATH                "/var/opt/bosch/static/connectivity/config/PM_config.json"

#define HOLD_TIME_AFTER_SCO_DISCONNECTION 500

#define HOLD_TIME_AFTER_ENDING_VR_SESSION 1000

#define WAIT_TIME_FOR_ARL_RESPONSE        3500

constexpr int WAIT_TIME_FOR_AUDIOPLAYER_RESPONSE  = 5;

constexpr uint16_t SUPPORTED_TYPE_FOR_SIRI        = 24;

constexpr int RVC_RESPONSE_TIMEOUT                = 500;

constexpr uint16_t MIN_AM_VOLUME_LEVEL            = 5;

constexpr uint16_t MAX_AM_VOLUME_LEVEL            = 40;

constexpr uint16_t GAM_VOICE_REC_SOURCE_ID        = 38;

constexpr uint16_t GAM_DEF_PHONE_SOURCE_X_ID      = 97;

constexpr uint16_t GAM_DEF_PHONE_SOURCE_OFFSET_ID = 95;

constexpr uint16_t GAM_DEF_PHONE_SOURCE_ID        = 27;

/**
 * Ecnr DataSet Values
 */
#define ECNR_DATASET_PHONE_NB        1

#define ECNR_DATASET_PHONE_WB        2

#define ECNR_DATASET_VR_NB           3

#define ECNR_DATASET_VR_WB           4

#define ECNR_DATASET_SIRI_NB         5

#define ECNR_DATASET_SIRI_WB         6

#define PHONE_SUBSTATE_HANDSETMODE   0

#define MAX_NUM_ACTIVE_DEVICES       1

} // namespace pmcommon
} // namespace bosch
} // namespace com

#endif // PmDefaultConfiguration_h
