/**
 * @file JsonReader.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the JsonReader class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file reads, stores and prints the config values from PmConfig Json file.
 *
 * @ingroup PmCommon
 */

#ifndef JsonReader_h
#define JsonReader_h

#include "IDataProvider.h"
#include "PmSingleton.h"

namespace com
{
namespace bosch
{
namespace pmcommon
{
   /**
    * JsonReader class definition
    */
   class JsonReader final : public IDataProvider, public PmSingleton<JsonReader>
   {
   public:
      /**
       * This method is used to read the configuration values from json file
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return bool
       */
      virtual bool readConfiguration(::std::string configFilePath) override;

      /**
       * This method is used to print the configuration values read from json file
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void traceConfiguration() override;

   private:
      friend class PmSingleton<JsonReader>;

      /**
       * Constructor of JsonReader class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      JsonReader();

      /**
       * Copy Constructor of JsonReader class => must not be used.
       *
       * @param[in] other: reference to copy
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      JsonReader(const JsonReader& other);

      /**
       * Overloading '=' operator => must not be used.
       *
       * @param[in] other: reference to copy
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      JsonReader& operator=(JsonReader other);

      /**
       * Destructor of JsonReader class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      ~JsonReader();
   };

} // namespace pmcommon
} // namespace bosch
} // namespace com

#endif //JsonReader_h
