/**
 * @file IDataProvider.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the IDataProvider class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file provides the interfaces for DataProvider classes.
 *
 * @ingroup PmCommon
 */

#ifndef IDataProvider_h
#define IDataProvider_h

#include <string>

namespace com
{
namespace bosch
{
namespace pmcommon
{
   /**
    * IDataProvider class definition
    */
   class IDataProvider
   {
   public:

      /**
       * Destructor of IDataProvider class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      virtual ~IDataProvider() {}

      /**
       * This method is used to read the configuration values
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      virtual bool readConfiguration(::std::string configFilePath) = 0;

      /**
       * This method is used to print the configuration values
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      virtual void traceConfiguration() = 0;
   };

} // namespace pmcommon
} // namespace bosch
} // namespace com

#endif //IDataProvider_h
