/**
 * @file AmSessionController.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the AmSessionController class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file provides the AmSessionController interfaces of PmAudioManager.
 *
 * @ingroup PmAudioManager
 */

#include "AmSessionController.h"
#include "AmMainController.h"
#include "AmIfMessageRequest.h"
#include "AmIfMessageResult.h"
#include "YakinduSmAudioSessionIf.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_AUDIO_MANAGER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/AmSessionController.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_AUDIO_MANAGER
#endif
#endif

namespace pmaudiomanager
{
   AmSessionController::AmSessionController()
   {
      ETG_TRACE_USR1(("AmSessionController: Constructor"));

      _smAudioSessionIf = new YakinduSmAudioSessionIf;
   }

   AmSessionController::~AmSessionController()
   {
      ETG_TRACE_USR1(("AmSessionController: Destructor"));

      if(nullptr != _smAudioSessionIf)
      {
         delete _smAudioSessionIf;
         _smAudioSessionIf = nullptr;
      }
   }

   void AmSessionController::prepareAudioRouteRequest(
         IN std::shared_ptr<AmIfMessage_PrepareAudioRouteRequest> amIfMessage)
   {
      if(nullptr != _smAudioSessionIf)
      {
         _smAudioSessionIf->prepareAudioRouteRequest(amIfMessage);
      }
   }

   void AmSessionController::playAudioFileRequest(IN std::shared_ptr<AmIfMessage_PlayAudioFileRequest> amIfMessage)
   {
      if(nullptr != _smAudioSessionIf)
      {
         _smAudioSessionIf->playAudioFileRequest(amIfMessage);
      }
   }

   void AmSessionController::playHfAudioRequest(IN std::shared_ptr<AmIfMessage_PlayHfAudioRequest> amIfMessage)
   {
      if(nullptr != _smAudioSessionIf)
      {
         _smAudioSessionIf->playHfAudioRequest(amIfMessage);
      }
   }

   void AmSessionController::stopAudioRequest(IN std::shared_ptr<AmIfMessage_StopAudioRequest> amIfMessage)
   {
      if(nullptr != _smAudioSessionIf)
      {
         _smAudioSessionIf->stopAudioRequest(amIfMessage);
      }
   }

   void AmSessionController::pauseAudioRequest(IN std::shared_ptr<AmIfMessage_PauseAudioRequest> amIfMessage)
   {
      if(nullptr != _smAudioSessionIf)
      {
         _smAudioSessionIf->pauseAudioRequest(amIfMessage);
      }
   }

   void AmSessionController::setMicMuteStateRequest(IN std::shared_ptr<AmIfMessage_SetMicMuteStateRequest> amIfMessage)
   {
      if(nullptr != _smAudioSessionIf)
      {
         _smAudioSessionIf->setMicMuteStateRequest(amIfMessage);
      }
   }

   void AmSessionController::ecnrInitializeResult(IN std::shared_ptr<AmIfMessage_EcnrInitializeResult> amIfMessage)
   {
      if(nullptr != _smAudioSessionIf)
      {
         _smAudioSessionIf->ecnrInitializeResult(amIfMessage);
      }
   }

   void AmSessionController::ecnrDestroyResult(IN std::shared_ptr<AmIfMessage_EcnrDestroyResult> amIfMessage)
   {
      if(nullptr != _smAudioSessionIf)
      {
         _smAudioSessionIf->ecnrDestroyResult(amIfMessage);
      }
   }

   void AmSessionController::ecnrSetConfigurationResult(
         IN std::shared_ptr<AmIfMessage_EcnrSetConfigurationResult> amIfMessage)
   {
      if(nullptr != _smAudioSessionIf)
      {
         _smAudioSessionIf->ecnrSetConfigurationResult(amIfMessage);
      }
   }

   void AmSessionController::ecnrSetSendMuteSwitchResult(
         IN std::shared_ptr<AmIfMessage_EcnrSetSendMuteSwitchResult> amIfMessage)
   {
      if(nullptr != _smAudioSessionIf)
      {
         _smAudioSessionIf->ecnrSetSendMuteSwitchResult(amIfMessage);
      }
   }

   void AmSessionController::ecnrStartAudioResult(IN std::shared_ptr<AmIfMessage_EcnrStartAudioResult> amIfMessage)
   {
      if(nullptr != _smAudioSessionIf)
      {
         _smAudioSessionIf->ecnrStartAudioResult(amIfMessage);
      }
   }

   void AmSessionController::ecnrStopAudioResult(IN std::shared_ptr<AmIfMessage_EcnrStopAudioResult> amIfMessage)
   {
      if(nullptr != _smAudioSessionIf)
      {
         _smAudioSessionIf->ecnrStopAudioResult(amIfMessage);
      }
   }

   void AmSessionController::ecnrGetVersionResult(IN std::shared_ptr<AmIfMessage_EcnrGetVersionResult> amIfMessage)
   {
      if(nullptr != _smAudioSessionIf)
      {
         _smAudioSessionIf->ecnrGetVersionResult(amIfMessage);
      }
   }

   void AmSessionController::requestAudioRouteResult(
         IN std::shared_ptr<AmIfMessage_RequestAudioRouteResult> amIfMessage)
   {
      if(nullptr != _smAudioSessionIf)
      {
         _smAudioSessionIf->requestAudioRouteResult(amIfMessage);
      }
   }

   void AmSessionController::releaseAudioRouteResult(
         IN std::shared_ptr<AmIfMessage_ReleaseAudioRouteResult> amIfMessage)
   {
      if(nullptr != _smAudioSessionIf)
      {
         _smAudioSessionIf->releaseAudioRouteResult(amIfMessage);
      }
   }

   void AmSessionController::sourceActivityResult(IN std::shared_ptr<AmIfMessage_SourceActivityResult> amIfMessage)
   {
      if(nullptr != _smAudioSessionIf)
      {
         _smAudioSessionIf->sourceActivityResult(amIfMessage);
      }
   }

   void AmSessionController::playbackStatus(IN std::shared_ptr<AmIfMessage_PlaybackStatus> amIfMessage)
   {
      if(nullptr != _smAudioSessionIf)
      {
         _smAudioSessionIf->playbackStatus(amIfMessage);
      }
   }

} // namespace pmcore
