/* *
 * @file WaitingModeToneAudioSm.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Generated code from WaitingModeToneAudioSm.sct
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 * */

#ifndef WAITINGMODETONEAUDIOSM_H_
#define WAITINGMODETONEAUDIOSM_H_


#include <PmAudioManagerSmTypes.h>
#include <deque>
#include "sc_types.h"
#include "StatemachineInterface.h"
#include "scTracing.h"

/*! \file Header of the state machine 'WaitingModeToneAudioSm'.
*/


#ifndef SCT_EVENTS_WAITINGMODETONEAUDIOSM_H
#define SCT_EVENTS_WAITINGMODETONEAUDIOSM_H
#ifndef SC_INVALID_EVENT_VALUE
#define SC_INVALID_EVENT_VALUE 0
#endif

namespace waitingmodetoneaudiosm_events
{
typedef enum  {
	waitingmodetoneaudiosm_invalid_event = SC_INVALID_EVENT_VALUE,
	SCI_AmClientRequest_PREPARE_WAITING_MODE_TONE_CHANNEL,
	SCI_AmClientRequest_PLAY_WAITING_MODE_TONE,
	SCI_AmClientRequest_PAUSE_WAITING_MODE_TONE,
	SCI_AmClientRequest_STOP_WAITING_MODE_TONE,
	SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_GRANTED,
	SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_DENIED,
	SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_DEALLOCATED,
	SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_ON,
	SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_OFF,
	SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_PAUSE,
	SCI_AudioPlayerResponse_PLAYING_SUCCESS,
	SCI_AudioPlayerResponse_PLAYING_ERROR,
	SCI_AudioPlayerResponse_STOP_SUCCESS,
	SCI_AudioPlayerResponse_STOP_FAILURE,
	InternalSCI_READY_TO_PLAY,
	InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT
} WaitingModeToneAudioSmEventName;

class SctEvent
{
	public:
		SctEvent(WaitingModeToneAudioSmEventName name) : name(name){}
		virtual ~SctEvent(){}
		const WaitingModeToneAudioSmEventName name;
		
};
		
template <typename T>
class TypedSctEvent : public SctEvent
{
	public:
		TypedSctEvent(WaitingModeToneAudioSmEventName name, T value) :
			SctEvent(name),
			value(value)
			{}
		virtual ~TypedSctEvent(){}
		const T value;
};

class SctEvent_SCI_AmClientRequest_PREPARE_WAITING_MODE_TONE_CHANNEL : public SctEvent
{
	public:
		SctEvent_SCI_AmClientRequest_PREPARE_WAITING_MODE_TONE_CHANNEL(WaitingModeToneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AmClientRequest_PLAY_WAITING_MODE_TONE : public TypedSctEvent<FilePath>
{
	public:
		SctEvent_SCI_AmClientRequest_PLAY_WAITING_MODE_TONE(WaitingModeToneAudioSmEventName name, FilePath value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AmClientRequest_PAUSE_WAITING_MODE_TONE : public SctEvent
{
	public:
		SctEvent_SCI_AmClientRequest_PAUSE_WAITING_MODE_TONE(WaitingModeToneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AmClientRequest_STOP_WAITING_MODE_TONE : public SctEvent
{
	public:
		SctEvent_SCI_AmClientRequest_STOP_WAITING_MODE_TONE(WaitingModeToneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_GRANTED : public TypedSctEvent<AudioSink>
{
	public:
		SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_GRANTED(WaitingModeToneAudioSmEventName name, AudioSink value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_DENIED : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_DENIED(WaitingModeToneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_DEALLOCATED : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_DEALLOCATED(WaitingModeToneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_ON : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_ON(WaitingModeToneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_OFF : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_OFF(WaitingModeToneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_PAUSE : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_PAUSE(WaitingModeToneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioPlayerResponse_PLAYING_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_AudioPlayerResponse_PLAYING_SUCCESS(WaitingModeToneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioPlayerResponse_PLAYING_ERROR : public TypedSctEvent<AmResultMessage>
{
	public:
		SctEvent_SCI_AudioPlayerResponse_PLAYING_ERROR(WaitingModeToneAudioSmEventName name, AmResultMessage value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AudioPlayerResponse_STOP_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_AudioPlayerResponse_STOP_SUCCESS(WaitingModeToneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioPlayerResponse_STOP_FAILURE : public TypedSctEvent<AmResultMessage>
{
	public:
		SctEvent_SCI_AudioPlayerResponse_STOP_FAILURE(WaitingModeToneAudioSmEventName name, AmResultMessage value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_InternalSCI_READY_TO_PLAY : public SctEvent
{
	public:
		SctEvent_InternalSCI_READY_TO_PLAY(WaitingModeToneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT : public SctEvent
{
	public:
		SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(WaitingModeToneAudioSmEventName name) : SctEvent(name){};
};

}
#endif /* SCT_EVENTS_WAITINGMODETONEAUDIOSM_H */


/*! Define indices of states in the StateConfVector */
#define SCVI_WAITINGMODETONEAUDIOREGION_IDLE 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_WAITTOPLAYWAITINGMODETONE 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_WAITTOPLAYWAITINGMODETONE_AMCLIENTREQUESTWAITREGION_WAITFORAMCLIENTREQUEST 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_WAITTOPLAYWAITINGMODETONE_AMCLIENTREQUESTWAITREGION_PLAYWAITINGMODETONEREQUEST 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_WAITTOPLAYWAITINGMODETONE_ARLRESPONSEWAITREGION_WAITFORWAITINGMODETONEROUTEALLOCATION 1
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_WAITTOPLAYWAITINGMODETONE_ARLRESPONSEWAITREGION_WAITINGMODETONESAONRECEIVED 1
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_WAITTOPLAYWAITINGMODETONE_ARLRESPONSEWAITREGION_WAITFORSAON 1
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_WAITINGMODETONEPLAYING 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_STOPPLAY 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_STOPPLAY_AUDIOPLAYEROPERATIONREGION_WAITFORPLAYERTOSTOP 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_STOPPLAY_AUDIOPLAYEROPERATIONREGION_PLAYBACKSTOPPED 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_STOPPLAY_AUDIOWRAPPEROPERATIONREGION_WAITFORROUTEDEALLOCATION 1
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_STOPPLAY_AUDIOWRAPPEROPERATIONREGION_WAITINGMODETONECHANNELDEALLOCATED 1
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_WAITFORROUTEDEALLOCATION 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_STREAMINGSTOPPED 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_WAITFORPLAYERSTOP 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_AUTOSAOFF 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE_PAUSEWAITINGMODETONEREGION_WAITPLAYERTOSTOP 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE_PAUSEWAITINGMODETONEREGION_PLAYBACKPAUSED 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE_PAUSEWAITINGMODETONEREGION_PLAYAFTERPLAYERRESPONSE 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE_PAUSEWAITINGMODETONEREGION_PAUSEAFTERPLAYERRESPONSE 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE_PAUSEWAITINGMODETONEREGION_STOPAFTERPLAYERRESPONSE 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE_PAUSEWAITINGMODETONEREGION_AUTOSAPAUSEAFTERPLAYERRESPONSE 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE_PAUSEWAITINGMODETONEREGION_AUTOSAOFFAFTERECNRRESPONSE 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE_PAUSEWAITINGMODETONEREGION_AUTOSAONAFTERPLAYERRESPONSE 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_AUTOSAPAUSE 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_WAITFORPLAYERTOSTOP 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_CHANNELPAUSED 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_AUTOSAOFFAFTERPLAYERRESPONSE 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_STOPAFTERPLAYERRESPONSE 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_SAONAFTERPLAYERRESPONSE 0
#define SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_PAUSEAFTERPLAYERRESPONSE 0


class WaitingModeToneAudioSm : public StatemachineInterface
{
	public:
		WaitingModeToneAudioSm();
		
		~WaitingModeToneAudioSm();
		
		/*! Enumeration of all states */ 
		typedef enum
		{
			WaitingModeToneAudioSm_last_state,
			WaitingModeToneAudioRegion_Idle,
			WaitingModeToneAudioRegion_WaitingModeTonePlay,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse,
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse
		} WaitingModeToneAudioSmStates;
					
		static const sc_integer numStates = 35;
		
		//! Inner class for AmClientRequest interface scope.
		class SCI_AmClientRequest
		{
			public:
				SCI_AmClientRequest(WaitingModeToneAudioSm * parent):
					PREPARE_WAITING_MODE_TONE_CHANNEL_raised(false),
					PLAY_WAITING_MODE_TONE_raised(false),
					PLAY_WAITING_MODE_TONE_value(),
					PAUSE_WAITING_MODE_TONE_raised(false),
					STOP_WAITING_MODE_TONE_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'PREPARE_WAITING_MODE_TONE_CHANNEL' that is defined in the interface scope 'AmClientRequest'. */
				void raise_pREPARE_WAITING_MODE_TONE_CHANNEL();
				
				
				/*! Raises the in event 'PLAY_WAITING_MODE_TONE' that is defined in the interface scope 'AmClientRequest'. */
				void raise_pLAY_WAITING_MODE_TONE(FilePath value);
				
				
				/*! Raises the in event 'PAUSE_WAITING_MODE_TONE' that is defined in the interface scope 'AmClientRequest'. */
				void raise_pAUSE_WAITING_MODE_TONE();
				
				
				/*! Raises the in event 'STOP_WAITING_MODE_TONE' that is defined in the interface scope 'AmClientRequest'. */
				void raise_sTOP_WAITING_MODE_TONE();
				
				
				
			private:
				friend class WaitingModeToneAudioSm;
				/*! Raises the in event 'PREPARE_WAITING_MODE_TONE_CHANNEL' that is defined in the interface scope 'AmClientRequest'. */
				void internal_raise_pREPARE_WAITING_MODE_TONE_CHANNEL();
				sc_boolean PREPARE_WAITING_MODE_TONE_CHANNEL_raised;
				/*! Raises the in event 'PLAY_WAITING_MODE_TONE' that is defined in the interface scope 'AmClientRequest'. */
				void internal_raise_pLAY_WAITING_MODE_TONE(FilePath value);
				sc_boolean PLAY_WAITING_MODE_TONE_raised;
				FilePath PLAY_WAITING_MODE_TONE_value;
				/*! Raises the in event 'PAUSE_WAITING_MODE_TONE' that is defined in the interface scope 'AmClientRequest'. */
				void internal_raise_pAUSE_WAITING_MODE_TONE();
				sc_boolean PAUSE_WAITING_MODE_TONE_raised;
				/*! Raises the in event 'STOP_WAITING_MODE_TONE' that is defined in the interface scope 'AmClientRequest'. */
				void internal_raise_sTOP_WAITING_MODE_TONE();
				sc_boolean STOP_WAITING_MODE_TONE_raised;
				WaitingModeToneAudioSm * parent;
				void dispatch_event(waitingmodetoneaudiosm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AmClientRequest'. */
		SCI_AmClientRequest* getSCI_AmClientRequest();
		
		//! Inner class for AudioWrapperReqIf interface scope.
		class SCI_AudioWrapperReqIf
		{
			public:
				SCI_AudioWrapperReqIf(WaitingModeToneAudioSm * parent):
					parent(parent)
				{}
				
				
				
				
				
			private:
				friend class WaitingModeToneAudioSm;
				WaitingModeToneAudioSm * parent;
				void dispatch_event(waitingmodetoneaudiosm_events::SctEvent * event);
				
				
		};
				//! Inner class for AudioWrapperReqIf interface scope operation callbacks.
				class SCI_AudioWrapperReqIf_OCB
				{
					public:
						virtual ~SCI_AudioWrapperReqIf_OCB() = 0;
						
						virtual void sendAllocateRequest() = 0;
						
						virtual void sendDeAllocateRequest() = 0;
						
						virtual void sendSrcActivityResult(SrcActivity srcActivity) = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_AudioWrapperReqIf_OCB'. */
				void setSCI_AudioWrapperReqIf_OCB(SCI_AudioWrapperReqIf_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_AudioWrapperReqIf'. */
		SCI_AudioWrapperReqIf* getSCI_AudioWrapperReqIf();
		
		//! Inner class for AudioWrapperResponse interface scope.
		class SCI_AudioWrapperResponse
		{
			public:
				SCI_AudioWrapperResponse(WaitingModeToneAudioSm * parent):
					WAITING_MODE_TONE_CHANNEL_GRANTED_raised(false),
					WAITING_MODE_TONE_CHANNEL_GRANTED_value(),
					WAITING_MODE_TONE_CHANNEL_DENIED_raised(false),
					WAITING_MODE_TONE_CHANNEL_DEALLOCATED_raised(false),
					WAITING_MODE_TONE_SA_ON_raised(false),
					WAITING_MODE_TONE_SA_OFF_raised(false),
					WAITING_MODE_TONE_SA_PAUSE_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'WAITING_MODE_TONE_CHANNEL_GRANTED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_wAITING_MODE_TONE_CHANNEL_GRANTED(AudioSink value);
				
				
				/*! Raises the in event 'WAITING_MODE_TONE_CHANNEL_DENIED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_wAITING_MODE_TONE_CHANNEL_DENIED();
				
				
				/*! Raises the in event 'WAITING_MODE_TONE_CHANNEL_DEALLOCATED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_wAITING_MODE_TONE_CHANNEL_DEALLOCATED();
				
				
				/*! Raises the in event 'WAITING_MODE_TONE_SA_ON' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_wAITING_MODE_TONE_SA_ON();
				
				
				/*! Raises the in event 'WAITING_MODE_TONE_SA_OFF' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_wAITING_MODE_TONE_SA_OFF();
				
				
				/*! Raises the in event 'WAITING_MODE_TONE_SA_PAUSE' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_wAITING_MODE_TONE_SA_PAUSE();
				
				
				
			private:
				friend class WaitingModeToneAudioSm;
				/*! Raises the in event 'WAITING_MODE_TONE_CHANNEL_GRANTED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_wAITING_MODE_TONE_CHANNEL_GRANTED(AudioSink value);
				sc_boolean WAITING_MODE_TONE_CHANNEL_GRANTED_raised;
				AudioSink WAITING_MODE_TONE_CHANNEL_GRANTED_value;
				/*! Raises the in event 'WAITING_MODE_TONE_CHANNEL_DENIED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_wAITING_MODE_TONE_CHANNEL_DENIED();
				sc_boolean WAITING_MODE_TONE_CHANNEL_DENIED_raised;
				/*! Raises the in event 'WAITING_MODE_TONE_CHANNEL_DEALLOCATED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_wAITING_MODE_TONE_CHANNEL_DEALLOCATED();
				sc_boolean WAITING_MODE_TONE_CHANNEL_DEALLOCATED_raised;
				/*! Raises the in event 'WAITING_MODE_TONE_SA_ON' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_wAITING_MODE_TONE_SA_ON();
				sc_boolean WAITING_MODE_TONE_SA_ON_raised;
				/*! Raises the in event 'WAITING_MODE_TONE_SA_OFF' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_wAITING_MODE_TONE_SA_OFF();
				sc_boolean WAITING_MODE_TONE_SA_OFF_raised;
				/*! Raises the in event 'WAITING_MODE_TONE_SA_PAUSE' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_wAITING_MODE_TONE_SA_PAUSE();
				sc_boolean WAITING_MODE_TONE_SA_PAUSE_raised;
				WaitingModeToneAudioSm * parent;
				void dispatch_event(waitingmodetoneaudiosm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AudioWrapperResponse'. */
		SCI_AudioWrapperResponse* getSCI_AudioWrapperResponse();
		
		//! Inner class for AudioPlayerReqIf interface scope.
		class SCI_AudioPlayerReqIf
		{
			public:
				SCI_AudioPlayerReqIf(WaitingModeToneAudioSm * parent):
					parent(parent)
				{}
				
				
				
				
				
			private:
				friend class WaitingModeToneAudioSm;
				WaitingModeToneAudioSm * parent;
				void dispatch_event(waitingmodetoneaudiosm_events::SctEvent * event);
				
				
		};
				//! Inner class for AudioPlayerReqIf interface scope operation callbacks.
				class SCI_AudioPlayerReqIf_OCB
				{
					public:
						virtual ~SCI_AudioPlayerReqIf_OCB() = 0;
						
						virtual AmResultCode setAlsaDeviceName(AudioSink sinkName, AudioSource srcName) = 0;
						
						virtual AmResultCode sendPlayFileRequest(FilePath filePath) = 0;
						
						virtual AmResultCode stopPlayback() = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_AudioPlayerReqIf_OCB'. */
				void setSCI_AudioPlayerReqIf_OCB(SCI_AudioPlayerReqIf_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_AudioPlayerReqIf'. */
		SCI_AudioPlayerReqIf* getSCI_AudioPlayerReqIf();
		
		//! Inner class for AudioPlayerResponse interface scope.
		class SCI_AudioPlayerResponse
		{
			public:
				SCI_AudioPlayerResponse(WaitingModeToneAudioSm * parent):
					PLAYING_SUCCESS_raised(false),
					PLAYING_ERROR_raised(false),
					PLAYING_ERROR_value(),
					STOP_SUCCESS_raised(false),
					STOP_FAILURE_raised(false),
					STOP_FAILURE_value(),
					parent(parent)
				{}
				
				/*! Raises the in event 'PLAYING_SUCCESS' that is defined in the interface scope 'AudioPlayerResponse'. */
				void raise_pLAYING_SUCCESS();
				
				
				/*! Raises the in event 'PLAYING_ERROR' that is defined in the interface scope 'AudioPlayerResponse'. */
				void raise_pLAYING_ERROR(AmResultMessage value);
				
				
				/*! Raises the in event 'STOP_SUCCESS' that is defined in the interface scope 'AudioPlayerResponse'. */
				void raise_sTOP_SUCCESS();
				
				
				/*! Raises the in event 'STOP_FAILURE' that is defined in the interface scope 'AudioPlayerResponse'. */
				void raise_sTOP_FAILURE(AmResultMessage value);
				
				
				
			private:
				friend class WaitingModeToneAudioSm;
				/*! Raises the in event 'PLAYING_SUCCESS' that is defined in the interface scope 'AudioPlayerResponse'. */
				void internal_raise_pLAYING_SUCCESS();
				sc_boolean PLAYING_SUCCESS_raised;
				/*! Raises the in event 'PLAYING_ERROR' that is defined in the interface scope 'AudioPlayerResponse'. */
				void internal_raise_pLAYING_ERROR(AmResultMessage value);
				sc_boolean PLAYING_ERROR_raised;
				AmResultMessage PLAYING_ERROR_value;
				/*! Raises the in event 'STOP_SUCCESS' that is defined in the interface scope 'AudioPlayerResponse'. */
				void internal_raise_sTOP_SUCCESS();
				sc_boolean STOP_SUCCESS_raised;
				/*! Raises the in event 'STOP_FAILURE' that is defined in the interface scope 'AudioPlayerResponse'. */
				void internal_raise_sTOP_FAILURE(AmResultMessage value);
				sc_boolean STOP_FAILURE_raised;
				AmResultMessage STOP_FAILURE_value;
				WaitingModeToneAudioSm * parent;
				void dispatch_event(waitingmodetoneaudiosm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AudioPlayerResponse'. */
		SCI_AudioPlayerResponse* getSCI_AudioPlayerResponse();
		
		//! Inner class for WaitingModeToneSmHandler interface scope.
		class SCI_WaitingModeToneSmHandler
		{
			public:
				SCI_WaitingModeToneSmHandler(WaitingModeToneAudioSm * parent):
					parent(parent)
				{}
				
				/*! Gets the value of the variable 'waitingModeToneFilePath' that is defined in the interface scope 'WaitingModeToneSmHandler'. */
				FilePath get_waitingModeToneFilePath() const;
				
				/*! Sets the value of the variable 'waitingModeToneFilePath' that is defined in the interface scope 'WaitingModeToneSmHandler'. */
				void set_waitingModeToneFilePath(FilePath value);
				
				
				/*! Gets the value of the variable 'sinkName' that is defined in the interface scope 'WaitingModeToneSmHandler'. */
				AudioSink get_sinkName() const;
				
				/*! Sets the value of the variable 'sinkName' that is defined in the interface scope 'WaitingModeToneSmHandler'. */
				void set_sinkName(AudioSink value);
				
				
				
				
				
				
			private:
				friend class WaitingModeToneAudioSm;
				FilePath waitingModeToneFilePath;
				AudioSink sinkName;
				WaitingModeToneAudioSm * parent;
				void dispatch_event(waitingmodetoneaudiosm_events::SctEvent * event);
				
				
		};
				//! Inner class for WaitingModeToneSmHandler interface scope operation callbacks.
				class SCI_WaitingModeToneSmHandler_OCB
				{
					public:
						virtual ~SCI_WaitingModeToneSmHandler_OCB() = 0;
						
						virtual void updateWaitingModeToneFilePath(FilePath filePath) = 0;
						
						virtual void updateStatus(RouteState routeState, AmResultMessage msg) = 0;
						
						virtual void updateSinkName(AudioSink sinkName) = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_WaitingModeToneSmHandler_OCB'. */
				void setSCI_WaitingModeToneSmHandler_OCB(SCI_WaitingModeToneSmHandler_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_WaitingModeToneSmHandler'. */
		SCI_WaitingModeToneSmHandler* getSCI_WaitingModeToneSmHandler();
		
		
		/*
		 * Functions inherited from StatemachineInterface
		 */
		virtual void init();
		
		virtual void enter();
		
		virtual void exit();
		
		virtual void runCycle();
		
		/*!
		* Checks if the state machine is active (until 2.4.1 this method was used for states).
		* A state machine is active if it has been entered. It is inactive if it has not been entered at all or if it has been exited.
		*/
		virtual sc_boolean isActive() const;
		
		
		/*!
		* Checks if all active states are final. 
		* If there are no active states then the state machine is considered being inactive. In this case this method returns false.
		*/
		virtual sc_boolean isFinal() const;
		
		void setTraceObserver(ysc::TraceObserver<WaitingModeToneAudioSmStates>* tracingcallback);
		
		ysc::TraceObserver<WaitingModeToneAudioSmStates>* getTraceObserver();
		
		/*! Checks if the specified state is active (until 2.4.1 the used method for states was calles isActive()). */
		sc_boolean isStateActive(WaitingModeToneAudioSmStates state) const;
		
		
		
	protected:
		
		
	private:
		WaitingModeToneAudioSm(const WaitingModeToneAudioSm &rhs);
		WaitingModeToneAudioSm& operator=(const WaitingModeToneAudioSm&);
		
		//! Inner class for internal interface scope.
		class InternalSCI
		{
			public:
				InternalSCI(WaitingModeToneAudioSm * parent):
					READY_TO_PLAY_raised(false),
					SEND_SRC_ACTIVITY_OFF_RESULT_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'READY_TO_PLAY' that is defined in the internal scope. */
				void raise_rEADY_TO_PLAY();
				
				/*! Checks if the out event 'READY_TO_PLAY' that is defined in the internal scope has been raised. */
				sc_boolean isRaised_rEADY_TO_PLAY() const;
				
				
				/*! Raises the in event 'SEND_SRC_ACTIVITY_OFF_RESULT' that is defined in the internal scope. */
				void raise_sEND_SRC_ACTIVITY_OFF_RESULT();
				
				/*! Checks if the out event 'SEND_SRC_ACTIVITY_OFF_RESULT' that is defined in the internal scope has been raised. */
				sc_boolean isRaised_sEND_SRC_ACTIVITY_OFF_RESULT() const;
				
				
				
			private:
				friend class WaitingModeToneAudioSm;
				/*! Raises the in event 'READY_TO_PLAY' that is defined in the internal scope. */
				void internal_raise_rEADY_TO_PLAY();
				sc_boolean READY_TO_PLAY_raised;
				/*! Raises the in event 'SEND_SRC_ACTIVITY_OFF_RESULT' that is defined in the internal scope. */
				void internal_raise_sEND_SRC_ACTIVITY_OFF_RESULT();
				sc_boolean SEND_SRC_ACTIVITY_OFF_RESULT_raised;
				WaitingModeToneAudioSm * parent;
				void dispatch_event(waitingmodetoneaudiosm_events::SctEvent * event);
				
				
		};
		
		//! the maximum number of orthogonal states defines the dimension of the state configuration vector.
		static const sc_ushort maxOrthogonalStates = 2;
		
		
		ysc::TraceObserver<WaitingModeToneAudioSmStates>* ifaceTraceObserver;
		
		WaitingModeToneAudioSmStates stateConfVector[maxOrthogonalStates];
		
		sc_ushort stateConfVectorPosition;
		
		SCI_AmClientRequest ifaceAmClientRequest;
		SCI_AudioWrapperReqIf ifaceAudioWrapperReqIf;
		SCI_AudioWrapperReqIf_OCB* ifaceAudioWrapperReqIf_OCB;
		SCI_AudioWrapperResponse ifaceAudioWrapperResponse;
		SCI_AudioPlayerReqIf ifaceAudioPlayerReqIf;
		SCI_AudioPlayerReqIf_OCB* ifaceAudioPlayerReqIf_OCB;
		SCI_AudioPlayerResponse ifaceAudioPlayerResponse;
		SCI_WaitingModeToneSmHandler ifaceWaitingModeToneSmHandler;
		SCI_WaitingModeToneSmHandler_OCB* ifaceWaitingModeToneSmHandler_OCB;
		InternalSCI ifaceInternalSCI;
		
		// prototypes of all internal functions
		
		void effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_tr0();
		void effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_tr1();
		void effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_tr1();
		void effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_tr2();
		void effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_tr3();
		void effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_tr5();
		void effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_tr7();
		void effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_tr0();
		void effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_tr1();
		void effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_tr2();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused();
		void enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse();
		void enseq_WaitingModeToneAudioRegion_Idle_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_AutoSAOff();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_DeallocateRoute();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopAndDeallocate();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_entry_AutoSAOffAfterEcnrResponse6();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_entry_AutoSAOnAfterPlayerResponse8();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_entry_AutoSAPauseAfterPlayerResponse4();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_entry_PlayWaitingModeTone1();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_entry_StopAfterPlayerResponse0();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPaused();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_entry_AutoSAOffAfterPlayerResponse3();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_entry_StopAfterPlayerResponse4();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse_default();
		void enseq_WaitingModeToneAudioRegion_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_DeallocateRoute();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopAndDeallocate();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSAOff();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_StopAfterPlayerResponse0();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_PlayWaitingModeTone1();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_AutoSAPauseAfterPlayerResponse4();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_AutoSAOffAfterEcnrResponse6();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_AutoSAOnAfterPlayerResponse8();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_default();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAPaused();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_AutoSAOffAfterPlayerResponse3();
		void enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_StopAfterPlayerResponse4();
		void exseq_WaitingModeToneAudioRegion_Idle();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse();
		void exseq_WaitingModeToneAudioRegion();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion();
		void exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion__entry_Default();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region__entry_Default();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_DeallocateRoute();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopAndDeallocate();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSAOff();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion__entry_Default();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_StopAfterPlayerResponse0();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_PlayWaitingModeTone1();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_AutoSAPauseAfterPlayerResponse4();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_AutoSAOffAfterEcnrResponse6();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_AutoSAOnAfterPlayerResponse8();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion__entry_Default();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAPaused();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_AutoSAOffAfterPlayerResponse3();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_StopAfterPlayerResponse4();
		void react_WaitingModeToneAudioRegion__entry_Default();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_ChannelDenied();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_ExitOnChannelDeallocated();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayWaitingModeTone();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopWaitingModeTone();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPause();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOff();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PlayWaitingModeTone();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOff();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_DeallocateRoute();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_ChannelDeallocated();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion__sync0();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion__sync1();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region__sync0();
		void react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region__sync1();
		sc_boolean react();
		sc_boolean WaitingModeToneAudioRegion_Idle_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse_react(const sc_boolean try_transition);
		sc_boolean WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse_react(const sc_boolean try_transition);
		void clearInEvents();
		void clearOutEvents();
		
		
		std::deque<waitingmodetoneaudiosm_events::SctEvent*> internalEventQueue;
		waitingmodetoneaudiosm_events::SctEvent* getNextEvent();
		void dispatch_event(waitingmodetoneaudiosm_events::SctEvent * event);
		std::deque<waitingmodetoneaudiosm_events::SctEvent*> inEventQueue;
		sc_boolean isRunningCycle;
		
		
};


inline WaitingModeToneAudioSm::SCI_AudioWrapperReqIf_OCB::~SCI_AudioWrapperReqIf_OCB() {}
inline WaitingModeToneAudioSm::SCI_AudioPlayerReqIf_OCB::~SCI_AudioPlayerReqIf_OCB() {}
inline WaitingModeToneAudioSm::SCI_WaitingModeToneSmHandler_OCB::~SCI_WaitingModeToneSmHandler_OCB() {}


#endif /* WAITINGMODETONEAUDIOSM_H_ */
