/* *
 * @file VoiceRecAudioSm.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Generated code from VoiceRecAudioSm.sct
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 * */

#ifndef VOICERECAUDIOSM_H_
#define VOICERECAUDIOSM_H_


#include <PmAudioManagerSmTypes.h>
#include <deque>
#include "sc_types.h"
#include "StatemachineInterface.h"
#include "scTracing.h"

/*! \file Header of the state machine 'VoiceRecAudioSm'.
*/


#ifndef SCT_EVENTS_VOICERECAUDIOSM_H
#define SCT_EVENTS_VOICERECAUDIOSM_H
#ifndef SC_INVALID_EVENT_VALUE
#define SC_INVALID_EVENT_VALUE 0
#endif

namespace voicerecaudiosm_events
{
typedef enum  {
	voicerecaudiosm_invalid_event = SC_INVALID_EVENT_VALUE,
	SCI_AmClientRequest_PREPARE_VOICEREC_CHANNEL,
	SCI_AmClientRequest_STREAM_VOICEREC_AUDIO,
	SCI_AmClientRequest_PAUSE_VOICEREC_AUDIO,
	SCI_AmClientRequest_STOP_VOICEREC_AUDIO,
	SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_GRANTED,
	SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_DENIED,
	SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_DEALLOCATED,
	SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_ON,
	SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_OFF,
	SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_PAUSE,
	SCI_EcnrResponse_ECNR_INIT_SUCCESS,
	SCI_EcnrResponse_ECNR_INIT_FAILURE,
	SCI_EcnrResponse_ECNR_SET_CONFIGURATION_SUCCESS,
	SCI_EcnrResponse_ECNR_SET_CONFIGURATION_FAILURE,
	SCI_EcnrResponse_ECNR_START_SUCCESS,
	SCI_EcnrResponse_ECNR_START_FAILURE,
	SCI_EcnrResponse_ECNR_STOP_SUCCESS,
	SCI_EcnrResponse_ECNR_STOP_FAILURE,
	SCI_EcnrResponse_ECNR_DESTROY_SUCCESS,
	SCI_EcnrResponse_ECNR_DESTROY_FAILURE,
	InternalSCI_READY_TO_PLAY,
	InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT
} VoiceRecAudioSmEventName;

class SctEvent
{
	public:
		SctEvent(VoiceRecAudioSmEventName name) : name(name){}
		virtual ~SctEvent(){}
		const VoiceRecAudioSmEventName name;
		
};
		
template <typename T>
class TypedSctEvent : public SctEvent
{
	public:
		TypedSctEvent(VoiceRecAudioSmEventName name, T value) :
			SctEvent(name),
			value(value)
			{}
		virtual ~TypedSctEvent(){}
		const T value;
};

class SctEvent_SCI_AmClientRequest_PREPARE_VOICEREC_CHANNEL : public SctEvent
{
	public:
		SctEvent_SCI_AmClientRequest_PREPARE_VOICEREC_CHANNEL(VoiceRecAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AmClientRequest_STREAM_VOICEREC_AUDIO : public TypedSctEvent<SamplingType>
{
	public:
		SctEvent_SCI_AmClientRequest_STREAM_VOICEREC_AUDIO(VoiceRecAudioSmEventName name, SamplingType value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AmClientRequest_PAUSE_VOICEREC_AUDIO : public SctEvent
{
	public:
		SctEvent_SCI_AmClientRequest_PAUSE_VOICEREC_AUDIO(VoiceRecAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AmClientRequest_STOP_VOICEREC_AUDIO : public SctEvent
{
	public:
		SctEvent_SCI_AmClientRequest_STOP_VOICEREC_AUDIO(VoiceRecAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_GRANTED : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_GRANTED(VoiceRecAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_DENIED : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_DENIED(VoiceRecAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_DEALLOCATED : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_DEALLOCATED(VoiceRecAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_ON : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_ON(VoiceRecAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_OFF : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_OFF(VoiceRecAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_PAUSE : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_PAUSE(VoiceRecAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_EcnrResponse_ECNR_INIT_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_INIT_SUCCESS(VoiceRecAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_EcnrResponse_ECNR_INIT_FAILURE : public TypedSctEvent<AmResultMessage>
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_INIT_FAILURE(VoiceRecAudioSmEventName name, AmResultMessage value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_EcnrResponse_ECNR_SET_CONFIGURATION_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_SET_CONFIGURATION_SUCCESS(VoiceRecAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_EcnrResponse_ECNR_SET_CONFIGURATION_FAILURE : public TypedSctEvent<AmResultMessage>
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_SET_CONFIGURATION_FAILURE(VoiceRecAudioSmEventName name, AmResultMessage value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_EcnrResponse_ECNR_START_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_START_SUCCESS(VoiceRecAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_EcnrResponse_ECNR_START_FAILURE : public TypedSctEvent<AmResultMessage>
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_START_FAILURE(VoiceRecAudioSmEventName name, AmResultMessage value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_EcnrResponse_ECNR_STOP_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_STOP_SUCCESS(VoiceRecAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_EcnrResponse_ECNR_STOP_FAILURE : public TypedSctEvent<AmResultMessage>
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_STOP_FAILURE(VoiceRecAudioSmEventName name, AmResultMessage value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_EcnrResponse_ECNR_DESTROY_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_DESTROY_SUCCESS(VoiceRecAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_EcnrResponse_ECNR_DESTROY_FAILURE : public TypedSctEvent<AmResultMessage>
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_DESTROY_FAILURE(VoiceRecAudioSmEventName name, AmResultMessage value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_InternalSCI_READY_TO_PLAY : public SctEvent
{
	public:
		SctEvent_InternalSCI_READY_TO_PLAY(VoiceRecAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT : public SctEvent
{
	public:
		SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(VoiceRecAudioSmEventName name) : SctEvent(name){};
};

}
#endif /* SCT_EVENTS_VOICERECAUDIOSM_H */


/*! Define indices of states in the StateConfVector */
#define SCVI_VOICERECAUDIOREGION_IDLE 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PREPARINGVOICERECAUDIO 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PREPARINGVOICERECAUDIO_AMCLIENTREQUESTWAITREGION_WAITFORPLAYREQUEST 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PREPARINGVOICERECAUDIO_AMCLIENTREQUESTWAITREGION_READYTOSTREAM 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PREPARINGVOICERECAUDIO_ARLRESPONSEWAITREGION_WAITFORVOICERECROUTEALLOCATION 1
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PREPARINGVOICERECAUDIO_ARLRESPONSEWAITREGION_VOICERECSAONRECEIVED 1
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PREPARINGVOICERECAUDIO_ARLRESPONSEWAITREGION_WAITFORSAON 1
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_WAITFORECNRINIT 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_WAITFORECNRSTART 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_STOPAFTERECNRINIT 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_STOPAFTERECNRSTART 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_AUTOSAOFFATECNRSTART 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_AUTOSAOFFATECNRINIT 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_STREAMING 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_CHANNELPAUSED 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_WAITFORECNRRESPONSE 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_READYTOSTREAM 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_CONFIGUREANDSTREAM 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_CHANNELACTIVATED 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_PLAYAFTERECNRRESPONSE 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED_PAUSEAUDIOREGION_CHANNELPAUSED 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED_PAUSEAUDIOREGION_WAITFORECNRRESPONSE 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED_PAUSEAUDIOREGION_CHANNELACTIVATED 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED_PAUSEAUDIOREGION_PLAYAFTERECNRRESPONSE 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ECNROPERATION_WAITFORECNRSTOP 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ECNROPERATION_WAITFORECNRDESTROY 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ECNROPERATION_ECNRDESTROYED 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ARLOPERATION_WAITFORVOICERECROUTEDEALLOCATION 1
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ARLOPERATION_VOICERECSAOFF 1
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_STREAMINGSTOPPED 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_WAITFORROUTEDEALLOCATION 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL_ECNROPERATION_WAITFORECNRDESTROY 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL_ECNROPERATION_ECNRDESTROYED 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL_ARLOPERATION_WAITFORVOICERECROUTEDEALLOCATION 1
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL_ARLOPERATION_VOICERECSAOFF 1
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_WAITFORECNRDESTROY 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_WAITFORECNRSTOP 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_AUTOSOURCESWITCH 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO_PAUSEVOICERECAUDIOREGION_WAITFORECNRSTOP 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO_PAUSEVOICERECAUDIOREGION_VOICERECAUDIOPAUSED 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO_PAUSEVOICERECAUDIOREGION_PLAYAFTERECNRRESPONSE 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO_PAUSEVOICERECAUDIOREGION_WAITFORECNRCONFIGURE 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO_PAUSEVOICERECAUDIOREGION_PAUSEAFTERECNRRESPONSE 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO_PAUSEVOICERECAUDIOREGION_STOPAFTERECNRRESPONSE 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO_PAUSEVOICERECAUDIOREGION_AUTOSAOFFAFTERECNRRESPONSE 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO_PAUSEVOICERECAUDIOREGION_AUTOSAPAUSEAFTERECNRRESPONSE 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO_PAUSEVOICERECAUDIOREGION_AUTOSAONAFTERECNRRESPONSE 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_WAITFORECNRDESTROY 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_CHANNELAUTOPAUSED 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_WAITFORECNRSTOP 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_STARTTOSTREAM 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_CONFIGUREANDSTREAM 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_AUTOSAOFFAFTERECNRRESPONSE 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_STOPAFTERECNRRESPONSE 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_STOPAFTERECNRSTOP 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_AUTOSAOFFAFTERECNRSTOP 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_PAUSEAFTERECNRDESTROY 0
#define SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_PAUSEAFTERECNRSTOP 0


class VoiceRecAudioSm : public StatemachineInterface
{
	public:
		VoiceRecAudioSm();
		
		~VoiceRecAudioSm();
		
		/*! Enumeration of all states */ 
		typedef enum
		{
			VoiceRecAudioSm_last_state,
			VoiceRecAudioRegion_IDLE,
			VoiceRecAudioRegion_VoiceRecAudio,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy,
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop
		} VoiceRecAudioSmStates;
					
		static const sc_integer numStates = 67;
		
		//! Inner class for AmClientRequest interface scope.
		class SCI_AmClientRequest
		{
			public:
				SCI_AmClientRequest(VoiceRecAudioSm * parent):
					PREPARE_VOICEREC_CHANNEL_raised(false),
					STREAM_VOICEREC_AUDIO_raised(false),
					STREAM_VOICEREC_AUDIO_value(),
					PAUSE_VOICEREC_AUDIO_raised(false),
					STOP_VOICEREC_AUDIO_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'PREPARE_VOICEREC_CHANNEL' that is defined in the interface scope 'AmClientRequest'. */
				void raise_pREPARE_VOICEREC_CHANNEL();
				
				
				/*! Raises the in event 'STREAM_VOICEREC_AUDIO' that is defined in the interface scope 'AmClientRequest'. */
				void raise_sTREAM_VOICEREC_AUDIO(SamplingType value);
				
				
				/*! Raises the in event 'PAUSE_VOICEREC_AUDIO' that is defined in the interface scope 'AmClientRequest'. */
				void raise_pAUSE_VOICEREC_AUDIO();
				
				
				/*! Raises the in event 'STOP_VOICEREC_AUDIO' that is defined in the interface scope 'AmClientRequest'. */
				void raise_sTOP_VOICEREC_AUDIO();
				
				
				
			private:
				friend class VoiceRecAudioSm;
				/*! Raises the in event 'PREPARE_VOICEREC_CHANNEL' that is defined in the interface scope 'AmClientRequest'. */
				void internal_raise_pREPARE_VOICEREC_CHANNEL();
				sc_boolean PREPARE_VOICEREC_CHANNEL_raised;
				/*! Raises the in event 'STREAM_VOICEREC_AUDIO' that is defined in the interface scope 'AmClientRequest'. */
				void internal_raise_sTREAM_VOICEREC_AUDIO(SamplingType value);
				sc_boolean STREAM_VOICEREC_AUDIO_raised;
				SamplingType STREAM_VOICEREC_AUDIO_value;
				/*! Raises the in event 'PAUSE_VOICEREC_AUDIO' that is defined in the interface scope 'AmClientRequest'. */
				void internal_raise_pAUSE_VOICEREC_AUDIO();
				sc_boolean PAUSE_VOICEREC_AUDIO_raised;
				/*! Raises the in event 'STOP_VOICEREC_AUDIO' that is defined in the interface scope 'AmClientRequest'. */
				void internal_raise_sTOP_VOICEREC_AUDIO();
				sc_boolean STOP_VOICEREC_AUDIO_raised;
				VoiceRecAudioSm * parent;
				void dispatch_event(voicerecaudiosm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AmClientRequest'. */
		SCI_AmClientRequest* getSCI_AmClientRequest();
		
		//! Inner class for AudioWrapperReqIf interface scope.
		class SCI_AudioWrapperReqIf
		{
			public:
				SCI_AudioWrapperReqIf(VoiceRecAudioSm * parent):
					parent(parent)
				{}
				
				
				
				
				
			private:
				friend class VoiceRecAudioSm;
				VoiceRecAudioSm * parent;
				void dispatch_event(voicerecaudiosm_events::SctEvent * event);
				
				
		};
				//! Inner class for AudioWrapperReqIf interface scope operation callbacks.
				class SCI_AudioWrapperReqIf_OCB
				{
					public:
						virtual ~SCI_AudioWrapperReqIf_OCB() = 0;
						
						virtual void sendAllocateRequest() = 0;
						
						virtual void sendDeAllocateRequest() = 0;
						
						virtual void sendSrcActivityResult(SrcActivity srcActivity) = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_AudioWrapperReqIf_OCB'. */
				void setSCI_AudioWrapperReqIf_OCB(SCI_AudioWrapperReqIf_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_AudioWrapperReqIf'. */
		SCI_AudioWrapperReqIf* getSCI_AudioWrapperReqIf();
		
		//! Inner class for AudioWrapperResponse interface scope.
		class SCI_AudioWrapperResponse
		{
			public:
				SCI_AudioWrapperResponse(VoiceRecAudioSm * parent):
					VOICEREC_AUDIO_CHANNEL_GRANTED_raised(false),
					VOICEREC_AUDIO_CHANNEL_DENIED_raised(false),
					VOICEREC_AUDIO_CHANNEL_DEALLOCATED_raised(false),
					VOICEREC_AUDIO_SA_ON_raised(false),
					VOICEREC_AUDIO_SA_OFF_raised(false),
					VOICEREC_AUDIO_SA_PAUSE_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'VOICEREC_AUDIO_CHANNEL_GRANTED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_vOICEREC_AUDIO_CHANNEL_GRANTED();
				
				
				/*! Raises the in event 'VOICEREC_AUDIO_CHANNEL_DENIED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_vOICEREC_AUDIO_CHANNEL_DENIED();
				
				
				/*! Raises the in event 'VOICEREC_AUDIO_CHANNEL_DEALLOCATED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_vOICEREC_AUDIO_CHANNEL_DEALLOCATED();
				
				
				/*! Raises the in event 'VOICEREC_AUDIO_SA_ON' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_vOICEREC_AUDIO_SA_ON();
				
				
				/*! Raises the in event 'VOICEREC_AUDIO_SA_OFF' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_vOICEREC_AUDIO_SA_OFF();
				
				
				/*! Raises the in event 'VOICEREC_AUDIO_SA_PAUSE' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_vOICEREC_AUDIO_SA_PAUSE();
				
				
				
			private:
				friend class VoiceRecAudioSm;
				/*! Raises the in event 'VOICEREC_AUDIO_CHANNEL_GRANTED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_vOICEREC_AUDIO_CHANNEL_GRANTED();
				sc_boolean VOICEREC_AUDIO_CHANNEL_GRANTED_raised;
				/*! Raises the in event 'VOICEREC_AUDIO_CHANNEL_DENIED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_vOICEREC_AUDIO_CHANNEL_DENIED();
				sc_boolean VOICEREC_AUDIO_CHANNEL_DENIED_raised;
				/*! Raises the in event 'VOICEREC_AUDIO_CHANNEL_DEALLOCATED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_vOICEREC_AUDIO_CHANNEL_DEALLOCATED();
				sc_boolean VOICEREC_AUDIO_CHANNEL_DEALLOCATED_raised;
				/*! Raises the in event 'VOICEREC_AUDIO_SA_ON' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_vOICEREC_AUDIO_SA_ON();
				sc_boolean VOICEREC_AUDIO_SA_ON_raised;
				/*! Raises the in event 'VOICEREC_AUDIO_SA_OFF' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_vOICEREC_AUDIO_SA_OFF();
				sc_boolean VOICEREC_AUDIO_SA_OFF_raised;
				/*! Raises the in event 'VOICEREC_AUDIO_SA_PAUSE' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_vOICEREC_AUDIO_SA_PAUSE();
				sc_boolean VOICEREC_AUDIO_SA_PAUSE_raised;
				VoiceRecAudioSm * parent;
				void dispatch_event(voicerecaudiosm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AudioWrapperResponse'. */
		SCI_AudioWrapperResponse* getSCI_AudioWrapperResponse();
		
		//! Inner class for EcnrRequest interface scope.
		class SCI_EcnrRequest
		{
			public:
				SCI_EcnrRequest(VoiceRecAudioSm * parent):
					parent(parent)
				{}
				
				
				
				
				
				
				
			private:
				friend class VoiceRecAudioSm;
				VoiceRecAudioSm * parent;
				void dispatch_event(voicerecaudiosm_events::SctEvent * event);
				
				
		};
				//! Inner class for EcnrRequest interface scope operation callbacks.
				class SCI_EcnrRequest_OCB
				{
					public:
						virtual ~SCI_EcnrRequest_OCB() = 0;
						
						virtual AmResultCode sendEcnrInit(SamplingType samplingType) = 0;
						
						virtual AmResultCode sendEcnrSetConfiguration(SamplingType samplingType) = 0;
						
						virtual AmResultCode sendEcnrStart() = 0;
						
						virtual AmResultCode sendEcnrStop() = 0;
						
						virtual AmResultCode sendEcnrDestroy() = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_EcnrRequest_OCB'. */
				void setSCI_EcnrRequest_OCB(SCI_EcnrRequest_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_EcnrRequest'. */
		SCI_EcnrRequest* getSCI_EcnrRequest();
		
		//! Inner class for EcnrResponse interface scope.
		class SCI_EcnrResponse
		{
			public:
				SCI_EcnrResponse(VoiceRecAudioSm * parent):
					ECNR_INIT_SUCCESS_raised(false),
					ECNR_INIT_FAILURE_raised(false),
					ECNR_INIT_FAILURE_value(),
					ECNR_SET_CONFIGURATION_SUCCESS_raised(false),
					ECNR_SET_CONFIGURATION_FAILURE_raised(false),
					ECNR_SET_CONFIGURATION_FAILURE_value(),
					ECNR_START_SUCCESS_raised(false),
					ECNR_START_FAILURE_raised(false),
					ECNR_START_FAILURE_value(),
					ECNR_STOP_SUCCESS_raised(false),
					ECNR_STOP_FAILURE_raised(false),
					ECNR_STOP_FAILURE_value(),
					ECNR_DESTROY_SUCCESS_raised(false),
					ECNR_DESTROY_FAILURE_raised(false),
					ECNR_DESTROY_FAILURE_value(),
					parent(parent)
				{}
				
				/*! Raises the in event 'ECNR_INIT_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_INIT_SUCCESS();
				
				
				/*! Raises the in event 'ECNR_INIT_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_INIT_FAILURE(AmResultMessage value);
				
				
				/*! Raises the in event 'ECNR_SET_CONFIGURATION_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_SET_CONFIGURATION_SUCCESS();
				
				
				/*! Raises the in event 'ECNR_SET_CONFIGURATION_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_SET_CONFIGURATION_FAILURE(AmResultMessage value);
				
				
				/*! Raises the in event 'ECNR_START_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_START_SUCCESS();
				
				
				/*! Raises the in event 'ECNR_START_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_START_FAILURE(AmResultMessage value);
				
				
				/*! Raises the in event 'ECNR_STOP_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_STOP_SUCCESS();
				
				
				/*! Raises the in event 'ECNR_STOP_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_STOP_FAILURE(AmResultMessage value);
				
				
				/*! Raises the in event 'ECNR_DESTROY_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_DESTROY_SUCCESS();
				
				
				/*! Raises the in event 'ECNR_DESTROY_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_DESTROY_FAILURE(AmResultMessage value);
				
				
				
			private:
				friend class VoiceRecAudioSm;
				/*! Raises the in event 'ECNR_INIT_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_INIT_SUCCESS();
				sc_boolean ECNR_INIT_SUCCESS_raised;
				/*! Raises the in event 'ECNR_INIT_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_INIT_FAILURE(AmResultMessage value);
				sc_boolean ECNR_INIT_FAILURE_raised;
				AmResultMessage ECNR_INIT_FAILURE_value;
				/*! Raises the in event 'ECNR_SET_CONFIGURATION_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_SET_CONFIGURATION_SUCCESS();
				sc_boolean ECNR_SET_CONFIGURATION_SUCCESS_raised;
				/*! Raises the in event 'ECNR_SET_CONFIGURATION_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_SET_CONFIGURATION_FAILURE(AmResultMessage value);
				sc_boolean ECNR_SET_CONFIGURATION_FAILURE_raised;
				AmResultMessage ECNR_SET_CONFIGURATION_FAILURE_value;
				/*! Raises the in event 'ECNR_START_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_START_SUCCESS();
				sc_boolean ECNR_START_SUCCESS_raised;
				/*! Raises the in event 'ECNR_START_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_START_FAILURE(AmResultMessage value);
				sc_boolean ECNR_START_FAILURE_raised;
				AmResultMessage ECNR_START_FAILURE_value;
				/*! Raises the in event 'ECNR_STOP_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_STOP_SUCCESS();
				sc_boolean ECNR_STOP_SUCCESS_raised;
				/*! Raises the in event 'ECNR_STOP_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_STOP_FAILURE(AmResultMessage value);
				sc_boolean ECNR_STOP_FAILURE_raised;
				AmResultMessage ECNR_STOP_FAILURE_value;
				/*! Raises the in event 'ECNR_DESTROY_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_DESTROY_SUCCESS();
				sc_boolean ECNR_DESTROY_SUCCESS_raised;
				/*! Raises the in event 'ECNR_DESTROY_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_DESTROY_FAILURE(AmResultMessage value);
				sc_boolean ECNR_DESTROY_FAILURE_raised;
				AmResultMessage ECNR_DESTROY_FAILURE_value;
				VoiceRecAudioSm * parent;
				void dispatch_event(voicerecaudiosm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_EcnrResponse'. */
		SCI_EcnrResponse* getSCI_EcnrResponse();
		
		//! Inner class for VoiceRecAudioSmHandler interface scope.
		class SCI_VoiceRecAudioSmHandler
		{
			public:
				SCI_VoiceRecAudioSmHandler(VoiceRecAudioSm * parent):
					parent(parent)
				{}
				
				/*! Gets the value of the variable 'samplingType' that is defined in the interface scope 'VoiceRecAudioSmHandler'. */
				SamplingType get_samplingType() const;
				
				/*! Sets the value of the variable 'samplingType' that is defined in the interface scope 'VoiceRecAudioSmHandler'. */
				void set_samplingType(SamplingType value);
				
				
				
				
				
			private:
				friend class VoiceRecAudioSm;
				SamplingType samplingType;
				VoiceRecAudioSm * parent;
				void dispatch_event(voicerecaudiosm_events::SctEvent * event);
				
				
		};
				//! Inner class for VoiceRecAudioSmHandler interface scope operation callbacks.
				class SCI_VoiceRecAudioSmHandler_OCB
				{
					public:
						virtual ~SCI_VoiceRecAudioSmHandler_OCB() = 0;
						
						virtual void updateSamplingType(SamplingType samplingType) = 0;
						
						virtual void updateStatus(RouteState routeState, AmResultMessage msg) = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_VoiceRecAudioSmHandler_OCB'. */
				void setSCI_VoiceRecAudioSmHandler_OCB(SCI_VoiceRecAudioSmHandler_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_VoiceRecAudioSmHandler'. */
		SCI_VoiceRecAudioSmHandler* getSCI_VoiceRecAudioSmHandler();
		
		
		/*
		 * Functions inherited from StatemachineInterface
		 */
		virtual void init();
		
		virtual void enter();
		
		virtual void exit();
		
		virtual void runCycle();
		
		/*!
		* Checks if the state machine is active (until 2.4.1 this method was used for states).
		* A state machine is active if it has been entered. It is inactive if it has not been entered at all or if it has been exited.
		*/
		virtual sc_boolean isActive() const;
		
		
		/*!
		* Checks if all active states are final. 
		* If there are no active states then the state machine is considered being inactive. In this case this method returns false.
		*/
		virtual sc_boolean isFinal() const;
		
		void setTraceObserver(ysc::TraceObserver<VoiceRecAudioSmStates>* tracingcallback);
		
		ysc::TraceObserver<VoiceRecAudioSmStates>* getTraceObserver();
		
		/*! Checks if the specified state is active (until 2.4.1 the used method for states was calles isActive()). */
		sc_boolean isStateActive(VoiceRecAudioSmStates state) const;
		
		
		
	protected:
		
		
	private:
		VoiceRecAudioSm(const VoiceRecAudioSm &rhs);
		VoiceRecAudioSm& operator=(const VoiceRecAudioSm&);
		
		//! Inner class for internal interface scope.
		class InternalSCI
		{
			public:
				InternalSCI(VoiceRecAudioSm * parent):
					READY_TO_PLAY_raised(false),
					SEND_SRC_ACTIVITY_OFF_RESULT_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'READY_TO_PLAY' that is defined in the internal scope. */
				void raise_rEADY_TO_PLAY();
				
				/*! Checks if the out event 'READY_TO_PLAY' that is defined in the internal scope has been raised. */
				sc_boolean isRaised_rEADY_TO_PLAY() const;
				
				
				/*! Raises the in event 'SEND_SRC_ACTIVITY_OFF_RESULT' that is defined in the internal scope. */
				void raise_sEND_SRC_ACTIVITY_OFF_RESULT();
				
				/*! Checks if the out event 'SEND_SRC_ACTIVITY_OFF_RESULT' that is defined in the internal scope has been raised. */
				sc_boolean isRaised_sEND_SRC_ACTIVITY_OFF_RESULT() const;
				
				
				
			private:
				friend class VoiceRecAudioSm;
				/*! Raises the in event 'READY_TO_PLAY' that is defined in the internal scope. */
				void internal_raise_rEADY_TO_PLAY();
				sc_boolean READY_TO_PLAY_raised;
				/*! Raises the in event 'SEND_SRC_ACTIVITY_OFF_RESULT' that is defined in the internal scope. */
				void internal_raise_sEND_SRC_ACTIVITY_OFF_RESULT();
				sc_boolean SEND_SRC_ACTIVITY_OFF_RESULT_raised;
				VoiceRecAudioSm * parent;
				void dispatch_event(voicerecaudiosm_events::SctEvent * event);
				
				
		};
		
		//! the maximum number of orthogonal states defines the dimension of the state configuration vector.
		static const sc_ushort maxOrthogonalStates = 2;
		
		
		ysc::TraceObserver<VoiceRecAudioSmStates>* ifaceTraceObserver;
		
		VoiceRecAudioSmStates stateConfVector[maxOrthogonalStates];
		
		sc_ushort stateConfVectorPosition;
		
		SCI_AmClientRequest ifaceAmClientRequest;
		SCI_AudioWrapperReqIf ifaceAudioWrapperReqIf;
		SCI_AudioWrapperReqIf_OCB* ifaceAudioWrapperReqIf_OCB;
		SCI_AudioWrapperResponse ifaceAudioWrapperResponse;
		SCI_EcnrRequest ifaceEcnrRequest;
		SCI_EcnrRequest_OCB* ifaceEcnrRequest_OCB;
		SCI_EcnrResponse ifaceEcnrResponse;
		SCI_VoiceRecAudioSmHandler ifaceVoiceRecAudioSmHandler;
		SCI_VoiceRecAudioSmHandler_OCB* ifaceVoiceRecAudioSmHandler_OCB;
		InternalSCI ifaceInternalSCI;
		
		// prototypes of all internal functions
		
		sc_boolean check_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_0_tr0_tr0();
		sc_boolean check_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_1_tr0_tr0();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_tr0();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_tr1();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr0();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr2();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr5();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr6();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr7();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr9();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr10();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr11();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr12();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_tr4();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_tr2();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_tr3();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_tr1();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_tr1();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_tr2();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_tr4();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_tr6();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr0();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr1();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr4();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr5();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr6();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr7();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr8();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_0_tr0();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_0_tr1();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_1_tr0();
		void effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_1_tr1();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
		void enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream();
		void enseq_VoiceRecAudioRegion_IDLE_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_StreamingOngoing();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecStartStreaming();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_entry_DeallocateRoute8();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_entry_DefaultStop1();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_entry_DestroyEcnrAndDeallocateRoute4();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_entry_StopEcnrAndDestroy3();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_AutoSAPause();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_Ready2Stream();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_AutoSAPause();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_AutoSAOff();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_DeallocateRoute();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_DestroyEcnrAndDeallocateRoute();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_DestroyEcnrOnly();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopEcnrAndDestroy();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_entry_AutoSAOffAfterEcnrResponse3();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_entry_AutoSAOnAfterEcnrResponse9();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_entry_AutoSAPauseAfterEcnrResponse5();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_entry_StopAfterEcnrResponse0();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_StopEcnrAndPause();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_entry_AutoSAOffAfterEcnrResponse2();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_entry_StopAfterEcnrResponse3();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop_default();
		void enseq_VoiceRecAudioRegion_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_VoiceRecStartStreaming();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StreamingOngoing();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_StopEcnrAndDestroy3();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_DestroyEcnrAndDeallocateRoute4();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_DefaultStop1();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_DeallocateRoute8();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_AutoSAPause();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_Ready2Stream();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_AutoSAPause();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DeallocateRoute();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateRoute();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrOnly();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopEcnrAndDestroy();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSAOff();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_StopAfterEcnrResponse0();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_AutoSAOffAfterEcnrResponse3();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_AutoSAPauseAfterEcnrResponse5();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_AutoSAOnAfterEcnrResponse9();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_default();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopEcnrAndPause();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_entry_AutoSAOffAfterEcnrResponse2();
		void enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_entry_StopAfterEcnrResponse3();
		void exseq_VoiceRecAudioRegion_IDLE();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop();
		void exseq_VoiceRecAudioRegion();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion();
		void exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_0();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_1();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion__entry_Default();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion__entry_Default();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_VoiceRecStartStreaming();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_AutoSAPause();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion__entry_Default();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_Ready2Stream();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_AutoSAPause();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion__entry_Default();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StreamingOngoing();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_StopEcnrAndDestroy3();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_DestroyEcnrAndDeallocateRoute4();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_DefaultStop1();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_DeallocateRoute8();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion__entry_Default();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DeallocateRoute();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateRoute();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrOnly();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopEcnrAndDestroy();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSAOff();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__entry_Default();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_StopAfterEcnrResponse0();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_AutoSAOffAfterEcnrResponse3();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_AutoSAPauseAfterEcnrResponse5();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_AutoSAOnAfterEcnrResponse9();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion__entry_Default();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopEcnrAndPause();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_entry_AutoSAOffAfterEcnrResponse2();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_entry_StopAfterEcnrResponse3();
		void react_VoiceRecAudioRegion__entry_Default();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopEcnrAndDestroy();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateRoute();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DefaultStop();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_StreamAudio();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DestroyEcnr();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOff();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DeallocateRoute();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DestroyEcnrAndPause();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ReadyToStream();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_StreamingStarted();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopEcnrAndPause();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudio();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_ExitOnchannelDeallocated();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_ChannelDeallocated();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecStartStreaming();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_DestroEcnrAndDeallocate();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_DestroyEcnr();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPause();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_ChannelDenied();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartStreaming();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureEcnrAndStart();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_DeallocateRoute();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOff();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_DestroyEcnrAndDeallocate();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_DestroyEcnrOnly();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ECNR_STOP_FAILURE();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion__sync0();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion__sync1();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion__sync0();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion__sync1();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion__sync2();
		void react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion__sync3();
		sc_boolean react();
		sc_boolean VoiceRecAudioRegion_IDLE_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy_react(const sc_boolean try_transition);
		sc_boolean VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop_react(const sc_boolean try_transition);
		void clearInEvents();
		void clearOutEvents();
		
		
		std::deque<voicerecaudiosm_events::SctEvent*> internalEventQueue;
		voicerecaudiosm_events::SctEvent* getNextEvent();
		void dispatch_event(voicerecaudiosm_events::SctEvent * event);
		std::deque<voicerecaudiosm_events::SctEvent*> inEventQueue;
		sc_boolean isRunningCycle;
		
		
};


inline VoiceRecAudioSm::SCI_AudioWrapperReqIf_OCB::~SCI_AudioWrapperReqIf_OCB() {}
inline VoiceRecAudioSm::SCI_EcnrRequest_OCB::~SCI_EcnrRequest_OCB() {}
inline VoiceRecAudioSm::SCI_VoiceRecAudioSmHandler_OCB::~SCI_VoiceRecAudioSmHandler_OCB() {}


#endif /* VOICERECAUDIOSM_H_ */
