/* *
 * @file VoiceCallAudioSm.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Generated code from VoiceCallAudioSm.sct
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 * */

#ifndef VOICECALLAUDIOSM_H_
#define VOICECALLAUDIOSM_H_


#include <PmAudioManagerSmTypes.h>
#include <deque>
#include "sc_types.h"
#include "StatemachineInterface.h"
#include "scTracing.h"

/*! \file Header of the state machine 'VoiceCallAudioSm'.
*/


#ifndef SCT_EVENTS_VOICECALLAUDIOSM_H
#define SCT_EVENTS_VOICECALLAUDIOSM_H
#ifndef SC_INVALID_EVENT_VALUE
#define SC_INVALID_EVENT_VALUE 0
#endif

namespace voicecallaudiosm_events
{
typedef enum  {
	voicecallaudiosm_invalid_event = SC_INVALID_EVENT_VALUE,
	SCI_AmClientRequest_PREPARE_VOICECALL_CHANNEL,
	SCI_AmClientRequest_STREAM_VOICECALL_AUDIO,
	SCI_AmClientRequest_PAUSE_VOICECALL_AUDIO,
	SCI_AmClientRequest_STOP_VOICECALL_AUDIO,
	SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_GRANTED,
	SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_DENIED,
	SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_DEALLOCATED,
	SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_ON,
	SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_OFF,
	SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_PAUSE,
	SCI_EcnrResponse_ECNR_INIT_SUCCESS,
	SCI_EcnrResponse_ECNR_INIT_FAILURE,
	SCI_EcnrResponse_ECNR_SET_CONFIGURATION_SUCCESS,
	SCI_EcnrResponse_ECNR_SET_CONFIGURATION_FAILURE,
	SCI_EcnrResponse_ECNR_START_SUCCESS,
	SCI_EcnrResponse_ECNR_START_FAILURE,
	SCI_EcnrResponse_ECNR_STOP_SUCCESS,
	SCI_EcnrResponse_ECNR_STOP_FAILURE,
	SCI_EcnrResponse_ECNR_DESTROY_SUCCESS,
	SCI_EcnrResponse_ECNR_DESTROY_FAILURE,
	InternalSCI_READY_TO_PLAY,
	InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT
} VoiceCallAudioSmEventName;

class SctEvent
{
	public:
		SctEvent(VoiceCallAudioSmEventName name) : name(name){}
		virtual ~SctEvent(){}
		const VoiceCallAudioSmEventName name;
		
};
		
template <typename T>
class TypedSctEvent : public SctEvent
{
	public:
		TypedSctEvent(VoiceCallAudioSmEventName name, T value) :
			SctEvent(name),
			value(value)
			{}
		virtual ~TypedSctEvent(){}
		const T value;
};

class SctEvent_SCI_AmClientRequest_PREPARE_VOICECALL_CHANNEL : public SctEvent
{
	public:
		SctEvent_SCI_AmClientRequest_PREPARE_VOICECALL_CHANNEL(VoiceCallAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AmClientRequest_STREAM_VOICECALL_AUDIO : public TypedSctEvent<SamplingType>
{
	public:
		SctEvent_SCI_AmClientRequest_STREAM_VOICECALL_AUDIO(VoiceCallAudioSmEventName name, SamplingType value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AmClientRequest_PAUSE_VOICECALL_AUDIO : public SctEvent
{
	public:
		SctEvent_SCI_AmClientRequest_PAUSE_VOICECALL_AUDIO(VoiceCallAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AmClientRequest_STOP_VOICECALL_AUDIO : public SctEvent
{
	public:
		SctEvent_SCI_AmClientRequest_STOP_VOICECALL_AUDIO(VoiceCallAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_GRANTED : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_GRANTED(VoiceCallAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_DENIED : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_DENIED(VoiceCallAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_DEALLOCATED : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_DEALLOCATED(VoiceCallAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_ON : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_ON(VoiceCallAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_OFF : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_OFF(VoiceCallAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_PAUSE : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_PAUSE(VoiceCallAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_EcnrResponse_ECNR_INIT_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_INIT_SUCCESS(VoiceCallAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_EcnrResponse_ECNR_INIT_FAILURE : public TypedSctEvent<AmResultMessage>
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_INIT_FAILURE(VoiceCallAudioSmEventName name, AmResultMessage value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_EcnrResponse_ECNR_SET_CONFIGURATION_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_SET_CONFIGURATION_SUCCESS(VoiceCallAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_EcnrResponse_ECNR_SET_CONFIGURATION_FAILURE : public TypedSctEvent<AmResultMessage>
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_SET_CONFIGURATION_FAILURE(VoiceCallAudioSmEventName name, AmResultMessage value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_EcnrResponse_ECNR_START_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_START_SUCCESS(VoiceCallAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_EcnrResponse_ECNR_START_FAILURE : public TypedSctEvent<AmResultMessage>
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_START_FAILURE(VoiceCallAudioSmEventName name, AmResultMessage value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_EcnrResponse_ECNR_STOP_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_STOP_SUCCESS(VoiceCallAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_EcnrResponse_ECNR_STOP_FAILURE : public TypedSctEvent<AmResultMessage>
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_STOP_FAILURE(VoiceCallAudioSmEventName name, AmResultMessage value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_EcnrResponse_ECNR_DESTROY_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_DESTROY_SUCCESS(VoiceCallAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_EcnrResponse_ECNR_DESTROY_FAILURE : public TypedSctEvent<AmResultMessage>
{
	public:
		SctEvent_SCI_EcnrResponse_ECNR_DESTROY_FAILURE(VoiceCallAudioSmEventName name, AmResultMessage value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_InternalSCI_READY_TO_PLAY : public SctEvent
{
	public:
		SctEvent_InternalSCI_READY_TO_PLAY(VoiceCallAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT : public SctEvent
{
	public:
		SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(VoiceCallAudioSmEventName name) : SctEvent(name){};
};

}
#endif /* SCT_EVENTS_VOICECALLAUDIOSM_H */


/*! Define indices of states in the StateConfVector */
#define SCVI_VOICECALLAUDIOREGION_IDLE 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PREPARINGVOICECALLAUDIO 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PREPARINGVOICECALLAUDIO_AMCLIENTREQUESTWAITREGION_WAITFORPLAYREQUEST 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PREPARINGVOICECALLAUDIO_AMCLIENTREQUESTWAITREGION_READYTOSTREAM 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PREPARINGVOICECALLAUDIO_ARLRESPONSEWAITREGION_WAITFORPHONEROUTEALLOCATION 1
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PREPARINGVOICECALLAUDIO_ARLRESPONSEWAITREGION_VOICECALLSAONRECEIVED 1
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PREPARINGVOICECALLAUDIO_ARLRESPONSEWAITREGION_WAITFORSAON 1
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_WAITFORECNRINIT 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_WAITFORECNRSTART 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_STOPAFTERECNRINIT 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_STOPAFTERECNRSTART 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_AUTOSAOFFATECNRSTART 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_AUTOSAOFFATECNRINIT 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_STREAMING 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_CHANNELPAUSED 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_WAITFORECNRRESPONSE 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_READYTOSTREAM 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_CONFIGUREANDSTREAM 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_CHANNELACTIVATED 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_PLAYAFTERECNRRESPONSE 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED_PAUSEAUDIOREGION_CHANNELPAUSED 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED_PAUSEAUDIOREGION_WAITFORECNRRESPONSE 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED_PAUSEAUDIOREGION_CHANNELACTIVATED 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED_PAUSEAUDIOREGION_PLAYAFTERECNRRESPONSE 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ECNROPERATION_WAITFORECNRSTOP 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ECNROPERATION_WAITFORECNRDESTROY 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ECNROPERATION_ECNRDESTROYED 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ARLOPERATION_WAITFORPHONEROUTEDEALLOCATION 1
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ARLOPERATION_VOICECALLSAOFF 1
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_STREAMINGSTOPPED 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_WAITFORROUTEDEALLOCATION 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL_ECNROPERATION_WAITFORECNRDESTROY 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL_ECNROPERATION_ECNRDESTROYED 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL_ARLOPERATION_WAITFORPHONEROUTEDEALLOCATION 1
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL_ARLOPERATION_VOICECALLSAOFF 1
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_WAITFORECNRDESTROY 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_WAITFORECNRSTOP 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_AUTOSOURCESWITCH 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO_PAUSEVOICECALLAUDIOREGION_WAITFORECNRSTOP 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO_PAUSEVOICECALLAUDIOREGION_VOICECALLAUDIOPAUSED 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO_PAUSEVOICECALLAUDIOREGION_PLAYAFTERECNRRESPONSE 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO_PAUSEVOICECALLAUDIOREGION_WAITFORECNRCONFIGURE 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO_PAUSEVOICECALLAUDIOREGION_PAUSEAFTERECNRRESPONSE 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO_PAUSEVOICECALLAUDIOREGION_STOPAFTERECNRRESPONSE 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO_PAUSEVOICECALLAUDIOREGION_AUTOSAOFFAFTERECNRRESPONSE 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO_PAUSEVOICECALLAUDIOREGION_AUTOSAPAUSEAFTERECNRRESPONSE 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO_PAUSEVOICECALLAUDIOREGION_AUTOSAONAFTERECNRRESPONSE 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_WAITFORECNRDESTROY 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_CHANNELAUTOPAUSED 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_WAITFORECNRSTOP 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_STARTTOSTREAM 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_CONFIGUREANDSTREAM 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_AUTOSAOFFAFTERECNRRESPONSE 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_STOPAFTERECNRRESPONSE 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_STOPAFTERECNRSTOP 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_AUTOSAOFFAFTERECNRSTOP 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_PAUSEAFTERECNRDESTROY 0
#define SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_PAUSEAFTERECNRSTOP 0


class VoiceCallAudioSm : public StatemachineInterface
{
	public:
		VoiceCallAudioSm();
		
		~VoiceCallAudioSm();
		
		/*! Enumeration of all states */ 
		typedef enum
		{
			VoiceCallAudioSm_last_state,
			VoiceCallAudioRegion_IDLE,
			VoiceCallAudioRegion_VoiceCallAudio,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy,
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop
		} VoiceCallAudioSmStates;
					
		static const sc_integer numStates = 67;
		
		//! Inner class for AmClientRequest interface scope.
		class SCI_AmClientRequest
		{
			public:
				SCI_AmClientRequest(VoiceCallAudioSm * parent):
					PREPARE_VOICECALL_CHANNEL_raised(false),
					STREAM_VOICECALL_AUDIO_raised(false),
					STREAM_VOICECALL_AUDIO_value(),
					PAUSE_VOICECALL_AUDIO_raised(false),
					STOP_VOICECALL_AUDIO_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'PREPARE_VOICECALL_CHANNEL' that is defined in the interface scope 'AmClientRequest'. */
				void raise_pREPARE_VOICECALL_CHANNEL();
				
				
				/*! Raises the in event 'STREAM_VOICECALL_AUDIO' that is defined in the interface scope 'AmClientRequest'. */
				void raise_sTREAM_VOICECALL_AUDIO(SamplingType value);
				
				
				/*! Raises the in event 'PAUSE_VOICECALL_AUDIO' that is defined in the interface scope 'AmClientRequest'. */
				void raise_pAUSE_VOICECALL_AUDIO();
				
				
				/*! Raises the in event 'STOP_VOICECALL_AUDIO' that is defined in the interface scope 'AmClientRequest'. */
				void raise_sTOP_VOICECALL_AUDIO();
				
				
				
			private:
				friend class VoiceCallAudioSm;
				/*! Raises the in event 'PREPARE_VOICECALL_CHANNEL' that is defined in the interface scope 'AmClientRequest'. */
				void internal_raise_pREPARE_VOICECALL_CHANNEL();
				sc_boolean PREPARE_VOICECALL_CHANNEL_raised;
				/*! Raises the in event 'STREAM_VOICECALL_AUDIO' that is defined in the interface scope 'AmClientRequest'. */
				void internal_raise_sTREAM_VOICECALL_AUDIO(SamplingType value);
				sc_boolean STREAM_VOICECALL_AUDIO_raised;
				SamplingType STREAM_VOICECALL_AUDIO_value;
				/*! Raises the in event 'PAUSE_VOICECALL_AUDIO' that is defined in the interface scope 'AmClientRequest'. */
				void internal_raise_pAUSE_VOICECALL_AUDIO();
				sc_boolean PAUSE_VOICECALL_AUDIO_raised;
				/*! Raises the in event 'STOP_VOICECALL_AUDIO' that is defined in the interface scope 'AmClientRequest'. */
				void internal_raise_sTOP_VOICECALL_AUDIO();
				sc_boolean STOP_VOICECALL_AUDIO_raised;
				VoiceCallAudioSm * parent;
				void dispatch_event(voicecallaudiosm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AmClientRequest'. */
		SCI_AmClientRequest* getSCI_AmClientRequest();
		
		//! Inner class for AudioWrapperReqIf interface scope.
		class SCI_AudioWrapperReqIf
		{
			public:
				SCI_AudioWrapperReqIf(VoiceCallAudioSm * parent):
					parent(parent)
				{}
				
				
				
				
				
			private:
				friend class VoiceCallAudioSm;
				VoiceCallAudioSm * parent;
				void dispatch_event(voicecallaudiosm_events::SctEvent * event);
				
				
		};
				//! Inner class for AudioWrapperReqIf interface scope operation callbacks.
				class SCI_AudioWrapperReqIf_OCB
				{
					public:
						virtual ~SCI_AudioWrapperReqIf_OCB() = 0;
						
						virtual void sendAllocateRequest() = 0;
						
						virtual void sendDeAllocateRequest() = 0;
						
						virtual void sendSrcActivityResult(SrcActivity srcActivity) = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_AudioWrapperReqIf_OCB'. */
				void setSCI_AudioWrapperReqIf_OCB(SCI_AudioWrapperReqIf_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_AudioWrapperReqIf'. */
		SCI_AudioWrapperReqIf* getSCI_AudioWrapperReqIf();
		
		//! Inner class for AudioWrapperResponse interface scope.
		class SCI_AudioWrapperResponse
		{
			public:
				SCI_AudioWrapperResponse(VoiceCallAudioSm * parent):
					VOICECALL_AUDIO_CHANNEL_GRANTED_raised(false),
					VOICECALL_AUDIO_CHANNEL_DENIED_raised(false),
					VOICECALL_AUDIO_CHANNEL_DEALLOCATED_raised(false),
					VOICECALL_AUDIO_SA_ON_raised(false),
					VOICECALL_AUDIO_SA_OFF_raised(false),
					VOICECALL_AUDIO_SA_PAUSE_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'VOICECALL_AUDIO_CHANNEL_GRANTED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_vOICECALL_AUDIO_CHANNEL_GRANTED();
				
				
				/*! Raises the in event 'VOICECALL_AUDIO_CHANNEL_DENIED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_vOICECALL_AUDIO_CHANNEL_DENIED();
				
				
				/*! Raises the in event 'VOICECALL_AUDIO_CHANNEL_DEALLOCATED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_vOICECALL_AUDIO_CHANNEL_DEALLOCATED();
				
				
				/*! Raises the in event 'VOICECALL_AUDIO_SA_ON' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_vOICECALL_AUDIO_SA_ON();
				
				
				/*! Raises the in event 'VOICECALL_AUDIO_SA_OFF' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_vOICECALL_AUDIO_SA_OFF();
				
				
				/*! Raises the in event 'VOICECALL_AUDIO_SA_PAUSE' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_vOICECALL_AUDIO_SA_PAUSE();
				
				
				
			private:
				friend class VoiceCallAudioSm;
				/*! Raises the in event 'VOICECALL_AUDIO_CHANNEL_GRANTED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_vOICECALL_AUDIO_CHANNEL_GRANTED();
				sc_boolean VOICECALL_AUDIO_CHANNEL_GRANTED_raised;
				/*! Raises the in event 'VOICECALL_AUDIO_CHANNEL_DENIED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_vOICECALL_AUDIO_CHANNEL_DENIED();
				sc_boolean VOICECALL_AUDIO_CHANNEL_DENIED_raised;
				/*! Raises the in event 'VOICECALL_AUDIO_CHANNEL_DEALLOCATED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_vOICECALL_AUDIO_CHANNEL_DEALLOCATED();
				sc_boolean VOICECALL_AUDIO_CHANNEL_DEALLOCATED_raised;
				/*! Raises the in event 'VOICECALL_AUDIO_SA_ON' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_vOICECALL_AUDIO_SA_ON();
				sc_boolean VOICECALL_AUDIO_SA_ON_raised;
				/*! Raises the in event 'VOICECALL_AUDIO_SA_OFF' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_vOICECALL_AUDIO_SA_OFF();
				sc_boolean VOICECALL_AUDIO_SA_OFF_raised;
				/*! Raises the in event 'VOICECALL_AUDIO_SA_PAUSE' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_vOICECALL_AUDIO_SA_PAUSE();
				sc_boolean VOICECALL_AUDIO_SA_PAUSE_raised;
				VoiceCallAudioSm * parent;
				void dispatch_event(voicecallaudiosm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AudioWrapperResponse'. */
		SCI_AudioWrapperResponse* getSCI_AudioWrapperResponse();
		
		//! Inner class for EcnrRequest interface scope.
		class SCI_EcnrRequest
		{
			public:
				SCI_EcnrRequest(VoiceCallAudioSm * parent):
					parent(parent)
				{}
				
				
				
				
				
				
				
			private:
				friend class VoiceCallAudioSm;
				VoiceCallAudioSm * parent;
				void dispatch_event(voicecallaudiosm_events::SctEvent * event);
				
				
		};
				//! Inner class for EcnrRequest interface scope operation callbacks.
				class SCI_EcnrRequest_OCB
				{
					public:
						virtual ~SCI_EcnrRequest_OCB() = 0;
						
						virtual AmResultCode sendEcnrInit(SamplingType samplingType) = 0;
						
						virtual AmResultCode sendEcnrSetConfiguration(SamplingType samplingType) = 0;
						
						virtual AmResultCode sendEcnrStart() = 0;
						
						virtual AmResultCode sendEcnrStop() = 0;
						
						virtual AmResultCode sendEcnrDestroy() = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_EcnrRequest_OCB'. */
				void setSCI_EcnrRequest_OCB(SCI_EcnrRequest_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_EcnrRequest'. */
		SCI_EcnrRequest* getSCI_EcnrRequest();
		
		//! Inner class for EcnrResponse interface scope.
		class SCI_EcnrResponse
		{
			public:
				SCI_EcnrResponse(VoiceCallAudioSm * parent):
					ECNR_INIT_SUCCESS_raised(false),
					ECNR_INIT_FAILURE_raised(false),
					ECNR_INIT_FAILURE_value(),
					ECNR_SET_CONFIGURATION_SUCCESS_raised(false),
					ECNR_SET_CONFIGURATION_FAILURE_raised(false),
					ECNR_SET_CONFIGURATION_FAILURE_value(),
					ECNR_START_SUCCESS_raised(false),
					ECNR_START_FAILURE_raised(false),
					ECNR_START_FAILURE_value(),
					ECNR_STOP_SUCCESS_raised(false),
					ECNR_STOP_FAILURE_raised(false),
					ECNR_STOP_FAILURE_value(),
					ECNR_DESTROY_SUCCESS_raised(false),
					ECNR_DESTROY_FAILURE_raised(false),
					ECNR_DESTROY_FAILURE_value(),
					parent(parent)
				{}
				
				/*! Raises the in event 'ECNR_INIT_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_INIT_SUCCESS();
				
				
				/*! Raises the in event 'ECNR_INIT_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_INIT_FAILURE(AmResultMessage value);
				
				
				/*! Raises the in event 'ECNR_SET_CONFIGURATION_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_SET_CONFIGURATION_SUCCESS();
				
				
				/*! Raises the in event 'ECNR_SET_CONFIGURATION_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_SET_CONFIGURATION_FAILURE(AmResultMessage value);
				
				
				/*! Raises the in event 'ECNR_START_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_START_SUCCESS();
				
				
				/*! Raises the in event 'ECNR_START_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_START_FAILURE(AmResultMessage value);
				
				
				/*! Raises the in event 'ECNR_STOP_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_STOP_SUCCESS();
				
				
				/*! Raises the in event 'ECNR_STOP_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_STOP_FAILURE(AmResultMessage value);
				
				
				/*! Raises the in event 'ECNR_DESTROY_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_DESTROY_SUCCESS();
				
				
				/*! Raises the in event 'ECNR_DESTROY_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void raise_eCNR_DESTROY_FAILURE(AmResultMessage value);
				
				
				
			private:
				friend class VoiceCallAudioSm;
				/*! Raises the in event 'ECNR_INIT_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_INIT_SUCCESS();
				sc_boolean ECNR_INIT_SUCCESS_raised;
				/*! Raises the in event 'ECNR_INIT_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_INIT_FAILURE(AmResultMessage value);
				sc_boolean ECNR_INIT_FAILURE_raised;
				AmResultMessage ECNR_INIT_FAILURE_value;
				/*! Raises the in event 'ECNR_SET_CONFIGURATION_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_SET_CONFIGURATION_SUCCESS();
				sc_boolean ECNR_SET_CONFIGURATION_SUCCESS_raised;
				/*! Raises the in event 'ECNR_SET_CONFIGURATION_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_SET_CONFIGURATION_FAILURE(AmResultMessage value);
				sc_boolean ECNR_SET_CONFIGURATION_FAILURE_raised;
				AmResultMessage ECNR_SET_CONFIGURATION_FAILURE_value;
				/*! Raises the in event 'ECNR_START_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_START_SUCCESS();
				sc_boolean ECNR_START_SUCCESS_raised;
				/*! Raises the in event 'ECNR_START_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_START_FAILURE(AmResultMessage value);
				sc_boolean ECNR_START_FAILURE_raised;
				AmResultMessage ECNR_START_FAILURE_value;
				/*! Raises the in event 'ECNR_STOP_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_STOP_SUCCESS();
				sc_boolean ECNR_STOP_SUCCESS_raised;
				/*! Raises the in event 'ECNR_STOP_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_STOP_FAILURE(AmResultMessage value);
				sc_boolean ECNR_STOP_FAILURE_raised;
				AmResultMessage ECNR_STOP_FAILURE_value;
				/*! Raises the in event 'ECNR_DESTROY_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_DESTROY_SUCCESS();
				sc_boolean ECNR_DESTROY_SUCCESS_raised;
				/*! Raises the in event 'ECNR_DESTROY_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_eCNR_DESTROY_FAILURE(AmResultMessage value);
				sc_boolean ECNR_DESTROY_FAILURE_raised;
				AmResultMessage ECNR_DESTROY_FAILURE_value;
				VoiceCallAudioSm * parent;
				void dispatch_event(voicecallaudiosm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_EcnrResponse'. */
		SCI_EcnrResponse* getSCI_EcnrResponse();
		
		//! Inner class for VoiceCallAudioSmHandler interface scope.
		class SCI_VoiceCallAudioSmHandler
		{
			public:
				SCI_VoiceCallAudioSmHandler(VoiceCallAudioSm * parent):
					parent(parent)
				{}
				
				/*! Gets the value of the variable 'samplingType' that is defined in the interface scope 'VoiceCallAudioSmHandler'. */
				SamplingType get_samplingType() const;
				
				/*! Sets the value of the variable 'samplingType' that is defined in the interface scope 'VoiceCallAudioSmHandler'. */
				void set_samplingType(SamplingType value);
				
				
				
				
				
			private:
				friend class VoiceCallAudioSm;
				SamplingType samplingType;
				VoiceCallAudioSm * parent;
				void dispatch_event(voicecallaudiosm_events::SctEvent * event);
				
				
		};
				//! Inner class for VoiceCallAudioSmHandler interface scope operation callbacks.
				class SCI_VoiceCallAudioSmHandler_OCB
				{
					public:
						virtual ~SCI_VoiceCallAudioSmHandler_OCB() = 0;
						
						virtual void updateSamplingType(SamplingType samplingType) = 0;
						
						virtual void updateStatus(RouteState routeState, AmResultMessage msg) = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_VoiceCallAudioSmHandler_OCB'. */
				void setSCI_VoiceCallAudioSmHandler_OCB(SCI_VoiceCallAudioSmHandler_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_VoiceCallAudioSmHandler'. */
		SCI_VoiceCallAudioSmHandler* getSCI_VoiceCallAudioSmHandler();
		
		
		/*
		 * Functions inherited from StatemachineInterface
		 */
		virtual void init();
		
		virtual void enter();
		
		virtual void exit();
		
		virtual void runCycle();
		
		/*!
		* Checks if the state machine is active (until 2.4.1 this method was used for states).
		* A state machine is active if it has been entered. It is inactive if it has not been entered at all or if it has been exited.
		*/
		virtual sc_boolean isActive() const;
		
		
		/*!
		* Checks if all active states are final. 
		* If there are no active states then the state machine is considered being inactive. In this case this method returns false.
		*/
		virtual sc_boolean isFinal() const;
		
		void setTraceObserver(ysc::TraceObserver<VoiceCallAudioSmStates>* tracingcallback);
		
		ysc::TraceObserver<VoiceCallAudioSmStates>* getTraceObserver();
		
		/*! Checks if the specified state is active (until 2.4.1 the used method for states was calles isActive()). */
		sc_boolean isStateActive(VoiceCallAudioSmStates state) const;
		
		
		
	protected:
		
		
	private:
		VoiceCallAudioSm(const VoiceCallAudioSm &rhs);
		VoiceCallAudioSm& operator=(const VoiceCallAudioSm&);
		
		//! Inner class for internal interface scope.
		class InternalSCI
		{
			public:
				InternalSCI(VoiceCallAudioSm * parent):
					READY_TO_PLAY_raised(false),
					SEND_SRC_ACTIVITY_OFF_RESULT_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'READY_TO_PLAY' that is defined in the internal scope. */
				void raise_rEADY_TO_PLAY();
				
				/*! Checks if the out event 'READY_TO_PLAY' that is defined in the internal scope has been raised. */
				sc_boolean isRaised_rEADY_TO_PLAY() const;
				
				
				/*! Raises the in event 'SEND_SRC_ACTIVITY_OFF_RESULT' that is defined in the internal scope. */
				void raise_sEND_SRC_ACTIVITY_OFF_RESULT();
				
				/*! Checks if the out event 'SEND_SRC_ACTIVITY_OFF_RESULT' that is defined in the internal scope has been raised. */
				sc_boolean isRaised_sEND_SRC_ACTIVITY_OFF_RESULT() const;
				
				
				
			private:
				friend class VoiceCallAudioSm;
				/*! Raises the in event 'READY_TO_PLAY' that is defined in the internal scope. */
				void internal_raise_rEADY_TO_PLAY();
				sc_boolean READY_TO_PLAY_raised;
				/*! Raises the in event 'SEND_SRC_ACTIVITY_OFF_RESULT' that is defined in the internal scope. */
				void internal_raise_sEND_SRC_ACTIVITY_OFF_RESULT();
				sc_boolean SEND_SRC_ACTIVITY_OFF_RESULT_raised;
				VoiceCallAudioSm * parent;
				void dispatch_event(voicecallaudiosm_events::SctEvent * event);
				
				
		};
		
		//! the maximum number of orthogonal states defines the dimension of the state configuration vector.
		static const sc_ushort maxOrthogonalStates = 2;
		
		
		ysc::TraceObserver<VoiceCallAudioSmStates>* ifaceTraceObserver;
		
		VoiceCallAudioSmStates stateConfVector[maxOrthogonalStates];
		
		sc_ushort stateConfVectorPosition;
		
		SCI_AmClientRequest ifaceAmClientRequest;
		SCI_AudioWrapperReqIf ifaceAudioWrapperReqIf;
		SCI_AudioWrapperReqIf_OCB* ifaceAudioWrapperReqIf_OCB;
		SCI_AudioWrapperResponse ifaceAudioWrapperResponse;
		SCI_EcnrRequest ifaceEcnrRequest;
		SCI_EcnrRequest_OCB* ifaceEcnrRequest_OCB;
		SCI_EcnrResponse ifaceEcnrResponse;
		SCI_VoiceCallAudioSmHandler ifaceVoiceCallAudioSmHandler;
		SCI_VoiceCallAudioSmHandler_OCB* ifaceVoiceCallAudioSmHandler_OCB;
		InternalSCI ifaceInternalSCI;
		
		// prototypes of all internal functions
		
		sc_boolean check_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_0_tr0_tr0();
		sc_boolean check_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_1_tr0_tr0();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_tr0();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_tr1();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr0();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr2();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr5();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr6();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr7();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr9();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr10();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr11();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr12();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_tr4();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_tr2();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_tr3();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_tr1();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_tr1();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_tr2();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_tr4();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_tr6();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr0();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr1();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr4();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr5();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr6();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr7();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr8();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_0_tr0();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_0_tr1();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_1_tr0();
		void effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_1_tr1();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
		void enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream();
		void enseq_VoiceCallAudioRegion_IDLE_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_StreamingOngoing();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallStartStreaming();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_entry_DeallocateRoute8();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_entry_DefaultStop1();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_entry_DestroyEcnrAndDeallocateRoute4();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_entry_StopEcnrAndDestroy3();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_AutoSAPause();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_Ready2Stream();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_AutoSAPause();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_AutoSAOff();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_DeallocateRoute();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_DestroyEcnrAndDeallocateRoute();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_DestroyEcnrOnly();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopEcnrAndDestroy();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_entry_AutoSAOffAfterEcnrResponse3();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_entry_AutoSAOnAfterEcnrResponse9();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_entry_AutoSAPauseAfterEcnrResponse5();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_entry_StopAfterEcnrResponse0();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_StopEcnrAndPause();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_entry_AutoSAOffAfterEcnrResponse2();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_entry_StopAfterEcnrResponse3();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop_default();
		void enseq_VoiceCallAudioRegion_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_VoiceCallStartStreaming();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StreamingOngoing();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_StopEcnrAndDestroy3();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_DestroyEcnrAndDeallocateRoute4();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_DefaultStop1();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_DeallocateRoute8();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_AutoSAPause();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_Ready2Stream();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_AutoSAPause();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DeallocateRoute();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateRoute();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrOnly();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopEcnrAndDestroy();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSAOff();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_StopAfterEcnrResponse0();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_AutoSAOffAfterEcnrResponse3();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_AutoSAPauseAfterEcnrResponse5();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_AutoSAOnAfterEcnrResponse9();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_default();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopEcnrAndPause();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_entry_AutoSAOffAfterEcnrResponse2();
		void enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_entry_StopAfterEcnrResponse3();
		void exseq_VoiceCallAudioRegion_IDLE();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop();
		void exseq_VoiceCallAudioRegion();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion();
		void exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_0();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_1();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion__entry_Default();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion__entry_Default();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_VoiceCallStartStreaming();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_AutoSAPause();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion__entry_Default();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_Ready2Stream();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_AutoSAPause();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion__entry_Default();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StreamingOngoing();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_StopEcnrAndDestroy3();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_DestroyEcnrAndDeallocateRoute4();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_DefaultStop1();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_DeallocateRoute8();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion__entry_Default();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DeallocateRoute();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateRoute();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrOnly();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopEcnrAndDestroy();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSAOff();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__entry_Default();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_StopAfterEcnrResponse0();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_AutoSAOffAfterEcnrResponse3();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_AutoSAPauseAfterEcnrResponse5();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_AutoSAOnAfterEcnrResponse9();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion__entry_Default();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopEcnrAndPause();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_entry_AutoSAOffAfterEcnrResponse2();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_entry_StopAfterEcnrResponse3();
		void react_VoiceCallAudioRegion__entry_Default();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopEcnrAndDestroy();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DestroyEcnrAndDeallocateRoute();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DefaultStop();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_StreamAudio();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DestroyEcnr();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOff();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DeallocateRoute();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DestroyEcnrAndPause();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ReadyToStream();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_StreamingStarted();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopEcnrAndPause();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudio();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_exitOnDeallocated();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_ChannelDeallocated();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallStartStreaming();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_DestroEcnrAndDeallocate();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_DestroyEcnr();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPause();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_ChannelDenied();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartStreaming();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureEcnrAndStart();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_DeallocateRoute();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOff();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_DestroyEcnrAndDeallocate();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_DestroyEcnrOnly();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_STOP_FAILURE();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion__sync0();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion__sync1();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation__sync0();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion__sync0();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion__sync1();
		void react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion__sync2();
		sc_boolean react();
		sc_boolean VoiceCallAudioRegion_IDLE_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy_react(const sc_boolean try_transition);
		sc_boolean VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop_react(const sc_boolean try_transition);
		void clearInEvents();
		void clearOutEvents();
		
		
		std::deque<voicecallaudiosm_events::SctEvent*> internalEventQueue;
		voicecallaudiosm_events::SctEvent* getNextEvent();
		void dispatch_event(voicecallaudiosm_events::SctEvent * event);
		std::deque<voicecallaudiosm_events::SctEvent*> inEventQueue;
		sc_boolean isRunningCycle;
		
		
};


inline VoiceCallAudioSm::SCI_AudioWrapperReqIf_OCB::~SCI_AudioWrapperReqIf_OCB() {}
inline VoiceCallAudioSm::SCI_EcnrRequest_OCB::~SCI_EcnrRequest_OCB() {}
inline VoiceCallAudioSm::SCI_VoiceCallAudioSmHandler_OCB::~SCI_VoiceCallAudioSmHandler_OCB() {}


#endif /* VOICECALLAUDIOSM_H_ */
