/* *
 * @file VoiceCallAudioSm.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Generated code from VoiceCallAudioSm.sct
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 * */

#include "VoiceCallAudioSm.h"

/*! \file Implementation of the state machine 'VoiceCallAudioSm'
*/




VoiceCallAudioSm::VoiceCallAudioSm()  :
ifaceTraceObserver(0),
stateConfVectorPosition(0),
ifaceAmClientRequest(this),
ifaceAudioWrapperReqIf(this),
ifaceAudioWrapperReqIf_OCB(sc_null),
ifaceAudioWrapperResponse(this),
ifaceEcnrRequest(this),
ifaceEcnrRequest_OCB(sc_null),
ifaceEcnrResponse(this),
ifaceVoiceCallAudioSmHandler(this),
ifaceVoiceCallAudioSmHandler_OCB(sc_null),
ifaceInternalSCI(this),
isRunningCycle(false)
{
}

VoiceCallAudioSm::~VoiceCallAudioSm()
{
}


using namespace voicecallaudiosm_events;

SctEvent* VoiceCallAudioSm::getNextEvent()
{
	SctEvent* nextEvent = 0;
	
	if(!internalEventQueue.empty()) {
		nextEvent = internalEventQueue.front();
		internalEventQueue.pop_front();
	}
	else if(!inEventQueue.empty()) {
		nextEvent = inEventQueue.front();
		inEventQueue.pop_front();
	}
	
	return nextEvent;
}

void VoiceCallAudioSm::dispatch_event(SctEvent * event)
{
	if(event == 0) {
		return;
	}
	switch(event->name)
	{
		case SCI_AmClientRequest_PREPARE_VOICECALL_CHANNEL:
		case SCI_AmClientRequest_STREAM_VOICECALL_AUDIO:
		case SCI_AmClientRequest_PAUSE_VOICECALL_AUDIO:
		case SCI_AmClientRequest_STOP_VOICECALL_AUDIO:
		{
			ifaceAmClientRequest.dispatch_event(event);
			break;
		}
		case SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_GRANTED:
		case SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_DENIED:
		case SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_DEALLOCATED:
		case SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_ON:
		case SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_OFF:
		case SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_PAUSE:
		{
			ifaceAudioWrapperResponse.dispatch_event(event);
			break;
		}
		case SCI_EcnrResponse_ECNR_INIT_SUCCESS:
		case SCI_EcnrResponse_ECNR_INIT_FAILURE:
		case SCI_EcnrResponse_ECNR_SET_CONFIGURATION_SUCCESS:
		case SCI_EcnrResponse_ECNR_SET_CONFIGURATION_FAILURE:
		case SCI_EcnrResponse_ECNR_START_SUCCESS:
		case SCI_EcnrResponse_ECNR_START_FAILURE:
		case SCI_EcnrResponse_ECNR_STOP_SUCCESS:
		case SCI_EcnrResponse_ECNR_STOP_FAILURE:
		case SCI_EcnrResponse_ECNR_DESTROY_SUCCESS:
		case SCI_EcnrResponse_ECNR_DESTROY_FAILURE:
		{
			ifaceEcnrResponse.dispatch_event(event);
			break;
		}
		case InternalSCI_READY_TO_PLAY:
		case InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT:
		{
			ifaceInternalSCI.dispatch_event(event);
			break;
		}
		default:
			break;
	}
}

void VoiceCallAudioSm::SCI_AmClientRequest::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AmClientRequest_PREPARE_VOICECALL_CHANNEL:
		{
			internal_raise_pREPARE_VOICECALL_CHANNEL();
			break;
		}
		case SCI_AmClientRequest_STREAM_VOICECALL_AUDIO:
		{
			SctEvent_SCI_AmClientRequest_STREAM_VOICECALL_AUDIO * e = static_cast<SctEvent_SCI_AmClientRequest_STREAM_VOICECALL_AUDIO*>(event);
			if(e != 0) {
				internal_raise_sTREAM_VOICECALL_AUDIO(e->value);
			}
			break;
		}
		case SCI_AmClientRequest_PAUSE_VOICECALL_AUDIO:
		{
			internal_raise_pAUSE_VOICECALL_AUDIO();
			break;
		}
		case SCI_AmClientRequest_STOP_VOICECALL_AUDIO:
		{
			internal_raise_sTOP_VOICECALL_AUDIO();
			break;
		}
		default:
			break;
	}
}
void VoiceCallAudioSm::SCI_AudioWrapperReqIf::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void VoiceCallAudioSm::SCI_AudioWrapperResponse::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_GRANTED:
		{
			internal_raise_vOICECALL_AUDIO_CHANNEL_GRANTED();
			break;
		}
		case SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_DENIED:
		{
			internal_raise_vOICECALL_AUDIO_CHANNEL_DENIED();
			break;
		}
		case SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_DEALLOCATED:
		{
			internal_raise_vOICECALL_AUDIO_CHANNEL_DEALLOCATED();
			break;
		}
		case SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_ON:
		{
			internal_raise_vOICECALL_AUDIO_SA_ON();
			break;
		}
		case SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_OFF:
		{
			internal_raise_vOICECALL_AUDIO_SA_OFF();
			break;
		}
		case SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_PAUSE:
		{
			internal_raise_vOICECALL_AUDIO_SA_PAUSE();
			break;
		}
		default:
			break;
	}
}
void VoiceCallAudioSm::SCI_EcnrRequest::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void VoiceCallAudioSm::SCI_EcnrResponse::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_EcnrResponse_ECNR_INIT_SUCCESS:
		{
			internal_raise_eCNR_INIT_SUCCESS();
			break;
		}
		case SCI_EcnrResponse_ECNR_INIT_FAILURE:
		{
			SctEvent_SCI_EcnrResponse_ECNR_INIT_FAILURE * e = static_cast<SctEvent_SCI_EcnrResponse_ECNR_INIT_FAILURE*>(event);
			if(e != 0) {
				internal_raise_eCNR_INIT_FAILURE(e->value);
			}
			break;
		}
		case SCI_EcnrResponse_ECNR_SET_CONFIGURATION_SUCCESS:
		{
			internal_raise_eCNR_SET_CONFIGURATION_SUCCESS();
			break;
		}
		case SCI_EcnrResponse_ECNR_SET_CONFIGURATION_FAILURE:
		{
			SctEvent_SCI_EcnrResponse_ECNR_SET_CONFIGURATION_FAILURE * e = static_cast<SctEvent_SCI_EcnrResponse_ECNR_SET_CONFIGURATION_FAILURE*>(event);
			if(e != 0) {
				internal_raise_eCNR_SET_CONFIGURATION_FAILURE(e->value);
			}
			break;
		}
		case SCI_EcnrResponse_ECNR_START_SUCCESS:
		{
			internal_raise_eCNR_START_SUCCESS();
			break;
		}
		case SCI_EcnrResponse_ECNR_START_FAILURE:
		{
			SctEvent_SCI_EcnrResponse_ECNR_START_FAILURE * e = static_cast<SctEvent_SCI_EcnrResponse_ECNR_START_FAILURE*>(event);
			if(e != 0) {
				internal_raise_eCNR_START_FAILURE(e->value);
			}
			break;
		}
		case SCI_EcnrResponse_ECNR_STOP_SUCCESS:
		{
			internal_raise_eCNR_STOP_SUCCESS();
			break;
		}
		case SCI_EcnrResponse_ECNR_STOP_FAILURE:
		{
			SctEvent_SCI_EcnrResponse_ECNR_STOP_FAILURE * e = static_cast<SctEvent_SCI_EcnrResponse_ECNR_STOP_FAILURE*>(event);
			if(e != 0) {
				internal_raise_eCNR_STOP_FAILURE(e->value);
			}
			break;
		}
		case SCI_EcnrResponse_ECNR_DESTROY_SUCCESS:
		{
			internal_raise_eCNR_DESTROY_SUCCESS();
			break;
		}
		case SCI_EcnrResponse_ECNR_DESTROY_FAILURE:
		{
			SctEvent_SCI_EcnrResponse_ECNR_DESTROY_FAILURE * e = static_cast<SctEvent_SCI_EcnrResponse_ECNR_DESTROY_FAILURE*>(event);
			if(e != 0) {
				internal_raise_eCNR_DESTROY_FAILURE(e->value);
			}
			break;
		}
		default:
			break;
	}
}
void VoiceCallAudioSm::SCI_VoiceCallAudioSmHandler::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void VoiceCallAudioSm::InternalSCI::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case InternalSCI_READY_TO_PLAY:
		{
			internal_raise_rEADY_TO_PLAY();
			break;
		}
		case InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT:
		{
			internal_raise_sEND_SRC_ACTIVITY_OFF_RESULT();
			break;
		}
		default:
			break;
	}
}


void VoiceCallAudioSm::init()
{
	for (sc_ushort i = 0; i < maxOrthogonalStates; ++i)
		stateConfVector[i] = VoiceCallAudioSm_last_state;
	
	stateConfVectorPosition = 0;

	clearInEvents();
	clearOutEvents();
	
}

void VoiceCallAudioSm::enter()
{
	/* Default enter sequence for statechart VoiceCallAudioSm */
	enseq_VoiceCallAudioRegion_default();
}

void VoiceCallAudioSm::exit()
{
	/* Default exit sequence for statechart VoiceCallAudioSm */
	exseq_VoiceCallAudioRegion();
}

sc_boolean VoiceCallAudioSm::isActive() const
{
	return stateConfVector[0] != VoiceCallAudioSm_last_state||stateConfVector[1] != VoiceCallAudioSm_last_state;
}

/* 
 * Always returns 'false' since this state machine can never become final.
 */
sc_boolean VoiceCallAudioSm::isFinal() const
{
   return false;}

void VoiceCallAudioSm::runCycle()
{
	if (isRunningCycle == false)
	{
		isRunningCycle = true;
		clearOutEvents();
						
		SctEvent * currentEvent = getNextEvent();
		
		do
		{
			/* Set event flags as usual */
			dispatch_event(currentEvent);
			
			for (stateConfVectorPosition = 0;
				stateConfVectorPosition < maxOrthogonalStates;
				stateConfVectorPosition++)
				{
					
				switch (stateConfVector[stateConfVectorPosition])
				{
				case VoiceCallAudioRegion_IDLE :
				{
					VoiceCallAudioRegion_IDLE_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy_react(true);
					break;
				}
				case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop :
				{
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop_react(true);
					break;
				}
				default:
					break;
				}
			}
			
			/* Delete event from memory */
			delete currentEvent;
			clearInEvents();
		} while((currentEvent = getNextEvent()));
		
		isRunningCycle = false;
	}
}

void VoiceCallAudioSm::clearInEvents()
{
	ifaceAmClientRequest.PREPARE_VOICECALL_CHANNEL_raised = false;
	ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_raised = false;
	ifaceAmClientRequest.PAUSE_VOICECALL_AUDIO_raised = false;
	ifaceAmClientRequest.STOP_VOICECALL_AUDIO_raised = false;
	ifaceAudioWrapperResponse.VOICECALL_AUDIO_CHANNEL_GRANTED_raised = false;
	ifaceAudioWrapperResponse.VOICECALL_AUDIO_CHANNEL_DENIED_raised = false;
	ifaceAudioWrapperResponse.VOICECALL_AUDIO_CHANNEL_DEALLOCATED_raised = false;
	ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_ON_raised = false;
	ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised = false;
	ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_PAUSE_raised = false;
	ifaceEcnrResponse.ECNR_INIT_SUCCESS_raised = false;
	ifaceEcnrResponse.ECNR_INIT_FAILURE_raised = false;
	ifaceEcnrResponse.ECNR_SET_CONFIGURATION_SUCCESS_raised = false;
	ifaceEcnrResponse.ECNR_SET_CONFIGURATION_FAILURE_raised = false;
	ifaceEcnrResponse.ECNR_START_SUCCESS_raised = false;
	ifaceEcnrResponse.ECNR_START_FAILURE_raised = false;
	ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised = false;
	ifaceEcnrResponse.ECNR_STOP_FAILURE_raised = false;
	ifaceEcnrResponse.ECNR_DESTROY_SUCCESS_raised = false;
	ifaceEcnrResponse.ECNR_DESTROY_FAILURE_raised = false;
	ifaceInternalSCI.READY_TO_PLAY_raised = false; 
	ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised = false; 
}

void VoiceCallAudioSm::clearOutEvents()
{
}


sc_boolean VoiceCallAudioSm::isStateActive(VoiceCallAudioSmStates state) const
{
	switch (state)
	{
		case VoiceCallAudioRegion_IDLE : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_IDLE] == VoiceCallAudioRegion_IDLE
			);
		case VoiceCallAudioRegion_VoiceCallAudio : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO] >= VoiceCallAudioRegion_VoiceCallAudio
				&& stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO] <= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PREPARINGVOICECALLAUDIO] >= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio
				&& stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PREPARINGVOICECALLAUDIO] <= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PREPARINGVOICECALLAUDIO_AMCLIENTREQUESTWAITREGION_WAITFORPLAYREQUEST] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PREPARINGVOICECALLAUDIO_AMCLIENTREQUESTWAITREGION_READYTOSTREAM] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PREPARINGVOICECALLAUDIO_ARLRESPONSEWAITREGION_WAITFORPHONEROUTEALLOCATION] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PREPARINGVOICECALLAUDIO_ARLRESPONSEWAITREGION_VOICECALLSAONRECEIVED] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PREPARINGVOICECALLAUDIO_ARLRESPONSEWAITREGION_WAITFORSAON] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO] >= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio
				&& stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO] <= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_WAITFORECNRINIT] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_WAITFORECNRSTART] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_STOPAFTERECNRINIT] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_STOPAFTERECNRSTART] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_AUTOSAOFFATECNRSTART] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_AUTOSAOFFATECNRINIT] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_STREAMING] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED] >= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured
				&& stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED] <= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_CHANNELPAUSED] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_WAITFORECNRRESPONSE] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_READYTOSTREAM] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_CONFIGUREANDSTREAM] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_CHANNELACTIVATED] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_PLAYAFTERECNRRESPONSE] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED] >= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted
				&& stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED] <= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED_PAUSEAUDIOREGION_CHANNELPAUSED] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED_PAUSEAUDIOREGION_WAITFORECNRRESPONSE] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED_PAUSEAUDIOREGION_CHANNELACTIVATED] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STREAMINGVOICECALLAUDIO_VOICECALLAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED_PAUSEAUDIOREGION_PLAYAFTERECNRRESPONSE] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING] >= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming
				&& stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING] <= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL] >= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel
				&& stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL] <= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ECNROPERATION_WAITFORECNRSTOP] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ECNROPERATION_WAITFORECNRDESTROY] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ECNROPERATION_ECNRDESTROYED] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ARLOPERATION_WAITFORPHONEROUTEDEALLOCATION] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ARLOPERATION_VOICECALLSAOFF] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_STREAMINGSTOPPED] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_WAITFORROUTEDEALLOCATION] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL] >= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel
				&& stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL] <= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL_ECNROPERATION_WAITFORECNRDESTROY] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL_ECNROPERATION_ECNRDESTROYED] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL_ARLOPERATION_WAITFORPHONEROUTEDEALLOCATION] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL_ARLOPERATION_VOICECALLSAOFF] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_WAITFORECNRDESTROY] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_WAITFORECNRSTOP] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_STOPCALLAUDIOSTREAMING_STOPCALLAUDIOSTREAMINGREGION_AUTOSOURCESWITCH] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO] >= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio
				&& stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO] <= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO_PAUSEVOICECALLAUDIOREGION_WAITFORECNRSTOP] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO_PAUSEVOICECALLAUDIOREGION_VOICECALLAUDIOPAUSED] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO_PAUSEVOICECALLAUDIOREGION_PLAYAFTERECNRRESPONSE] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO_PAUSEVOICECALLAUDIOREGION_WAITFORECNRCONFIGURE] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO_PAUSEVOICECALLAUDIOREGION_PAUSEAFTERECNRRESPONSE] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO_PAUSEVOICECALLAUDIOREGION_STOPAFTERECNRRESPONSE] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO_PAUSEVOICECALLAUDIOREGION_AUTOSAOFFAFTERECNRRESPONSE] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO_PAUSEVOICECALLAUDIOREGION_AUTOSAPAUSEAFTERECNRRESPONSE] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_PAUSEVOICECALLAUDIO_PAUSEVOICECALLAUDIOREGION_AUTOSAONAFTERECNRRESPONSE] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED] >= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused
				&& stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED] <= VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_WAITFORECNRDESTROY] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_CHANNELAUTOPAUSED] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_WAITFORECNRSTOP] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_STARTTOSTREAM] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_CONFIGUREANDSTREAM] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_AUTOSAOFFAFTERECNRRESPONSE] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_STOPAFTERECNRRESPONSE] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_STOPAFTERECNRSTOP] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_AUTOSAOFFAFTERECNRSTOP] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_PAUSEAFTERECNRDESTROY] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy
			);
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop : 
			return (sc_boolean) (stateConfVector[SCVI_VOICECALLAUDIOREGION_VOICECALLAUDIO_VOICECALLAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_PAUSEAFTERECNRSTOP] == VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop
			);
		default: return false;
	}
}

VoiceCallAudioSm::SCI_AmClientRequest* VoiceCallAudioSm::getSCI_AmClientRequest()
{
	return &ifaceAmClientRequest;
}
/* Functions for event PREPARE_VOICECALL_CHANNEL in interface SCI_AmClientRequest */
void VoiceCallAudioSm::SCI_AmClientRequest::raise_pREPARE_VOICECALL_CHANNEL()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AmClientRequest_PREPARE_VOICECALL_CHANNEL(SCI_AmClientRequest_PREPARE_VOICECALL_CHANNEL));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_AmClientRequest::internal_raise_pREPARE_VOICECALL_CHANNEL()
{
	PREPARE_VOICECALL_CHANNEL_raised = true;
}
/* Functions for event STREAM_VOICECALL_AUDIO in interface SCI_AmClientRequest */
void VoiceCallAudioSm::SCI_AmClientRequest::raise_sTREAM_VOICECALL_AUDIO(SamplingType value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AmClientRequest_STREAM_VOICECALL_AUDIO(SCI_AmClientRequest_STREAM_VOICECALL_AUDIO, value));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_AmClientRequest::internal_raise_sTREAM_VOICECALL_AUDIO(SamplingType value)
{
	STREAM_VOICECALL_AUDIO_value = value;
	STREAM_VOICECALL_AUDIO_raised = true;
}
/* Functions for event PAUSE_VOICECALL_AUDIO in interface SCI_AmClientRequest */
void VoiceCallAudioSm::SCI_AmClientRequest::raise_pAUSE_VOICECALL_AUDIO()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AmClientRequest_PAUSE_VOICECALL_AUDIO(SCI_AmClientRequest_PAUSE_VOICECALL_AUDIO));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_AmClientRequest::internal_raise_pAUSE_VOICECALL_AUDIO()
{
	PAUSE_VOICECALL_AUDIO_raised = true;
}
/* Functions for event STOP_VOICECALL_AUDIO in interface SCI_AmClientRequest */
void VoiceCallAudioSm::SCI_AmClientRequest::raise_sTOP_VOICECALL_AUDIO()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AmClientRequest_STOP_VOICECALL_AUDIO(SCI_AmClientRequest_STOP_VOICECALL_AUDIO));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_AmClientRequest::internal_raise_sTOP_VOICECALL_AUDIO()
{
	STOP_VOICECALL_AUDIO_raised = true;
}
VoiceCallAudioSm::SCI_AudioWrapperReqIf* VoiceCallAudioSm::getSCI_AudioWrapperReqIf()
{
	return &ifaceAudioWrapperReqIf;
}
void VoiceCallAudioSm::setSCI_AudioWrapperReqIf_OCB(SCI_AudioWrapperReqIf_OCB* operationCallback)
{
	ifaceAudioWrapperReqIf_OCB = operationCallback;
}
VoiceCallAudioSm::SCI_AudioWrapperResponse* VoiceCallAudioSm::getSCI_AudioWrapperResponse()
{
	return &ifaceAudioWrapperResponse;
}
/* Functions for event VOICECALL_AUDIO_CHANNEL_GRANTED in interface SCI_AudioWrapperResponse */
void VoiceCallAudioSm::SCI_AudioWrapperResponse::raise_vOICECALL_AUDIO_CHANNEL_GRANTED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_GRANTED(SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_GRANTED));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_AudioWrapperResponse::internal_raise_vOICECALL_AUDIO_CHANNEL_GRANTED()
{
	VOICECALL_AUDIO_CHANNEL_GRANTED_raised = true;
}
/* Functions for event VOICECALL_AUDIO_CHANNEL_DENIED in interface SCI_AudioWrapperResponse */
void VoiceCallAudioSm::SCI_AudioWrapperResponse::raise_vOICECALL_AUDIO_CHANNEL_DENIED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_DENIED(SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_DENIED));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_AudioWrapperResponse::internal_raise_vOICECALL_AUDIO_CHANNEL_DENIED()
{
	VOICECALL_AUDIO_CHANNEL_DENIED_raised = true;
}
/* Functions for event VOICECALL_AUDIO_CHANNEL_DEALLOCATED in interface SCI_AudioWrapperResponse */
void VoiceCallAudioSm::SCI_AudioWrapperResponse::raise_vOICECALL_AUDIO_CHANNEL_DEALLOCATED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_DEALLOCATED(SCI_AudioWrapperResponse_VOICECALL_AUDIO_CHANNEL_DEALLOCATED));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_AudioWrapperResponse::internal_raise_vOICECALL_AUDIO_CHANNEL_DEALLOCATED()
{
	VOICECALL_AUDIO_CHANNEL_DEALLOCATED_raised = true;
}
/* Functions for event VOICECALL_AUDIO_SA_ON in interface SCI_AudioWrapperResponse */
void VoiceCallAudioSm::SCI_AudioWrapperResponse::raise_vOICECALL_AUDIO_SA_ON()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_ON(SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_ON));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_AudioWrapperResponse::internal_raise_vOICECALL_AUDIO_SA_ON()
{
	VOICECALL_AUDIO_SA_ON_raised = true;
}
/* Functions for event VOICECALL_AUDIO_SA_OFF in interface SCI_AudioWrapperResponse */
void VoiceCallAudioSm::SCI_AudioWrapperResponse::raise_vOICECALL_AUDIO_SA_OFF()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_OFF(SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_OFF));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_AudioWrapperResponse::internal_raise_vOICECALL_AUDIO_SA_OFF()
{
	VOICECALL_AUDIO_SA_OFF_raised = true;
}
/* Functions for event VOICECALL_AUDIO_SA_PAUSE in interface SCI_AudioWrapperResponse */
void VoiceCallAudioSm::SCI_AudioWrapperResponse::raise_vOICECALL_AUDIO_SA_PAUSE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_PAUSE(SCI_AudioWrapperResponse_VOICECALL_AUDIO_SA_PAUSE));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_AudioWrapperResponse::internal_raise_vOICECALL_AUDIO_SA_PAUSE()
{
	VOICECALL_AUDIO_SA_PAUSE_raised = true;
}
VoiceCallAudioSm::SCI_EcnrRequest* VoiceCallAudioSm::getSCI_EcnrRequest()
{
	return &ifaceEcnrRequest;
}
void VoiceCallAudioSm::setSCI_EcnrRequest_OCB(SCI_EcnrRequest_OCB* operationCallback)
{
	ifaceEcnrRequest_OCB = operationCallback;
}
VoiceCallAudioSm::SCI_EcnrResponse* VoiceCallAudioSm::getSCI_EcnrResponse()
{
	return &ifaceEcnrResponse;
}
/* Functions for event ECNR_INIT_SUCCESS in interface SCI_EcnrResponse */
void VoiceCallAudioSm::SCI_EcnrResponse::raise_eCNR_INIT_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_INIT_SUCCESS(SCI_EcnrResponse_ECNR_INIT_SUCCESS));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_EcnrResponse::internal_raise_eCNR_INIT_SUCCESS()
{
	ECNR_INIT_SUCCESS_raised = true;
}
/* Functions for event ECNR_INIT_FAILURE in interface SCI_EcnrResponse */
void VoiceCallAudioSm::SCI_EcnrResponse::raise_eCNR_INIT_FAILURE(AmResultMessage value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_INIT_FAILURE(SCI_EcnrResponse_ECNR_INIT_FAILURE, value));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_EcnrResponse::internal_raise_eCNR_INIT_FAILURE(AmResultMessage value)
{
	ECNR_INIT_FAILURE_value = value;
	ECNR_INIT_FAILURE_raised = true;
}
/* Functions for event ECNR_SET_CONFIGURATION_SUCCESS in interface SCI_EcnrResponse */
void VoiceCallAudioSm::SCI_EcnrResponse::raise_eCNR_SET_CONFIGURATION_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_SET_CONFIGURATION_SUCCESS(SCI_EcnrResponse_ECNR_SET_CONFIGURATION_SUCCESS));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_EcnrResponse::internal_raise_eCNR_SET_CONFIGURATION_SUCCESS()
{
	ECNR_SET_CONFIGURATION_SUCCESS_raised = true;
}
/* Functions for event ECNR_SET_CONFIGURATION_FAILURE in interface SCI_EcnrResponse */
void VoiceCallAudioSm::SCI_EcnrResponse::raise_eCNR_SET_CONFIGURATION_FAILURE(AmResultMessage value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_SET_CONFIGURATION_FAILURE(SCI_EcnrResponse_ECNR_SET_CONFIGURATION_FAILURE, value));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_EcnrResponse::internal_raise_eCNR_SET_CONFIGURATION_FAILURE(AmResultMessage value)
{
	ECNR_SET_CONFIGURATION_FAILURE_value = value;
	ECNR_SET_CONFIGURATION_FAILURE_raised = true;
}
/* Functions for event ECNR_START_SUCCESS in interface SCI_EcnrResponse */
void VoiceCallAudioSm::SCI_EcnrResponse::raise_eCNR_START_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_START_SUCCESS(SCI_EcnrResponse_ECNR_START_SUCCESS));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_EcnrResponse::internal_raise_eCNR_START_SUCCESS()
{
	ECNR_START_SUCCESS_raised = true;
}
/* Functions for event ECNR_START_FAILURE in interface SCI_EcnrResponse */
void VoiceCallAudioSm::SCI_EcnrResponse::raise_eCNR_START_FAILURE(AmResultMessage value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_START_FAILURE(SCI_EcnrResponse_ECNR_START_FAILURE, value));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_EcnrResponse::internal_raise_eCNR_START_FAILURE(AmResultMessage value)
{
	ECNR_START_FAILURE_value = value;
	ECNR_START_FAILURE_raised = true;
}
/* Functions for event ECNR_STOP_SUCCESS in interface SCI_EcnrResponse */
void VoiceCallAudioSm::SCI_EcnrResponse::raise_eCNR_STOP_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_STOP_SUCCESS(SCI_EcnrResponse_ECNR_STOP_SUCCESS));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_EcnrResponse::internal_raise_eCNR_STOP_SUCCESS()
{
	ECNR_STOP_SUCCESS_raised = true;
}
/* Functions for event ECNR_STOP_FAILURE in interface SCI_EcnrResponse */
void VoiceCallAudioSm::SCI_EcnrResponse::raise_eCNR_STOP_FAILURE(AmResultMessage value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_STOP_FAILURE(SCI_EcnrResponse_ECNR_STOP_FAILURE, value));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_EcnrResponse::internal_raise_eCNR_STOP_FAILURE(AmResultMessage value)
{
	ECNR_STOP_FAILURE_value = value;
	ECNR_STOP_FAILURE_raised = true;
}
/* Functions for event ECNR_DESTROY_SUCCESS in interface SCI_EcnrResponse */
void VoiceCallAudioSm::SCI_EcnrResponse::raise_eCNR_DESTROY_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_DESTROY_SUCCESS(SCI_EcnrResponse_ECNR_DESTROY_SUCCESS));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_EcnrResponse::internal_raise_eCNR_DESTROY_SUCCESS()
{
	ECNR_DESTROY_SUCCESS_raised = true;
}
/* Functions for event ECNR_DESTROY_FAILURE in interface SCI_EcnrResponse */
void VoiceCallAudioSm::SCI_EcnrResponse::raise_eCNR_DESTROY_FAILURE(AmResultMessage value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_DESTROY_FAILURE(SCI_EcnrResponse_ECNR_DESTROY_FAILURE, value));
	parent->runCycle();
}
void VoiceCallAudioSm::SCI_EcnrResponse::internal_raise_eCNR_DESTROY_FAILURE(AmResultMessage value)
{
	ECNR_DESTROY_FAILURE_value = value;
	ECNR_DESTROY_FAILURE_raised = true;
}
VoiceCallAudioSm::SCI_VoiceCallAudioSmHandler* VoiceCallAudioSm::getSCI_VoiceCallAudioSmHandler()
{
	return &ifaceVoiceCallAudioSmHandler;
}
SamplingType VoiceCallAudioSm::SCI_VoiceCallAudioSmHandler::get_samplingType() const
{
	return samplingType;
}

void VoiceCallAudioSm::SCI_VoiceCallAudioSmHandler::set_samplingType(SamplingType value)
{
	samplingType = value;
}

void VoiceCallAudioSm::setSCI_VoiceCallAudioSmHandler_OCB(SCI_VoiceCallAudioSmHandler_OCB* operationCallback)
{
	ifaceVoiceCallAudioSmHandler_OCB = operationCallback;
}
/* Functions for event READY_TO_PLAY in interface InternalSCI */
void VoiceCallAudioSm::InternalSCI::raise_rEADY_TO_PLAY()
{
	parent->internalEventQueue.push_back(new SctEvent_InternalSCI_READY_TO_PLAY(InternalSCI_READY_TO_PLAY));
	parent->runCycle();
}
void VoiceCallAudioSm::InternalSCI::internal_raise_rEADY_TO_PLAY()
{
	READY_TO_PLAY_raised = true;
}
sc_boolean VoiceCallAudioSm::InternalSCI::isRaised_rEADY_TO_PLAY() const
{
	return READY_TO_PLAY_raised;
}
/* Functions for event SEND_SRC_ACTIVITY_OFF_RESULT in interface InternalSCI */
void VoiceCallAudioSm::InternalSCI::raise_sEND_SRC_ACTIVITY_OFF_RESULT()
{
	parent->internalEventQueue.push_back(new SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT));
	parent->runCycle();
}
void VoiceCallAudioSm::InternalSCI::internal_raise_sEND_SRC_ACTIVITY_OFF_RESULT()
{
	SEND_SRC_ACTIVITY_OFF_RESULT_raised = true;
}
sc_boolean VoiceCallAudioSm::InternalSCI::isRaised_sEND_SRC_ACTIVITY_OFF_RESULT() const
{
	return SEND_SRC_ACTIVITY_OFF_RESULT_raised;
}

void VoiceCallAudioSm::setTraceObserver(ysc::TraceObserver<VoiceCallAudioSmStates>* tracingcallback) {
	ifaceTraceObserver = tracingcallback;
}

ysc::TraceObserver<VoiceCallAudioSm::VoiceCallAudioSmStates>* VoiceCallAudioSm::getTraceObserver() {
	return ifaceTraceObserver;
}

// implementations of all internal functions

sc_boolean VoiceCallAudioSm::check_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_0_tr0_tr0()
{
	return (ifaceVoiceCallAudioSmHandler.samplingType) == (ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_value);
}

sc_boolean VoiceCallAudioSm::check_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_1_tr0_tr0()
{
	return (ifaceVoiceCallAudioSmHandler.samplingType) == (ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_value);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_tr0()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio();
	enseq_VoiceCallAudioRegion_IDLE_default();
	react();
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_tr1()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio();
	enseq_VoiceCallAudioRegion_IDLE_default();
	react();
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr0()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_DeallocateRoute();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr2()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopEcnrAndDestroy();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr5()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_DestroyEcnrAndDeallocateRoute();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr6()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_default();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr7()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_DestroyEcnrOnly();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr9()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_AutoSAOff();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr10()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_default();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr11()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_StopEcnrAndPause();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr12()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_default();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_tr4()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart_default();
	VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_tr2()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
	ifaceVoiceCallAudioSmHandler_OCB->updateStatus(STREAMING_PAUSED, (sc_string) "Audio paused");
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_Ready2Stream();
	VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_tr3()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming_default();
	VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_tr1()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming();
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_ChannelDeallocated();
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_tr1()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallStartStreaming();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_tr2()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_DestroyEcnrAndDeallocateRoute();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_tr4()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_DestroyEcnrOnly();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_tr6()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_default();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr0()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_default();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr1()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallStartStreaming();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr4()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_DeallocateRoute();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr5()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_DestroyEcnrAndDeallocateRoute();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr6()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_AutoSAOff();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr7()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_DestroyEcnrOnly();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr8()
{
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_StreamingOngoing();
	VoiceCallAudioRegion_VoiceCallAudio_react(false);
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_0_tr0()
{
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse_default();
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_0_tr1()
{
	ifaceVoiceCallAudioSmHandler_OCB->updateSamplingType(ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_value);
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure_default();
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_1_tr0()
{
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallStartStreaming();
}

void VoiceCallAudioSm::effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_1_tr1()
{
	ifaceVoiceCallAudioSmHandler_OCB->updateSamplingType(ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_value);
	ifaceEcnrRequest_OCB->sendEcnrSetConfiguration(ifaceVoiceCallAudioSmHandler.samplingType);
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure_default();
}

/* Entry action for state 'PreparingVoiceCallAudio'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio()
{
	/* Entry action for state 'PreparingVoiceCallAudio'. */
	ifaceVoiceCallAudioSmHandler_OCB->updateStatus(PREPARING, (sc_string) "Preparing");
}

/* Entry action for state 'ReadyToStream'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream()
{
	/* Entry action for state 'ReadyToStream'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_READY_TO_PLAY(InternalSCI_READY_TO_PLAY));
}

/* Entry action for state 'WaitForPhoneRouteAllocation'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation()
{
	/* Entry action for state 'WaitForPhoneRouteAllocation'. */
	ifaceAudioWrapperReqIf_OCB->sendAllocateRequest();
}

/* Entry action for state 'VoiceCallSAOnReceived'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived()
{
	/* Entry action for state 'VoiceCallSAOnReceived'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_READY_TO_PLAY(InternalSCI_READY_TO_PLAY));
}

/* Entry action for state 'WaitForSAOn'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn()
{
	/* Entry action for state 'WaitForSAOn'. */
	ifaceVoiceCallAudioSmHandler_OCB->updateStatus(READY_TO_STREAM, (sc_string) "Voice call audio channel Granted");
}

/* Entry action for state 'WaitForEcnrInit'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit()
{
	/* Entry action for state 'WaitForEcnrInit'. */
	ifaceEcnrRequest_OCB->sendEcnrInit(ifaceVoiceCallAudioSmHandler.samplingType);
}

/* Entry action for state 'WaitForEcnrStart'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart()
{
	/* Entry action for state 'WaitForEcnrStart'. */
	ifaceEcnrRequest_OCB->sendEcnrStart();
}

/* Entry action for state 'Streaming'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming()
{
	/* Entry action for state 'Streaming'. */
	ifaceVoiceCallAudioSmHandler_OCB->updateStatus(STREAMING, (sc_string) "Audio streaming");
}

/* Entry action for state 'ConfigureAndStream'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream()
{
	/* Entry action for state 'ConfigureAndStream'. */
	ifaceVoiceCallAudioSmHandler_OCB->updateStatus(STREAMING_PAUSED, (sc_string) "Audio paused");
}

/* Entry action for state 'WaitForEcnrStop'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop()
{
	/* Entry action for state 'WaitForEcnrStop'. */
	ifaceEcnrRequest_OCB->sendEcnrStop();
}

/* Entry action for state 'WaitForEcnrDestroy'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy()
{
	/* Entry action for state 'WaitForEcnrDestroy'. */
	ifaceEcnrRequest_OCB->sendEcnrDestroy();
}

/* Entry action for state 'EcnrDestroyed'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed()
{
	/* Entry action for state 'EcnrDestroyed'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT));
}

/* Entry action for state 'WaitForPhoneRouteDeallocation'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation()
{
	/* Entry action for state 'WaitForPhoneRouteDeallocation'. */
	ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
}

/* Entry action for state 'VoiceCallSAOff'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff()
{
	/* Entry action for state 'VoiceCallSAOff'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT));
}

/* Entry action for state 'StreamingStopped'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped()
{
	/* Entry action for state 'StreamingStopped'. */
	ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_OFF);
}

/* Entry action for state 'WaitForRouteDeallocation'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation()
{
	/* Entry action for state 'WaitForRouteDeallocation'. */
	ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
}

/* Entry action for state 'WaitForEcnrDestroy'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy()
{
	/* Entry action for state 'WaitForEcnrDestroy'. */
	ifaceEcnrRequest_OCB->sendEcnrDestroy();
}

/* Entry action for state 'EcnrDestroyed'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed()
{
	/* Entry action for state 'EcnrDestroyed'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT));
}

/* Entry action for state 'WaitForPhoneRouteDeallocation'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation()
{
	/* Entry action for state 'WaitForPhoneRouteDeallocation'. */
	ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
}

/* Entry action for state 'VoiceCallSAOff'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff()
{
	/* Entry action for state 'VoiceCallSAOff'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT));
}

/* Entry action for state 'WaitForEcnrDestroy'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy()
{
	/* Entry action for state 'WaitForEcnrDestroy'. */
	ifaceEcnrRequest_OCB->sendEcnrDestroy();
}

/* Entry action for state 'WaitForEcnrStop'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop()
{
	/* Entry action for state 'WaitForEcnrStop'. */
	ifaceEcnrRequest_OCB->sendEcnrStop();
}

/* Entry action for state 'AutoSourceSwitch'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch()
{
	/* Entry action for state 'AutoSourceSwitch'. */
	ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_OFF);
	ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
	ifaceVoiceCallAudioSmHandler_OCB->updateStatus(DEALLOCATING, (sc_string) "Source Switch");
}

/* Entry action for state 'WaitForEcnrStop'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop()
{
	/* Entry action for state 'WaitForEcnrStop'. */
	ifaceEcnrRequest_OCB->sendEcnrStop();
}

/* Entry action for state 'VoiceCallAudioPaused'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused()
{
	/* Entry action for state 'VoiceCallAudioPaused'. */
	ifaceVoiceCallAudioSmHandler_OCB->updateStatus(STREAMING_PAUSED, (sc_string) "Audio paused");
}

/* Entry action for state 'WaitForEcnrDestroy'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy()
{
	/* Entry action for state 'WaitForEcnrDestroy'. */
	ifaceEcnrRequest_OCB->sendEcnrDestroy();
}

/* Entry action for state 'ChannelAutoPaused'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused()
{
	/* Entry action for state 'ChannelAutoPaused'. */
	ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_PAUSE);
}

/* Entry action for state 'WaitForEcnrStop'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop()
{
	/* Entry action for state 'WaitForEcnrStop'. */
	ifaceEcnrRequest_OCB->sendEcnrStop();
}

/* Entry action for state 'StartToStream'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream()
{
	/* Entry action for state 'StartToStream'. */
	ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
}

/* Entry action for state 'ConfigureAndStream'. */
void VoiceCallAudioSm::enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream()
{
	/* Entry action for state 'ConfigureAndStream'. */
	ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
}

/* 'default' enter sequence for state IDLE */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_IDLE_default()
{
	/* 'default' enter sequence for state IDLE */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_IDLE);
	}
	stateConfVector[0] = VoiceCallAudioRegion_IDLE;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state VoiceCallAudio */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_default()
{
	/* 'default' enter sequence for state VoiceCallAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_default();
}

/* 'default' enter sequence for state WaitForPlayRequest */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest_default()
{
	/* 'default' enter sequence for state WaitForPlayRequest */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ReadyToStream */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream_default()
{
	/* 'default' enter sequence for state ReadyToStream */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForPhoneRouteAllocation */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation_default()
{
	/* 'default' enter sequence for state WaitForPhoneRouteAllocation */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation);
	}
	stateConfVector[1] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state VoiceCallSAOnReceived */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived_default()
{
	/* 'default' enter sequence for state VoiceCallSAOnReceived */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived);
	}
	stateConfVector[1] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state WaitForSAOn */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn_default()
{
	/* 'default' enter sequence for state WaitForSAOn */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn);
	}
	stateConfVector[1] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn;
	stateConfVectorPosition = 1;
}

/* 'StreamingOngoing' enter sequence for state StreamingVoiceCallAudio */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_StreamingOngoing()
{
	/* 'StreamingOngoing' enter sequence for state StreamingVoiceCallAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StreamingOngoing();
}

/* 'VoiceCallStartStreaming' enter sequence for state StreamingVoiceCallAudio */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallStartStreaming()
{
	/* 'VoiceCallStartStreaming' enter sequence for state StreamingVoiceCallAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_VoiceCallStartStreaming();
}

/* 'default' enter sequence for state StreamingVoiceCallAudio */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_default()
{
	/* 'default' enter sequence for state StreamingVoiceCallAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_default();
}

/* 'entry_DeallocateRoute8' enter sequence for state StreamingVoiceCallAudio */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_entry_DeallocateRoute8()
{
	/* 'entry_DeallocateRoute8' enter sequence for state StreamingVoiceCallAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_DeallocateRoute8();
}

/* 'entry_DefaultStop1' enter sequence for state StreamingVoiceCallAudio */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_entry_DefaultStop1()
{
	/* 'entry_DefaultStop1' enter sequence for state StreamingVoiceCallAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_DefaultStop1();
}

/* 'entry_DestroyEcnrAndDeallocateRoute4' enter sequence for state StreamingVoiceCallAudio */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_entry_DestroyEcnrAndDeallocateRoute4()
{
	/* 'entry_DestroyEcnrAndDeallocateRoute4' enter sequence for state StreamingVoiceCallAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_DestroyEcnrAndDeallocateRoute4();
}

/* 'entry_StopEcnrAndDestroy3' enter sequence for state StreamingVoiceCallAudio */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_entry_StopEcnrAndDestroy3()
{
	/* 'entry_StopEcnrAndDestroy3' enter sequence for state StreamingVoiceCallAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_StopEcnrAndDestroy3();
}

/* 'default' enter sequence for state WaitForEcnrInit */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit_default()
{
	/* 'default' enter sequence for state WaitForEcnrInit */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForEcnrStart */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart_default()
{
	/* 'default' enter sequence for state WaitForEcnrStart */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StopAfterEcnrInit */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit_default()
{
	/* 'default' enter sequence for state StopAfterEcnrInit */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StopAfterEcnrStart */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart_default()
{
	/* 'default' enter sequence for state StopAfterEcnrStart */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAOffAtEcnrStart */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart_default()
{
	/* 'default' enter sequence for state AutoSAOffAtEcnrStart */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAOffAtEcnrInit */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit_default()
{
	/* 'default' enter sequence for state AutoSAOffAtEcnrInit */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state Streaming */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming_default()
{
	/* 'default' enter sequence for state Streaming */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming;
	stateConfVectorPosition = 0;
}

/* 'AutoSAPause' enter sequence for state PauseAudioRequestBeforeEcnrConfigured */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_AutoSAPause()
{
	/* 'AutoSAPause' enter sequence for state PauseAudioRequestBeforeEcnrConfigured */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_AutoSAPause();
}

/* 'Ready2Stream' enter sequence for state PauseAudioRequestBeforeEcnrConfigured */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_Ready2Stream()
{
	/* 'Ready2Stream' enter sequence for state PauseAudioRequestBeforeEcnrConfigured */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_Ready2Stream();
}

/* 'default' enter sequence for state PauseAudioRequestBeforeEcnrConfigured */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_default()
{
	/* 'default' enter sequence for state PauseAudioRequestBeforeEcnrConfigured */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_default();
}

/* 'default' enter sequence for state ChannelPaused */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused_default()
{
	/* 'default' enter sequence for state ChannelPaused */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForEcnrResponse */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse_default()
{
	/* 'default' enter sequence for state WaitForEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ReadyToStream */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream_default()
{
	/* 'default' enter sequence for state ReadyToStream */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ConfigureAndStream */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream_default()
{
	/* 'default' enter sequence for state ConfigureAndStream */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ChannelActivated */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated_default()
{
	/* 'default' enter sequence for state ChannelActivated */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PlayAfterEcnrResponse */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state PlayAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'AutoSAPause' enter sequence for state PauseAudioRequestBeforeEcnrStarted */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_AutoSAPause()
{
	/* 'AutoSAPause' enter sequence for state PauseAudioRequestBeforeEcnrStarted */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_AutoSAPause();
}

/* 'default' enter sequence for state PauseAudioRequestBeforeEcnrStarted */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_default()
{
	/* 'default' enter sequence for state PauseAudioRequestBeforeEcnrStarted */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_default();
}

/* 'default' enter sequence for state ChannelPaused */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused_default()
{
	/* 'default' enter sequence for state ChannelPaused */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForEcnrResponse */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse_default()
{
	/* 'default' enter sequence for state WaitForEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ChannelActivated */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated_default()
{
	/* 'default' enter sequence for state ChannelActivated */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PlayAfterEcnrResponse */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state PlayAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'AutoSAOff' enter sequence for state StopCallAudioStreaming */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_AutoSAOff()
{
	/* 'AutoSAOff' enter sequence for state StopCallAudioStreaming */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSAOff();
}

/* 'DeallocateRoute' enter sequence for state StopCallAudioStreaming */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_DeallocateRoute()
{
	/* 'DeallocateRoute' enter sequence for state StopCallAudioStreaming */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DeallocateRoute();
}

/* 'DestroyEcnrAndDeallocateRoute' enter sequence for state StopCallAudioStreaming */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_DestroyEcnrAndDeallocateRoute()
{
	/* 'DestroyEcnrAndDeallocateRoute' enter sequence for state StopCallAudioStreaming */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateRoute();
}

/* 'DestroyEcnrOnly' enter sequence for state StopCallAudioStreaming */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_DestroyEcnrOnly()
{
	/* 'DestroyEcnrOnly' enter sequence for state StopCallAudioStreaming */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrOnly();
}

/* 'StopEcnrAndDestroy' enter sequence for state StopCallAudioStreaming */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopEcnrAndDestroy()
{
	/* 'StopEcnrAndDestroy' enter sequence for state StopCallAudioStreaming */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopEcnrAndDestroy();
}

/* 'default' enter sequence for state StopCallAudioStreaming */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_default()
{
	/* 'default' enter sequence for state StopCallAudioStreaming */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_default();
}

/* 'default' enter sequence for state WaitForEcnrStop */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop_default()
{
	/* 'default' enter sequence for state WaitForEcnrStop */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForEcnrDestroy */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_default()
{
	/* 'default' enter sequence for state WaitForEcnrDestroy */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state EcnrDestroyed */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed_default()
{
	/* 'default' enter sequence for state EcnrDestroyed */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForPhoneRouteDeallocation */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation_default()
{
	/* 'default' enter sequence for state WaitForPhoneRouteDeallocation */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation);
	}
	stateConfVector[1] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state VoiceCallSAOff */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff_default()
{
	/* 'default' enter sequence for state VoiceCallSAOff */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff);
	}
	stateConfVector[1] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state StreamingStopped */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped_default()
{
	/* 'default' enter sequence for state StreamingStopped */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForRouteDeallocation */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation_default()
{
	/* 'default' enter sequence for state WaitForRouteDeallocation */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForEcnrDestroy */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_default()
{
	/* 'default' enter sequence for state WaitForEcnrDestroy */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state EcnrDestroyed */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed_default()
{
	/* 'default' enter sequence for state EcnrDestroyed */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForPhoneRouteDeallocation */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation_default()
{
	/* 'default' enter sequence for state WaitForPhoneRouteDeallocation */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation);
	}
	stateConfVector[1] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state VoiceCallSAOff */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff_default()
{
	/* 'default' enter sequence for state VoiceCallSAOff */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff);
	}
	stateConfVector[1] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state WaitForEcnrDestroy */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy_default()
{
	/* 'default' enter sequence for state WaitForEcnrDestroy */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForEcnrStop */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop_default()
{
	/* 'default' enter sequence for state WaitForEcnrStop */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSourceSwitch */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch_default()
{
	/* 'default' enter sequence for state AutoSourceSwitch */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PauseVoiceCallAudio */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_default()
{
	/* 'default' enter sequence for state PauseVoiceCallAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_default();
}

/* 'entry_AutoSAOffAfterEcnrResponse3' enter sequence for state PauseVoiceCallAudio */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_entry_AutoSAOffAfterEcnrResponse3()
{
	/* 'entry_AutoSAOffAfterEcnrResponse3' enter sequence for state PauseVoiceCallAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_AutoSAOffAfterEcnrResponse3();
}

/* 'entry_AutoSAOnAfterEcnrResponse9' enter sequence for state PauseVoiceCallAudio */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_entry_AutoSAOnAfterEcnrResponse9()
{
	/* 'entry_AutoSAOnAfterEcnrResponse9' enter sequence for state PauseVoiceCallAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_AutoSAOnAfterEcnrResponse9();
}

/* 'entry_AutoSAPauseAfterEcnrResponse5' enter sequence for state PauseVoiceCallAudio */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_entry_AutoSAPauseAfterEcnrResponse5()
{
	/* 'entry_AutoSAPauseAfterEcnrResponse5' enter sequence for state PauseVoiceCallAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_AutoSAPauseAfterEcnrResponse5();
}

/* 'entry_StopAfterEcnrResponse0' enter sequence for state PauseVoiceCallAudio */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_entry_StopAfterEcnrResponse0()
{
	/* 'entry_StopAfterEcnrResponse0' enter sequence for state PauseVoiceCallAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_StopAfterEcnrResponse0();
}

/* 'default' enter sequence for state WaitForEcnrStop */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop_default()
{
	/* 'default' enter sequence for state WaitForEcnrStop */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state VoiceCallAudioPaused */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused_default()
{
	/* 'default' enter sequence for state VoiceCallAudioPaused */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PlayAfterEcnrResponse */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state PlayAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForEcnrConfigure */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure_default()
{
	/* 'default' enter sequence for state WaitForEcnrConfigure */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PauseAfterEcnrResponse */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state PauseAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StopAfterEcnrResponse */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state StopAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAOffAfterEcnrResponse */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state AutoSAOffAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAPauseAfterEcnrResponse */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state AutoSAPauseAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAOnAfterEcnrResponse */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state AutoSAOnAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'StopEcnrAndPause' enter sequence for state AutoPaused */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_StopEcnrAndPause()
{
	/* 'StopEcnrAndPause' enter sequence for state AutoPaused */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopEcnrAndPause();
}

/* 'default' enter sequence for state AutoPaused */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_default()
{
	/* 'default' enter sequence for state AutoPaused */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_default();
}

/* 'entry_AutoSAOffAfterEcnrResponse2' enter sequence for state AutoPaused */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_entry_AutoSAOffAfterEcnrResponse2()
{
	/* 'entry_AutoSAOffAfterEcnrResponse2' enter sequence for state AutoPaused */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_entry_AutoSAOffAfterEcnrResponse2();
}

/* 'entry_StopAfterEcnrResponse3' enter sequence for state AutoPaused */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_entry_StopAfterEcnrResponse3()
{
	/* 'entry_StopAfterEcnrResponse3' enter sequence for state AutoPaused */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_entry_StopAfterEcnrResponse3();
}

/* 'default' enter sequence for state WaitForEcnrDestroy */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy_default()
{
	/* 'default' enter sequence for state WaitForEcnrDestroy */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ChannelAutoPaused */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused_default()
{
	/* 'default' enter sequence for state ChannelAutoPaused */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForEcnrStop */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop_default()
{
	/* 'default' enter sequence for state WaitForEcnrStop */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StartToStream */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream_default()
{
	/* 'default' enter sequence for state StartToStream */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ConfigureAndStream */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream_default()
{
	/* 'default' enter sequence for state ConfigureAndStream */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAOffAfterEcnrResponse */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state AutoSAOffAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StopAfterEcnrResponse */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state StopAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StopAfterEcnrStop */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop_default()
{
	/* 'default' enter sequence for state StopAfterEcnrStop */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAOffAfterEcnrStop */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop_default()
{
	/* 'default' enter sequence for state AutoSAOffAfterEcnrStop */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PauseAfterEcnrDestroy */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy_default()
{
	/* 'default' enter sequence for state PauseAfterEcnrDestroy */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PauseAfterEcnrStop */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop_default()
{
	/* 'default' enter sequence for state PauseAfterEcnrStop */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop);
	}
	stateConfVector[0] = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for region VoiceCallAudioRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_default()
{
	/* 'default' enter sequence for region VoiceCallAudioRegion */
	react_VoiceCallAudioRegion__entry_Default();
}

/* 'default' enter sequence for region VoiceCallAudioStartRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_default()
{
	/* 'default' enter sequence for region VoiceCallAudioStartRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion__entry_Default();
}

/* 'default' enter sequence for region VoiceCallAudioStreamingRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_default()
{
	/* 'default' enter sequence for region VoiceCallAudioStreamingRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion__entry_Default();
}

/* 'VoiceCallStartStreaming' enter sequence for region VoiceCallAudioStreamingRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_VoiceCallStartStreaming()
{
	/* 'VoiceCallStartStreaming' enter sequence for region VoiceCallAudioStreamingRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_VoiceCallStartStreaming();
}

/* 'StreamingOngoing' enter sequence for region VoiceCallAudioStreamingRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StreamingOngoing()
{
	/* 'StreamingOngoing' enter sequence for region VoiceCallAudioStreamingRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StreamingOngoing();
}

/* 'entry_StopEcnrAndDestroy3' enter sequence for region VoiceCallAudioStreamingRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_StopEcnrAndDestroy3()
{
	/* 'entry_StopEcnrAndDestroy3' enter sequence for region VoiceCallAudioStreamingRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_StopEcnrAndDestroy3();
}

/* 'entry_DestroyEcnrAndDeallocateRoute4' enter sequence for region VoiceCallAudioStreamingRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_DestroyEcnrAndDeallocateRoute4()
{
	/* 'entry_DestroyEcnrAndDeallocateRoute4' enter sequence for region VoiceCallAudioStreamingRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_DestroyEcnrAndDeallocateRoute4();
}

/* 'entry_DefaultStop1' enter sequence for region VoiceCallAudioStreamingRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_DefaultStop1()
{
	/* 'entry_DefaultStop1' enter sequence for region VoiceCallAudioStreamingRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_DefaultStop1();
}

/* 'entry_DeallocateRoute8' enter sequence for region VoiceCallAudioStreamingRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_DeallocateRoute8()
{
	/* 'entry_DeallocateRoute8' enter sequence for region VoiceCallAudioStreamingRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_DeallocateRoute8();
}

/* 'AutoSAPause' enter sequence for region PauseAudioRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_AutoSAPause()
{
	/* 'AutoSAPause' enter sequence for region PauseAudioRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_AutoSAPause();
}

/* 'default' enter sequence for region PauseAudioRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_default()
{
	/* 'default' enter sequence for region PauseAudioRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion__entry_Default();
}

/* 'Ready2Stream' enter sequence for region PauseAudioRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_Ready2Stream()
{
	/* 'Ready2Stream' enter sequence for region PauseAudioRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_Ready2Stream();
}

/* 'AutoSAPause' enter sequence for region PauseAudioRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_AutoSAPause()
{
	/* 'AutoSAPause' enter sequence for region PauseAudioRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_AutoSAPause();
}

/* 'default' enter sequence for region PauseAudioRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_default()
{
	/* 'default' enter sequence for region PauseAudioRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion__entry_Default();
}

/* 'default' enter sequence for region StopCallAudioStreamingRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_default()
{
	/* 'default' enter sequence for region StopCallAudioStreamingRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion__entry_Default();
}

/* 'DeallocateRoute' enter sequence for region StopCallAudioStreamingRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DeallocateRoute()
{
	/* 'DeallocateRoute' enter sequence for region StopCallAudioStreamingRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DeallocateRoute();
}

/* 'DestroyEcnrAndDeallocateRoute' enter sequence for region StopCallAudioStreamingRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateRoute()
{
	/* 'DestroyEcnrAndDeallocateRoute' enter sequence for region StopCallAudioStreamingRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateRoute();
}

/* 'DestroyEcnrOnly' enter sequence for region StopCallAudioStreamingRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrOnly()
{
	/* 'DestroyEcnrOnly' enter sequence for region StopCallAudioStreamingRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrOnly();
}

/* 'StopEcnrAndDestroy' enter sequence for region StopCallAudioStreamingRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopEcnrAndDestroy()
{
	/* 'StopEcnrAndDestroy' enter sequence for region StopCallAudioStreamingRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopEcnrAndDestroy();
}

/* 'AutoSAOff' enter sequence for region StopCallAudioStreamingRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSAOff()
{
	/* 'AutoSAOff' enter sequence for region StopCallAudioStreamingRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSAOff();
}

/* 'default' enter sequence for region PauseVoiceCallAudioRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_default()
{
	/* 'default' enter sequence for region PauseVoiceCallAudioRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__entry_Default();
}

/* 'entry_StopAfterEcnrResponse0' enter sequence for region PauseVoiceCallAudioRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_StopAfterEcnrResponse0()
{
	/* 'entry_StopAfterEcnrResponse0' enter sequence for region PauseVoiceCallAudioRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_StopAfterEcnrResponse0();
}

/* 'entry_AutoSAOffAfterEcnrResponse3' enter sequence for region PauseVoiceCallAudioRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_AutoSAOffAfterEcnrResponse3()
{
	/* 'entry_AutoSAOffAfterEcnrResponse3' enter sequence for region PauseVoiceCallAudioRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_AutoSAOffAfterEcnrResponse3();
}

/* 'entry_AutoSAPauseAfterEcnrResponse5' enter sequence for region PauseVoiceCallAudioRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_AutoSAPauseAfterEcnrResponse5()
{
	/* 'entry_AutoSAPauseAfterEcnrResponse5' enter sequence for region PauseVoiceCallAudioRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_AutoSAPauseAfterEcnrResponse5();
}

/* 'entry_AutoSAOnAfterEcnrResponse9' enter sequence for region PauseVoiceCallAudioRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_AutoSAOnAfterEcnrResponse9()
{
	/* 'entry_AutoSAOnAfterEcnrResponse9' enter sequence for region PauseVoiceCallAudioRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_AutoSAOnAfterEcnrResponse9();
}

/* 'default' enter sequence for region AutoPauseRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_default()
{
	/* 'default' enter sequence for region AutoPauseRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion__entry_Default();
}

/* 'StopEcnrAndPause' enter sequence for region AutoPauseRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopEcnrAndPause()
{
	/* 'StopEcnrAndPause' enter sequence for region AutoPauseRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopEcnrAndPause();
}

/* 'entry_AutoSAOffAfterEcnrResponse2' enter sequence for region AutoPauseRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_entry_AutoSAOffAfterEcnrResponse2()
{
	/* 'entry_AutoSAOffAfterEcnrResponse2' enter sequence for region AutoPauseRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_entry_AutoSAOffAfterEcnrResponse2();
}

/* 'entry_StopAfterEcnrResponse3' enter sequence for region AutoPauseRegion */
void VoiceCallAudioSm::enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_entry_StopAfterEcnrResponse3()
{
	/* 'entry_StopAfterEcnrResponse3' enter sequence for region AutoPauseRegion */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_entry_StopAfterEcnrResponse3();
}

/* Default exit sequence for state IDLE */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_IDLE()
{
	/* Default exit sequence for state IDLE */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state VoiceCallAudio */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio()
{
	/* Default exit sequence for state VoiceCallAudio */
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion();
}

/* Default exit sequence for state PreparingVoiceCallAudio */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio()
{
	/* Default exit sequence for state PreparingVoiceCallAudio */
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion();
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion();
}

/* Default exit sequence for state WaitForPlayRequest */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest()
{
	/* Default exit sequence for state WaitForPlayRequest */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ReadyToStream */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream()
{
	/* Default exit sequence for state ReadyToStream */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForPhoneRouteAllocation */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation()
{
	/* Default exit sequence for state WaitForPhoneRouteAllocation */
	stateConfVector[1] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state VoiceCallSAOnReceived */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived()
{
	/* Default exit sequence for state VoiceCallSAOnReceived */
	stateConfVector[1] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state WaitForSAOn */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn()
{
	/* Default exit sequence for state WaitForSAOn */
	stateConfVector[1] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state StreamingVoiceCallAudio */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio()
{
	/* Default exit sequence for state StreamingVoiceCallAudio */
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion();
}

/* Default exit sequence for state WaitForEcnrInit */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit()
{
	/* Default exit sequence for state WaitForEcnrInit */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForEcnrStart */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart()
{
	/* Default exit sequence for state WaitForEcnrStart */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopAfterEcnrInit */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit()
{
	/* Default exit sequence for state StopAfterEcnrInit */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopAfterEcnrStart */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart()
{
	/* Default exit sequence for state StopAfterEcnrStart */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAOffAtEcnrStart */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart()
{
	/* Default exit sequence for state AutoSAOffAtEcnrStart */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAOffAtEcnrInit */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit()
{
	/* Default exit sequence for state AutoSAOffAtEcnrInit */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state Streaming */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming()
{
	/* Default exit sequence for state Streaming */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PauseAudioRequestBeforeEcnrConfigured */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured()
{
	/* Default exit sequence for state PauseAudioRequestBeforeEcnrConfigured */
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion();
}

/* Default exit sequence for state ChannelPaused */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused()
{
	/* Default exit sequence for state ChannelPaused */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForEcnrResponse */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse()
{
	/* Default exit sequence for state WaitForEcnrResponse */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ReadyToStream */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream()
{
	/* Default exit sequence for state ReadyToStream */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ConfigureAndStream */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream()
{
	/* Default exit sequence for state ConfigureAndStream */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ChannelActivated */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated()
{
	/* Default exit sequence for state ChannelActivated */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PlayAfterEcnrResponse */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse()
{
	/* Default exit sequence for state PlayAfterEcnrResponse */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PauseAudioRequestBeforeEcnrStarted */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted()
{
	/* Default exit sequence for state PauseAudioRequestBeforeEcnrStarted */
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion();
}

/* Default exit sequence for state ChannelPaused */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused()
{
	/* Default exit sequence for state ChannelPaused */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForEcnrResponse */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse()
{
	/* Default exit sequence for state WaitForEcnrResponse */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ChannelActivated */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated()
{
	/* Default exit sequence for state ChannelActivated */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PlayAfterEcnrResponse */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse()
{
	/* Default exit sequence for state PlayAfterEcnrResponse */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopCallAudioStreaming */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming()
{
	/* Default exit sequence for state StopCallAudioStreaming */
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion();
}

/* Default exit sequence for state StopStreamingAndDeallocateChannel */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel()
{
	/* Default exit sequence for state StopStreamingAndDeallocateChannel */
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation();
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation();
}

/* Default exit sequence for state WaitForEcnrStop */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop()
{
	/* Default exit sequence for state WaitForEcnrStop */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForEcnrDestroy */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy()
{
	/* Default exit sequence for state WaitForEcnrDestroy */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state EcnrDestroyed */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed()
{
	/* Default exit sequence for state EcnrDestroyed */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForPhoneRouteDeallocation */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation()
{
	/* Default exit sequence for state WaitForPhoneRouteDeallocation */
	stateConfVector[1] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state VoiceCallSAOff */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff()
{
	/* Default exit sequence for state VoiceCallSAOff */
	stateConfVector[1] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state StreamingStopped */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped()
{
	/* Default exit sequence for state StreamingStopped */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForRouteDeallocation */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation()
{
	/* Default exit sequence for state WaitForRouteDeallocation */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state DestroyEcnrAndDeallocateChannel */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel()
{
	/* Default exit sequence for state DestroyEcnrAndDeallocateChannel */
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation();
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation();
}

/* Default exit sequence for state WaitForEcnrDestroy */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy()
{
	/* Default exit sequence for state WaitForEcnrDestroy */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state EcnrDestroyed */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed()
{
	/* Default exit sequence for state EcnrDestroyed */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForPhoneRouteDeallocation */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation()
{
	/* Default exit sequence for state WaitForPhoneRouteDeallocation */
	stateConfVector[1] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state VoiceCallSAOff */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff()
{
	/* Default exit sequence for state VoiceCallSAOff */
	stateConfVector[1] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state WaitForEcnrDestroy */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy()
{
	/* Default exit sequence for state WaitForEcnrDestroy */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForEcnrStop */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop()
{
	/* Default exit sequence for state WaitForEcnrStop */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSourceSwitch */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch()
{
	/* Default exit sequence for state AutoSourceSwitch */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PauseVoiceCallAudio */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio()
{
	/* Default exit sequence for state PauseVoiceCallAudio */
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion();
}

/* Default exit sequence for state WaitForEcnrStop */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop()
{
	/* Default exit sequence for state WaitForEcnrStop */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state VoiceCallAudioPaused */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused()
{
	/* Default exit sequence for state VoiceCallAudioPaused */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PlayAfterEcnrResponse */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse()
{
	/* Default exit sequence for state PlayAfterEcnrResponse */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForEcnrConfigure */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure()
{
	/* Default exit sequence for state WaitForEcnrConfigure */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PauseAfterEcnrResponse */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse()
{
	/* Default exit sequence for state PauseAfterEcnrResponse */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopAfterEcnrResponse */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse()
{
	/* Default exit sequence for state StopAfterEcnrResponse */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAOffAfterEcnrResponse */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse()
{
	/* Default exit sequence for state AutoSAOffAfterEcnrResponse */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAPauseAfterEcnrResponse */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse()
{
	/* Default exit sequence for state AutoSAPauseAfterEcnrResponse */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAOnAfterEcnrResponse */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse()
{
	/* Default exit sequence for state AutoSAOnAfterEcnrResponse */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoPaused */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused()
{
	/* Default exit sequence for state AutoPaused */
	exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion();
}

/* Default exit sequence for state WaitForEcnrDestroy */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy()
{
	/* Default exit sequence for state WaitForEcnrDestroy */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ChannelAutoPaused */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused()
{
	/* Default exit sequence for state ChannelAutoPaused */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForEcnrStop */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop()
{
	/* Default exit sequence for state WaitForEcnrStop */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StartToStream */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream()
{
	/* Default exit sequence for state StartToStream */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ConfigureAndStream */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream()
{
	/* Default exit sequence for state ConfigureAndStream */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAOffAfterEcnrResponse */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse()
{
	/* Default exit sequence for state AutoSAOffAfterEcnrResponse */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopAfterEcnrResponse */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse()
{
	/* Default exit sequence for state StopAfterEcnrResponse */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopAfterEcnrStop */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop()
{
	/* Default exit sequence for state StopAfterEcnrStop */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAOffAfterEcnrStop */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop()
{
	/* Default exit sequence for state AutoSAOffAfterEcnrStop */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PauseAfterEcnrDestroy */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy()
{
	/* Default exit sequence for state PauseAfterEcnrDestroy */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PauseAfterEcnrStop */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop()
{
	/* Default exit sequence for state PauseAfterEcnrStop */
	stateConfVector[0] = VoiceCallAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for region VoiceCallAudioRegion */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion()
{
	/* Default exit sequence for region VoiceCallAudioRegion */
	/* Handle exit of all possible states (of VoiceCallAudioSm.VoiceCallAudioRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceCallAudioRegion_IDLE :
		{
			exseq_VoiceCallAudioRegion_IDLE();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop();
			break;
		}
		default: break;
	}
	/* Handle exit of all possible states (of VoiceCallAudioSm.VoiceCallAudioRegion) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region VoiceCallAudioStartRegion */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion()
{
	/* Default exit sequence for region VoiceCallAudioStartRegion */
	/* Handle exit of all possible states (of VoiceCallAudioSm.VoiceCallAudioRegion.VoiceCallAudio.VoiceCallAudioStartRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop();
			break;
		}
		default: break;
	}
	/* Handle exit of all possible states (of VoiceCallAudioSm.VoiceCallAudioRegion.VoiceCallAudio.VoiceCallAudioStartRegion) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region AmClientRequestWaitRegion */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion()
{
	/* Default exit sequence for region AmClientRequestWaitRegion */
	/* Handle exit of all possible states (of VoiceCallAudioSm.VoiceCallAudioRegion.VoiceCallAudio.VoiceCallAudioStartRegion.PreparingVoiceCallAudio.AmClientRequestWaitRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region ArlResponseWaitRegion */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion()
{
	/* Default exit sequence for region ArlResponseWaitRegion */
	/* Handle exit of all possible states (of VoiceCallAudioSm.VoiceCallAudioRegion.VoiceCallAudio.VoiceCallAudioStartRegion.PreparingVoiceCallAudio.ArlResponseWaitRegion) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region VoiceCallAudioStreamingRegion */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion()
{
	/* Default exit sequence for region VoiceCallAudioStreamingRegion */
	/* Handle exit of all possible states (of VoiceCallAudioSm.VoiceCallAudioRegion.VoiceCallAudio.VoiceCallAudioStartRegion.StreamingVoiceCallAudio.VoiceCallAudioStreamingRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region PauseAudioRegion */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion()
{
	/* Default exit sequence for region PauseAudioRegion */
	/* Handle exit of all possible states (of VoiceCallAudioSm.VoiceCallAudioRegion.VoiceCallAudio.VoiceCallAudioStartRegion.StreamingVoiceCallAudio.VoiceCallAudioStreamingRegion.PauseAudioRequestBeforeEcnrConfigured.PauseAudioRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region PauseAudioRegion */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion()
{
	/* Default exit sequence for region PauseAudioRegion */
	/* Handle exit of all possible states (of VoiceCallAudioSm.VoiceCallAudioRegion.VoiceCallAudio.VoiceCallAudioStartRegion.StreamingVoiceCallAudio.VoiceCallAudioStreamingRegion.PauseAudioRequestBeforeEcnrStarted.PauseAudioRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region StopCallAudioStreamingRegion */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion()
{
	/* Default exit sequence for region StopCallAudioStreamingRegion */
	/* Handle exit of all possible states (of VoiceCallAudioSm.VoiceCallAudioRegion.VoiceCallAudio.VoiceCallAudioStartRegion.StopCallAudioStreaming.StopCallAudioStreamingRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch();
			break;
		}
		default: break;
	}
	/* Handle exit of all possible states (of VoiceCallAudioSm.VoiceCallAudioRegion.VoiceCallAudio.VoiceCallAudioStartRegion.StopCallAudioStreaming.StopCallAudioStreamingRegion) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region EcnrOperation */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation()
{
	/* Default exit sequence for region EcnrOperation */
	/* Handle exit of all possible states (of VoiceCallAudioSm.VoiceCallAudioRegion.VoiceCallAudio.VoiceCallAudioStartRegion.StopCallAudioStreaming.StopCallAudioStreamingRegion.StopStreamingAndDeallocateChannel.EcnrOperation) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region ArlOperation */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation()
{
	/* Default exit sequence for region ArlOperation */
	/* Handle exit of all possible states (of VoiceCallAudioSm.VoiceCallAudioRegion.VoiceCallAudio.VoiceCallAudioStartRegion.StopCallAudioStreaming.StopCallAudioStreamingRegion.StopStreamingAndDeallocateChannel.ArlOperation) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region EcnrOperation */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation()
{
	/* Default exit sequence for region EcnrOperation */
	/* Handle exit of all possible states (of VoiceCallAudioSm.VoiceCallAudioRegion.VoiceCallAudio.VoiceCallAudioStartRegion.StopCallAudioStreaming.StopCallAudioStreamingRegion.DestroyEcnrAndDeallocateChannel.EcnrOperation) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region ArlOperation */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation()
{
	/* Default exit sequence for region ArlOperation */
	/* Handle exit of all possible states (of VoiceCallAudioSm.VoiceCallAudioRegion.VoiceCallAudio.VoiceCallAudioStartRegion.StopCallAudioStreaming.StopCallAudioStreamingRegion.DestroyEcnrAndDeallocateChannel.ArlOperation) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region PauseVoiceCallAudioRegion */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion()
{
	/* Default exit sequence for region PauseVoiceCallAudioRegion */
	/* Handle exit of all possible states (of VoiceCallAudioSm.VoiceCallAudioRegion.VoiceCallAudio.VoiceCallAudioStartRegion.PauseVoiceCallAudio.PauseVoiceCallAudioRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region AutoPauseRegion */
void VoiceCallAudioSm::exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion()
{
	/* Default exit sequence for region AutoPauseRegion */
	/* Handle exit of all possible states (of VoiceCallAudioSm.VoiceCallAudioRegion.VoiceCallAudio.VoiceCallAudioStartRegion.AutoPaused.AutoPauseRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy();
			break;
		}
		case VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop :
		{
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop();
			break;
		}
		default: break;
	}
}

/* The reactions of state null. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_0()
{
	/* The reactions of state null. */
	if (check_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_0_tr0_tr0())
	{ 
		effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_0_tr0();
	}  else
	{
		effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_0_tr1();
	}
}

/* The reactions of state null. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_1()
{
	/* The reactions of state null. */
	if (check_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_1_tr0_tr0())
	{ 
		effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_1_tr0();
	}  else
	{
		effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_1_tr1();
	}
}

/* Default react sequence for initial entry  */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion__sync0();
}

/* Default react sequence for initial entry  */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit_default();
}

/* Default react sequence for initial entry VoiceCallStartStreaming */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_VoiceCallStartStreaming()
{
	/* Default react sequence for initial entry VoiceCallStartStreaming */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart_default();
}

/* Default react sequence for initial entry AutoSAPause */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_AutoSAPause()
{
	/* Default react sequence for initial entry AutoSAPause */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused_default();
}

/* Default react sequence for initial entry  */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse_default();
}

/* Default react sequence for initial entry Ready2Stream */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_Ready2Stream()
{
	/* Default react sequence for initial entry Ready2Stream */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream_default();
}

/* Default react sequence for initial entry AutoSAPause */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_AutoSAPause()
{
	/* Default react sequence for initial entry AutoSAPause */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused_default();
}

/* Default react sequence for initial entry  */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse_default();
}

/* Default react sequence for initial entry StreamingOngoing */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StreamingOngoing()
{
	/* Default react sequence for initial entry StreamingOngoing */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming_default();
}

/* Default react sequence for initial entry entry_StopEcnrAndDestroy3 */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_StopEcnrAndDestroy3()
{
	/* Default react sequence for initial entry entry_StopEcnrAndDestroy3 */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopEcnrAndDestroy();
}

/* Default react sequence for initial entry entry_DestroyEcnrAndDeallocateRoute4 */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_DestroyEcnrAndDeallocateRoute4()
{
	/* Default react sequence for initial entry entry_DestroyEcnrAndDeallocateRoute4 */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DestroyEcnrAndDeallocateRoute();
}

/* Default react sequence for initial entry entry_DefaultStop1 */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_DefaultStop1()
{
	/* Default react sequence for initial entry entry_DefaultStop1 */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DefaultStop();
}

/* Default react sequence for initial entry entry_DeallocateRoute8 */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_entry_DeallocateRoute8()
{
	/* Default react sequence for initial entry entry_DeallocateRoute8 */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DeallocateRoute();
}

/* Default react sequence for initial entry  */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel);
	}
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation__sync0();
}

/* Default react sequence for initial entry DeallocateRoute */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DeallocateRoute()
{
	/* Default react sequence for initial entry DeallocateRoute */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation_default();
}

/* Default react sequence for initial entry DestroyEcnrAndDeallocateRoute */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateRoute()
{
	/* Default react sequence for initial entry DestroyEcnrAndDeallocateRoute */
	react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion__sync2();
}

/* Default react sequence for initial entry DestroyEcnrOnly */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrOnly()
{
	/* Default react sequence for initial entry DestroyEcnrOnly */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy_default();
}

/* Default react sequence for initial entry StopEcnrAndDestroy */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopEcnrAndDestroy()
{
	/* Default react sequence for initial entry StopEcnrAndDestroy */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop_default();
}

/* Default react sequence for initial entry AutoSAOff */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSAOff()
{
	/* Default react sequence for initial entry AutoSAOff */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch_default();
}

/* Default react sequence for initial entry  */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop_default();
}

/* Default react sequence for initial entry entry_StopAfterEcnrResponse0 */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_StopAfterEcnrResponse0()
{
	/* Default react sequence for initial entry entry_StopAfterEcnrResponse0 */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse_default();
}

/* Default react sequence for initial entry entry_AutoSAOffAfterEcnrResponse3 */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_AutoSAOffAfterEcnrResponse3()
{
	/* Default react sequence for initial entry entry_AutoSAOffAfterEcnrResponse3 */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse_default();
}

/* Default react sequence for initial entry entry_AutoSAPauseAfterEcnrResponse5 */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_AutoSAPauseAfterEcnrResponse5()
{
	/* Default react sequence for initial entry entry_AutoSAPauseAfterEcnrResponse5 */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse_default();
}

/* Default react sequence for initial entry entry_AutoSAOnAfterEcnrResponse9 */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_entry_AutoSAOnAfterEcnrResponse9()
{
	/* Default react sequence for initial entry entry_AutoSAOnAfterEcnrResponse9 */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse_default();
}

/* Default react sequence for initial entry  */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy_default();
}

/* Default react sequence for initial entry StopEcnrAndPause */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopEcnrAndPause()
{
	/* Default react sequence for initial entry StopEcnrAndPause */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop_default();
}

/* Default react sequence for initial entry entry_AutoSAOffAfterEcnrResponse2 */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_entry_AutoSAOffAfterEcnrResponse2()
{
	/* Default react sequence for initial entry entry_AutoSAOffAfterEcnrResponse2 */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse_default();
}

/* Default react sequence for initial entry entry_StopAfterEcnrResponse3 */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_entry_StopAfterEcnrResponse3()
{
	/* Default react sequence for initial entry entry_StopAfterEcnrResponse3 */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse_default();
}

/* Default react sequence for initial entry  */
void VoiceCallAudioSm::react_VoiceCallAudioRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_VoiceCallAudioRegion_IDLE_default();
}

/* The reactions of exit StopEcnrAndDestroy. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopEcnrAndDestroy()
{
	/* The reactions of exit StopEcnrAndDestroy. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr2();
}

/* The reactions of exit DestroyEcnrAndDeallocateRoute. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DestroyEcnrAndDeallocateRoute()
{
	/* The reactions of exit DestroyEcnrAndDeallocateRoute. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr5();
}

/* The reactions of exit DefaultStop. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DefaultStop()
{
	/* The reactions of exit DefaultStop. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr6();
}

/* The reactions of exit StreamAudio. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_StreamAudio()
{
	/* The reactions of exit StreamAudio. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_tr4();
}

/* The reactions of exit DestroyEcnr. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DestroyEcnr()
{
	/* The reactions of exit DestroyEcnr. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr7();
}

/* The reactions of exit AutoSAOff. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOff()
{
	/* The reactions of exit AutoSAOff. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr9();
}

/* The reactions of exit DeallocateRoute. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DeallocateRoute()
{
	/* The reactions of exit DeallocateRoute. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr0();
}

/* The reactions of exit DestroyEcnrAndPause. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DestroyEcnrAndPause()
{
	/* The reactions of exit DestroyEcnrAndPause. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr10();
}

/* The reactions of exit ReadyToStream. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ReadyToStream()
{
	/* The reactions of exit ReadyToStream. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_tr2();
}

/* The reactions of exit StreamingStarted. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_StreamingStarted()
{
	/* The reactions of exit StreamingStarted. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_tr3();
}

/* The reactions of exit StopEcnrAndPause. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopEcnrAndPause()
{
	/* The reactions of exit StopEcnrAndPause. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr11();
}

/* The reactions of exit PauseAudio. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudio()
{
	/* The reactions of exit PauseAudio. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_tr12();
}

/* The reactions of exit exitOnDeallocated. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_exitOnDeallocated()
{
	/* The reactions of exit exitOnDeallocated. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_tr1();
}

/* The reactions of exit ChannelDeallocated. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_ChannelDeallocated()
{
	/* The reactions of exit ChannelDeallocated. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_tr0();
}

/* The reactions of exit VoiceCallStartStreaming. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallStartStreaming()
{
	/* The reactions of exit VoiceCallStartStreaming. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_tr1();
}

/* The reactions of exit DestroEcnrAndDeallocate. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_DestroEcnrAndDeallocate()
{
	/* The reactions of exit DestroEcnrAndDeallocate. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_tr2();
}

/* The reactions of exit DestroyEcnr. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_DestroyEcnr()
{
	/* The reactions of exit DestroyEcnr. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_tr4();
}

/* The reactions of exit AutoSAPause. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPause()
{
	/* The reactions of exit AutoSAPause. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_tr6();
}

/* The reactions of exit ChannelDenied. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_ChannelDenied()
{
	/* The reactions of exit ChannelDenied. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_tr1();
}

/* The reactions of exit StartStreaming. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartStreaming()
{
	/* The reactions of exit StartStreaming. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr1();
}

/* The reactions of exit ConfigureEcnrAndStart. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureEcnrAndStart()
{
	/* The reactions of exit ConfigureEcnrAndStart. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr0();
}

/* The reactions of exit DeallocateRoute. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_DeallocateRoute()
{
	/* The reactions of exit DeallocateRoute. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr4();
}

/* The reactions of exit AutoSAOff. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOff()
{
	/* The reactions of exit AutoSAOff. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr6();
}

/* The reactions of exit DestroyEcnrAndDeallocate. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_DestroyEcnrAndDeallocate()
{
	/* The reactions of exit DestroyEcnrAndDeallocate. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr5();
}

/* The reactions of exit DestroyEcnrOnly. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_DestroyEcnrOnly()
{
	/* The reactions of exit DestroyEcnrOnly. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr7();
}

/* The reactions of exit STOP_FAILURE. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_STOP_FAILURE()
{
	/* The reactions of exit STOP_FAILURE. */
	effect_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_tr8();
}

/* The reactions of state null. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion__sync0()
{
	/* The reactions of state null. */
	enact_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest_default();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation_default();
}

/* The reactions of state null. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion__sync1()
{
	/* The reactions of state null. */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_default();
}

/* The reactions of state null. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation__sync0()
{
	/* The reactions of state null. */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop_default();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation_default();
}

/* The reactions of state null. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion__sync0()
{
	/* The reactions of state null. */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped_default();
}

/* The reactions of state null. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion__sync1()
{
	/* The reactions of state null. */
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped_default();
}

/* The reactions of state null. */
void VoiceCallAudioSm::react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion__sync2()
{
	/* The reactions of state null. */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel);
	}
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_default();
	enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation_default();
}

sc_boolean VoiceCallAudioSm::react() {
	/* State machine reactions. */
	return false;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_IDLE_react(const sc_boolean try_transition) {
	/* The reactions of state IDLE. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.PREPARE_VOICECALL_CHANNEL_raised)
		{ 
			exseq_VoiceCallAudioRegion_IDLE();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_default();
			react();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_ON_raised)
		{ 
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
		} 
		if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
		{ 
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_OFF);
		} 
		did_transition = react();
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_react(const sc_boolean try_transition) {
	/* The reactions of state VoiceCallAudio. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = react();
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_react(const sc_boolean try_transition) {
	/* The reactions of state PreparingVoiceCallAudio. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_CHANNEL_DENIED_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio();
			ifaceVoiceCallAudioSmHandler_OCB->updateStatus(FAILURE, (sc_string) "ChannelAcquisition-Channel Denied");
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_ChannelDenied();
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio();
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_AutoSAOff();
				VoiceCallAudioRegion_VoiceCallAudio_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForPlayRequest. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_WaitForPlayRequest();
			ifaceVoiceCallAudioSmHandler_OCB->updateSamplingType(ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_value);
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream_default();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream_react(const sc_boolean try_transition) {
	/* The reactions of state ReadyToStream. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.READY_TO_PLAY_raised) && (isStateActive(VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived))) && (ifaceInternalSCI.READY_TO_PLAY_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion__sync1();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForPhoneRouteAllocation. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.STOP_VOICECALL_AUDIO_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio();
			ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
			ifaceVoiceCallAudioSmHandler_OCB->updateStatus(NOT_ALLOCATED, (sc_string) "Deallocated");
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_ChannelDeallocated();
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_CHANNEL_GRANTED_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForPhoneRouteAllocation();
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn_default();
				VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived_react(const sc_boolean try_transition) {
	/* The reactions of state VoiceCallSAOnReceived. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.READY_TO_PLAY_raised) && (isStateActive(VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_AmClientRequestWaitRegion_ReadyToStream))) && (ifaceInternalSCI.READY_TO_PLAY_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion__sync1();
		}  else
		{
			if (ifaceAmClientRequest.STOP_VOICECALL_AUDIO_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio();
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_DeallocateRoute();
				VoiceCallAudioRegion_VoiceCallAudio_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.PREPARE_VOICECALL_CHANNEL_raised)
		{ 
			ifaceVoiceCallAudioSmHandler_OCB->updateStatus(READY_TO_STREAM, (sc_string) "Voice call audio channel Granted");
		} 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForSAOn. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_ON_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_WaitForSAOn();
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_ArlResponseWaitRegion_VoiceCallSAOnReceived_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_react(false);
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_CHANNEL_DEALLOCATED_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio();
				ifaceVoiceCallAudioSmHandler_OCB->updateStatus(NOT_ALLOCATED, (sc_string) "Deallocated");
				react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_ChannelDeallocated();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.STOP_VOICECALL_AUDIO_raised)
		{ 
			ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
		} 
		if (ifaceAmClientRequest.PREPARE_VOICECALL_CHANNEL_raised)
		{ 
			ifaceVoiceCallAudioSmHandler_OCB->updateStatus(READY_TO_STREAM, (sc_string) "Voice call audio channel Granted");
		} 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PreparingVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(const sc_boolean try_transition) {
	/* The reactions of state StreamingVoiceCallAudio. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.STOP_VOICECALL_AUDIO_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_entry_DefaultStop1();
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio();
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_entry_StopEcnrAndDestroy3();
			}  else
			{
				if (ifaceEcnrResponse.ECNR_START_FAILURE_raised)
				{ 
					exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio();
					enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_entry_DestroyEcnrAndDeallocateRoute4();
				}  else
				{
					if (ifaceEcnrResponse.ECNR_INIT_FAILURE_raised)
					{ 
						exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio();
						enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_entry_DeallocateRoute8();
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.PREPARE_VOICECALL_CHANNEL_raised)
		{ 
			ifaceVoiceCallAudioSmHandler_OCB->updateStatus(FAILURE, (sc_string) "ChannelAcquisition-Channel Already Prepared");
		} 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrInit. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_INIT_SUCCESS_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
		}  else
		{
			if (ifaceAmClientRequest.STOP_VOICECALL_AUDIO_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit();
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit_default();
				VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
			}  else
			{
				if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
				{ 
					exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit();
					enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit_default();
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
				}  else
				{
					if (ifaceAmClientRequest.PAUSE_VOICECALL_AUDIO_raised)
					{ 
						exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit();
						enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_default();
						VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
					}  else
					{
						if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_PAUSE_raised)
						{ 
							exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit();
							enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_AutoSAPause();
							VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
						}  else
						{
							did_transition = false;
						}
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrStart. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.STOP_VOICECALL_AUDIO_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart();
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart_default();
				VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
			}  else
			{
				if (ifaceEcnrResponse.ECNR_START_SUCCESS_raised)
				{ 
					exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart();
					enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming_default();
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
				}  else
				{
					if (ifaceAmClientRequest.PAUSE_VOICECALL_AUDIO_raised)
					{ 
						exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart();
						enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_default();
						VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
					}  else
					{
						if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_PAUSE_raised)
						{ 
							exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart();
							enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_AutoSAPause();
							VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
						}  else
						{
							did_transition = false;
						}
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit_react(const sc_boolean try_transition) {
	/* The reactions of state StopAfterEcnrInit. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_INIT_SUCCESS_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DestroyEcnrAndDeallocateRoute();
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit();
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit_default();
				VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart_react(const sc_boolean try_transition) {
	/* The reactions of state StopAfterEcnrStart. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_START_SUCCESS_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DefaultStop();
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart();
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart_default();
				VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAOffAtEcnrStart. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_START_SUCCESS_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopEcnrAndDestroy();
		}  else
		{
			if (ifaceEcnrResponse.ECNR_START_FAILURE_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart();
				react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DestroyEcnr();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAOffAtEcnrInit. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_INIT_SUCCESS_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DestroyEcnr();
		}  else
		{
			if (ifaceEcnrResponse.ECNR_INIT_FAILURE_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit();
				react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOff();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming_react(const sc_boolean try_transition) {
	/* The reactions of state Streaming. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.PAUSE_VOICECALL_AUDIO_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudio();
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_PAUSE_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_Streaming();
				react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopEcnrAndPause();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(const sc_boolean try_transition) {
	/* The reactions of state PauseAudioRequestBeforeEcnrConfigured. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrInit_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
		}  else
		{
			if ((ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_raised) || (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_ON_raised))
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrInit_default();
				VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
			}  else
			{
				if (ifaceAmClientRequest.STOP_VOICECALL_AUDIO_raised)
				{ 
					exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
					enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrInit_default();
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
				}  else
				{
					if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_PAUSE_raised)
					{ 
						exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
						react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DestroyEcnrAndPause();
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused_react(const sc_boolean try_transition) {
	/* The reactions of state ChannelPaused. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_INIT_SUCCESS_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DestroyEcnrAndPause();
		}  else
		{
			if (ifaceEcnrResponse.ECNR_INIT_FAILURE_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused();
				ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_PAUSE);
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream_default();
				VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(false);
			}  else
			{
				if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_ON_raised)
				{ 
					exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused();
					ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
					enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated_default();
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_INIT_SUCCESS_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(false);
		}  else
		{
			if (ifaceEcnrResponse.ECNR_INIT_FAILURE_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse();
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream_default();
				VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(false);
			}  else
			{
				if (ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_raised)
				{ 
					exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse();
					ifaceVoiceCallAudioSmHandler_OCB->updateSamplingType(ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_value);
					enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse_default();
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(false);
				}  else
				{
					if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_PAUSE_raised)
					{ 
						exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse();
						enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused_default();
						VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(false);
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream_react(const sc_boolean try_transition) {
	/* The reactions of state ReadyToStream. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DestroyEcnr();
		}  else
		{
			if (ifaceAmClientRequest.STOP_VOICECALL_AUDIO_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
				react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DestroyEcnrAndDeallocateRoute();
			}  else
			{
				if (ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_raised)
				{ 
					exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream();
					ifaceVoiceCallAudioSmHandler_OCB->updateSamplingType(ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_value);
					react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_StreamAudio();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream_react(const sc_boolean try_transition) {
	/* The reactions of state ConfigureAndStream. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOff();
		}  else
		{
			if (ifaceAmClientRequest.STOP_VOICECALL_AUDIO_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
				react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DeallocateRoute();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.PAUSE_VOICECALL_AUDIO_raised)
		{ 
			ifaceVoiceCallAudioSmHandler_OCB->updateStatus(STREAMING_PAUSED, (sc_string) "Audio paused");
		} 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated_react(const sc_boolean try_transition) {
	/* The reactions of state ChannelActivated. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_PAUSE_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(false);
		}  else
		{
			if (ifaceEcnrResponse.ECNR_INIT_SUCCESS_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated();
				react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_StreamAudio();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state PlayAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.PAUSE_VOICECALL_AUDIO_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(false);
		}  else
		{
			if (ifaceEcnrResponse.ECNR_INIT_SUCCESS_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse();
				react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_StreamAudio();
			}  else
			{
				if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_PAUSE_raised)
				{ 
					exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse();
					enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused_default();
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_react(const sc_boolean try_transition) {
	/* The reactions of state PauseAudioRequestBeforeEcnrStarted. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_AutoSAOffAtEcnrStart_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
		}  else
		{
			if (ifaceAmClientRequest.STOP_VOICECALL_AUDIO_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopAfterEcnrStart_default();
				VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
			}  else
			{
				if ((ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_raised) || (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_ON_raised))
				{ 
					exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
					enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_WaitForEcnrStart_default();
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
				}  else
				{
					if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_PAUSE_raised)
					{ 
						exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
						if(ifaceTraceObserver != sc_null) {
							ifaceTraceObserver->stateEntered(VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted);
						}
						enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused_default();
						VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(false);
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused_react(const sc_boolean try_transition) {
	/* The reactions of state ChannelPaused. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_START_SUCCESS_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_StopEcnrAndPause();
		}  else
		{
			if (ifaceEcnrResponse.ECNR_START_FAILURE_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
				react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_DestroyEcnrAndPause();
			}  else
			{
				if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_ON_raised)
				{ 
					exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused();
					ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
					enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated_default();
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_START_SUCCESS_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudio();
		}  else
		{
			if (ifaceEcnrResponse.ECNR_START_FAILURE_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse();
				react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ReadyToStream();
			}  else
			{
				if (ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_raised)
				{ 
					exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse();
					ifaceVoiceCallAudioSmHandler_OCB->updateSamplingType(ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_value);
					enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse_default();
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated_react(const sc_boolean try_transition) {
	/* The reactions of state ChannelActivated. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_START_SUCCESS_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_StreamingStarted();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state PlayAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.PAUSE_VOICECALL_AUDIO_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_react(false);
		}  else
		{
			if (ifaceEcnrResponse.ECNR_START_SUCCESS_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse();
				react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_StreamingStarted();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_react(const sc_boolean try_transition) {
	/* The reactions of state StopCallAudioStreaming. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_CHANNEL_DEALLOCATED_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming();
			ifaceVoiceCallAudioSmHandler_OCB->updateStatus(NOT_ALLOCATED, (sc_string) "Deallocated");
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_ChannelDeallocated();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.PREPARE_VOICECALL_CHANNEL_raised)
		{ 
			ifaceVoiceCallAudioSmHandler_OCB->updateStatus(FAILURE, (sc_string) "ChannelAcquisition-Stop In Progress");
		} 
		if (ifaceAmClientRequest.PAUSE_VOICECALL_AUDIO_raised)
		{ 
			ifaceVoiceCallAudioSmHandler_OCB->updateStatus(FAILURE, (sc_string) "PauseAudio-Stop In Progress");
		} 
		if (ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_raised)
		{ 
			ifaceVoiceCallAudioSmHandler_OCB->updateStatus(FAILURE, (sc_string) "PlayAudio-Stop In Progress");
		} 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_react(const sc_boolean try_transition) {
	/* The reactions of state StopStreamingAndDeallocateChannel. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_default();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrDestroy. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_DESTROY_SUCCESS_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed_default();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed_react(const sc_boolean try_transition) {
	/* The reactions of state EcnrDestroyed. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised) && (isStateActive(VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff))) && (ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion__sync0();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForPhoneRouteDeallocation. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceCallSAOff_react(const sc_boolean try_transition) {
	/* The reactions of state VoiceCallSAOff. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised) && (isStateActive(VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed))) && (ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion__sync0();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StopStreamingAndDeallocateChannel_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped_react(const sc_boolean try_transition) {
	/* The reactions of state StreamingStopped. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForRouteDeallocation. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForRouteDeallocation();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_StreamingStopped_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_react(const sc_boolean try_transition) {
	/* The reactions of state DestroyEcnrAndDeallocateChannel. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrDestroy. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_DESTROY_SUCCESS_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed_default();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed_react(const sc_boolean try_transition) {
	/* The reactions of state EcnrDestroyed. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised) && (isStateActive(VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff))) && (ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion__sync1();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForPhoneRouteDeallocation. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForPhoneRouteDeallocation();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceCallSAOff_react(const sc_boolean try_transition) {
	/* The reactions of state VoiceCallSAOff. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised) && (isStateActive(VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed))) && (ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion__sync1();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrDestroy. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_DESTROY_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_DESTROY_FAILURE_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrStop();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_WaitForEcnrDestroy_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSourceSwitch. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_CHANNEL_DEALLOCATED_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_AutoSourceSwitch();
			ifaceVoiceCallAudioSmHandler_OCB->updateStatus(NOT_ALLOCATED, (sc_string) "Source Switch");
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_StopCallAudioStreamingRegion_exitOnDeallocated();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StopCallAudioStreaming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_react(const sc_boolean try_transition) {
	/* The reactions of state PauseVoiceCallAudio. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.STOP_VOICECALL_AUDIO_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_entry_StopAfterEcnrResponse0();
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio();
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_entry_AutoSAOffAfterEcnrResponse3();
			}  else
			{
				if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_PAUSE_raised)
				{ 
					exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio();
					enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_entry_AutoSAPauseAfterEcnrResponse5();
				}  else
				{
					if (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised)
					{ 
						exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio();
						enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_StreamingOngoing();
						VoiceCallAudioRegion_VoiceCallAudio_react(false);
					}  else
					{
						if (ifaceEcnrResponse.ECNR_SET_CONFIGURATION_FAILURE_raised)
						{ 
							exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio();
							enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_StreamingVoiceCallAudio_VoiceCallStartStreaming();
							VoiceCallAudioRegion_VoiceCallAudio_react(false);
						}  else
						{
							if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_ON_raised)
							{ 
								exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio();
								ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
								enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_entry_AutoSAOnAfterEcnrResponse9();
							}  else
							{
								did_transition = false;
							}
						}
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.PREPARE_VOICECALL_CHANNEL_raised)
		{ 
			ifaceVoiceCallAudioSmHandler_OCB->updateStatus(READY_TO_STREAM, (sc_string) "Channel Already Prepared");
		} 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_react(false);
		}  else
		{
			if (ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrStop();
				react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_0();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused_react(const sc_boolean try_transition) {
	/* The reactions of state VoiceCallAudioPaused. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_1();
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused();
				react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_DestroyEcnr();
			}  else
			{
				if (ifaceAmClientRequest.STOP_VOICECALL_AUDIO_raised)
				{ 
					exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused();
					react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_DestroEcnrAndDeallocate();
				}  else
				{
					if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_PAUSE_raised)
					{ 
						exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused();
						react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPause();
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state PlayAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.PAUSE_VOICECALL_AUDIO_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_react(false);
		}  else
		{
			if (ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PlayAfterEcnrResponse();
				react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallStartStreaming();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrConfigure. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.PAUSE_VOICECALL_AUDIO_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_react(false);
		}  else
		{
			if (ifaceEcnrResponse.ECNR_SET_CONFIGURATION_SUCCESS_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_WaitForEcnrConfigure();
				react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallStartStreaming();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised)
		{ 
			ifaceEcnrRequest_OCB->sendEcnrSetConfiguration(ifaceVoiceCallAudioSmHandler.samplingType);
		} 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state PauseAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_SET_CONFIGURATION_SUCCESS_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallAudioPaused_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_react(false);
		}  else
		{
			if (ifaceAmClientRequest.STREAM_VOICECALL_AUDIO_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_PauseAfterEcnrResponse();
				react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion__choice_0();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state StopAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((((ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised)) || (ifaceEcnrResponse.ECNR_SET_CONFIGURATION_SUCCESS_raised)) || (ifaceEcnrResponse.ECNR_SET_CONFIGURATION_FAILURE_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_StopAfterEcnrResponse();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_DestroEcnrAndDeallocate();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAOffAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((((ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised)) || (ifaceEcnrResponse.ECNR_SET_CONFIGURATION_SUCCESS_raised)) || (ifaceEcnrResponse.ECNR_SET_CONFIGURATION_FAILURE_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOffAfterEcnrResponse();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_DestroyEcnr();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAPauseAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((((ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised)) || (ifaceEcnrResponse.ECNR_SET_CONFIGURATION_SUCCESS_raised)) || (ifaceEcnrResponse.ECNR_SET_CONFIGURATION_FAILURE_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPauseAfterEcnrResponse();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAPause();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAOnAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_AutoSAOnAfterEcnrResponse();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_PauseVoiceCallAudioRegion_VoiceCallStartStreaming();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_PauseVoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(const sc_boolean try_transition) {
	/* The reactions of state AutoPaused. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_entry_AutoSAOffAfterEcnrResponse2();
		}  else
		{
			if (ifaceAmClientRequest.STOP_VOICECALL_AUDIO_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused();
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_entry_StopAfterEcnrResponse3();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.PREPARE_VOICECALL_CHANNEL_raised)
		{ 
			ifaceVoiceCallAudioSmHandler_OCB->updateStatus(FAILURE, (sc_string) "ChannelAcquisition-Channel Already Prepared");
		} 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrDestroy. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_DESTROY_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_DESTROY_FAILURE_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(false);
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_ON_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy();
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream_default();
				VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused_react(const sc_boolean try_transition) {
	/* The reactions of state ChannelAutoPaused. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_ON_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureEcnrAndStart();
		}  else
		{
			if (ifaceAmClientRequest.STOP_VOICECALL_AUDIO_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused();
				react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_DeallocateRoute();
			}  else
			{
				if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
				{ 
					exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused();
					react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOff();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.PAUSE_VOICECALL_AUDIO_raised)
		{ 
			ifaceVoiceCallAudioSmHandler_OCB->updateStatus(STREAMING_PAUSED, (sc_string) "Audio paused");
		} 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(false);
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_ON_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream_default();
				VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(false);
			}  else
			{
				if (ifaceAmClientRequest.STOP_VOICECALL_AUDIO_raised)
				{ 
					exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
					enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop_default();
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(false);
				}  else
				{
					if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
					{ 
						exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
						enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop_default();
						VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(false);
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream_react(const sc_boolean try_transition) {
	/* The reactions of state StartToStream. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartStreaming();
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_PAUSE_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop_default();
				VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(false);
			}  else
			{
				if (ifaceAmClientRequest.STOP_VOICECALL_AUDIO_raised)
				{ 
					exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
					enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop_default();
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(false);
				}  else
				{
					if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_OFF_raised)
					{ 
						exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
						enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop_default();
						VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(false);
					}  else
					{
						if (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised)
						{ 
							exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
							react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_STOP_FAILURE();
						}  else
						{
							did_transition = false;
						}
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream_react(const sc_boolean try_transition) {
	/* The reactions of state ConfigureAndStream. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_DESTROY_FAILURE_raised)
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartStreaming();
		}  else
		{
			if (ifaceEcnrResponse.ECNR_DESTROY_SUCCESS_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream();
				react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureEcnrAndStart();
			}  else
			{
				if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_PAUSE_raised)
				{ 
					exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream();
					enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy_default();
					VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAOffAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_DESTROY_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_DESTROY_FAILURE_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOff();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state StopAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_DESTROY_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_DESTROY_FAILURE_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_DeallocateRoute();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop_react(const sc_boolean try_transition) {
	/* The reactions of state StopAfterEcnrStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_DestroyEcnrAndDeallocate();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAOffAfterEcnrStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop();
			react_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_DestroyEcnrOnly();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy_react(const sc_boolean try_transition) {
	/* The reactions of state PauseAfterEcnrDestroy. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_DESTROY_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_DESTROY_FAILURE_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(false);
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_ON_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy();
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream_default();
				VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceCallAudioSm::VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop_react(const sc_boolean try_transition) {
	/* The reactions of state PauseAfterEcnrStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised))
		{ 
			exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop();
			enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy_default();
			VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(false);
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICECALL_AUDIO_SA_ON_raised)
			{ 
				exseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop();
				enseq_VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream_default();
				VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceCallAudioRegion_VoiceCallAudio_VoiceCallAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}



