/* *
 * @file VehicleRingtoneAudioSm.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Generated code from VehicleRingtoneAudioSm.sct
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 * */

#ifndef VEHICLERINGTONEAUDIOSM_H_
#define VEHICLERINGTONEAUDIOSM_H_


#include <PmAudioManagerSmTypes.h>
#include <deque>
#include "sc_types.h"
#include "StatemachineInterface.h"
#include "scTracing.h"

/*! \file Header of the state machine 'VehicleRingtoneAudioSm'.
*/


#ifndef SCT_EVENTS_VEHICLERINGTONEAUDIOSM_H
#define SCT_EVENTS_VEHICLERINGTONEAUDIOSM_H
#ifndef SC_INVALID_EVENT_VALUE
#define SC_INVALID_EVENT_VALUE 0
#endif

namespace vehicleringtoneaudiosm_events
{
typedef enum  {
	vehicleringtoneaudiosm_invalid_event = SC_INVALID_EVENT_VALUE,
	SCI_AmClientRequest_PREPARE_OUTBAND_RINGTONE_CHANNEL,
	SCI_AmClientRequest_PLAY_OUTBAND_RINGTONE,
	SCI_AmClientRequest_PAUSE_OUTBAND_RINGTONE,
	SCI_AmClientRequest_STOP_OUTBAND_RINGTONE,
	SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_GRANTED,
	SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_DENIED,
	SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_DEALLOCATED,
	SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_ON,
	SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_OFF,
	SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_PAUSE,
	SCI_AudioPlayerResponse_PLAYING_SUCCESS,
	SCI_AudioPlayerResponse_PLAYING_ERROR,
	SCI_AudioPlayerResponse_STOP_SUCCESS,
	SCI_AudioPlayerResponse_STOP_FAILURE,
	InternalSCI_READY_TO_PLAY,
	InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT
} VehicleRingtoneAudioSmEventName;

class SctEvent
{
	public:
		SctEvent(VehicleRingtoneAudioSmEventName name) : name(name){}
		virtual ~SctEvent(){}
		const VehicleRingtoneAudioSmEventName name;
		
};
		
template <typename T>
class TypedSctEvent : public SctEvent
{
	public:
		TypedSctEvent(VehicleRingtoneAudioSmEventName name, T value) :
			SctEvent(name),
			value(value)
			{}
		virtual ~TypedSctEvent(){}
		const T value;
};

class SctEvent_SCI_AmClientRequest_PREPARE_OUTBAND_RINGTONE_CHANNEL : public SctEvent
{
	public:
		SctEvent_SCI_AmClientRequest_PREPARE_OUTBAND_RINGTONE_CHANNEL(VehicleRingtoneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AmClientRequest_PLAY_OUTBAND_RINGTONE : public SctEvent
{
	public:
		SctEvent_SCI_AmClientRequest_PLAY_OUTBAND_RINGTONE(VehicleRingtoneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AmClientRequest_PAUSE_OUTBAND_RINGTONE : public SctEvent
{
	public:
		SctEvent_SCI_AmClientRequest_PAUSE_OUTBAND_RINGTONE(VehicleRingtoneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AmClientRequest_STOP_OUTBAND_RINGTONE : public SctEvent
{
	public:
		SctEvent_SCI_AmClientRequest_STOP_OUTBAND_RINGTONE(VehicleRingtoneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_GRANTED : public TypedSctEvent<AudioSink>
{
	public:
		SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_GRANTED(VehicleRingtoneAudioSmEventName name, AudioSink value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_DENIED : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_DENIED(VehicleRingtoneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_DEALLOCATED : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_DEALLOCATED(VehicleRingtoneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_ON : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_ON(VehicleRingtoneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_OFF : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_OFF(VehicleRingtoneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_PAUSE : public SctEvent
{
	public:
		SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_PAUSE(VehicleRingtoneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioPlayerResponse_PLAYING_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_AudioPlayerResponse_PLAYING_SUCCESS(VehicleRingtoneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioPlayerResponse_PLAYING_ERROR : public TypedSctEvent<AmResultMessage>
{
	public:
		SctEvent_SCI_AudioPlayerResponse_PLAYING_ERROR(VehicleRingtoneAudioSmEventName name, AmResultMessage value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AudioPlayerResponse_STOP_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_AudioPlayerResponse_STOP_SUCCESS(VehicleRingtoneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioPlayerResponse_STOP_FAILURE : public TypedSctEvent<AmResultMessage>
{
	public:
		SctEvent_SCI_AudioPlayerResponse_STOP_FAILURE(VehicleRingtoneAudioSmEventName name, AmResultMessage value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_InternalSCI_READY_TO_PLAY : public SctEvent
{
	public:
		SctEvent_InternalSCI_READY_TO_PLAY(VehicleRingtoneAudioSmEventName name) : SctEvent(name){};
};
class SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT : public SctEvent
{
	public:
		SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(VehicleRingtoneAudioSmEventName name) : SctEvent(name){};
};

}
#endif /* SCT_EVENTS_VEHICLERINGTONEAUDIOSM_H */


/*! Define indices of states in the StateConfVector */
#define SCVI_VEHICLERINGTONEAUDIOREGION_IDLE 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_WAITTOPLAYOUTBANDRINGTONE 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_WAITTOPLAYOUTBANDRINGTONE_AMCLIENTREQUESTWAITREGION_WAITFORAMCLIENTREQUEST 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_WAITTOPLAYOUTBANDRINGTONE_AMCLIENTREQUESTWAITREGION_PLAYRINGTONEREQUEST 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_WAITTOPLAYOUTBANDRINGTONE_ARLRESPONSEWAITREGION_WAITFORRINGTONEROUTEALLOCATION 1
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_WAITTOPLAYOUTBANDRINGTONE_ARLRESPONSEWAITREGION_RINGTONESAONRECEIVED 1
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_WAITTOPLAYOUTBANDRINGTONE_ARLRESPONSEWAITREGION_WAITFORSAON 1
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_OUTBANDRINGTONEPLAYING 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_STOPPLAY 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_STOPPLAY_AUDIOPLAYEROPERATIONREGION_WAITFORPLAYERTOSTOP 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_STOPPLAY_AUDIOPLAYEROPERATIONREGION_PLAYBACKSTOPPED 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_STOPPLAY_AUDIOWRAPPEROPERATIONREGION_WAITFORROUTEDEALLOCATION 1
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_STOPPLAY_AUDIOWRAPPEROPERATIONREGION_RINGTONECHANNELDEALLOCATED 1
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_WAITFORROUTEDEALLOCATION 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_STREAMINGSTOPPED 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_WAITFORPLAYERSTOP 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_AUTOSAOFF 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_WAITFORROUTEDEALLOCATIONANDSTOPPLAYBACK 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE_PAUSERINGTONEREGION_WAITPLAYERTOSTOP 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE_PAUSERINGTONEREGION_PLAYBACKPAUSED 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE_PAUSERINGTONEREGION_PLAYAFTERPLAYERRESPONSE 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE_PAUSERINGTONEREGION_PAUSEAFTERPLAYERRESPONSE 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE_PAUSERINGTONEREGION_STOPAFTERPLAYERRESPONSE 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE_PAUSERINGTONEREGION_AUTOSAPAUSEAFTERPLAYERRESPONSE 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE_PAUSERINGTONEREGION_AUTOSAOFFAFTERECNRRESPONSE 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE_PAUSERINGTONEREGION_AUTOSAONAFTERPLAYERRESPONSE 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_AUTOSAPAUSE 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_WAITFORPLAYERTOSTOP 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_CHANNELPAUSED 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_AUTOSAOFFAFTERPLAYERRESPONSE 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_STOPAFTERPLAYERRESPONSE 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_SAONAFTERPLAYERRESPONSE 0
#define SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_PAUSEAFTERPLAYERRESPONSE 0


class VehicleRingtoneAudioSm : public StatemachineInterface
{
	public:
		VehicleRingtoneAudioSm();
		
		~VehicleRingtoneAudioSm();
		
		/*! Enumeration of all states */ 
		typedef enum
		{
			VehicleRingtoneAudioSm_last_state,
			VehicleRingtoneAudioRegion_Idle,
			VehicleRingtoneAudioRegion_RingtonePlay,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse,
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse
		} VehicleRingtoneAudioSmStates;
					
		static const sc_integer numStates = 36;
		
		//! Inner class for AmClientRequest interface scope.
		class SCI_AmClientRequest
		{
			public:
				SCI_AmClientRequest(VehicleRingtoneAudioSm * parent):
					PREPARE_OUTBAND_RINGTONE_CHANNEL_raised(false),
					PLAY_OUTBAND_RINGTONE_raised(false),
					PAUSE_OUTBAND_RINGTONE_raised(false),
					STOP_OUTBAND_RINGTONE_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'PREPARE_OUTBAND_RINGTONE_CHANNEL' that is defined in the interface scope 'AmClientRequest'. */
				void raise_pREPARE_OUTBAND_RINGTONE_CHANNEL();
				
				
				/*! Raises the in event 'PLAY_OUTBAND_RINGTONE' that is defined in the interface scope 'AmClientRequest'. */
				void raise_pLAY_OUTBAND_RINGTONE();
				
				
				/*! Raises the in event 'PAUSE_OUTBAND_RINGTONE' that is defined in the interface scope 'AmClientRequest'. */
				void raise_pAUSE_OUTBAND_RINGTONE();
				
				
				/*! Raises the in event 'STOP_OUTBAND_RINGTONE' that is defined in the interface scope 'AmClientRequest'. */
				void raise_sTOP_OUTBAND_RINGTONE();
				
				
				
			private:
				friend class VehicleRingtoneAudioSm;
				/*! Raises the in event 'PREPARE_OUTBAND_RINGTONE_CHANNEL' that is defined in the interface scope 'AmClientRequest'. */
				void internal_raise_pREPARE_OUTBAND_RINGTONE_CHANNEL();
				sc_boolean PREPARE_OUTBAND_RINGTONE_CHANNEL_raised;
				/*! Raises the in event 'PLAY_OUTBAND_RINGTONE' that is defined in the interface scope 'AmClientRequest'. */
				void internal_raise_pLAY_OUTBAND_RINGTONE();
				sc_boolean PLAY_OUTBAND_RINGTONE_raised;
				/*! Raises the in event 'PAUSE_OUTBAND_RINGTONE' that is defined in the interface scope 'AmClientRequest'. */
				void internal_raise_pAUSE_OUTBAND_RINGTONE();
				sc_boolean PAUSE_OUTBAND_RINGTONE_raised;
				/*! Raises the in event 'STOP_OUTBAND_RINGTONE' that is defined in the interface scope 'AmClientRequest'. */
				void internal_raise_sTOP_OUTBAND_RINGTONE();
				sc_boolean STOP_OUTBAND_RINGTONE_raised;
				VehicleRingtoneAudioSm * parent;
				void dispatch_event(vehicleringtoneaudiosm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AmClientRequest'. */
		SCI_AmClientRequest* getSCI_AmClientRequest();
		
		//! Inner class for AudioWrapperReqIf interface scope.
		class SCI_AudioWrapperReqIf
		{
			public:
				SCI_AudioWrapperReqIf(VehicleRingtoneAudioSm * parent):
					parent(parent)
				{}
				
				
				
				
				
			private:
				friend class VehicleRingtoneAudioSm;
				VehicleRingtoneAudioSm * parent;
				void dispatch_event(vehicleringtoneaudiosm_events::SctEvent * event);
				
				
		};
				//! Inner class for AudioWrapperReqIf interface scope operation callbacks.
				class SCI_AudioWrapperReqIf_OCB
				{
					public:
						virtual ~SCI_AudioWrapperReqIf_OCB() = 0;
						
						virtual void sendAllocateRequest() = 0;
						
						virtual void sendDeAllocateRequest() = 0;
						
						virtual void sendSrcActivityResult(SrcActivity srcActivity) = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_AudioWrapperReqIf_OCB'. */
				void setSCI_AudioWrapperReqIf_OCB(SCI_AudioWrapperReqIf_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_AudioWrapperReqIf'. */
		SCI_AudioWrapperReqIf* getSCI_AudioWrapperReqIf();
		
		//! Inner class for AudioWrapperResponse interface scope.
		class SCI_AudioWrapperResponse
		{
			public:
				SCI_AudioWrapperResponse(VehicleRingtoneAudioSm * parent):
					OUTBAND_RINGTONE_CHANNEL_GRANTED_raised(false),
					OUTBAND_RINGTONE_CHANNEL_GRANTED_value(),
					OUTBAND_RINGTONE_CHANNEL_DENIED_raised(false),
					OUTBAND_RINGTONE_CHANNEL_DEALLOCATED_raised(false),
					OUTBAND_RINGTONE_SA_ON_raised(false),
					OUTBAND_RINGTONE_SA_OFF_raised(false),
					OUTBAND_RINGTONE_SA_PAUSE_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'OUTBAND_RINGTONE_CHANNEL_GRANTED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_oUTBAND_RINGTONE_CHANNEL_GRANTED(AudioSink value);
				
				
				/*! Raises the in event 'OUTBAND_RINGTONE_CHANNEL_DENIED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_oUTBAND_RINGTONE_CHANNEL_DENIED();
				
				
				/*! Raises the in event 'OUTBAND_RINGTONE_CHANNEL_DEALLOCATED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_oUTBAND_RINGTONE_CHANNEL_DEALLOCATED();
				
				
				/*! Raises the in event 'OUTBAND_RINGTONE_SA_ON' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_oUTBAND_RINGTONE_SA_ON();
				
				
				/*! Raises the in event 'OUTBAND_RINGTONE_SA_OFF' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_oUTBAND_RINGTONE_SA_OFF();
				
				
				/*! Raises the in event 'OUTBAND_RINGTONE_SA_PAUSE' that is defined in the interface scope 'AudioWrapperResponse'. */
				void raise_oUTBAND_RINGTONE_SA_PAUSE();
				
				
				
			private:
				friend class VehicleRingtoneAudioSm;
				/*! Raises the in event 'OUTBAND_RINGTONE_CHANNEL_GRANTED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_oUTBAND_RINGTONE_CHANNEL_GRANTED(AudioSink value);
				sc_boolean OUTBAND_RINGTONE_CHANNEL_GRANTED_raised;
				AudioSink OUTBAND_RINGTONE_CHANNEL_GRANTED_value;
				/*! Raises the in event 'OUTBAND_RINGTONE_CHANNEL_DENIED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_oUTBAND_RINGTONE_CHANNEL_DENIED();
				sc_boolean OUTBAND_RINGTONE_CHANNEL_DENIED_raised;
				/*! Raises the in event 'OUTBAND_RINGTONE_CHANNEL_DEALLOCATED' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_oUTBAND_RINGTONE_CHANNEL_DEALLOCATED();
				sc_boolean OUTBAND_RINGTONE_CHANNEL_DEALLOCATED_raised;
				/*! Raises the in event 'OUTBAND_RINGTONE_SA_ON' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_oUTBAND_RINGTONE_SA_ON();
				sc_boolean OUTBAND_RINGTONE_SA_ON_raised;
				/*! Raises the in event 'OUTBAND_RINGTONE_SA_OFF' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_oUTBAND_RINGTONE_SA_OFF();
				sc_boolean OUTBAND_RINGTONE_SA_OFF_raised;
				/*! Raises the in event 'OUTBAND_RINGTONE_SA_PAUSE' that is defined in the interface scope 'AudioWrapperResponse'. */
				void internal_raise_oUTBAND_RINGTONE_SA_PAUSE();
				sc_boolean OUTBAND_RINGTONE_SA_PAUSE_raised;
				VehicleRingtoneAudioSm * parent;
				void dispatch_event(vehicleringtoneaudiosm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AudioWrapperResponse'. */
		SCI_AudioWrapperResponse* getSCI_AudioWrapperResponse();
		
		//! Inner class for AudioPlayerReqIf interface scope.
		class SCI_AudioPlayerReqIf
		{
			public:
				SCI_AudioPlayerReqIf(VehicleRingtoneAudioSm * parent):
					parent(parent)
				{}
				
				
				
				
				
			private:
				friend class VehicleRingtoneAudioSm;
				VehicleRingtoneAudioSm * parent;
				void dispatch_event(vehicleringtoneaudiosm_events::SctEvent * event);
				
				
		};
				//! Inner class for AudioPlayerReqIf interface scope operation callbacks.
				class SCI_AudioPlayerReqIf_OCB
				{
					public:
						virtual ~SCI_AudioPlayerReqIf_OCB() = 0;
						
						virtual AmResultCode setAlsaDeviceName(AudioSink sinkName, AudioSource srcName) = 0;
						
						virtual AmResultCode sendPlayFileRequest(FilePath filePath, PlayCount playCount) = 0;
						
						virtual AmResultCode stopPlayback() = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_AudioPlayerReqIf_OCB'. */
				void setSCI_AudioPlayerReqIf_OCB(SCI_AudioPlayerReqIf_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_AudioPlayerReqIf'. */
		SCI_AudioPlayerReqIf* getSCI_AudioPlayerReqIf();
		
		//! Inner class for AudioPlayerResponse interface scope.
		class SCI_AudioPlayerResponse
		{
			public:
				SCI_AudioPlayerResponse(VehicleRingtoneAudioSm * parent):
					PLAYING_SUCCESS_raised(false),
					PLAYING_ERROR_raised(false),
					PLAYING_ERROR_value(),
					STOP_SUCCESS_raised(false),
					STOP_FAILURE_raised(false),
					STOP_FAILURE_value(),
					parent(parent)
				{}
				
				/*! Raises the in event 'PLAYING_SUCCESS' that is defined in the interface scope 'AudioPlayerResponse'. */
				void raise_pLAYING_SUCCESS();
				
				
				/*! Raises the in event 'PLAYING_ERROR' that is defined in the interface scope 'AudioPlayerResponse'. */
				void raise_pLAYING_ERROR(AmResultMessage value);
				
				
				/*! Raises the in event 'STOP_SUCCESS' that is defined in the interface scope 'AudioPlayerResponse'. */
				void raise_sTOP_SUCCESS();
				
				
				/*! Raises the in event 'STOP_FAILURE' that is defined in the interface scope 'AudioPlayerResponse'. */
				void raise_sTOP_FAILURE(AmResultMessage value);
				
				
				
			private:
				friend class VehicleRingtoneAudioSm;
				/*! Raises the in event 'PLAYING_SUCCESS' that is defined in the interface scope 'AudioPlayerResponse'. */
				void internal_raise_pLAYING_SUCCESS();
				sc_boolean PLAYING_SUCCESS_raised;
				/*! Raises the in event 'PLAYING_ERROR' that is defined in the interface scope 'AudioPlayerResponse'. */
				void internal_raise_pLAYING_ERROR(AmResultMessage value);
				sc_boolean PLAYING_ERROR_raised;
				AmResultMessage PLAYING_ERROR_value;
				/*! Raises the in event 'STOP_SUCCESS' that is defined in the interface scope 'AudioPlayerResponse'. */
				void internal_raise_sTOP_SUCCESS();
				sc_boolean STOP_SUCCESS_raised;
				/*! Raises the in event 'STOP_FAILURE' that is defined in the interface scope 'AudioPlayerResponse'. */
				void internal_raise_sTOP_FAILURE(AmResultMessage value);
				sc_boolean STOP_FAILURE_raised;
				AmResultMessage STOP_FAILURE_value;
				VehicleRingtoneAudioSm * parent;
				void dispatch_event(vehicleringtoneaudiosm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AudioPlayerResponse'. */
		SCI_AudioPlayerResponse* getSCI_AudioPlayerResponse();
		
		//! Inner class for VehicleRingtoneSmHandler interface scope.
		class SCI_VehicleRingtoneSmHandler
		{
			public:
				SCI_VehicleRingtoneSmHandler(VehicleRingtoneAudioSm * parent):
					parent(parent)
				{}
				
				/*! Gets the value of the variable 'ringtoneFilePath' that is defined in the interface scope 'VehicleRingtoneSmHandler'. */
				FilePath get_ringtoneFilePath() const;
				
				/*! Sets the value of the variable 'ringtoneFilePath' that is defined in the interface scope 'VehicleRingtoneSmHandler'. */
				void set_ringtoneFilePath(FilePath value);
				
				
				/*! Gets the value of the variable 'sinkName' that is defined in the interface scope 'VehicleRingtoneSmHandler'. */
				AudioSink get_sinkName() const;
				
				/*! Sets the value of the variable 'sinkName' that is defined in the interface scope 'VehicleRingtoneSmHandler'. */
				void set_sinkName(AudioSink value);
				
				
				/*! Gets the value of the variable 'ringtonePlayCount' that is defined in the interface scope 'VehicleRingtoneSmHandler'. */
				PlayCount get_ringtonePlayCount() const;
				
				/*! Sets the value of the variable 'ringtonePlayCount' that is defined in the interface scope 'VehicleRingtoneSmHandler'. */
				void set_ringtonePlayCount(PlayCount value);
				
				
				
				
				
			private:
				friend class VehicleRingtoneAudioSm;
				FilePath ringtoneFilePath;
				AudioSink sinkName;
				PlayCount ringtonePlayCount;
				VehicleRingtoneAudioSm * parent;
				void dispatch_event(vehicleringtoneaudiosm_events::SctEvent * event);
				
				
		};
				//! Inner class for VehicleRingtoneSmHandler interface scope operation callbacks.
				class SCI_VehicleRingtoneSmHandler_OCB
				{
					public:
						virtual ~SCI_VehicleRingtoneSmHandler_OCB() = 0;
						
						virtual void updateStatus(RouteState routeState, AmResultMessage msg) = 0;
						
						virtual void updateSinkName(AudioSink sinkName) = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_VehicleRingtoneSmHandler_OCB'. */
				void setSCI_VehicleRingtoneSmHandler_OCB(SCI_VehicleRingtoneSmHandler_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_VehicleRingtoneSmHandler'. */
		SCI_VehicleRingtoneSmHandler* getSCI_VehicleRingtoneSmHandler();
		
		
		/*
		 * Functions inherited from StatemachineInterface
		 */
		virtual void init();
		
		virtual void enter();
		
		virtual void exit();
		
		virtual void runCycle();
		
		/*!
		* Checks if the state machine is active (until 2.4.1 this method was used for states).
		* A state machine is active if it has been entered. It is inactive if it has not been entered at all or if it has been exited.
		*/
		virtual sc_boolean isActive() const;
		
		
		/*!
		* Checks if all active states are final. 
		* If there are no active states then the state machine is considered being inactive. In this case this method returns false.
		*/
		virtual sc_boolean isFinal() const;
		
		void setTraceObserver(ysc::TraceObserver<VehicleRingtoneAudioSmStates>* tracingcallback);
		
		ysc::TraceObserver<VehicleRingtoneAudioSmStates>* getTraceObserver();
		
		/*! Checks if the specified state is active (until 2.4.1 the used method for states was calles isActive()). */
		sc_boolean isStateActive(VehicleRingtoneAudioSmStates state) const;
		
		
		
	protected:
		
		
	private:
		VehicleRingtoneAudioSm(const VehicleRingtoneAudioSm &rhs);
		VehicleRingtoneAudioSm& operator=(const VehicleRingtoneAudioSm&);
		
		//! Inner class for internal interface scope.
		class InternalSCI
		{
			public:
				InternalSCI(VehicleRingtoneAudioSm * parent):
					READY_TO_PLAY_raised(false),
					SEND_SRC_ACTIVITY_OFF_RESULT_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'READY_TO_PLAY' that is defined in the internal scope. */
				void raise_rEADY_TO_PLAY();
				
				/*! Checks if the out event 'READY_TO_PLAY' that is defined in the internal scope has been raised. */
				sc_boolean isRaised_rEADY_TO_PLAY() const;
				
				
				/*! Raises the in event 'SEND_SRC_ACTIVITY_OFF_RESULT' that is defined in the internal scope. */
				void raise_sEND_SRC_ACTIVITY_OFF_RESULT();
				
				/*! Checks if the out event 'SEND_SRC_ACTIVITY_OFF_RESULT' that is defined in the internal scope has been raised. */
				sc_boolean isRaised_sEND_SRC_ACTIVITY_OFF_RESULT() const;
				
				
				
			private:
				friend class VehicleRingtoneAudioSm;
				/*! Raises the in event 'READY_TO_PLAY' that is defined in the internal scope. */
				void internal_raise_rEADY_TO_PLAY();
				sc_boolean READY_TO_PLAY_raised;
				/*! Raises the in event 'SEND_SRC_ACTIVITY_OFF_RESULT' that is defined in the internal scope. */
				void internal_raise_sEND_SRC_ACTIVITY_OFF_RESULT();
				sc_boolean SEND_SRC_ACTIVITY_OFF_RESULT_raised;
				VehicleRingtoneAudioSm * parent;
				void dispatch_event(vehicleringtoneaudiosm_events::SctEvent * event);
				
				
		};
		
		//! the maximum number of orthogonal states defines the dimension of the state configuration vector.
		static const sc_ushort maxOrthogonalStates = 2;
		
		
		ysc::TraceObserver<VehicleRingtoneAudioSmStates>* ifaceTraceObserver;
		
		VehicleRingtoneAudioSmStates stateConfVector[maxOrthogonalStates];
		
		sc_ushort stateConfVectorPosition;
		
		SCI_AmClientRequest ifaceAmClientRequest;
		SCI_AudioWrapperReqIf ifaceAudioWrapperReqIf;
		SCI_AudioWrapperReqIf_OCB* ifaceAudioWrapperReqIf_OCB;
		SCI_AudioWrapperResponse ifaceAudioWrapperResponse;
		SCI_AudioPlayerReqIf ifaceAudioPlayerReqIf;
		SCI_AudioPlayerReqIf_OCB* ifaceAudioPlayerReqIf_OCB;
		SCI_AudioPlayerResponse ifaceAudioPlayerResponse;
		SCI_VehicleRingtoneSmHandler ifaceVehicleRingtoneSmHandler;
		SCI_VehicleRingtoneSmHandler_OCB* ifaceVehicleRingtoneSmHandler_OCB;
		InternalSCI ifaceInternalSCI;
		
		// prototypes of all internal functions
		
		void effect_VehicleRingtoneAudioRegion_RingtonePlay_tr0();
		void effect_VehicleRingtoneAudioRegion_RingtonePlay_tr1();
		void effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_tr1();
		void effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_tr2();
		void effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_tr3();
		void effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_tr5();
		void effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_tr7();
		void effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_tr0();
		void effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_tr1();
		void effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_tr2();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused();
		void enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse();
		void enseq_VehicleRingtoneAudioRegion_Idle_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_AutoSAOff();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_DeallocateAndStop();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_DeallocateRoute();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopAndDeallocate();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_entry_AutoSAOffAfterEcnrResponse6();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_entry_AutoSAOnAfterPlayerResponse8();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_entry_AutoSAPauseAfterPlayerResponse4();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_entry_PlayRingtone1();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_entry_StopAfterPlayerResponse0();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPaused();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_entry_AutoSAOffAfterPlayerResponse3();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_entry_StopAfterPlayerResponse4();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse_default();
		void enseq_VehicleRingtoneAudioRegion_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_DeallocateRoute();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopAndDeallocate();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSAOff();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_DeallocateAndStop();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_StopAfterPlayerResponse0();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_PlayRingtone1();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_AutoSAPauseAfterPlayerResponse4();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_AutoSAOffAfterEcnrResponse6();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_AutoSAOnAfterPlayerResponse8();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_default();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAPaused();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_AutoSAOffAfterPlayerResponse3();
		void enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_StopAfterPlayerResponse4();
		void exseq_VehicleRingtoneAudioRegion_Idle();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse();
		void exseq_VehicleRingtoneAudioRegion();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion();
		void exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion__entry_Default();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region__entry_Default();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_DeallocateRoute();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopAndDeallocate();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSAOff();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_DeallocateAndStop();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion__entry_Default();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_StopAfterPlayerResponse0();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_PlayRingtone1();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_AutoSAPauseAfterPlayerResponse4();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_AutoSAOffAfterEcnrResponse6();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_AutoSAOnAfterPlayerResponse8();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion__entry_Default();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAPaused();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_AutoSAOffAfterPlayerResponse3();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_StopAfterPlayerResponse4();
		void react_VehicleRingtoneAudioRegion__entry_Default();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_ChannelDenied();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_exitOnDeallacated();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayRingtone();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopRingtone();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPause();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOff();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PlayRingtone();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOff();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_DeallocateRoute();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_ChannelDeallocated();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion__sync0();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion__sync1();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region__sync0();
		void react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region__sync1();
		sc_boolean react();
		sc_boolean VehicleRingtoneAudioRegion_Idle_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse_react(const sc_boolean try_transition);
		sc_boolean VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse_react(const sc_boolean try_transition);
		void clearInEvents();
		void clearOutEvents();
		
		
		std::deque<vehicleringtoneaudiosm_events::SctEvent*> internalEventQueue;
		vehicleringtoneaudiosm_events::SctEvent* getNextEvent();
		void dispatch_event(vehicleringtoneaudiosm_events::SctEvent * event);
		std::deque<vehicleringtoneaudiosm_events::SctEvent*> inEventQueue;
		sc_boolean isRunningCycle;
		
		
};


inline VehicleRingtoneAudioSm::SCI_AudioWrapperReqIf_OCB::~SCI_AudioWrapperReqIf_OCB() {}
inline VehicleRingtoneAudioSm::SCI_AudioPlayerReqIf_OCB::~SCI_AudioPlayerReqIf_OCB() {}
inline VehicleRingtoneAudioSm::SCI_VehicleRingtoneSmHandler_OCB::~SCI_VehicleRingtoneSmHandler_OCB() {}


#endif /* VEHICLERINGTONEAUDIOSM_H_ */
