/* *
 * @file VehicleRingtoneAudioSm.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Generated code from VehicleRingtoneAudioSm.sct
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 * */

#include "VehicleRingtoneAudioSm.h"

/*! \file Implementation of the state machine 'VehicleRingtoneAudioSm'
*/




VehicleRingtoneAudioSm::VehicleRingtoneAudioSm()  :
ifaceTraceObserver(0),
stateConfVectorPosition(0),
ifaceAmClientRequest(this),
ifaceAudioWrapperReqIf(this),
ifaceAudioWrapperReqIf_OCB(sc_null),
ifaceAudioWrapperResponse(this),
ifaceAudioPlayerReqIf(this),
ifaceAudioPlayerReqIf_OCB(sc_null),
ifaceAudioPlayerResponse(this),
ifaceVehicleRingtoneSmHandler(this),
ifaceVehicleRingtoneSmHandler_OCB(sc_null),
ifaceInternalSCI(this),
isRunningCycle(false)
{
}

VehicleRingtoneAudioSm::~VehicleRingtoneAudioSm()
{
}


using namespace vehicleringtoneaudiosm_events;

SctEvent* VehicleRingtoneAudioSm::getNextEvent()
{
	SctEvent* nextEvent = 0;
	
	if(!internalEventQueue.empty()) {
		nextEvent = internalEventQueue.front();
		internalEventQueue.pop_front();
	}
	else if(!inEventQueue.empty()) {
		nextEvent = inEventQueue.front();
		inEventQueue.pop_front();
	}
	
	return nextEvent;
}

void VehicleRingtoneAudioSm::dispatch_event(SctEvent * event)
{
	if(event == 0) {
		return;
	}
	switch(event->name)
	{
		case SCI_AmClientRequest_PREPARE_OUTBAND_RINGTONE_CHANNEL:
		case SCI_AmClientRequest_PLAY_OUTBAND_RINGTONE:
		case SCI_AmClientRequest_PAUSE_OUTBAND_RINGTONE:
		case SCI_AmClientRequest_STOP_OUTBAND_RINGTONE:
		{
			ifaceAmClientRequest.dispatch_event(event);
			break;
		}
		case SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_GRANTED:
		case SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_DENIED:
		case SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_DEALLOCATED:
		case SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_ON:
		case SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_OFF:
		case SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_PAUSE:
		{
			ifaceAudioWrapperResponse.dispatch_event(event);
			break;
		}
		case SCI_AudioPlayerResponse_PLAYING_SUCCESS:
		case SCI_AudioPlayerResponse_PLAYING_ERROR:
		case SCI_AudioPlayerResponse_STOP_SUCCESS:
		case SCI_AudioPlayerResponse_STOP_FAILURE:
		{
			ifaceAudioPlayerResponse.dispatch_event(event);
			break;
		}
		case InternalSCI_READY_TO_PLAY:
		case InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT:
		{
			ifaceInternalSCI.dispatch_event(event);
			break;
		}
		default:
			break;
	}
}

void VehicleRingtoneAudioSm::SCI_AmClientRequest::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AmClientRequest_PREPARE_OUTBAND_RINGTONE_CHANNEL:
		{
			internal_raise_pREPARE_OUTBAND_RINGTONE_CHANNEL();
			break;
		}
		case SCI_AmClientRequest_PLAY_OUTBAND_RINGTONE:
		{
			internal_raise_pLAY_OUTBAND_RINGTONE();
			break;
		}
		case SCI_AmClientRequest_PAUSE_OUTBAND_RINGTONE:
		{
			internal_raise_pAUSE_OUTBAND_RINGTONE();
			break;
		}
		case SCI_AmClientRequest_STOP_OUTBAND_RINGTONE:
		{
			internal_raise_sTOP_OUTBAND_RINGTONE();
			break;
		}
		default:
			break;
	}
}
void VehicleRingtoneAudioSm::SCI_AudioWrapperReqIf::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void VehicleRingtoneAudioSm::SCI_AudioWrapperResponse::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_GRANTED:
		{
			SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_GRANTED * e = static_cast<SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_GRANTED*>(event);
			if(e != 0) {
				internal_raise_oUTBAND_RINGTONE_CHANNEL_GRANTED(e->value);
			}
			break;
		}
		case SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_DENIED:
		{
			internal_raise_oUTBAND_RINGTONE_CHANNEL_DENIED();
			break;
		}
		case SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_DEALLOCATED:
		{
			internal_raise_oUTBAND_RINGTONE_CHANNEL_DEALLOCATED();
			break;
		}
		case SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_ON:
		{
			internal_raise_oUTBAND_RINGTONE_SA_ON();
			break;
		}
		case SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_OFF:
		{
			internal_raise_oUTBAND_RINGTONE_SA_OFF();
			break;
		}
		case SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_PAUSE:
		{
			internal_raise_oUTBAND_RINGTONE_SA_PAUSE();
			break;
		}
		default:
			break;
	}
}
void VehicleRingtoneAudioSm::SCI_AudioPlayerReqIf::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void VehicleRingtoneAudioSm::SCI_AudioPlayerResponse::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AudioPlayerResponse_PLAYING_SUCCESS:
		{
			internal_raise_pLAYING_SUCCESS();
			break;
		}
		case SCI_AudioPlayerResponse_PLAYING_ERROR:
		{
			SctEvent_SCI_AudioPlayerResponse_PLAYING_ERROR * e = static_cast<SctEvent_SCI_AudioPlayerResponse_PLAYING_ERROR*>(event);
			if(e != 0) {
				internal_raise_pLAYING_ERROR(e->value);
			}
			break;
		}
		case SCI_AudioPlayerResponse_STOP_SUCCESS:
		{
			internal_raise_sTOP_SUCCESS();
			break;
		}
		case SCI_AudioPlayerResponse_STOP_FAILURE:
		{
			SctEvent_SCI_AudioPlayerResponse_STOP_FAILURE * e = static_cast<SctEvent_SCI_AudioPlayerResponse_STOP_FAILURE*>(event);
			if(e != 0) {
				internal_raise_sTOP_FAILURE(e->value);
			}
			break;
		}
		default:
			break;
	}
}
void VehicleRingtoneAudioSm::SCI_VehicleRingtoneSmHandler::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void VehicleRingtoneAudioSm::InternalSCI::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case InternalSCI_READY_TO_PLAY:
		{
			internal_raise_rEADY_TO_PLAY();
			break;
		}
		case InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT:
		{
			internal_raise_sEND_SRC_ACTIVITY_OFF_RESULT();
			break;
		}
		default:
			break;
	}
}


void VehicleRingtoneAudioSm::init()
{
	for (sc_ushort i = 0; i < maxOrthogonalStates; ++i)
		stateConfVector[i] = VehicleRingtoneAudioSm_last_state;
	
	stateConfVectorPosition = 0;

	clearInEvents();
	clearOutEvents();
	
	/* Default init sequence for statechart VehicleRingtoneAudioSm */
	ifaceVehicleRingtoneSmHandler.ringtoneFilePath = (sc_string) "";
	ifaceVehicleRingtoneSmHandler.sinkName = (sc_string) "";
	ifaceVehicleRingtoneSmHandler.ringtonePlayCount = PLAY_COUNT_DEFAULT;
}

void VehicleRingtoneAudioSm::enter()
{
	/* Default enter sequence for statechart VehicleRingtoneAudioSm */
	enseq_VehicleRingtoneAudioRegion_default();
}

void VehicleRingtoneAudioSm::exit()
{
	/* Default exit sequence for statechart VehicleRingtoneAudioSm */
	exseq_VehicleRingtoneAudioRegion();
}

sc_boolean VehicleRingtoneAudioSm::isActive() const
{
	return stateConfVector[0] != VehicleRingtoneAudioSm_last_state||stateConfVector[1] != VehicleRingtoneAudioSm_last_state;
}

/* 
 * Always returns 'false' since this state machine can never become final.
 */
sc_boolean VehicleRingtoneAudioSm::isFinal() const
{
   return false;}

void VehicleRingtoneAudioSm::runCycle()
{
	if (isRunningCycle == false)
	{
		isRunningCycle = true;
		clearOutEvents();
						
		SctEvent * currentEvent = getNextEvent();
		
		do
		{
			/* Set event flags as usual */
			dispatch_event(currentEvent);
			
			for (stateConfVectorPosition = 0;
				stateConfVectorPosition < maxOrthogonalStates;
				stateConfVectorPosition++)
				{
					
				switch (stateConfVector[stateConfVectorPosition])
				{
				case VehicleRingtoneAudioRegion_Idle :
				{
					VehicleRingtoneAudioRegion_Idle_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse_react(true);
					break;
				}
				case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse :
				{
					VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse_react(true);
					break;
				}
				default:
					break;
				}
			}
			
			/* Delete event from memory */
			delete currentEvent;
			clearInEvents();
		} while((currentEvent = getNextEvent()));
		
		isRunningCycle = false;
	}
}

void VehicleRingtoneAudioSm::clearInEvents()
{
	ifaceAmClientRequest.PREPARE_OUTBAND_RINGTONE_CHANNEL_raised = false;
	ifaceAmClientRequest.PLAY_OUTBAND_RINGTONE_raised = false;
	ifaceAmClientRequest.PAUSE_OUTBAND_RINGTONE_raised = false;
	ifaceAmClientRequest.STOP_OUTBAND_RINGTONE_raised = false;
	ifaceAudioWrapperResponse.OUTBAND_RINGTONE_CHANNEL_GRANTED_raised = false;
	ifaceAudioWrapperResponse.OUTBAND_RINGTONE_CHANNEL_DENIED_raised = false;
	ifaceAudioWrapperResponse.OUTBAND_RINGTONE_CHANNEL_DEALLOCATED_raised = false;
	ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_ON_raised = false;
	ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_OFF_raised = false;
	ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_PAUSE_raised = false;
	ifaceAudioPlayerResponse.PLAYING_SUCCESS_raised = false;
	ifaceAudioPlayerResponse.PLAYING_ERROR_raised = false;
	ifaceAudioPlayerResponse.STOP_SUCCESS_raised = false;
	ifaceAudioPlayerResponse.STOP_FAILURE_raised = false;
	ifaceInternalSCI.READY_TO_PLAY_raised = false; 
	ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised = false; 
}

void VehicleRingtoneAudioSm::clearOutEvents()
{
}


sc_boolean VehicleRingtoneAudioSm::isStateActive(VehicleRingtoneAudioSmStates state) const
{
	switch (state)
	{
		case VehicleRingtoneAudioRegion_Idle : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_IDLE] == VehicleRingtoneAudioRegion_Idle
			);
		case VehicleRingtoneAudioRegion_RingtonePlay : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY] >= VehicleRingtoneAudioRegion_RingtonePlay
				&& stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY] <= VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_WAITTOPLAYOUTBANDRINGTONE] >= VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone
				&& stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_WAITTOPLAYOUTBANDRINGTONE] <= VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_WAITTOPLAYOUTBANDRINGTONE_AMCLIENTREQUESTWAITREGION_WAITFORAMCLIENTREQUEST] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_WAITTOPLAYOUTBANDRINGTONE_AMCLIENTREQUESTWAITREGION_PLAYRINGTONEREQUEST] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_WAITTOPLAYOUTBANDRINGTONE_ARLRESPONSEWAITREGION_WAITFORRINGTONEROUTEALLOCATION] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_WAITTOPLAYOUTBANDRINGTONE_ARLRESPONSEWAITREGION_RINGTONESAONRECEIVED] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_WAITTOPLAYOUTBANDRINGTONE_ARLRESPONSEWAITREGION_WAITFORSAON] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_OUTBANDRINGTONEPLAYING] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY] >= VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay
				&& stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY] <= VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_STOPPLAY] >= VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay
				&& stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_STOPPLAY] <= VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_STOPPLAY_AUDIOPLAYEROPERATIONREGION_WAITFORPLAYERTOSTOP] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_STOPPLAY_AUDIOPLAYEROPERATIONREGION_PLAYBACKSTOPPED] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_STOPPLAY_AUDIOWRAPPEROPERATIONREGION_WAITFORROUTEDEALLOCATION] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_STOPPLAY_AUDIOWRAPPEROPERATIONREGION_RINGTONECHANNELDEALLOCATED] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_WAITFORROUTEDEALLOCATION] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_STREAMINGSTOPPED] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_WAITFORPLAYERSTOP] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_AUTOSAOFF] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_STOPRINGTONEPLAY_STOPRINGTONEPLAY_REGION_WAITFORROUTEDEALLOCATIONANDSTOPPLAYBACK] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE] >= VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone
				&& stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE] <= VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE_PAUSERINGTONEREGION_WAITPLAYERTOSTOP] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE_PAUSERINGTONEREGION_PLAYBACKPAUSED] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE_PAUSERINGTONEREGION_PLAYAFTERPLAYERRESPONSE] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE_PAUSERINGTONEREGION_PAUSEAFTERPLAYERRESPONSE] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE_PAUSERINGTONEREGION_STOPAFTERPLAYERRESPONSE] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE_PAUSERINGTONEREGION_AUTOSAPAUSEAFTERPLAYERRESPONSE] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE_PAUSERINGTONEREGION_AUTOSAOFFAFTERECNRRESPONSE] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_PAUSERINGTONE_PAUSERINGTONEREGION_AUTOSAONAFTERPLAYERRESPONSE] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_AUTOSAPAUSE] >= VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause
				&& stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_AUTOSAPAUSE] <= VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_WAITFORPLAYERTOSTOP] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_CHANNELPAUSED] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_AUTOSAOFFAFTERPLAYERRESPONSE] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_STOPAFTERPLAYERRESPONSE] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_SAONAFTERPLAYERRESPONSE] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse
			);
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VEHICLERINGTONEAUDIOREGION_RINGTONEPLAY_RINGTONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_PAUSEAFTERPLAYERRESPONSE] == VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse
			);
		default: return false;
	}
}

VehicleRingtoneAudioSm::SCI_AmClientRequest* VehicleRingtoneAudioSm::getSCI_AmClientRequest()
{
	return &ifaceAmClientRequest;
}
/* Functions for event PREPARE_OUTBAND_RINGTONE_CHANNEL in interface SCI_AmClientRequest */
void VehicleRingtoneAudioSm::SCI_AmClientRequest::raise_pREPARE_OUTBAND_RINGTONE_CHANNEL()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AmClientRequest_PREPARE_OUTBAND_RINGTONE_CHANNEL(SCI_AmClientRequest_PREPARE_OUTBAND_RINGTONE_CHANNEL));
	parent->runCycle();
}
void VehicleRingtoneAudioSm::SCI_AmClientRequest::internal_raise_pREPARE_OUTBAND_RINGTONE_CHANNEL()
{
	PREPARE_OUTBAND_RINGTONE_CHANNEL_raised = true;
}
/* Functions for event PLAY_OUTBAND_RINGTONE in interface SCI_AmClientRequest */
void VehicleRingtoneAudioSm::SCI_AmClientRequest::raise_pLAY_OUTBAND_RINGTONE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AmClientRequest_PLAY_OUTBAND_RINGTONE(SCI_AmClientRequest_PLAY_OUTBAND_RINGTONE));
	parent->runCycle();
}
void VehicleRingtoneAudioSm::SCI_AmClientRequest::internal_raise_pLAY_OUTBAND_RINGTONE()
{
	PLAY_OUTBAND_RINGTONE_raised = true;
}
/* Functions for event PAUSE_OUTBAND_RINGTONE in interface SCI_AmClientRequest */
void VehicleRingtoneAudioSm::SCI_AmClientRequest::raise_pAUSE_OUTBAND_RINGTONE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AmClientRequest_PAUSE_OUTBAND_RINGTONE(SCI_AmClientRequest_PAUSE_OUTBAND_RINGTONE));
	parent->runCycle();
}
void VehicleRingtoneAudioSm::SCI_AmClientRequest::internal_raise_pAUSE_OUTBAND_RINGTONE()
{
	PAUSE_OUTBAND_RINGTONE_raised = true;
}
/* Functions for event STOP_OUTBAND_RINGTONE in interface SCI_AmClientRequest */
void VehicleRingtoneAudioSm::SCI_AmClientRequest::raise_sTOP_OUTBAND_RINGTONE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AmClientRequest_STOP_OUTBAND_RINGTONE(SCI_AmClientRequest_STOP_OUTBAND_RINGTONE));
	parent->runCycle();
}
void VehicleRingtoneAudioSm::SCI_AmClientRequest::internal_raise_sTOP_OUTBAND_RINGTONE()
{
	STOP_OUTBAND_RINGTONE_raised = true;
}
VehicleRingtoneAudioSm::SCI_AudioWrapperReqIf* VehicleRingtoneAudioSm::getSCI_AudioWrapperReqIf()
{
	return &ifaceAudioWrapperReqIf;
}
void VehicleRingtoneAudioSm::setSCI_AudioWrapperReqIf_OCB(SCI_AudioWrapperReqIf_OCB* operationCallback)
{
	ifaceAudioWrapperReqIf_OCB = operationCallback;
}
VehicleRingtoneAudioSm::SCI_AudioWrapperResponse* VehicleRingtoneAudioSm::getSCI_AudioWrapperResponse()
{
	return &ifaceAudioWrapperResponse;
}
/* Functions for event OUTBAND_RINGTONE_CHANNEL_GRANTED in interface SCI_AudioWrapperResponse */
void VehicleRingtoneAudioSm::SCI_AudioWrapperResponse::raise_oUTBAND_RINGTONE_CHANNEL_GRANTED(AudioSink value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_GRANTED(SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_GRANTED, value));
	parent->runCycle();
}
void VehicleRingtoneAudioSm::SCI_AudioWrapperResponse::internal_raise_oUTBAND_RINGTONE_CHANNEL_GRANTED(AudioSink value)
{
	OUTBAND_RINGTONE_CHANNEL_GRANTED_value = value;
	OUTBAND_RINGTONE_CHANNEL_GRANTED_raised = true;
}
/* Functions for event OUTBAND_RINGTONE_CHANNEL_DENIED in interface SCI_AudioWrapperResponse */
void VehicleRingtoneAudioSm::SCI_AudioWrapperResponse::raise_oUTBAND_RINGTONE_CHANNEL_DENIED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_DENIED(SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_DENIED));
	parent->runCycle();
}
void VehicleRingtoneAudioSm::SCI_AudioWrapperResponse::internal_raise_oUTBAND_RINGTONE_CHANNEL_DENIED()
{
	OUTBAND_RINGTONE_CHANNEL_DENIED_raised = true;
}
/* Functions for event OUTBAND_RINGTONE_CHANNEL_DEALLOCATED in interface SCI_AudioWrapperResponse */
void VehicleRingtoneAudioSm::SCI_AudioWrapperResponse::raise_oUTBAND_RINGTONE_CHANNEL_DEALLOCATED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_DEALLOCATED(SCI_AudioWrapperResponse_OUTBAND_RINGTONE_CHANNEL_DEALLOCATED));
	parent->runCycle();
}
void VehicleRingtoneAudioSm::SCI_AudioWrapperResponse::internal_raise_oUTBAND_RINGTONE_CHANNEL_DEALLOCATED()
{
	OUTBAND_RINGTONE_CHANNEL_DEALLOCATED_raised = true;
}
/* Functions for event OUTBAND_RINGTONE_SA_ON in interface SCI_AudioWrapperResponse */
void VehicleRingtoneAudioSm::SCI_AudioWrapperResponse::raise_oUTBAND_RINGTONE_SA_ON()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_ON(SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_ON));
	parent->runCycle();
}
void VehicleRingtoneAudioSm::SCI_AudioWrapperResponse::internal_raise_oUTBAND_RINGTONE_SA_ON()
{
	OUTBAND_RINGTONE_SA_ON_raised = true;
}
/* Functions for event OUTBAND_RINGTONE_SA_OFF in interface SCI_AudioWrapperResponse */
void VehicleRingtoneAudioSm::SCI_AudioWrapperResponse::raise_oUTBAND_RINGTONE_SA_OFF()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_OFF(SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_OFF));
	parent->runCycle();
}
void VehicleRingtoneAudioSm::SCI_AudioWrapperResponse::internal_raise_oUTBAND_RINGTONE_SA_OFF()
{
	OUTBAND_RINGTONE_SA_OFF_raised = true;
}
/* Functions for event OUTBAND_RINGTONE_SA_PAUSE in interface SCI_AudioWrapperResponse */
void VehicleRingtoneAudioSm::SCI_AudioWrapperResponse::raise_oUTBAND_RINGTONE_SA_PAUSE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_PAUSE(SCI_AudioWrapperResponse_OUTBAND_RINGTONE_SA_PAUSE));
	parent->runCycle();
}
void VehicleRingtoneAudioSm::SCI_AudioWrapperResponse::internal_raise_oUTBAND_RINGTONE_SA_PAUSE()
{
	OUTBAND_RINGTONE_SA_PAUSE_raised = true;
}
VehicleRingtoneAudioSm::SCI_AudioPlayerReqIf* VehicleRingtoneAudioSm::getSCI_AudioPlayerReqIf()
{
	return &ifaceAudioPlayerReqIf;
}
void VehicleRingtoneAudioSm::setSCI_AudioPlayerReqIf_OCB(SCI_AudioPlayerReqIf_OCB* operationCallback)
{
	ifaceAudioPlayerReqIf_OCB = operationCallback;
}
VehicleRingtoneAudioSm::SCI_AudioPlayerResponse* VehicleRingtoneAudioSm::getSCI_AudioPlayerResponse()
{
	return &ifaceAudioPlayerResponse;
}
/* Functions for event PLAYING_SUCCESS in interface SCI_AudioPlayerResponse */
void VehicleRingtoneAudioSm::SCI_AudioPlayerResponse::raise_pLAYING_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioPlayerResponse_PLAYING_SUCCESS(SCI_AudioPlayerResponse_PLAYING_SUCCESS));
	parent->runCycle();
}
void VehicleRingtoneAudioSm::SCI_AudioPlayerResponse::internal_raise_pLAYING_SUCCESS()
{
	PLAYING_SUCCESS_raised = true;
}
/* Functions for event PLAYING_ERROR in interface SCI_AudioPlayerResponse */
void VehicleRingtoneAudioSm::SCI_AudioPlayerResponse::raise_pLAYING_ERROR(AmResultMessage value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioPlayerResponse_PLAYING_ERROR(SCI_AudioPlayerResponse_PLAYING_ERROR, value));
	parent->runCycle();
}
void VehicleRingtoneAudioSm::SCI_AudioPlayerResponse::internal_raise_pLAYING_ERROR(AmResultMessage value)
{
	PLAYING_ERROR_value = value;
	PLAYING_ERROR_raised = true;
}
/* Functions for event STOP_SUCCESS in interface SCI_AudioPlayerResponse */
void VehicleRingtoneAudioSm::SCI_AudioPlayerResponse::raise_sTOP_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioPlayerResponse_STOP_SUCCESS(SCI_AudioPlayerResponse_STOP_SUCCESS));
	parent->runCycle();
}
void VehicleRingtoneAudioSm::SCI_AudioPlayerResponse::internal_raise_sTOP_SUCCESS()
{
	STOP_SUCCESS_raised = true;
}
/* Functions for event STOP_FAILURE in interface SCI_AudioPlayerResponse */
void VehicleRingtoneAudioSm::SCI_AudioPlayerResponse::raise_sTOP_FAILURE(AmResultMessage value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioPlayerResponse_STOP_FAILURE(SCI_AudioPlayerResponse_STOP_FAILURE, value));
	parent->runCycle();
}
void VehicleRingtoneAudioSm::SCI_AudioPlayerResponse::internal_raise_sTOP_FAILURE(AmResultMessage value)
{
	STOP_FAILURE_value = value;
	STOP_FAILURE_raised = true;
}
VehicleRingtoneAudioSm::SCI_VehicleRingtoneSmHandler* VehicleRingtoneAudioSm::getSCI_VehicleRingtoneSmHandler()
{
	return &ifaceVehicleRingtoneSmHandler;
}
FilePath VehicleRingtoneAudioSm::SCI_VehicleRingtoneSmHandler::get_ringtoneFilePath() const
{
	return ringtoneFilePath;
}

void VehicleRingtoneAudioSm::SCI_VehicleRingtoneSmHandler::set_ringtoneFilePath(FilePath value)
{
	ringtoneFilePath = value;
}

AudioSink VehicleRingtoneAudioSm::SCI_VehicleRingtoneSmHandler::get_sinkName() const
{
	return sinkName;
}

void VehicleRingtoneAudioSm::SCI_VehicleRingtoneSmHandler::set_sinkName(AudioSink value)
{
	sinkName = value;
}

PlayCount VehicleRingtoneAudioSm::SCI_VehicleRingtoneSmHandler::get_ringtonePlayCount() const
{
	return ringtonePlayCount;
}

void VehicleRingtoneAudioSm::SCI_VehicleRingtoneSmHandler::set_ringtonePlayCount(PlayCount value)
{
	ringtonePlayCount = value;
}

void VehicleRingtoneAudioSm::setSCI_VehicleRingtoneSmHandler_OCB(SCI_VehicleRingtoneSmHandler_OCB* operationCallback)
{
	ifaceVehicleRingtoneSmHandler_OCB = operationCallback;
}
/* Functions for event READY_TO_PLAY in interface InternalSCI */
void VehicleRingtoneAudioSm::InternalSCI::raise_rEADY_TO_PLAY()
{
	parent->internalEventQueue.push_back(new SctEvent_InternalSCI_READY_TO_PLAY(InternalSCI_READY_TO_PLAY));
	parent->runCycle();
}
void VehicleRingtoneAudioSm::InternalSCI::internal_raise_rEADY_TO_PLAY()
{
	READY_TO_PLAY_raised = true;
}
sc_boolean VehicleRingtoneAudioSm::InternalSCI::isRaised_rEADY_TO_PLAY() const
{
	return READY_TO_PLAY_raised;
}
/* Functions for event SEND_SRC_ACTIVITY_OFF_RESULT in interface InternalSCI */
void VehicleRingtoneAudioSm::InternalSCI::raise_sEND_SRC_ACTIVITY_OFF_RESULT()
{
	parent->internalEventQueue.push_back(new SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT));
	parent->runCycle();
}
void VehicleRingtoneAudioSm::InternalSCI::internal_raise_sEND_SRC_ACTIVITY_OFF_RESULT()
{
	SEND_SRC_ACTIVITY_OFF_RESULT_raised = true;
}
sc_boolean VehicleRingtoneAudioSm::InternalSCI::isRaised_sEND_SRC_ACTIVITY_OFF_RESULT() const
{
	return SEND_SRC_ACTIVITY_OFF_RESULT_raised;
}

void VehicleRingtoneAudioSm::setTraceObserver(ysc::TraceObserver<VehicleRingtoneAudioSmStates>* tracingcallback) {
	ifaceTraceObserver = tracingcallback;
}

ysc::TraceObserver<VehicleRingtoneAudioSm::VehicleRingtoneAudioSmStates>* VehicleRingtoneAudioSm::getTraceObserver() {
	return ifaceTraceObserver;
}

// implementations of all internal functions

void VehicleRingtoneAudioSm::effect_VehicleRingtoneAudioRegion_RingtonePlay_tr0()
{
	exseq_VehicleRingtoneAudioRegion_RingtonePlay();
	enseq_VehicleRingtoneAudioRegion_Idle_default();
	react();
}

void VehicleRingtoneAudioSm::effect_VehicleRingtoneAudioRegion_RingtonePlay_tr1()
{
	exseq_VehicleRingtoneAudioRegion_RingtonePlay();
	enseq_VehicleRingtoneAudioRegion_Idle_default();
	react();
}

void VehicleRingtoneAudioSm::effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_tr1()
{
	exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay();
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_ChannelDeallocated();
}

void VehicleRingtoneAudioSm::effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_tr2()
{
	exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone();
	ifaceAudioPlayerReqIf_OCB->setAlsaDeviceName(ifaceVehicleRingtoneSmHandler.sinkName, (sc_string) "");
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying_default();
	VehicleRingtoneAudioRegion_RingtonePlay_react(false);
}

void VehicleRingtoneAudioSm::effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_tr3()
{
	exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone();
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_DeallocateRoute();
	VehicleRingtoneAudioRegion_RingtonePlay_react(false);
}

void VehicleRingtoneAudioSm::effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_tr5()
{
	exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone();
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPaused();
	VehicleRingtoneAudioRegion_RingtonePlay_react(false);
}

void VehicleRingtoneAudioSm::effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_tr7()
{
	exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone();
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_AutoSAOff();
	VehicleRingtoneAudioRegion_RingtonePlay_react(false);
}

void VehicleRingtoneAudioSm::effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_tr0()
{
	exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause();
	ifaceAudioPlayerReqIf_OCB->setAlsaDeviceName(ifaceVehicleRingtoneSmHandler.sinkName, (sc_string) "");
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying_default();
	VehicleRingtoneAudioRegion_RingtonePlay_react(false);
}

void VehicleRingtoneAudioSm::effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_tr1()
{
	exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause();
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_AutoSAOff();
	VehicleRingtoneAudioRegion_RingtonePlay_react(false);
}

void VehicleRingtoneAudioSm::effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_tr2()
{
	exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause();
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_DeallocateRoute();
	VehicleRingtoneAudioRegion_RingtonePlay_react(false);
}

/* Entry action for state 'WaitToPlayOutbandRingtone'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone()
{
	/* Entry action for state 'WaitToPlayOutbandRingtone'. */
	ifaceVehicleRingtoneSmHandler_OCB->updateStatus(PREPARING, (sc_string) "Preparing Ringtone channel");
}

/* Entry action for state 'PlayRingtoneRequest'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest()
{
	/* Entry action for state 'PlayRingtoneRequest'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_READY_TO_PLAY(InternalSCI_READY_TO_PLAY));
}

/* Entry action for state 'WaitForRingtoneRouteAllocation'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation()
{
	/* Entry action for state 'WaitForRingtoneRouteAllocation'. */
	ifaceAudioWrapperReqIf_OCB->sendAllocateRequest();
}

/* Entry action for state 'RingtoneSAOnReceived'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived()
{
	/* Entry action for state 'RingtoneSAOnReceived'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_READY_TO_PLAY(InternalSCI_READY_TO_PLAY));
}

/* Entry action for state 'WaitForSAOn'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn()
{
	/* Entry action for state 'WaitForSAOn'. */
	ifaceAudioPlayerReqIf_OCB->setAlsaDeviceName(ifaceAudioWrapperResponse.OUTBAND_RINGTONE_CHANNEL_GRANTED_value, (sc_string) "");
	ifaceVehicleRingtoneSmHandler_OCB->updateSinkName(ifaceAudioWrapperResponse.OUTBAND_RINGTONE_CHANNEL_GRANTED_value);
	ifaceVehicleRingtoneSmHandler_OCB->updateStatus(READY_TO_STREAM, (sc_string) "Ringtone channel granted");
}

/* Entry action for state 'OutbandRingtonePlaying'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying()
{
	/* Entry action for state 'OutbandRingtonePlaying'. */
	ifaceAudioPlayerReqIf_OCB->sendPlayFileRequest(ifaceVehicleRingtoneSmHandler.ringtoneFilePath, ifaceVehicleRingtoneSmHandler.ringtonePlayCount);
}

/* Entry action for state 'WaitForPlayerToStop'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop()
{
	/* Entry action for state 'WaitForPlayerToStop'. */
	ifaceAudioPlayerReqIf_OCB->stopPlayback();
}

/* Entry action for state 'PlaybackStopped'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped()
{
	/* Entry action for state 'PlaybackStopped'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT));
}

/* Entry action for state 'WaitForRouteDeallocation'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation()
{
	/* Entry action for state 'WaitForRouteDeallocation'. */
	ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
}

/* Entry action for state 'RingtoneChannelDeallocated'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated()
{
	/* Entry action for state 'RingtoneChannelDeallocated'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT));
}

/* Entry action for state 'WaitForRouteDeallocation'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation()
{
	/* Entry action for state 'WaitForRouteDeallocation'. */
	ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
}

/* Entry action for state 'StreamingStopped'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped()
{
	/* Entry action for state 'StreamingStopped'. */
	ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_OFF);
}

/* Entry action for state 'WaitForPlayerStop'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop()
{
	/* Entry action for state 'WaitForPlayerStop'. */
	ifaceAudioPlayerReqIf_OCB->stopPlayback();
}

/* Entry action for state 'AutoSaoff'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff()
{
	/* Entry action for state 'AutoSaoff'. */
	ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_OFF);
	ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
	ifaceVehicleRingtoneSmHandler_OCB->updateStatus(DEALLOCATING, (sc_string) "Source Switch");
}

/* Entry action for state 'WaitForRouteDeallocationAndStopPlayback'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback()
{
	/* Entry action for state 'WaitForRouteDeallocationAndStopPlayback'. */
	ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
}

/* Entry action for state 'WaitPlayerTostop'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop()
{
	/* Entry action for state 'WaitPlayerTostop'. */
	ifaceAudioPlayerReqIf_OCB->stopPlayback();
}

/* Entry action for state 'PlaybackPaused'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused()
{
	/* Entry action for state 'PlaybackPaused'. */
	ifaceVehicleRingtoneSmHandler_OCB->updateStatus(STREAMING_PAUSED, (sc_string) "Audio paused");
}

/* Entry action for state 'WaitForPlayerToStop'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop()
{
	/* Entry action for state 'WaitForPlayerToStop'. */
	ifaceAudioPlayerReqIf_OCB->stopPlayback();
}

/* Entry action for state 'ChannelPaused'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused()
{
	/* Entry action for state 'ChannelPaused'. */
	ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_PAUSE);
	ifaceVehicleRingtoneSmHandler_OCB->updateStatus(STREAMING_PAUSED, (sc_string) "Auto paused");
}

/* Entry action for state 'SAOnAfterPlayerResponse'. */
void VehicleRingtoneAudioSm::enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse()
{
	/* Entry action for state 'SAOnAfterPlayerResponse'. */
	ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
}

/* 'default' enter sequence for state Idle */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_Idle_default()
{
	/* 'default' enter sequence for state Idle */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_Idle);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_Idle;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state RingtonePlay */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_default()
{
	/* 'default' enter sequence for state RingtonePlay */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay);
	}
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_default();
}

/* 'default' enter sequence for state WaitForAmClientRequest */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest_default()
{
	/* 'default' enter sequence for state WaitForAmClientRequest */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PlayRingtoneRequest */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest_default()
{
	/* 'default' enter sequence for state PlayRingtoneRequest */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForRingtoneRouteAllocation */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation_default()
{
	/* 'default' enter sequence for state WaitForRingtoneRouteAllocation */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation);
	}
	stateConfVector[1] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state RingtoneSAOnReceived */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived_default()
{
	/* 'default' enter sequence for state RingtoneSAOnReceived */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived);
	}
	stateConfVector[1] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state WaitForSAOn */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn_default()
{
	/* 'default' enter sequence for state WaitForSAOn */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn);
	}
	stateConfVector[1] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state OutbandRingtonePlaying */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying_default()
{
	/* 'default' enter sequence for state OutbandRingtonePlaying */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying;
	stateConfVectorPosition = 0;
}

/* 'AutoSAOff' enter sequence for state StopRingtonePlay */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_AutoSAOff()
{
	/* 'AutoSAOff' enter sequence for state StopRingtonePlay */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay);
	}
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSAOff();
}

/* 'DeallocateAndStop' enter sequence for state StopRingtonePlay */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_DeallocateAndStop()
{
	/* 'DeallocateAndStop' enter sequence for state StopRingtonePlay */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay);
	}
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_DeallocateAndStop();
}

/* 'DeallocateRoute' enter sequence for state StopRingtonePlay */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_DeallocateRoute()
{
	/* 'DeallocateRoute' enter sequence for state StopRingtonePlay */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay);
	}
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_DeallocateRoute();
}

/* 'StopAndDeallocate' enter sequence for state StopRingtonePlay */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopAndDeallocate()
{
	/* 'StopAndDeallocate' enter sequence for state StopRingtonePlay */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay);
	}
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopAndDeallocate();
}

/* 'default' enter sequence for state StopRingtonePlay */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_default()
{
	/* 'default' enter sequence for state StopRingtonePlay */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay);
	}
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_default();
}

/* 'default' enter sequence for state WaitForPlayerToStop */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop_default()
{
	/* 'default' enter sequence for state WaitForPlayerToStop */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PlaybackStopped */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped_default()
{
	/* 'default' enter sequence for state PlaybackStopped */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForRouteDeallocation */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation_default()
{
	/* 'default' enter sequence for state WaitForRouteDeallocation */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation);
	}
	stateConfVector[1] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state RingtoneChannelDeallocated */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated_default()
{
	/* 'default' enter sequence for state RingtoneChannelDeallocated */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated);
	}
	stateConfVector[1] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state WaitForRouteDeallocation */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation_default()
{
	/* 'default' enter sequence for state WaitForRouteDeallocation */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StreamingStopped */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped_default()
{
	/* 'default' enter sequence for state StreamingStopped */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForPlayerStop */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop_default()
{
	/* 'default' enter sequence for state WaitForPlayerStop */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSaoff */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff_default()
{
	/* 'default' enter sequence for state AutoSaoff */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForRouteDeallocationAndStopPlayback */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback_default()
{
	/* 'default' enter sequence for state WaitForRouteDeallocationAndStopPlayback */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PauseRingtone */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_default()
{
	/* 'default' enter sequence for state PauseRingtone */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone);
	}
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_default();
}

/* 'entry_AutoSAOffAfterEcnrResponse6' enter sequence for state PauseRingtone */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_entry_AutoSAOffAfterEcnrResponse6()
{
	/* 'entry_AutoSAOffAfterEcnrResponse6' enter sequence for state PauseRingtone */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone);
	}
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_AutoSAOffAfterEcnrResponse6();
}

/* 'entry_AutoSAOnAfterPlayerResponse8' enter sequence for state PauseRingtone */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_entry_AutoSAOnAfterPlayerResponse8()
{
	/* 'entry_AutoSAOnAfterPlayerResponse8' enter sequence for state PauseRingtone */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone);
	}
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_AutoSAOnAfterPlayerResponse8();
}

/* 'entry_AutoSAPauseAfterPlayerResponse4' enter sequence for state PauseRingtone */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_entry_AutoSAPauseAfterPlayerResponse4()
{
	/* 'entry_AutoSAPauseAfterPlayerResponse4' enter sequence for state PauseRingtone */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone);
	}
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_AutoSAPauseAfterPlayerResponse4();
}

/* 'entry_PlayRingtone1' enter sequence for state PauseRingtone */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_entry_PlayRingtone1()
{
	/* 'entry_PlayRingtone1' enter sequence for state PauseRingtone */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone);
	}
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_PlayRingtone1();
}

/* 'entry_StopAfterPlayerResponse0' enter sequence for state PauseRingtone */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_entry_StopAfterPlayerResponse0()
{
	/* 'entry_StopAfterPlayerResponse0' enter sequence for state PauseRingtone */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone);
	}
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_StopAfterPlayerResponse0();
}

/* 'default' enter sequence for state WaitPlayerTostop */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop_default()
{
	/* 'default' enter sequence for state WaitPlayerTostop */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PlaybackPaused */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused_default()
{
	/* 'default' enter sequence for state PlaybackPaused */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PlayAfterPlayerResponse */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse_default()
{
	/* 'default' enter sequence for state PlayAfterPlayerResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PauseAfterPlayerResponse */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse_default()
{
	/* 'default' enter sequence for state PauseAfterPlayerResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StopAfterPlayerResponse */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse_default()
{
	/* 'default' enter sequence for state StopAfterPlayerResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAPauseAfterPlayerResponse */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse_default()
{
	/* 'default' enter sequence for state AutoSAPauseAfterPlayerResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAOffAfterEcnrResponse */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state AutoSAOffAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAOnAfterPlayerResponse */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse_default()
{
	/* 'default' enter sequence for state AutoSAOnAfterPlayerResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse;
	stateConfVectorPosition = 0;
}

/* 'AutoSAPaused' enter sequence for state AutoSAPause */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPaused()
{
	/* 'AutoSAPaused' enter sequence for state AutoSAPause */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause);
	}
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAPaused();
}

/* 'default' enter sequence for state AutoSAPause */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_default()
{
	/* 'default' enter sequence for state AutoSAPause */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause);
	}
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_default();
}

/* 'entry_AutoSAOffAfterPlayerResponse3' enter sequence for state AutoSAPause */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_entry_AutoSAOffAfterPlayerResponse3()
{
	/* 'entry_AutoSAOffAfterPlayerResponse3' enter sequence for state AutoSAPause */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause);
	}
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_AutoSAOffAfterPlayerResponse3();
}

/* 'entry_StopAfterPlayerResponse4' enter sequence for state AutoSAPause */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_entry_StopAfterPlayerResponse4()
{
	/* 'entry_StopAfterPlayerResponse4' enter sequence for state AutoSAPause */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause);
	}
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_StopAfterPlayerResponse4();
}

/* 'default' enter sequence for state WaitForPlayerToStop */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop_default()
{
	/* 'default' enter sequence for state WaitForPlayerToStop */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ChannelPaused */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused_default()
{
	/* 'default' enter sequence for state ChannelPaused */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAOffAfterPlayerResponse */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse_default()
{
	/* 'default' enter sequence for state AutoSAOffAfterPlayerResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StopAfterPlayerResponse */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse_default()
{
	/* 'default' enter sequence for state StopAfterPlayerResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state SAOnAfterPlayerResponse */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse_default()
{
	/* 'default' enter sequence for state SAOnAfterPlayerResponse */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PauseAfterPlayerResponse */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse_default()
{
	/* 'default' enter sequence for state PauseAfterPlayerResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse);
	}
	stateConfVector[0] = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for region VehicleRingtoneAudioRegion */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_default()
{
	/* 'default' enter sequence for region VehicleRingtoneAudioRegion */
	react_VehicleRingtoneAudioRegion__entry_Default();
}

/* 'default' enter sequence for region RingtonePlayRegion */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_default()
{
	/* 'default' enter sequence for region RingtonePlayRegion */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion__entry_Default();
}

/* 'default' enter sequence for region StopRingtonePlay Region */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_default()
{
	/* 'default' enter sequence for region StopRingtonePlay Region */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region__entry_Default();
}

/* 'DeallocateRoute' enter sequence for region StopRingtonePlay Region */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_DeallocateRoute()
{
	/* 'DeallocateRoute' enter sequence for region StopRingtonePlay Region */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_DeallocateRoute();
}

/* 'StopAndDeallocate' enter sequence for region StopRingtonePlay Region */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopAndDeallocate()
{
	/* 'StopAndDeallocate' enter sequence for region StopRingtonePlay Region */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopAndDeallocate();
}

/* 'AutoSAOff' enter sequence for region StopRingtonePlay Region */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSAOff()
{
	/* 'AutoSAOff' enter sequence for region StopRingtonePlay Region */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSAOff();
}

/* 'DeallocateAndStop' enter sequence for region StopRingtonePlay Region */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_DeallocateAndStop()
{
	/* 'DeallocateAndStop' enter sequence for region StopRingtonePlay Region */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_DeallocateAndStop();
}

/* 'default' enter sequence for region PauseRingtoneRegion */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_default()
{
	/* 'default' enter sequence for region PauseRingtoneRegion */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion__entry_Default();
}

/* 'entry_StopAfterPlayerResponse0' enter sequence for region PauseRingtoneRegion */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_StopAfterPlayerResponse0()
{
	/* 'entry_StopAfterPlayerResponse0' enter sequence for region PauseRingtoneRegion */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_StopAfterPlayerResponse0();
}

/* 'entry_PlayRingtone1' enter sequence for region PauseRingtoneRegion */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_PlayRingtone1()
{
	/* 'entry_PlayRingtone1' enter sequence for region PauseRingtoneRegion */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_PlayRingtone1();
}

/* 'entry_AutoSAPauseAfterPlayerResponse4' enter sequence for region PauseRingtoneRegion */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_AutoSAPauseAfterPlayerResponse4()
{
	/* 'entry_AutoSAPauseAfterPlayerResponse4' enter sequence for region PauseRingtoneRegion */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_AutoSAPauseAfterPlayerResponse4();
}

/* 'entry_AutoSAOffAfterEcnrResponse6' enter sequence for region PauseRingtoneRegion */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_AutoSAOffAfterEcnrResponse6()
{
	/* 'entry_AutoSAOffAfterEcnrResponse6' enter sequence for region PauseRingtoneRegion */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_AutoSAOffAfterEcnrResponse6();
}

/* 'entry_AutoSAOnAfterPlayerResponse8' enter sequence for region PauseRingtoneRegion */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_AutoSAOnAfterPlayerResponse8()
{
	/* 'entry_AutoSAOnAfterPlayerResponse8' enter sequence for region PauseRingtoneRegion */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_AutoSAOnAfterPlayerResponse8();
}

/* 'default' enter sequence for region AutoSAPauseRegion */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_default()
{
	/* 'default' enter sequence for region AutoSAPauseRegion */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion__entry_Default();
}

/* 'AutoSAPaused' enter sequence for region AutoSAPauseRegion */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAPaused()
{
	/* 'AutoSAPaused' enter sequence for region AutoSAPauseRegion */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAPaused();
}

/* 'entry_AutoSAOffAfterPlayerResponse3' enter sequence for region AutoSAPauseRegion */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_AutoSAOffAfterPlayerResponse3()
{
	/* 'entry_AutoSAOffAfterPlayerResponse3' enter sequence for region AutoSAPauseRegion */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_AutoSAOffAfterPlayerResponse3();
}

/* 'entry_StopAfterPlayerResponse4' enter sequence for region AutoSAPauseRegion */
void VehicleRingtoneAudioSm::enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_StopAfterPlayerResponse4()
{
	/* 'entry_StopAfterPlayerResponse4' enter sequence for region AutoSAPauseRegion */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_StopAfterPlayerResponse4();
}

/* Default exit sequence for state Idle */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_Idle()
{
	/* Default exit sequence for state Idle */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state RingtonePlay */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay()
{
	/* Default exit sequence for state RingtonePlay */
	exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion();
}

/* Default exit sequence for state WaitToPlayOutbandRingtone */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone()
{
	/* Default exit sequence for state WaitToPlayOutbandRingtone */
	exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion();
	exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion();
}

/* Default exit sequence for state WaitForAmClientRequest */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest()
{
	/* Default exit sequence for state WaitForAmClientRequest */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PlayRingtoneRequest */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest()
{
	/* Default exit sequence for state PlayRingtoneRequest */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForRingtoneRouteAllocation */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation()
{
	/* Default exit sequence for state WaitForRingtoneRouteAllocation */
	stateConfVector[1] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state RingtoneSAOnReceived */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived()
{
	/* Default exit sequence for state RingtoneSAOnReceived */
	stateConfVector[1] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state WaitForSAOn */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn()
{
	/* Default exit sequence for state WaitForSAOn */
	stateConfVector[1] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state OutbandRingtonePlaying */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying()
{
	/* Default exit sequence for state OutbandRingtonePlaying */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopRingtonePlay */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay()
{
	/* Default exit sequence for state StopRingtonePlay */
	exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region();
}

/* Default exit sequence for state StopPlay */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay()
{
	/* Default exit sequence for state StopPlay */
	exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion();
	exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion();
}

/* Default exit sequence for state WaitForPlayerToStop */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop()
{
	/* Default exit sequence for state WaitForPlayerToStop */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PlaybackStopped */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped()
{
	/* Default exit sequence for state PlaybackStopped */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForRouteDeallocation */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation()
{
	/* Default exit sequence for state WaitForRouteDeallocation */
	stateConfVector[1] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state RingtoneChannelDeallocated */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated()
{
	/* Default exit sequence for state RingtoneChannelDeallocated */
	stateConfVector[1] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state WaitForRouteDeallocation */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation()
{
	/* Default exit sequence for state WaitForRouteDeallocation */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StreamingStopped */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped()
{
	/* Default exit sequence for state StreamingStopped */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForPlayerStop */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop()
{
	/* Default exit sequence for state WaitForPlayerStop */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSaoff */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff()
{
	/* Default exit sequence for state AutoSaoff */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForRouteDeallocationAndStopPlayback */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback()
{
	/* Default exit sequence for state WaitForRouteDeallocationAndStopPlayback */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PauseRingtone */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone()
{
	/* Default exit sequence for state PauseRingtone */
	exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion();
}

/* Default exit sequence for state WaitPlayerTostop */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop()
{
	/* Default exit sequence for state WaitPlayerTostop */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PlaybackPaused */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused()
{
	/* Default exit sequence for state PlaybackPaused */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PlayAfterPlayerResponse */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse()
{
	/* Default exit sequence for state PlayAfterPlayerResponse */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PauseAfterPlayerResponse */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse()
{
	/* Default exit sequence for state PauseAfterPlayerResponse */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopAfterPlayerResponse */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse()
{
	/* Default exit sequence for state StopAfterPlayerResponse */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAPauseAfterPlayerResponse */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse()
{
	/* Default exit sequence for state AutoSAPauseAfterPlayerResponse */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAOffAfterEcnrResponse */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse()
{
	/* Default exit sequence for state AutoSAOffAfterEcnrResponse */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAOnAfterPlayerResponse */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse()
{
	/* Default exit sequence for state AutoSAOnAfterPlayerResponse */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAPause */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause()
{
	/* Default exit sequence for state AutoSAPause */
	exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion();
}

/* Default exit sequence for state WaitForPlayerToStop */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop()
{
	/* Default exit sequence for state WaitForPlayerToStop */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ChannelPaused */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused()
{
	/* Default exit sequence for state ChannelPaused */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAOffAfterPlayerResponse */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse()
{
	/* Default exit sequence for state AutoSAOffAfterPlayerResponse */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopAfterPlayerResponse */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse()
{
	/* Default exit sequence for state StopAfterPlayerResponse */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state SAOnAfterPlayerResponse */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse()
{
	/* Default exit sequence for state SAOnAfterPlayerResponse */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PauseAfterPlayerResponse */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse()
{
	/* Default exit sequence for state PauseAfterPlayerResponse */
	stateConfVector[0] = VehicleRingtoneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for region VehicleRingtoneAudioRegion */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion()
{
	/* Default exit sequence for region VehicleRingtoneAudioRegion */
	/* Handle exit of all possible states (of VehicleRingtoneAudioSm.VehicleRingtoneAudioRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VehicleRingtoneAudioRegion_Idle :
		{
			exseq_VehicleRingtoneAudioRegion_Idle();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse();
			break;
		}
		default: break;
	}
	/* Handle exit of all possible states (of VehicleRingtoneAudioSm.VehicleRingtoneAudioRegion) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region RingtonePlayRegion */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion()
{
	/* Default exit sequence for region RingtonePlayRegion */
	/* Handle exit of all possible states (of VehicleRingtoneAudioSm.VehicleRingtoneAudioRegion.RingtonePlay.RingtonePlayRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse();
			break;
		}
		default: break;
	}
	/* Handle exit of all possible states (of VehicleRingtoneAudioSm.VehicleRingtoneAudioRegion.RingtonePlay.RingtonePlayRegion) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region AmClientRequestWaitRegion */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion()
{
	/* Default exit sequence for region AmClientRequestWaitRegion */
	/* Handle exit of all possible states (of VehicleRingtoneAudioSm.VehicleRingtoneAudioRegion.RingtonePlay.RingtonePlayRegion.WaitToPlayOutbandRingtone.AmClientRequestWaitRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region ArlResponseWaitRegion */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion()
{
	/* Default exit sequence for region ArlResponseWaitRegion */
	/* Handle exit of all possible states (of VehicleRingtoneAudioSm.VehicleRingtoneAudioRegion.RingtonePlay.RingtonePlayRegion.WaitToPlayOutbandRingtone.ArlResponseWaitRegion) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region StopRingtonePlay Region */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region()
{
	/* Default exit sequence for region StopRingtonePlay Region */
	/* Handle exit of all possible states (of VehicleRingtoneAudioSm.VehicleRingtoneAudioRegion.RingtonePlay.RingtonePlayRegion.StopRingtonePlay.StopRingtonePlay_Region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback();
			break;
		}
		default: break;
	}
	/* Handle exit of all possible states (of VehicleRingtoneAudioSm.VehicleRingtoneAudioRegion.RingtonePlay.RingtonePlayRegion.StopRingtonePlay.StopRingtonePlay_Region) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region AudioPlayerOperationRegion */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion()
{
	/* Default exit sequence for region AudioPlayerOperationRegion */
	/* Handle exit of all possible states (of VehicleRingtoneAudioSm.VehicleRingtoneAudioRegion.RingtonePlay.RingtonePlayRegion.StopRingtonePlay.StopRingtonePlay_Region.StopPlay.AudioPlayerOperationRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region AudioWrapperOperationRegion */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion()
{
	/* Default exit sequence for region AudioWrapperOperationRegion */
	/* Handle exit of all possible states (of VehicleRingtoneAudioSm.VehicleRingtoneAudioRegion.RingtonePlay.RingtonePlayRegion.StopRingtonePlay.StopRingtonePlay_Region.StopPlay.AudioWrapperOperationRegion) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region PauseRingtoneRegion */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion()
{
	/* Default exit sequence for region PauseRingtoneRegion */
	/* Handle exit of all possible states (of VehicleRingtoneAudioSm.VehicleRingtoneAudioRegion.RingtonePlay.RingtonePlayRegion.PauseRingtone.PauseRingtoneRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region AutoSAPauseRegion */
void VehicleRingtoneAudioSm::exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion()
{
	/* Default exit sequence for region AutoSAPauseRegion */
	/* Handle exit of all possible states (of VehicleRingtoneAudioSm.VehicleRingtoneAudioRegion.RingtonePlay.RingtonePlayRegion.AutoSAPause.AutoSAPauseRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse();
			break;
		}
		case VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse :
		{
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse();
			break;
		}
		default: break;
	}
}

/* Default react sequence for initial entry  */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion__sync1();
}

/* Default react sequence for initial entry  */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region__entry_Default()
{
	/* Default react sequence for initial entry  */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region__sync0();
}

/* Default react sequence for initial entry DeallocateRoute */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_DeallocateRoute()
{
	/* Default react sequence for initial entry DeallocateRoute */
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation_default();
}

/* Default react sequence for initial entry StopAndDeallocate */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopAndDeallocate()
{
	/* Default react sequence for initial entry StopAndDeallocate */
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop_default();
}

/* Default react sequence for initial entry AutoSAOff */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSAOff()
{
	/* Default react sequence for initial entry AutoSAOff */
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff_default();
}

/* Default react sequence for initial entry DeallocateAndStop */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_DeallocateAndStop()
{
	/* Default react sequence for initial entry DeallocateAndStop */
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback_default();
}

/* Default react sequence for initial entry  */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop_default();
}

/* Default react sequence for initial entry entry_StopAfterPlayerResponse0 */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_StopAfterPlayerResponse0()
{
	/* Default react sequence for initial entry entry_StopAfterPlayerResponse0 */
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse_default();
}

/* Default react sequence for initial entry entry_PlayRingtone1 */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_PlayRingtone1()
{
	/* Default react sequence for initial entry entry_PlayRingtone1 */
	react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayRingtone();
}

/* Default react sequence for initial entry entry_AutoSAPauseAfterPlayerResponse4 */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_AutoSAPauseAfterPlayerResponse4()
{
	/* Default react sequence for initial entry entry_AutoSAPauseAfterPlayerResponse4 */
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse_default();
}

/* Default react sequence for initial entry entry_AutoSAOffAfterEcnrResponse6 */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_AutoSAOffAfterEcnrResponse6()
{
	/* Default react sequence for initial entry entry_AutoSAOffAfterEcnrResponse6 */
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse_default();
}

/* Default react sequence for initial entry entry_AutoSAOnAfterPlayerResponse8 */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_entry_AutoSAOnAfterPlayerResponse8()
{
	/* Default react sequence for initial entry entry_AutoSAOnAfterPlayerResponse8 */
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse_default();
}

/* Default react sequence for initial entry  */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop_default();
}

/* Default react sequence for initial entry AutoSAPaused */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAPaused()
{
	/* Default react sequence for initial entry AutoSAPaused */
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused_default();
}

/* Default react sequence for initial entry entry_AutoSAOffAfterPlayerResponse3 */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_AutoSAOffAfterPlayerResponse3()
{
	/* Default react sequence for initial entry entry_AutoSAOffAfterPlayerResponse3 */
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse_default();
}

/* Default react sequence for initial entry entry_StopAfterPlayerResponse4 */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_StopAfterPlayerResponse4()
{
	/* Default react sequence for initial entry entry_StopAfterPlayerResponse4 */
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse_default();
}

/* Default react sequence for initial entry  */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_VehicleRingtoneAudioRegion_Idle_default();
}

/* The reactions of exit ChannelDenied. */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_ChannelDenied()
{
	/* The reactions of exit ChannelDenied. */
	effect_VehicleRingtoneAudioRegion_RingtonePlay_tr0();
}

/* The reactions of exit exitOnDeallacated. */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_exitOnDeallacated()
{
	/* The reactions of exit exitOnDeallacated. */
	effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_tr1();
}

/* The reactions of exit PlayRingtone. */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayRingtone()
{
	/* The reactions of exit PlayRingtone. */
	effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_tr2();
}

/* The reactions of exit StopRingtone. */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopRingtone()
{
	/* The reactions of exit StopRingtone. */
	effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_tr3();
}

/* The reactions of exit AutoSAPause. */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPause()
{
	/* The reactions of exit AutoSAPause. */
	effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_tr5();
}

/* The reactions of exit AutoSAOff. */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOff()
{
	/* The reactions of exit AutoSAOff. */
	effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_tr7();
}

/* The reactions of exit PlayRingtone. */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PlayRingtone()
{
	/* The reactions of exit PlayRingtone. */
	effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_tr0();
}

/* The reactions of exit AutoSAOff. */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOff()
{
	/* The reactions of exit AutoSAOff. */
	effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_tr1();
}

/* The reactions of exit DeallocateRoute. */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_DeallocateRoute()
{
	/* The reactions of exit DeallocateRoute. */
	effect_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_tr2();
}

/* The reactions of exit ChannelDeallocated. */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_ChannelDeallocated()
{
	/* The reactions of exit ChannelDeallocated. */
	effect_VehicleRingtoneAudioRegion_RingtonePlay_tr1();
}

/* The reactions of state null. */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion__sync0()
{
	/* The reactions of state null. */
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying_default();
}

/* The reactions of state null. */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion__sync1()
{
	/* The reactions of state null. */
	enact_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone);
	}
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest_default();
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation_default();
}

/* The reactions of state null. */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region__sync0()
{
	/* The reactions of state null. */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay);
	}
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop_default();
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation_default();
}

/* The reactions of state null. */
void VehicleRingtoneAudioSm::react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region__sync1()
{
	/* The reactions of state null. */
	enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped_default();
}

sc_boolean VehicleRingtoneAudioSm::react() {
	/* State machine reactions. */
	return false;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_Idle_react(const sc_boolean try_transition) {
	/* The reactions of state Idle. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.PREPARE_OUTBAND_RINGTONE_CHANNEL_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_Idle();
			enseq_VehicleRingtoneAudioRegion_RingtonePlay_default();
			react();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_ON_raised)
		{ 
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
		} 
		if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_OFF_raised)
		{ 
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_OFF);
		} 
		did_transition = react();
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_react(const sc_boolean try_transition) {
	/* The reactions of state RingtonePlay. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = react();
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_react(const sc_boolean try_transition) {
	/* The reactions of state WaitToPlayOutbandRingtone. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_CHANNEL_DENIED_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone();
			ifaceVehicleRingtoneSmHandler_OCB->updateStatus(FAILURE, (sc_string) "ChannelAcquisition-Channel Denied");
			react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_ChannelDenied();
		}  else
		{
			if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_OFF_raised)
			{ 
				exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone();
				enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_AutoSAOff();
				VehicleRingtoneAudioRegion_RingtonePlay_react(false);
			}  else
			{
				if (ifaceAmClientRequest.STOP_OUTBAND_RINGTONE_raised)
				{ 
					exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone();
					enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_DeallocateRoute();
					VehicleRingtoneAudioRegion_RingtonePlay_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForAmClientRequest. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.PLAY_OUTBAND_RINGTONE_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_WaitForAmClientRequest();
			enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest_default();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest_react(const sc_boolean try_transition) {
	/* The reactions of state PlayRingtoneRequest. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.READY_TO_PLAY_raised) && (isStateActive(VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived))) && (ifaceInternalSCI.READY_TO_PLAY_raised))
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone();
			react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion__sync0();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForRingtoneRouteAllocation. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_CHANNEL_GRANTED_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForRingtoneRouteAllocation();
			enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn_default();
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_react(false);
		}  else
		{
			if (ifaceAmClientRequest.STOP_OUTBAND_RINGTONE_raised)
			{ 
				exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone();
				ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
				ifaceVehicleRingtoneSmHandler_OCB->updateStatus(NOT_ALLOCATED, (sc_string) "Deallocated");
				react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_ChannelDeallocated();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived_react(const sc_boolean try_transition) {
	/* The reactions of state RingtoneSAOnReceived. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.READY_TO_PLAY_raised) && (isStateActive(VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_AmClientRequestWaitRegion_PlayRingtoneRequest))) && (ifaceInternalSCI.READY_TO_PLAY_raised))
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone();
			react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion__sync0();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForSAOn. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_ON_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_WaitForSAOn();
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
			enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_ArlResponseWaitRegion_RingtoneSAOnReceived_default();
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_react(false);
		}  else
		{
			if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_CHANNEL_DEALLOCATED_raised)
			{ 
				exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone();
				ifaceVehicleRingtoneSmHandler_OCB->updateStatus(NOT_ALLOCATED, (sc_string) "Deallocated");
				react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_ChannelDeallocated();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_WaitToPlayOutbandRingtone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying_react(const sc_boolean try_transition) {
	/* The reactions of state OutbandRingtonePlaying. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.STOP_OUTBAND_RINGTONE_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying();
			enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_default();
			VehicleRingtoneAudioRegion_RingtonePlay_react(false);
		}  else
		{
			if (ifaceAudioPlayerResponse.PLAYING_ERROR_raised)
			{ 
				exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying();
				enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_DeallocateRoute();
				VehicleRingtoneAudioRegion_RingtonePlay_react(false);
			}  else
			{
				if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_OFF_raised)
				{ 
					exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying();
					enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopAndDeallocate();
					VehicleRingtoneAudioRegion_RingtonePlay_react(false);
				}  else
				{
					if (ifaceAmClientRequest.PAUSE_OUTBAND_RINGTONE_raised)
					{ 
						exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying();
						enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_default();
						VehicleRingtoneAudioRegion_RingtonePlay_react(false);
					}  else
					{
						if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_PAUSE_raised)
						{ 
							exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying();
							enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_default();
							VehicleRingtoneAudioRegion_RingtonePlay_react(false);
						}  else
						{
							if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
							{ 
								exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_OutbandRingtonePlaying();
								enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_DeallocateAndStop();
								VehicleRingtoneAudioRegion_RingtonePlay_react(false);
							}  else
							{
								did_transition = false;
							}
						}
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioPlayerResponse.PLAYING_SUCCESS_raised)
		{ 
			ifaceVehicleRingtoneSmHandler_OCB->updateStatus(STREAMING, (sc_string) "Streaming");
		} 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_react(const sc_boolean try_transition) {
	/* The reactions of state StopRingtonePlay. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_CHANNEL_DEALLOCATED_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay();
			ifaceVehicleRingtoneSmHandler_OCB->updateStatus(NOT_ALLOCATED, (sc_string) "Deallocated");
			react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_ChannelDeallocated();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_react(const sc_boolean try_transition) {
	/* The reactions of state StopPlay. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForPlayerToStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAudioPlayerResponse.STOP_SUCCESS_raised) || (ifaceAudioPlayerResponse.STOP_FAILURE_raised))
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop();
			enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped_default();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped_react(const sc_boolean try_transition) {
	/* The reactions of state PlaybackStopped. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised) && (isStateActive(VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated))) && (ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised))
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay();
			react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region__sync1();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForRouteDeallocation. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_OFF_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation();
			enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated_default();
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioWrapperOperationRegion_RingtoneChannelDeallocated_react(const sc_boolean try_transition) {
	/* The reactions of state RingtoneChannelDeallocated. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised) && (isStateActive(VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped))) && (ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised))
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay();
			react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region__sync1();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StopPlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocation_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForRouteDeallocation. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_OFF_raised)
		{ 
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_OFF);
		} 
		if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_ON_raised)
		{ 
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
		} 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_StreamingStopped_react(const sc_boolean try_transition) {
	/* The reactions of state StreamingStopped. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForPlayerStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForPlayerStop();
			enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff_default();
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSaoff. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_CHANNEL_DEALLOCATED_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_AutoSaoff();
			ifaceVehicleRingtoneSmHandler_OCB->updateStatus(NOT_ALLOCATED, (sc_string) "Source Switch");
			react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_exitOnDeallacated();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_StopRingtonePlay_Region_WaitForRouteDeallocationAndStopPlayback_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForRouteDeallocationAndStopPlayback. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_OFF_raised)
		{ 
			ifaceAudioPlayerReqIf_OCB->stopPlayback();
		} 
		if ((ifaceAudioPlayerResponse.STOP_SUCCESS_raised) || (ifaceAudioPlayerResponse.STOP_FAILURE_raised))
		{ 
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_OFF);
		} 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_StopRingtonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_react(const sc_boolean try_transition) {
	/* The reactions of state PauseRingtone. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.STOP_OUTBAND_RINGTONE_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone();
			enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_entry_StopAfterPlayerResponse0();
		}  else
		{
			if (ifaceAmClientRequest.PLAY_OUTBAND_RINGTONE_raised)
			{ 
				exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone();
				enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_entry_PlayRingtone1();
			}  else
			{
				if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_PAUSE_raised)
				{ 
					exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone();
					enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_entry_AutoSAPauseAfterPlayerResponse4();
				}  else
				{
					if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_OFF_raised)
					{ 
						exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone();
						enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_entry_AutoSAOffAfterEcnrResponse6();
					}  else
					{
						if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_ON_raised)
						{ 
							exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone();
							ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
							enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_entry_AutoSAOnAfterPlayerResponse8();
						}  else
						{
							did_transition = false;
						}
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.PREPARE_OUTBAND_RINGTONE_CHANNEL_raised)
		{ 
			ifaceVehicleRingtoneSmHandler_OCB->updateStatus(READY_TO_STREAM, (sc_string) "Channel Already Prepared");
		} 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop_react(const sc_boolean try_transition) {
	/* The reactions of state WaitPlayerTostop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop();
			enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused_default();
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_react(false);
		}  else
		{
			if (ifaceAmClientRequest.PLAY_OUTBAND_RINGTONE_raised)
			{ 
				exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_WaitPlayerTostop();
				enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse_default();
				VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused_react(const sc_boolean try_transition) {
	/* The reactions of state PlaybackPaused. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_PAUSE_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused();
			react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPause();
		}  else
		{
			if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_OFF_raised)
			{ 
				exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused();
				react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOff();
			}  else
			{
				if (ifaceAmClientRequest.STOP_OUTBAND_RINGTONE_raised)
				{ 
					exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused();
					react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopRingtone();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse_react(const sc_boolean try_transition) {
	/* The reactions of state PlayAfterPlayerResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.PAUSE_OUTBAND_RINGTONE_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse();
			enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse_default();
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_react(false);
		}  else
		{
			if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
			{ 
				exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse();
				react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayRingtone();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse_react(const sc_boolean try_transition) {
	/* The reactions of state PauseAfterPlayerResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse();
			enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlaybackPaused_default();
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_react(false);
		}  else
		{
			if (ifaceAmClientRequest.PLAY_OUTBAND_RINGTONE_raised)
			{ 
				exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PauseAfterPlayerResponse();
				enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayAfterPlayerResponse_default();
				VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse_react(const sc_boolean try_transition) {
	/* The reactions of state StopAfterPlayerResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopAfterPlayerResponse();
			react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_StopRingtone();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAPauseAfterPlayerResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAudioPlayerResponse.STOP_SUCCESS_raised) || (ifaceAudioPlayerResponse.STOP_FAILURE_raised))
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPauseAfterPlayerResponse();
			react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAPause();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAOffAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAudioPlayerResponse.STOP_SUCCESS_raised) || (ifaceAudioPlayerResponse.STOP_FAILURE_raised))
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOffAfterEcnrResponse();
			react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOff();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAOnAfterPlayerResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_AutoSAOnAfterPlayerResponse();
			react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_PauseRingtoneRegion_PlayRingtone();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_PauseRingtone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAPause. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_OFF_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause();
			enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_entry_AutoSAOffAfterPlayerResponse3();
		}  else
		{
			if (ifaceAmClientRequest.STOP_OUTBAND_RINGTONE_raised)
			{ 
				exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause();
				enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_entry_StopAfterPlayerResponse4();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.PAUSE_OUTBAND_RINGTONE_raised)
		{ 
			ifaceVehicleRingtoneSmHandler_OCB->updateStatus(STREAMING_PAUSED, (sc_string) "Audio paused");
		} 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForPlayerToStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop();
			enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused_default();
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_react(false);
		}  else
		{
			if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_ON_raised)
			{ 
				exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop();
				enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse_default();
				VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused_react(const sc_boolean try_transition) {
	/* The reactions of state ChannelPaused. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_ON_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused();
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
			react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PlayRingtone();
		}  else
		{
			if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_OFF_raised)
			{ 
				exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused();
				react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOff();
			}  else
			{
				if (ifaceAmClientRequest.STOP_OUTBAND_RINGTONE_raised)
				{ 
					exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused();
					react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_DeallocateRoute();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAOffAfterPlayerResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse();
			react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOff();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse_react(const sc_boolean try_transition) {
	/* The reactions of state StopAfterPlayerResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse();
			react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_DeallocateRoute();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse_react(const sc_boolean try_transition) {
	/* The reactions of state SAOnAfterPlayerResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse();
			react_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PlayRingtone();
		}  else
		{
			if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_PAUSE_raised)
			{ 
				exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse();
				enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse_default();
				VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VehicleRingtoneAudioSm::VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse_react(const sc_boolean try_transition) {
	/* The reactions of state PauseAfterPlayerResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.OUTBAND_RINGTONE_SA_ON_raised)
		{ 
			exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse();
			enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse_default();
			VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_react(false);
		}  else
		{
			if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
			{ 
				exseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse();
				enseq_VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused_default();
				VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VehicleRingtoneAudioRegion_RingtonePlay_RingtonePlayRegion_AutoSAPause_react(try_transition);
	} 
	return did_transition;
}



