/* *
 * @file VoiceCallAudioSm.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Generated code from VoiceCallAudioSm.sct
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 * */

#ifndef MUTEUNMUTESM_H_
#define MUTEUNMUTESM_H_


#include <PmAudioManagerSmTypes.h>
#include <deque>
#include "sc_types.h"
#include "StatemachineInterface.h"
#include "scTracing.h"

/*! \file Header of the state machine 'MuteUnmuteSm'.
*/


#ifndef SCT_EVENTS_MUTEUNMUTESM_H
#define SCT_EVENTS_MUTEUNMUTESM_H
#ifndef SC_INVALID_EVENT_VALUE
#define SC_INVALID_EVENT_VALUE 0
#endif

namespace muteunmutesm_events
{
typedef enum  {
	muteunmutesm_invalid_event = SC_INVALID_EVENT_VALUE,
	SCI_AmClientRequest_MUTE_AUDIO,
	SCI_AmClientRequest_DEMUTE_AUDIO,
	SCI_EcnrResponse_REQUEST_SUCCESS,
	SCI_EcnrResponse_REQUEST_FAILURE
} MuteUnmuteSmEventName;

class SctEvent
{
	public:
		SctEvent(MuteUnmuteSmEventName name) : name(name){}
		virtual ~SctEvent(){}
		const MuteUnmuteSmEventName name;
		
};
		
template <typename T>
class TypedSctEvent : public SctEvent
{
	public:
		TypedSctEvent(MuteUnmuteSmEventName name, T value) :
			SctEvent(name),
			value(value)
			{}
		virtual ~TypedSctEvent(){}
		const T value;
};

class SctEvent_SCI_AmClientRequest_MUTE_AUDIO : public SctEvent
{
	public:
		SctEvent_SCI_AmClientRequest_MUTE_AUDIO(MuteUnmuteSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AmClientRequest_DEMUTE_AUDIO : public SctEvent
{
	public:
		SctEvent_SCI_AmClientRequest_DEMUTE_AUDIO(MuteUnmuteSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_EcnrResponse_REQUEST_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_EcnrResponse_REQUEST_SUCCESS(MuteUnmuteSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_EcnrResponse_REQUEST_FAILURE : public SctEvent
{
	public:
		SctEvent_SCI_EcnrResponse_REQUEST_FAILURE(MuteUnmuteSmEventName name) : SctEvent(name){};
};

}
#endif /* SCT_EVENTS_MUTEUNMUTESM_H */


/*! Define indices of states in the StateConfVector */
#define SCVI_MUTE_UNMUTE_REGION_MUTING 0
#define SCVI_MUTE_UNMUTE_REGION_DEMUTING 0
#define SCVI_MUTE_UNMUTE_REGION_DEMUTED 0
#define SCVI_MUTE_UNMUTE_REGION_MUTED 0
#define SCVI_MUTE_UNMUTE_REGION_DEMUTEAFTERMUTED 0
#define SCVI_MUTE_UNMUTE_REGION_MUTEAFTERDEMUTED 0


class MuteUnmuteSm : public StatemachineInterface
{
	public:
		MuteUnmuteSm();
		
		~MuteUnmuteSm();
		
		/*! Enumeration of all states */ 
		typedef enum
		{
			MuteUnmuteSm_last_state,
			mute_unmute_region_Muting,
			mute_unmute_region_DeMuting,
			mute_unmute_region_Demuted,
			mute_unmute_region_Muted,
			mute_unmute_region_DemuteAfterMuted,
			mute_unmute_region_MuteAfterDemuted
		} MuteUnmuteSmStates;
					
		static const sc_integer numStates = 6;
		
		//! Inner class for AmClientRequest interface scope.
		class SCI_AmClientRequest
		{
			public:
				SCI_AmClientRequest(MuteUnmuteSm * parent):
					MUTE_AUDIO_raised(false),
					DEMUTE_AUDIO_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'MUTE_AUDIO' that is defined in the interface scope 'AmClientRequest'. */
				void raise_mUTE_AUDIO();
				
				
				/*! Raises the in event 'DEMUTE_AUDIO' that is defined in the interface scope 'AmClientRequest'. */
				void raise_dEMUTE_AUDIO();
				
				
				
			private:
				friend class MuteUnmuteSm;
				/*! Raises the in event 'MUTE_AUDIO' that is defined in the interface scope 'AmClientRequest'. */
				void internal_raise_mUTE_AUDIO();
				sc_boolean MUTE_AUDIO_raised;
				/*! Raises the in event 'DEMUTE_AUDIO' that is defined in the interface scope 'AmClientRequest'. */
				void internal_raise_dEMUTE_AUDIO();
				sc_boolean DEMUTE_AUDIO_raised;
				MuteUnmuteSm * parent;
				void dispatch_event(muteunmutesm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AmClientRequest'. */
		SCI_AmClientRequest* getSCI_AmClientRequest();
		
		//! Inner class for EcnrRequest interface scope.
		class SCI_EcnrRequest
		{
			public:
				SCI_EcnrRequest(MuteUnmuteSm * parent):
					parent(parent)
				{}
				
				
				
				
			private:
				friend class MuteUnmuteSm;
				MuteUnmuteSm * parent;
				void dispatch_event(muteunmutesm_events::SctEvent * event);
				
				
		};
				//! Inner class for EcnrRequest interface scope operation callbacks.
				class SCI_EcnrRequest_OCB
				{
					public:
						virtual ~SCI_EcnrRequest_OCB() = 0;
						
						virtual AmResultCode sendEcnrMuteRequest() = 0;
						
						virtual AmResultCode sendEcnrDeMuteRequest() = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_EcnrRequest_OCB'. */
				void setSCI_EcnrRequest_OCB(SCI_EcnrRequest_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_EcnrRequest'. */
		SCI_EcnrRequest* getSCI_EcnrRequest();
		
		//! Inner class for EcnrResponse interface scope.
		class SCI_EcnrResponse
		{
			public:
				SCI_EcnrResponse(MuteUnmuteSm * parent):
					REQUEST_SUCCESS_raised(false),
					REQUEST_FAILURE_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'REQUEST_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void raise_rEQUEST_SUCCESS();
				
				
				/*! Raises the in event 'REQUEST_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void raise_rEQUEST_FAILURE();
				
				
				
			private:
				friend class MuteUnmuteSm;
				/*! Raises the in event 'REQUEST_SUCCESS' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_rEQUEST_SUCCESS();
				sc_boolean REQUEST_SUCCESS_raised;
				/*! Raises the in event 'REQUEST_FAILURE' that is defined in the interface scope 'EcnrResponse'. */
				void internal_raise_rEQUEST_FAILURE();
				sc_boolean REQUEST_FAILURE_raised;
				MuteUnmuteSm * parent;
				void dispatch_event(muteunmutesm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_EcnrResponse'. */
		SCI_EcnrResponse* getSCI_EcnrResponse();
		
		//! Inner class for SmHandler interface scope.
		class SCI_SmHandler
		{
			public:
				SCI_SmHandler(MuteUnmuteSm * parent):
					parent(parent)
				{}
				
				
				
			private:
				friend class MuteUnmuteSm;
				MuteUnmuteSm * parent;
				void dispatch_event(muteunmutesm_events::SctEvent * event);
				
				
		};
				//! Inner class for SmHandler interface scope operation callbacks.
				class SCI_SmHandler_OCB
				{
					public:
						virtual ~SCI_SmHandler_OCB() = 0;
						
						virtual void updateStatus(AmResultMessage msg) = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_SmHandler_OCB'. */
				void setSCI_SmHandler_OCB(SCI_SmHandler_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_SmHandler'. */
		SCI_SmHandler* getSCI_SmHandler();
		
		
		/*
		 * Functions inherited from StatemachineInterface
		 */
		virtual void init();
		
		virtual void enter();
		
		virtual void exit();
		
		virtual void runCycle();
		
		/*!
		* Checks if the state machine is active (until 2.4.1 this method was used for states).
		* A state machine is active if it has been entered. It is inactive if it has not been entered at all or if it has been exited.
		*/
		virtual sc_boolean isActive() const;
		
		
		/*!
		* Checks if all active states are final. 
		* If there are no active states then the state machine is considered being inactive. In this case this method returns false.
		*/
		virtual sc_boolean isFinal() const;
		
		void setTraceObserver(ysc::TraceObserver<MuteUnmuteSmStates>* tracingcallback);
		
		ysc::TraceObserver<MuteUnmuteSmStates>* getTraceObserver();
		
		/*! Checks if the specified state is active (until 2.4.1 the used method for states was calles isActive()). */
		sc_boolean isStateActive(MuteUnmuteSmStates state) const;
		
		
		
	protected:
		
		
	private:
		MuteUnmuteSm(const MuteUnmuteSm &rhs);
		MuteUnmuteSm& operator=(const MuteUnmuteSm&);
		
		
		//! the maximum number of orthogonal states defines the dimension of the state configuration vector.
		static const sc_ushort maxOrthogonalStates = 1;
		
		
		ysc::TraceObserver<MuteUnmuteSmStates>* ifaceTraceObserver;
		
		MuteUnmuteSmStates stateConfVector[maxOrthogonalStates];
		
		sc_ushort stateConfVectorPosition;
		
		SCI_AmClientRequest ifaceAmClientRequest;
		SCI_EcnrRequest ifaceEcnrRequest;
		SCI_EcnrRequest_OCB* ifaceEcnrRequest_OCB;
		SCI_EcnrResponse ifaceEcnrResponse;
		SCI_SmHandler ifaceSmHandler;
		SCI_SmHandler_OCB* ifaceSmHandler_OCB;
		
		// prototypes of all internal functions
		
		void exact_mute_unmute_region_Muted();
		void enseq_mute_unmute_region_Muting_default();
		void enseq_mute_unmute_region_DeMuting_default();
		void enseq_mute_unmute_region_Demuted_default();
		void enseq_mute_unmute_region_Muted_default();
		void enseq_mute_unmute_region_DemuteAfterMuted_default();
		void enseq_mute_unmute_region_MuteAfterDemuted_default();
		void enseq_mute_unmute_region_default();
		void exseq_mute_unmute_region_Muting();
		void exseq_mute_unmute_region_DeMuting();
		void exseq_mute_unmute_region_Demuted();
		void exseq_mute_unmute_region_Muted();
		void exseq_mute_unmute_region_DemuteAfterMuted();
		void exseq_mute_unmute_region_MuteAfterDemuted();
		void exseq_mute_unmute_region();
		void react_mute_unmute_region__entry_Default();
		sc_boolean react();
		sc_boolean mute_unmute_region_Muting_react(const sc_boolean try_transition);
		sc_boolean mute_unmute_region_DeMuting_react(const sc_boolean try_transition);
		sc_boolean mute_unmute_region_Demuted_react(const sc_boolean try_transition);
		sc_boolean mute_unmute_region_Muted_react(const sc_boolean try_transition);
		sc_boolean mute_unmute_region_DemuteAfterMuted_react(const sc_boolean try_transition);
		sc_boolean mute_unmute_region_MuteAfterDemuted_react(const sc_boolean try_transition);
		void clearInEvents();
		void clearOutEvents();
		
		
		muteunmutesm_events::SctEvent* getNextEvent();
		void dispatch_event(muteunmutesm_events::SctEvent * event);
		std::deque<muteunmutesm_events::SctEvent*> inEventQueue;
		sc_boolean isRunningCycle;
		
		
};


inline MuteUnmuteSm::SCI_EcnrRequest_OCB::~SCI_EcnrRequest_OCB() {}
inline MuteUnmuteSm::SCI_SmHandler_OCB::~SCI_SmHandler_OCB() {}


#endif /* MUTEUNMUTESM_H_ */
