/**
 * @file YakinduSmAudioSessionIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the YakinduSmAudioSessionIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file provides the state machine interfaces of audio session
 *
 * @ingroup PmAudioManager
 */

#ifndef YakinduSmAudioSessionIf_h
#define YakinduSmAudioSessionIf_h

#include "ISmAudioSessionIf.h"

namespace pmaudiomanager
{
   //class forward declarations
   class AudioSessionHandler;

   class YakinduSmAudioSessionIf final : public ISmAudioSessionIf
   {
   public:
      /**
       * Constructor of YakinduSmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      YakinduSmAudioSessionIf();

      /**
       * Destructor of YakinduSmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      ~YakinduSmAudioSessionIf();

      /**
       * Member function overridden from ISmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void prepareAudioRouteRequest(IN std::shared_ptr<AmIfMessage_PrepareAudioRouteRequest> amIfMessage) override;

      /**
       * Member function overridden from ISmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void playAudioFileRequest(IN std::shared_ptr<AmIfMessage_PlayAudioFileRequest> amIfMessage) override;

      /**
       * Member function overridden from ISmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void playHfAudioRequest(IN std::shared_ptr<AmIfMessage_PlayHfAudioRequest> amIfMessage) override;

      /**
       * Member function overridden from ISmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void stopAudioRequest(IN std::shared_ptr<AmIfMessage_StopAudioRequest> amIfMessage) override;

      /**
       * Member function overridden from ISmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void pauseAudioRequest(IN std::shared_ptr<AmIfMessage_PauseAudioRequest> amIfMessage) override;

      /**
       * Member function overridden from ISmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void setMicMuteStateRequest(IN std::shared_ptr<AmIfMessage_SetMicMuteStateRequest> amIfMessage) override;

      /**
       * Member function overridden from ISmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void ecnrInitializeResult(IN std::shared_ptr<AmIfMessage_EcnrInitializeResult> amIfMessage) override;

      /**
       * Member function overridden from ISmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void ecnrDestroyResult(IN std::shared_ptr<AmIfMessage_EcnrDestroyResult> amIfMessage) override;

      /**
       * Member function overridden from ISmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void ecnrSetConfigurationResult(IN std::shared_ptr<AmIfMessage_EcnrSetConfigurationResult> amIfMessage) override;

      /**
       * Member function overridden from ISmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void ecnrSetSendMuteSwitchResult(IN std::shared_ptr<AmIfMessage_EcnrSetSendMuteSwitchResult> amIfMessage) override;

      /**
       * Member function overridden from ISmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void ecnrStartAudioResult(IN std::shared_ptr<AmIfMessage_EcnrStartAudioResult> amIfMessage) override;

      /**
       * Member function overridden from ISmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void ecnrStopAudioResult(IN std::shared_ptr<AmIfMessage_EcnrStopAudioResult> amIfMessage) override;

      /**
       * Member function overridden from ISmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void ecnrGetVersionResult(IN std::shared_ptr<AmIfMessage_EcnrGetVersionResult> amIfMessage) override;

      /**
       * Member function overridden from ISmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void requestAudioRouteResult(IN std::shared_ptr<AmIfMessage_RequestAudioRouteResult> amIfMessage) override;

      /**
       * Member function overridden from ISmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void releaseAudioRouteResult(IN std::shared_ptr<AmIfMessage_ReleaseAudioRouteResult> amIfMessage) override;

      /**
       * Member function overridden from ISmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void sourceActivityResult(IN std::shared_ptr<AmIfMessage_SourceActivityResult> amIfMessage) override;

      /**
       * Member function overridden from ISmAudioSessionIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void playbackStatus(IN std::shared_ptr<AmIfMessage_PlaybackStatus> amIfMessage) override;

      /**
       * This method is used to remove SessionHandler from Map for the given SessionId and
       * updates the SessionRemoved NotificationEvent
       *
       * @param[in] amSessionId - am session id
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void removeSessionHandlerFromMap(IN const AmSessionId amSessionId);

   private:

      /**
       * This method is used to clear the SessionId and SessionHandler Mapping
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void clearSessionIdToSessionHandlerMap();

      ::std::map<AmSessionId, AudioSessionHandler*> _sessionIdToSessionHandlerMap; //map between session id and audio session handler
   };
}

#endif //YakinduSmAudioSessionIf_h
