/**
 * @file PmAudioManagerSmTypes.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file used to switch between target build and state chart simulation
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 */

#ifndef PmAudioManagerSmTypes_h
#define PmAudioManagerSmTypes_h

#ifndef DONT_INCLUDE_TARGET_BUILD_PATH

#include "PmAudioManagerTypesInternal.h"
#include "ArlTypes.h"
#include "AudioPlayerTypes.h"
using namespace pmaudiomanager;

#else

#include <string>

#define  PLAY_COUNT_DEFAULT  0xFF

typedef ::std::string AmResultMessage;

typedef ::std::string FilePath;

typedef ::std::string AudioSink;

typedef ::std::string AudioSource;

typedef unsigned char PlayCount;

typedef enum
{
   AM_RESULT_OK = 0UL,
   AM_RESULT_ERR_GENERAL,
   AM_RESULT_ERR_NOT_IMPLEMENTED,
   AM_RESULT_ERR_INVALID_PARAMETER
} AmResultCode;

typedef enum
{
   SRC_ACTIVITY_OFF   = 0UL,
   SRC_ACTIVITY_ON    = 1UL,
   SRC_ACTIVITY_PAUSE = 2UL
}SrcActivity;

typedef enum
{
   AM_UNKNOWN = 0UL,     /**< Unknown source, default value*/
   AM_VEHICLERINGTONE,   /**< For playing the vehicle ringtone or the playable audio file */
   AM_PHONEAUDIO,        /**< For phone call audio streaming */
   AM_WAITINGMODE,       /**< For waiting mode tone to be streamed for the far end device */
   AM_VOICERECOGNITION,  /**< Stream the voice recognition audio */
   AM_ALERTTONE          /**< For the Alert tone to be played */
}AudioChannel;

typedef enum{
   UNKNOWN = 0UL,
   NARROWBAND,
   WIDEBAND
}SamplingType;

typedef enum{
   NOT_ALLOCATED = 0UL,
   PREPARING,
   READY_TO_STREAM,
   STREAMING,
   STREAMING_PAUSED,
   DEALLOCATING,
   FAILURE = 255UL
}RouteState;

#endif

#endif // PmAudioManagerSmTypes_h
