/**
 * @file AmResult.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the AmResult class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef AmResult_h
#define AmResult_h

#include "PmAudioManagerTypesInternal.h"

namespace pmaudiomanager
{
   class AmResult
   {
   public:
      /**
       * Constructor of AmResult class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      AmResult();

      /**
       * Parameterized Constructor of AmResult class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      AmResult(const AmResultCode pmResultCode, const AmResultMessage pmResultMessage);

      /**
       * Copy Constructor of AmResult class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      AmResult(const AmResult& other);

      /**
       * Destructor of AmResult class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~AmResult();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(AmResult& first, AmResult& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      AmResult& operator=(AmResult other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const AmResult& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const AmResult& rhs) const;

      AmResultCode _amResultCode;       /**< am result code */
      AmResultMessage _amResultMessage; /**< am result message */
   };

} // namespace pmaudiomanager

#endif // AmResult_h
