/**
 * @file GeniviAmTypes.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the internal type definitions of Gen IVI Audio Manager
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 */

#ifndef GeniviAmTypes_h
#define GeniviAmTypes_h

#include <map>

namespace pmaudiomanager
{
/*
 * RULE 1: use a class instead of declaring a struct (avoiding problems with copy actions),
 *         implement copy constructor, assignment operator and equality/inequality operator
 *
 * keep following order:
 * - class forward declarations
 * - defines (if really necessary)
 * - typedefs
 * - enums
 * - structs => classes
 */

/**
 * Type definition for common result of a request.
 */
enum GeniviAMResult
{
   GeniviAmReqSuccess = 0, /**< OK, must be the first code */
   GeniviAmReqFailed,      /**< general error */

   GeniviAmReqLast         /**< end marker, must be the last one */	
};

/**
 * Error codes in GeniviAM implementation.
 */
enum AmErrorCode
{
   GeniviAmOk = 0, /**< OK, must be the first code */
   GeniviAmError,  /**< general error */

   GeniviAmLast    /**< end marker, must be the last one */
};

/**
 * GeniviAm response
 */
typedef enum
{
   GetListMainSinkSoundPropertiesFailure = 0,
   GetListMainSinkSoundPropertiesSuccess,
   SetMainSinkSoundPropertyFailure,
   SetMainSinkSoundPropertySuccess
}GeniviAmResponse;

}   //pmaudiomanager

#endif  //GeniviAmTypes_h
