/**
 * @file EcnrCallBackIf.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for Ecnr Service DBUS callback
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 */

#include "EcnrCallBackIf.h"
#include "EcnrWrapper.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_AUDIO_MANAGER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EcnrCallBackIf.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_AUDIO_MANAGER
#endif
#endif

using namespace ::org::bosch::ecnr::service;
using namespace ::asf::core;

namespace pmaudiomanager {

EcnrCallBackIf::EcnrCallBackIf()
{
   ETG_TRACE_USR4(("EcnrCallBackIf(): Constructor"));

   _ecnrWrapper = nullptr;
}

EcnrCallBackIf::EcnrCallBackIf(EcnrWrapper* ecnrWrapper)
{
   ETG_TRACE_USR4(("EcnrCallBackIf(): Parameterized Constructor"));

   _ecnrWrapper = ecnrWrapper;
}

EcnrCallBackIf::~EcnrCallBackIf()
{
   ETG_TRACE_USR4(("EcnrCallBackIf(): Destructor"));

   _ecnrWrapper = nullptr;
}

void EcnrCallBackIf::onServiceProxyAvailable(const ServiceState previousState, const ServiceState currentState,
      const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);
}

void EcnrCallBackIf::onServiceProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
      const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);
}

void EcnrCallBackIf::onEcnrDestroyError(const ::boost::shared_ptr< ServiceProxy >& proxy,
      const ::boost::shared_ptr< EcnrDestroyError >& error)
{
   (void)(proxy);

   if(nullptr != _ecnrWrapper)
   {
      _ecnrWrapper->destroyResultCB(ECNR_REQ_FAILED, error->getAct());
   }
}

void EcnrCallBackIf::onEcnrDestroyResponse(const ::boost::shared_ptr< ServiceProxy >& proxy,
      const ::boost::shared_ptr< EcnrDestroyResponse >& response)
{
   (void)(proxy);

   if(nullptr != _ecnrWrapper)
   {
      _ecnrWrapper->destroyResultCB(ECNR_REQ_SUCCESS, response->getAct());
   }
}

void EcnrCallBackIf::onEcnrInitializeError(const ::boost::shared_ptr< ServiceProxy >& proxy,
      const ::boost::shared_ptr< EcnrInitializeError >& error)
{
   (void)(proxy);

   if(nullptr != _ecnrWrapper)
   {
      _ecnrWrapper->initializeResultCB(ECNR_REQ_FAILED, error->getAct());
   }
}

void EcnrCallBackIf::onEcnrInitializeResponse(const ::boost::shared_ptr< ServiceProxy >& proxy,
      const ::boost::shared_ptr< EcnrInitializeResponse >& response)
{
   (void)(proxy);

   if(nullptr != _ecnrWrapper)
   {
      _ecnrWrapper->initializeResultCB(ECNR_REQ_SUCCESS, response->getAct());
   }
}

void EcnrCallBackIf::onEcnrSetConfigurationError(const ::boost::shared_ptr< ServiceProxy >& proxy,
      const ::boost::shared_ptr< EcnrSetConfigurationError >& error)
{
   (void)(proxy);

   if(nullptr != _ecnrWrapper)
   {
      _ecnrWrapper->setConfigurationResultCB(ECNR_REQ_FAILED, error->getAct());
   }
}

void EcnrCallBackIf::onEcnrSetConfigurationResponse(const ::boost::shared_ptr< ServiceProxy >& proxy,
      const ::boost::shared_ptr< EcnrSetConfigurationResponse >& response)
{
   (void)(proxy);

   if(nullptr != _ecnrWrapper)
   {
      _ecnrWrapper->setConfigurationResultCB(ECNR_REQ_SUCCESS, response->getAct());
   }
}

void EcnrCallBackIf::onEcnrSetSendMuteSwitchError(const ::boost::shared_ptr< ServiceProxy >& proxy,
      const ::boost::shared_ptr< EcnrSetSendMuteSwitchError >& error)
{
   (void)(proxy);

   if(nullptr != _ecnrWrapper)
   {
      _ecnrWrapper->setSendMuteSwitchResultCB(ECNR_REQ_FAILED, error->getAct());
   }
}

void EcnrCallBackIf::onEcnrSetSendMuteSwitchResponse(const ::boost::shared_ptr< ServiceProxy >& proxy,
      const ::boost::shared_ptr< EcnrSetSendMuteSwitchResponse >& response)
{
   (void)(proxy);

   if(nullptr != _ecnrWrapper)
   {
      _ecnrWrapper->setSendMuteSwitchResultCB(ECNR_REQ_SUCCESS, response->getAct());
   }
}

void EcnrCallBackIf::onEcnrStartAudioError(const ::boost::shared_ptr< ServiceProxy >& proxy,
      const ::boost::shared_ptr< EcnrStartAudioError >& error)
{
   (void)(proxy);

   if(nullptr != _ecnrWrapper)
   {
      _ecnrWrapper->startAudioResultCB(ECNR_REQ_FAILED, error->getAct());
   }
}

void EcnrCallBackIf::onEcnrStartAudioResponse(const ::boost::shared_ptr< ServiceProxy >& proxy,
      const ::boost::shared_ptr< EcnrStartAudioResponse >& response)
{
   (void)(proxy);

   if(nullptr != _ecnrWrapper)
   {
      _ecnrWrapper->startAudioResultCB(ECNR_REQ_SUCCESS, response->getAct());
   }
}

void EcnrCallBackIf::onEcnrStopAudioError(const ::boost::shared_ptr< ServiceProxy >& proxy,
      const ::boost::shared_ptr< EcnrStopAudioError >& error)
{
   (void)(proxy);

   if(nullptr != _ecnrWrapper)
   {
      _ecnrWrapper->stopAudioResultCB(ECNR_REQ_FAILED, error->getAct());
   }
}

void EcnrCallBackIf::onEcnrStopAudioResponse(const ::boost::shared_ptr< ServiceProxy >& proxy,
      const ::boost::shared_ptr< EcnrStopAudioResponse >& response)
{
   (void)(proxy);

   if(nullptr != _ecnrWrapper)
   {
      _ecnrWrapper->stopAudioResultCB(ECNR_REQ_SUCCESS, response->getAct());
   }
}

void EcnrCallBackIf::onEcnrGetVersionError(const ::boost::shared_ptr< ServiceProxy >& proxy,
      const ::boost::shared_ptr< EcnrGetVersionError >& error)
{
   (void)(proxy);

   if(nullptr != _ecnrWrapper)
   {
      ::std::vector< uint32 > emptyVersion;
      ::std::string emptyVersionString("");
      ::std::string emptyVersionComment("");

      _ecnrWrapper->getVersionResultCB(ECNR_REQ_FAILED, emptyVersion, emptyVersionString,
            emptyVersionComment, error->getAct());
   }
}

void EcnrCallBackIf::onEcnrGetVersionResponse(const ::boost::shared_ptr< ServiceProxy >& proxy,
      const ::boost::shared_ptr< EcnrGetVersionResponse >& response)
{
   (void)(proxy);

   if(nullptr != _ecnrWrapper)
   {
      _ecnrWrapper->getVersionResultCB(ECNR_REQ_SUCCESS, response->getVersion(), response->getVersionString(),
            response->getVersionComment(), response->getAct());
   }
}

} //pmaudiomanager
