/**
 * @file IEcnrCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for Ecnr Service DBUS callback
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 */

#ifndef IEcnrCallBackIf_h
#define IEcnrCallBackIf_h

#include "org/bosch/ecnr/serviceProxy.h"
#include <string>

using namespace ::asf::core;

namespace pmaudiomanager {

/**
 * Ecnr CallBack interface class
 */
class IEcnrCallBackIf :
      public ::org::bosch::ecnr::service::EcnrDestroyCallbackIF,
      public ::org::bosch::ecnr::service::EcnrInitializeCallbackIF,
      public ::org::bosch::ecnr::service::EcnrSetConfigurationCallbackIF,
      public ::org::bosch::ecnr::service::EcnrSetSendMuteSwitchCallbackIF,
      public ::org::bosch::ecnr::service::EcnrStartAudioCallbackIF,
      public ::org::bosch::ecnr::service::EcnrStopAudioCallbackIF,
      public ::org::bosch::ecnr::service::EcnrGetVersionCallbackIF
{
public:
   /**
    * Destructor of IEcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~IEcnrCallBackIf() {}

   /**
    * This method is used to notify the proxy availability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onServiceProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) = 0;

   /**
    * This method is used to notify the proxy unavailability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onServiceProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) = 0;

protected:
   /**
    * Error callback method for Destroy request
    *
    * @param[in] proxy - reference of Ecnr proxy
    * @param[in] error - reference to EcnrDestroyError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrDestroyError(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrDestroyError >& error) override = 0;

   /**
    * Callback method for Destroy request
    *
    * @param[in] proxy - reference of Ecnr proxy
    * @param[in] response - reference to EcnrDestroyResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrDestroyResponse(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrDestroyResponse >& response) override = 0;

   /**
    * Error callback method for Initialize request
    *
    * @param[in] proxy - reference of Ecnr proxy
    * @param[in] error - reference to EcnrInitializeError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrInitializeError(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrInitializeError >& error) override = 0;

   /**
    * Callback method for Initialize request
    *
    * @param[in] proxy - reference of Ecnr proxy
    * @param[in] response - reference to EcnrInitializeResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrInitializeResponse(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrInitializeResponse >& response) override = 0;

   /**
    * Error callback method for SetConfiguration request
    *
    * @param[in] proxy - reference of Ecnr proxy
    * @param[in] error - reference to EcnrSetConfigurationError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrSetConfigurationError(
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrSetConfigurationError >& error) override = 0;

   /**
    * Callback method for SetConfiguration request
    *
    * @param[in] proxy - reference of Ecnr proxy
    * @param[in] response - reference to EcnrSetConfigurationResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrSetConfigurationResponse(
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrSetConfigurationResponse >& response) override = 0;

   /**
    * Error callback method for SetSendMuteSwitch request
    *
    * @param[in] proxy - reference of Ecnr proxy
    * @param[in] error - reference to EcnrSetSendMuteSwitchError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrSetSendMuteSwitchError(
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrSetSendMuteSwitchError >& error) override = 0;

   /**
    * Callback method for SetSendMuteSwitch request
    *
    * @param[in] proxy - reference of Ecnr proxy
    * @param[in] response - reference to EcnrSetSendMuteSwitchResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrSetSendMuteSwitchResponse(
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrSetSendMuteSwitchResponse >& response) override = 0;

   /**
    * Error callback method for StartAudio request
    *
    * @param[in] proxy - reference of Ecnr proxy
    * @param[in] error - reference to EcnrStartAudioError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrStartAudioError(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrStartAudioError >& error) override = 0;

   /**
    * Callback method for StartAudio request
    *
    * @param[in] proxy - reference of Ecnr proxy
    * @param[in] response - reference to EcnrStartAudioResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrStartAudioResponse(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrStartAudioResponse >& response) override = 0;

   /**
    * Error callback method for StopAudio request
    *
    * @param[in] proxy - reference of Ecnr proxy
    * @param[in] error - reference to EcnrStopAudioError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrStopAudioError(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrStopAudioError >& error) override = 0;

   /**
    * Callback method for StopAudio request
    *
    * @param[in] proxy - reference of Ecnr proxy
    * @param[in] response - reference to EcnrStopAudioResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrStopAudioResponse(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrStopAudioResponse >& response) override = 0;

   /**
    * Error callback method for GetVersion request
    *
    * @param[in] proxy - reference of Ecnr proxy
    * @param[in] error - reference to EcnrGetVersionError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrGetVersionError(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrGetVersionError >& error) override = 0;

   /**
    * Callback method for GetVersion request
    *
    * @param[in] proxy - reference of Ecnr proxy
    * @param[in] response - reference to EcnrGetVersionResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrGetVersionResponse(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrGetVersionResponse >& response) override = 0;
};

} //pmaudiomanager

#endif // IEcnrCallBackIf_h
