/**
 * @file EcnrTypes.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the internal type definitions of Ecnr
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 */

#ifndef EcnrTypes_h
#define EcnrTypes_h

#include <vector>
#include <string>

namespace pmaudiomanager
{
/*
 * RULE 1: use a class instead of declaring a struct (avoiding problems with copy actions),
 *         implement copy constructor, assignment operator and equality/inequality operator
 *
 * keep following order:
 * - class forward declarations
 * - defines (if really necessary)
 * - typedefs
 * - enums
 * - structs => classes
 */

/**
 * Ecnr AppId Phone
 */
#define ECNR_APPID_PHONE      1

/**
 * Type definition for Ecnr Version.
 */
typedef std::string Version;

/**
 * Type definition for Ecnr Version Comment.
 */
typedef std::string VersionComment;

/**
 * Type definition for Ecnr App Id.
 */
typedef unsigned char EcnrAppId;

/**
 * Type definition for Ecnr Send Mute Switch.
 */
typedef unsigned char EcnrSendMuteSwitch;

/**
 * Type definition for Ecnr Configuration Id.
 */
typedef unsigned int  EcnrConfigurationId;

/**
 * Type definition for Ecnr Version Number.
 */
typedef ::std::vector< unsigned int > VersionNumber;

/**
 * Type definition for common result of a request.
 */
enum EcnrRequestResult
{
   ECNR_REQ_SUCCESS = 0, /**< OK, must be the first code */
   ECNR_REQ_FAILED,      /**< general error */

   ECNR_REQ_LAST         /**< end marker, must be the last one */
};

/**
 * Error codes in Ecnr implementation.
 */
enum EcnrErrorCode
{
   ECNR_OK = 0, /**< OK, must be the first code */
   ECNR_ERROR,  /**< general error */

   ECNR_LAST    /**< end marker, must be the last one */
};

/**
 * Ecnr response
 */
typedef enum
{
   ECNR_INIT_FAILURE = 0,
   ECNR_INIT_SUCCESS,
   ECNR_DESTROY_FAILURE,
   ECNR_DESTROY_SUCCESS,
   ECNR_SET_CONFIGURATION_FAILURE,
   ECNR_SET_CONFIGURATION_SUCCESS,
   ECNR_START_AUDIO_FAILURE,
   ECNR_START_AUDIO_SUCCESS,
   ECNR_STOP_AUDIO_FAILURE,
   ECNR_STOP_AUDIO_SUCCESS,
   ECNR_MUTE_DEMUTE_SUCCESS,
   ECNR_MUTE_DEMUTE_FAILURE
}EcnrReponse;

} //pmaudiomanager

#endif // EcnrTypes_h
