/**
 * @file EcnrRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for Ecnr DBUS Proxy
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 */

#ifndef EcnrRequestIf_h
#define EcnrRequestIf_h

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "IEcnrRequestIf.h"
#include "org/bosch/ecnr/serviceProxy.h"

using namespace ::asf::core;

namespace pmaudiomanager {

// class forward declarations
class IEcnrRequestIf;
class IEcnrCallBackIf;

/**
 * Ecnr Request class
 */
class EcnrRequestIf final :
      public ServiceAvailableIF,
      public ::ccdbusif::ICcDbusIfCreateProxy,
      public ::ccdbusif::ICcDbusIfDestroyProxy,
      public IEcnrRequestIf
{
public:
   /**
    * Constructor of EcnrRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EcnrRequestIf();

   /**
    * Destructor of EcnrRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EcnrRequestIf();

   /**
    * Member function Overridden from ICcDbusIfCreateProxy class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void createProxy(void) override;

   /**
    * Member function Overridden from ICcDbusIfDestroyProxy class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void destroyProxy(void) override;

   /**
    * Member function Overridden from IEcnrRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void setCallbackIf(IEcnrCallBackIf* callBackIf) override;

   /**
    * Member function Overridden from ServiceAvailableIF class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from ServiceAvailableIF class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from IEcnrRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual act_t sendEcnrInitializeRequest(uint8 ecnrAppId, uint32 ecnrConfigurationId) override;

   /**
    * Member function Overridden from IEcnrRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual act_t sendEcnrDestroyRequest(uint8 ecnrAppId) override;

   /**
    * Member function Overridden from IEcnrRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual act_t sendEcnrSetConfigurationRequest(uint8 ecnrAppId, uint32 ecnrConfigurationId) override;

   /**
    * Member function Overridden from IEcnrRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual act_t sendEcnrStartAudioRequest(uint8 ecnrAppId) override;

   /**
    * Member function Overridden from IEcnrRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual act_t sendEcnrStopAudioRequest(uint8 ecnrAppId) override;

   /**
    * Member function Overridden from IEcnrRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual act_t sendEcnrSetSendMuteSwitchRequest(uint8 ecnrAppId, uint8 ecnrSendMuteSwitch) override;

   /**
    * Member function Overridden from IEcnrRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual act_t sendEcnrGetVersionRequest(void) override;

private:
   ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy > _serviceProxy; /**< Ecnr proxy */
   IEcnrCallBackIf* _callBackIf; /**< pointer to Ecnr callback */
};

} //pmaudiomanager

#endif // EcnrRequestIf_h
