/**
 * @file EcnrCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for Ecnr Service DBUS callback
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 */

#ifndef EcnrCallBackIf_h
#define EcnrCallBackIf_h

#include "IEcnrCallBackIf.h"

namespace pmaudiomanager {

//class forward declarations
class EcnrWrapper;

/**
 * Ecnr CallBack class
 */
class EcnrCallBackIf : public IEcnrCallBackIf
{
public:
   /**
    * Parameterized Constructor of EcnrCallBackIf class
    *
    * @param[in] ecnrWrapper - pointer to EcnrWrapper
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EcnrCallBackIf(EcnrWrapper* ecnrWrapper);

   /**
    * Destructor of EcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EcnrCallBackIf();

   /**
    * Member function Overridden from EcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onServiceProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

   /**
    * Member function Overridden from EcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onServiceProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

protected:
   /**
    * Constructor of EcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EcnrCallBackIf();

   /**
    * Member function Overridden from EcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrDestroyError(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrDestroyError >& error) override;

   /**
    * Member function Overridden from EcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrDestroyResponse(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrDestroyResponse >& response) override;

   /**
    * Member function Overridden from EcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrInitializeError(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrInitializeError >& error) override;

   /**
    * Member function Overridden from EcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrInitializeResponse(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrInitializeResponse >& response) override;

   /**
    * Member function Overridden from EcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrSetConfigurationError(
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrSetConfigurationError >& error) override;

   /**
    * Member function Overridden from EcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrSetConfigurationResponse(
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrSetConfigurationResponse >& response) override;

   /**
    * Member function Overridden from EcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrSetSendMuteSwitchError(
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrSetSendMuteSwitchError >& error) override;

   /**
    * Member function Overridden from EcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrSetSendMuteSwitchResponse(
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrSetSendMuteSwitchResponse >& response) override;

   /**
    * Member function Overridden from EcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrStartAudioError(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrStartAudioError >& error) override;

   /**
    * Member function Overridden from EcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrStartAudioResponse(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrStartAudioResponse >& response) override;

   /**
    * Member function Overridden from EcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrStopAudioError(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrStopAudioError >& error) override;

   /**
    * Member function Overridden from EcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrStopAudioResponse(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrStopAudioResponse >& response) override;

   /**
    * Member function Overridden from EcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrGetVersionError(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrGetVersionError >& error) override;

   /**
    * Member function Overridden from EcnrCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEcnrGetVersionResponse(const ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::ecnr::service::EcnrGetVersionResponse >& response) override;

private:
   EcnrWrapper* _ecnrWrapper; /**< pointer to EcnrWrapper */
};

} //pmaudiomanager

#endif // EcnrCallBackIf_h
