/**
 * @file AudioPlayerTypes.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the internal type definitions of AudioPlayer
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 */

#ifndef AudioPlayerTypes_h
#define AudioPlayerTypes_h

#include <vector>
#include <string>

namespace pmaudiomanager
{
/*
 * RULE 1: use a class instead of declaring a struct (avoiding problems with copy actions),
 *         implement copy constructor, assignment operator and equality/inequality operator
 *
 * keep following order:
 * - class forward declarations
 * - defines (if really necessary)
 * - typedefs
 * - enums
 * - structs => classes
 */

typedef ::std::string AudioSink;

typedef ::std::string AudioSource;

typedef ::std::string AudioPlayerErrorInfo;

/**
 * Audio Player playback status
 */
enum class PlayStatus
{
   NOT_PLAYING = 0UL,  /**< Default */
   PLAYING,            /**< Playing */
   STOPPED,            /**< Playing Stopped */
   PLAYBACK_ERROR,     /**< Playback Error */
   STOP_PLAYBACK_ERROR /**< Stop Playback Error */
};

} // namespace pmaudiomanager

#endif // AudioPlayerTypes_h
