/**
 * @file ArlTypes.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the internal type definitions of Arl
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 */

#ifndef ArlTypes_h
#define ArlTypes_h

#include <vector>
#include <string>

namespace pmaudiomanager
{
/**
 * RULE 1: use a class instead of declaring a struct (avoiding problems with copy actions),
 *         implement copy constructor, assignment operator and equality/inequality operator
 *
 * keep following order:
 * - class forward declarations
 * - defines (if really necessary)
 * - typedefs
 * - enums
 * - structs => classes
 */

#define SUB_SOURCE_DEFAULT        0

#define SUB_SOURCE_1              1

#define TIMER_REPEAT_COUNT        1

typedef unsigned short int SubSource;

typedef ::std::vector<::std::string> AudioDeviceList;

typedef enum
{
   MUTE_REASON_USR_ACT     = 0x1UL,  /**< User action */
   MUTE_REASON_TRACK_START = 0x2UL,  /**< Track start */
   MUTE_REASON_SRC_SEL     = 0x4UL,  /**< Source selection */
   MUTE_REASON_DIAG        = 0x8UL,  /**< Diagnosis */
   MUTE_REASON_OTHER       = 0x10UL, /**< other Mute Reason */
}MuteReason;

typedef enum
{
   SRC_NOT_AVAILABLE    = 0UL, /**<  No device is connected */
   SRC_PLAYABLE_UNKNOWN = 1UL, /**<  Device is connected, playable content unknown */
   SRC_PLAYABLE         = 2UL, /**<  Device connected playable content found */
   SRC_NOT_PLAYABLE     = 3UL, /**<  Device connected, no playable content found or defect */
}SrcAvailability;

typedef enum
{
   AVAILABILITY_REASON_NEWMEDIA           = 0UL, /**< Device is newly inserted */
   AVAILABILITY_REASON_SAMEMEDIA          = 1UL, /**< Device was already there before */
   AVAILABILITY_REASON_NOMEDIA            = 2UL, /**< Media removed */
   AVAILABILITY_REASON_TEMPERATURE        = 3UL, /**< Over/Under temperature */
   AVAILABILITY_REASON_VOLTAGE            = 4UL, /**< Over/Under voltage */
   AVAILABILITY_REASON_ERROR              = 5UL, /**< Device Access/Read Error */
   AVAILABILITY_REASON_NO_CONTENT         = 6UL, /**< Device has no content */
   AVAILABILITY_REASON_OVERCURRENT        = 7UL, /**< Device has over current */
   AVAILABILITY_REASON_INTERNALDISCONNECT = 8UL  /**< Device has internal disconnect */
}AvailabilityReason;

typedef enum
{
   SRC_ACTIVITY_OFF   = 0UL,
   SRC_ACTIVITY_ON    = 1UL,
   SRC_ACTIVITY_PAUSE = 2UL
}SrcActivity;

typedef enum
{
   CHANNEL_GRANTED     = 0UL,
   CHANNEL_DENIED      = 1UL,
   CHANNEL_DEALLOCATED = 2UL
}AudioChannelStatus;

} //pmaudiomanager

#endif // ArlTypes_h
