/**
 * @file AmIfMessageCreator.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file creates instance of AmIfMessages
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 */

#ifndef AmIfMessageCreator_h
#define AmIfMessageCreator_h

#include "AmIfMessageRequest.h"
#include "AmIfMessageResult.h"
#include "LoopbackData.h"

namespace pmaudiomanager
{
   //Request messages
   inline std::shared_ptr<AmIfMessage_PrepareAudioRouteRequest> getNewAmIfMessage_PrepareAudioRouteRequest(
         IN const AmSessionId amSessionId, IN const AudioChannel audioChannelId)
   {
      return std::make_shared<AmIfMessage_PrepareAudioRouteRequest>(amSessionId, audioChannelId);
   }

   inline std::shared_ptr<AmIfMessage_PlayAudioFileRequest> getNewAmIfMessage_PlayAudioFileRequest(
         IN const AmSessionId amSessionId, IN const FilePath& filePath, IN const PlayCount playCount,
         IN const ToneType toneType)
   {
      return std::make_shared<AmIfMessage_PlayAudioFileRequest>(amSessionId, filePath, playCount, toneType);
   }

   inline std::shared_ptr<AmIfMessage_PlayHfAudioRequest> getNewAmIfMessage_PlayHfAudioRequest(
         IN const AmSessionId amSessionId, IN const SamplingType samplingType)
   {
      return std::make_shared<AmIfMessage_PlayHfAudioRequest>(amSessionId, samplingType);
   }

   inline std::shared_ptr<AmIfMessage_StopAudioRequest> getNewAmIfMessage_StopAudioRequest(
         IN const AmSessionId amSessionId)
   {
      return std::make_shared<AmIfMessage_StopAudioRequest>(amSessionId);
   }

   inline std::shared_ptr<AmIfMessage_PauseAudioRequest> getNewAmIfMessage_PauseAudioRequest(
         IN const AmSessionId amSessionId)
   {
      return std::make_shared<AmIfMessage_PauseAudioRequest>(amSessionId);
   }

   inline std::shared_ptr<AmIfMessage_SetMicMuteStateRequest> getNewAmIfMessage_SetMicMuteStateRequest(
         IN const MuteState muteState)
   {
      return std::make_shared<AmIfMessage_SetMicMuteStateRequest>(muteState);
   }


   inline std::shared_ptr<AmIfMessage_GetAudioSinkVolumeRequest> getNewAmIfMessage_GetAudioSinkVolumeRequest(
         IN const AmSessionId amSessionId, IN const GeniviAMSinkId sinkId)
   {
      return std::make_shared<AmIfMessage_GetAudioSinkVolumeRequest>(amSessionId, sinkId);
   }

   inline std::shared_ptr<AmIfMessage_SetAudioSinkVolumeRequest> getNewAmIfMessage_SetAudioSinkVolumeRequest(
         IN const AmSessionId amSessionId, IN const GeniviAMSinkId sinkId, const IN AmPropertyType2VolumeMap propertyValue)
   {
      return std::make_shared<AmIfMessage_SetAudioSinkVolumeRequest>(amSessionId, sinkId, propertyValue);
   }

   //Result messages
   inline std::shared_ptr<AmIfMessage_EcnrInitializeResult> getNewAmIfMessage_EcnrInitializeResult(
         IN const AmSessionId amSessionId, IN const AmResult& amResult)
   {
      return std::make_shared<AmIfMessage_EcnrInitializeResult>(amSessionId, amResult);
   }

   inline std::shared_ptr<AmIfMessage_EcnrDestroyResult> getNewAmIfMessage_EcnrDestroyResult(
         IN const AmSessionId amSessionId, IN const AmResult& amResult)
   {
      return std::make_shared<AmIfMessage_EcnrDestroyResult>(amSessionId, amResult);
   }

   inline std::shared_ptr<AmIfMessage_EcnrSetConfigurationResult> getNewAmIfMessage_EcnrSetConfigurationResult(
         IN const AmSessionId amSessionId, IN const AmResult& amResult)
   {
      return std::make_shared<AmIfMessage_EcnrSetConfigurationResult>(amSessionId, amResult);
   }

   inline std::shared_ptr<AmIfMessage_EcnrSetSendMuteSwitchResult> getNewAmIfMessage_EcnrSetSendMuteSwitchResult(
         IN const AmSessionId amSessionId, IN const AmResult& amResult)
   {
      return std::make_shared<AmIfMessage_EcnrSetSendMuteSwitchResult>(amSessionId, amResult);
   }

   inline std::shared_ptr<AmIfMessage_EcnrStartAudioResult> getNewAmIfMessage_EcnrStartAudioResult(
         IN const AmSessionId amSessionId, IN const AmResult& amResult)
   {
      return std::make_shared<AmIfMessage_EcnrStartAudioResult>(amSessionId, amResult);
   }

   inline std::shared_ptr<AmIfMessage_EcnrStopAudioResult> getNewAmIfMessage_EcnrStopAudioResult(
         IN const AmSessionId amSessionId, IN const AmResult& amResult)
   {
      return std::make_shared<AmIfMessage_EcnrStopAudioResult>(amSessionId, amResult);
   }

   inline std::shared_ptr<AmIfMessage_EcnrGetVersionResult> getNewAmIfMessage_EcnrGetVersionResult(
         IN const AmSessionId amSessionId, IN const AmResult& amResult, IN const Version& version,
         IN const VersionComment& versionComment, IN const VersionNumber& versionNumber)
   {
      return std::make_shared<AmIfMessage_EcnrGetVersionResult>(amSessionId, amResult, version,
            versionComment, versionNumber);
   }

   inline std::shared_ptr<AmIfMessage_RequestAudioRouteResult> getNewAmIfMessage_RequestAudioRouteResult(
         IN const AmSessionId amSessionId, IN const AmResult& amResult, IN const AudioChannel audioChannel,
         IN const AudioDeviceList& audioSink, IN const AudioDeviceList& audioSource)
   {
      return std::make_shared<AmIfMessage_RequestAudioRouteResult>(amSessionId, amResult, audioChannel,
            audioSink, audioSource);
   }

   inline std::shared_ptr<AmIfMessage_ReleaseAudioRouteResult> getNewAmIfMessage_ReleaseAudioRouteResult(
         IN const AmSessionId amSessionId, IN const AmResult& amResult, IN const AudioChannel audioChannel)
   {
      return std::make_shared<AmIfMessage_ReleaseAudioRouteResult>(amSessionId, amResult, audioChannel);
   }

   inline std::shared_ptr<AmIfMessage_SourceActivityResult> getNewAmIfMessage_SourceActivityResult(
         IN const AmSessionId amSessionId, IN const AudioChannel audioChannel, IN const SubSource subSource,
         IN const SrcActivity srcActivity)
   {
      return std::make_shared<AmIfMessage_SourceActivityResult>(amSessionId, audioChannel, subSource, srcActivity);
   }

   inline std::shared_ptr<AmIfMessage_RequestMuteActionResult> getNewAmIfMessage_RequestMuteActionResult(
         IN const AmResult& amResult, IN const AudioChannel audioChannel, IN const MuteState muteState)
   {
      return std::make_shared<AmIfMessage_RequestMuteActionResult>(amResult, audioChannel, muteState);
   }

   inline std::shared_ptr<AmIfMessage_PlaybackStatus> getNewAmIfMessage_PlaybackStatus(
         IN const AmSessionId amSessionId, IN const AmResult& amResult, IN const PlayStatus playStatus,
         IN const ToneType toneType)
   {
      return std::make_shared<AmIfMessage_PlaybackStatus>(amSessionId, amResult, playStatus, toneType);
   }

   inline std::shared_ptr<AmIfMessage_GetListMainSinkSoundPropertiesResult> getNewAmIfMessage_GetListMainSinkSoundPropertiesResult(
         IN const AmSessionId amSessionId, IN const AmResult& amResult)
   {
      return std::make_shared<AmIfMessage_GetListMainSinkSoundPropertiesResult>(amSessionId, amResult);
   }

   inline std::shared_ptr<AmIfMessage_SetMainSinkSoundPropertyResult> getNewAmIfMessage_SetMainSinkSoundPropertyResult(
         IN const AmSessionId amSessionId, IN const AmResult& amResult)
   {
      return std::make_shared<AmIfMessage_SetMainSinkSoundPropertyResult>(amSessionId, amResult);
   }

   inline std::shared_ptr<AmIfMessage_UpdateAudioSinkVolumeList> getNewAmIfMessage_UpdateAudioSinkVolumeList(
         IN const AmSessionId amSessionId, IN const AmResult& amResult, IN const GeniviAMSinkId& sinkId, IN const AmPropertyType2VolumeMap& propertymap)
   {
      return std::make_shared<AmIfMessage_UpdateAudioSinkVolumeList>(amSessionId, amResult, sinkId, propertymap);
   }

   inline AmLoopbackMessage_PlaybackStatus* getNewAmLoopbackMessage_PlaybackStatus(
         IN const com::bosch::pmcommon::PmSubComponentId subComponentId, IN const AmSessionId amSessionId,
         IN const AmResult& amResult, IN const PlayStatus playStatus, IN const ToneType toneType)
   {
      return new AmLoopbackMessage_PlaybackStatus(subComponentId, amSessionId, amResult, playStatus, toneType);
   }

}

#endif // AmIfMessageCreator_h
