/**
 * @file AmIfMessage.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the AmIfMessage class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 */

#ifndef AmIfMessage_h
#define AmIfMessage_h

#include "PmAudioManagerIfTypes.h"

namespace pmaudiomanager
{
   class AmIfMessage
   {
   public:

      /**
       * Parameterized Constructor of AmIfMessage class
       *
       * @param[in] messageId - Message ID of the AmIfMessage
       * @param[in] amSessionId - Am Session Id
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      explicit AmIfMessage(const AmIfMsgId messageId, const AmSessionId amSessionId);

      /**
       * Copy Constructor of AmIfMessage class
       *
       * @param[in] other - reference of AmIfMessage
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      AmIfMessage(const AmIfMessage& other);

      /**
       * Destructor of AmIfMessage class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      virtual ~AmIfMessage();

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      AmIfMessage& operator=(AmIfMessage other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const AmIfMessage& rhs) const;

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(AmIfMessage& first, AmIfMessage& second);

      /**
       * This method is used to get the Message ID of the message
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return AmIfMsgId - message ID
       */
      inline AmIfMsgId getMessageId(void) const
      {
         return _messageId;
      }

      /**
       * This method is used to set the Am Session Id
       *
       * @param[in] amSessionId - Am Session Id
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      inline void setAmSessionId(IN const AmSessionId amSessionId)
      {
         _amSessionId = amSessionId;
      }

      /**
       * This method is used to get the Am Session Id
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return AmSessionId
       */
      inline AmSessionId getAmSessionId(void) const
      {
         return _amSessionId;
      }

      /**
       * This method is used to print the values of parameters
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      virtual void traceMessage(void) const;

   protected:
      AmIfMsgId   _messageId;   /**< Message Id of the message */
      AmSessionId _amSessionId; /**< Am Session Id */
   };
}

#endif // AmIfMessage_h
