/* ETG definitions */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CONN_FRAMEWORK_SM
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/SMF.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CONN_FRAMEWORK_SM
#endif
#endif
#include "FunctionTracer.h"

/* others */
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <vector>
#include "SMF.h"
#include "etrace_mp.h"
#include "Dispatcher.h"
//#include "RequestResponseSM.h"
//weg #include "QueueFactory.h"

#include "Framework_Errorcodes.h"
#include "Utils.h"
#include "FwIEventMaster.h"
#include "FwAssert.h"
#include "FwStringUtils.h"

/*lint -save -e1401 */

using namespace std;
using namespace fw;

/* constants */
#define NOT_IMPLEMENTED_PRINT 1 /* = 1: print all not implemented user callback functions. */
#define MARSHAL_BASE 16

//TODO: find a better way to configure FAKE_THE_IPOD for module tests
int globalFakeTheIpod = 0;

/*lint -save -e826 -e1773 -e801 */

// own print implementation. must be replaced to print to trace
void SMF::DebugPrint(const char *format, ...)
{
	va_list vl;
	char cbuf[printStringSize];
	va_start(vl, format);
	vsnprintf(cbuf, sizeof(cbuf), format, vl);
	va_end(vl);

	ETG_TRACE_USR1(("%s",cbuf));
}

void SMF::NotImplemented(const char *name)
{
    ENTRY_INTERNAL
#if NOT_IMPLEMENTED_PRINT
	ETG_TRACE_COMP(("%s: not implemented", name));
#else
	(void)name;
#endif
}

/* the following is only for verification of a state machine. */
#define EXPECT_OFF 0

#if EXPECT_OFF
int SMF::ExpectReset(void) {return 0;}
int SMF::ExpectSetString(char *string) {(void)string; return 0;}
int SMF::Expect(char *inputString) {(void)inputString; return 0;}
int SMF::GetExpectErrorCount(void) { return 0;}
int SMF::PrintEnter(tState *state) {(void)state; return 0;}
int SMF::PrintExit(tState *state)  {(void)state; return 0;}
int SMF::PrintGuard(tTransition *trans) {(void)trans; return 0;}
int SMF::PrintAction(tTransition *trans) {(void)trans; return 0;}
int SMF::PrintConditionAction(tTransition *trans) {(void)trans; return 0;}

#else

#define EXPECT_PRINT_ERROR 1 /* = 1: prints an error if expect failes */
#define EXPECT_PRINT_PROGRESS 1 /* = 1: prints every expect check */

int SMF::ExpectReset(void)
{
	mExpectedString.clear();
	mCurrentExpectString = -1;
	return 0;
}

int SMF::ExpectSetString(const char *inputString)
{
	mExpectedString.push_back(inputString);
	return 0;
}

int SMF::Expect(const char *inputString)
{
	int i;

	/* if no expect strings are registered, do not check them */
	if (mExpectedString.size() == 0) return 1;

	for (i=0; i<(int)mExpectedString.size(); i++) {
		if (mExpectedString[i]) {
			if (!strncmp(inputString, mExpectedString[i], strlen(inputString))) {
				mExpectedString[i] = NULL;
				if (++mCurrentExpectString == i) {
#if EXPECT_PRINT_PROGRESS
					ETG_TRACE_COMP(("%s", inputString));
#endif
					return 1;
				} else {
					goto error;
				}
			}
		}
	}
error:
#if EXPECT_PRINT_ERROR
	DebugPrint("!!! ERROR: %s", inputString);
#endif
	mExpectErrorCount++;
	return 0;
}
int SMF::GetExpectErrorCount(void)
{
	return mExpectErrorCount;
}

int SMF::PrintEnter(tState *state)
{
	char cbuf[printStringSize];
	snprintf(cbuf, sizeof(cbuf), "State: %s: Enter", state->name);
	Expect(cbuf);
	return 0;
}

int SMF::PrintExit(tState *state)
{
	char cbuf[printStringSize];
	snprintf(cbuf, sizeof(cbuf), "State: %s: Exit", state->name);
	Expect(cbuf);
	return 0;
}

int SMF::PrintGuard(tTransition *trans)
{
	char cbuf[printStringSize];
	snprintf(cbuf, sizeof(cbuf), "Trans: %s: Guard", trans->name);
	Expect(cbuf);
	return 0;
}

int SMF::PrintAction(tTransition *trans)
{
	char cbuf[printStringSize];
	snprintf(cbuf, sizeof(cbuf), "Trans: %s: Action", trans->name);
	Expect(cbuf);
	return 1;
}

int SMF::PrintConditionAction(tTransition *trans)
{
	char cbuf[printStringSize];
	snprintf(cbuf, sizeof(cbuf), "Trans: %s: Condition", trans->name);
	Expect(cbuf);
	return 0;
}

#endif // #if EXPECT_ON == 1

LockForever SMF::_eventProcessingLock;

/* global state machine counter to numerate the state machine instances for better addressing */
static int stateMachineCounter = 0;

SMF::SMF() :
#ifdef SMF_ENABLE_EVENT_DEBUGGING
_eventDebugging(false),
#endif
_created(false)
{
    pointersGC = NULL;
    numberOfPointersGC = 0;
	mSDActionName = NULL;
	mSDTransactionName = NULL;
	memset(mSDEnterAction, 0, sizeof(mSDEnterAction));
	mRootState = NULL;
	mCurrentTrans = 0;
	mIsCreated = 0;
	mNULL_EVENT = CreateEvent("NULL_EVENT");
	mSMName = new char[strlen("SMNameNotSet")+1];
	strcpy((char *)mSMName, "SMNameNotSet");
	mSMFullName = new char[strlen("SMNameNotSet(0)")+1];
	strcpy((char *)mSMFullName, "SMNameNotSet(0)");
	snprintf((char *)mSMNamePostfix, sizeof(mSMNamePostfix), "%d", stateMachineCounter++);
	mCurrentExpectString = -1;
	mExpectErrorCount = 0;
	mCurrentContext = NULL;
	mMQExternal = NULL;
	mMQExternalName = NULL;
	mRetryCount = 3;
	mUSSleepTime = 500000L;
	mUserContext= NULL;

	// 2015-08-10: extension for lock and thread free SM
	_lockingEnabled = true; // default: each SM is executed in a separate thread
	_automaticProcessing = false;
	// 2016-10-31: extension for event master (run all SMs in 1 thread)
	_eventMaster = 0; // default: event master is not used (in order to use event master it must be registered)
	_eventPriority = 0; // default: 0 (highest priority)
	// 2017-03-01: extension for global lock approach
	_globalLock = 0; // will be set from outside if needed
	_eventProcessingActive = false;
	_eventProcessingPending = false;
	_eventLevelCounter = 0;
	// _eventProcessingLock
}

SMF::SMF(const SMF& ref) :
#ifdef SMF_ENABLE_EVENT_DEBUGGING
_eventDebugging(false),
#endif
_created(false)
{
   (void)(ref);

   // DO NOT USE!!!
   FW_NORMAL_ASSERT_ALWAYS();

   pointersGC = 0;
   numberOfPointersGC = 0;
   mSDActionName = 0;
   mSDTransactionName = 0;
   memset(mSDEnterAction, 0, sizeof(mSDEnterAction));
   mRootState = 0;
   mCurrentTrans = 0;
   mIsCreated = 0;
   mNULL_EVENT = CreateEvent("NULL_EVENT");
   mSMName = new char[strlen("SMNameNotSet")+1];
   strcpy((char *)mSMName, "SMNameNotSet");
   mSMFullName = new char[strlen("SMNameNotSet(0)")+1];
   strcpy((char *)mSMFullName, "SMNameNotSet(0)");
   snprintf((char *)mSMNamePostfix, sizeof(mSMNamePostfix), "%d", stateMachineCounter++);
   mCurrentExpectString = -1;
   mExpectErrorCount = 0;
   mCurrentContext = 0;
   mMQExternal = 0;
   mMQExternalName = 0;
   mRetryCount = 3;
   mUSSleepTime = 500000L;
   mUserContext= 0;

   _lockingEnabled = true; // default: each SM is executed in a separate thread
   _automaticProcessing = false;
   _eventMaster = 0; // default: event master is not used (in order to use event master it must be registered)
   _eventPriority = 0; // default: 0 (highest priority)
   _globalLock = 0; // will be set from outside if needed
   _eventProcessingActive = false;
   _eventProcessingPending = false;
   _eventLevelCounter = 0;
   // _eventProcessingLock
}

SMF& SMF::operator=(const SMF& ref)
{
   // DO NOT USE!!!
   FW_NORMAL_ASSERT_ALWAYS();

   if(this == &ref)
   {
      return *this;
   }

   // do not set any parameter

   return *this;
}

SMF::~SMF()
{
    /* loop over all contexts */
    for(int iContext=0; iContext<(int)mContextDirectory.size(); iContext++) {

        tStateContext *context = mContextDirectory[iContext];

        /* cancel a possibly running timer */
        if (context->AnswerTimerID) {
            context->AnswerTimer.CancelTimer(IN context->AnswerTimerID);
            ETG_TRACE_USR4(("stop Answer timeout timer for SM %20s / ctx=%d, id=%d", mSMFullName, iContext, (int)((long)context->AnswerTimerID)));
            context->AnswerTimerID = 0;
        }
    }

    /* free the main message queue */
    if(mMQExternal)
    {
        delete mMQExternal;
        mMQExternal = NULL;
    }

    /* free internal queues for all contexts */
    for(int i=0; i<(int)mContextDirectory.size(); i++) {
        tStateContext *context = mContextDirectory[i];
        if(context->MQInternal)
        {
            delete context->MQInternal;
            context->MQInternal = NULL;
        }
    }

	/* free all GC memory */
    /* also the contexs are deleted here and inside the contexts the Timer object too */
	freeGC();

    /* free all names */
	delete[] mSMName;
	mSMName = NULL;
	delete[] mSMFullName;
	mSMFullName = NULL;
	delete[] mMQExternalName;
	mMQExternalName = NULL;

	/* clear the vector with all delay queue pointers */
	mAllDelayQueues.clear();
	vector<MessageQueue *> emptyAllDelayQueues; // this is done to ensure that all memory will be freed
	mAllDelayQueues.swap(emptyAllDelayQueues);

	/* clear the vector with all known events */
	mKnownEvents.clear();
	vector<tEvent *> emptyKnownEvents; // this is done to ensure that all memory will be freed
	mKnownEvents.swap(emptyKnownEvents);

	_eventMaster = 0;
}

void SMF::SDPrint(const char *cbuf)
{
    ETG_TRACE_USR2(("%128s: %s", mSMName, cbuf));
}

int SMF::SDPrintState(tState *state)
{
	char cbuf[printStringSize];
	if (state->alreadyPrinted) return 0;
	snprintf(cbuf, sizeof(cbuf), "%s::%s [t] \"%s\"", state->name, state->name, state->name);
	SDPrint(cbuf);
	state->alreadyPrinted = 1;
	return 0;
}

int SMF::SDPrintEvent(tState *currentState, tEvent *event, char *arguments)
{
   FW_IF_NULL_PTR_RETURN_NULL(currentState);
   FW_IF_NULL_PTR_RETURN_NULL(event);
   FW_IF_NULL_PTR_RETURN_NULL(currentState->name);
   FW_IF_NULL_PTR_RETURN_NULL(event->name);

	char cbuf[printStringSize];

	if (arguments) {
		snprintf(cbuf, sizeof(cbuf), "ext:%s.%s(%s) &", currentState->name, event->name, arguments);
	} else {
		snprintf(cbuf, sizeof(cbuf), "ext:%s.%s() &", currentState->name, event->name);
	}

	SDPrint(cbuf);
	return 0;
}

int SMF::SDPrintNotConsumedEvent(tEvent *event)
{
	char cbuf[printStringSize];
	snprintf(cbuf, sizeof(cbuf), "ext:notConsumed.%s &", event->name);
    SDPrint(cbuf);
	return 0;
}

int SMF::SDPrintStateTransition(tState *currentState, tState *compoundState, tState *lastCurrentState, tTransition *trans)
{
	char cbuf[printStringSize];

	if (!lastCurrentState) lastCurrentState = compoundState;

	if (!mSDTransactionName){
	    if (trans) {
	        mSDTransactionName = (char *)trans->name;
	    } else {
	        mSDTransactionName = (char *)"UNKNOWN";
	    }
	}

	char *currentStateName;
	if (currentState) {
	    currentStateName = (char *)currentState->name;
	} else {
	    currentStateName = (char *)"UNKNOWN";
	}

	char *lastCurrentStateName;
	if (lastCurrentState) {
	    lastCurrentStateName = (char *)lastCurrentState->name;
	} else {
	    lastCurrentStateName = (char *)"UNKNOWN";
	}

	snprintf(cbuf, sizeof(cbuf), "%s:>%s.%s%s%s &", lastCurrentStateName, currentStateName,
		mSDTransactionName,
		(mSDActionName ? "/" : ""),
		(mSDActionName ? mSDActionName : "")
		);
	mSDActionName = NULL;
	mSDTransactionName = NULL;
	SDPrint(cbuf);
	if (mSDEnterAction[0]) SDPrint(mSDEnterAction);
	mSDEnterAction[0] = 0;
	return 0;
}

int SMF::SDPrintEnterAction(tState *currentState)
{
	if (currentState) {
		snprintf(mSDEnterAction, sizeof(mSDEnterAction), "%s:>%s.Enter/ %s &", currentState->name, currentState->name, currentState->enterName);
	}
	return 0;
}

int SMF::SDPrintCondition(tState *currentState, tTransition *trans)
{
	char cbuf[printStringSize];

	snprintf(cbuf, sizeof(cbuf), "%s:>%s.Cond/ %s &", currentState->name, currentState->name, trans->conditionName);

    SDPrint(cbuf);
	return 0;
}

int SMF::SDPrintGuard(tState *currentState, tTransition *trans)
{
	char cbuf[printStringSize];

	snprintf(cbuf, sizeof(cbuf), "%s:>%s.Guard/ %s &", currentState->name, currentState->name, trans->guardName);

    SDPrint(cbuf);
	return 0;
}

int SMF::SDPrintExitAction(tState *currentState)
{
	char cbuf[printStringSize];

	snprintf(cbuf, sizeof(cbuf), "%s:>%s.Exit/ %s &", currentState->name, currentState->name, currentState->exitName);

	SDPrint(cbuf);
	return 0;
}

int SMF::SDPrintAction(tTransition *trans, int falseAction)
{
	// is it a transition with a condition?
	if (trans->cond == hasCondition) {
		if (falseAction == 0) {
			mSDTransactionName = (char *)trans->trueName;
			mSDActionName = (char *)trans->actionName;
		} else {
			mSDTransactionName = (char *)trans->falseName;
			mSDActionName = (char *)trans->elseActionName;
		}

	// for a normal action without condition
	} else {
		mSDTransactionName = (char *)trans->name;
		if (trans->actionName != NULL) {
			mSDActionName = (char *)trans->actionName;
		}
	}

	return 0;
}

int SMF::SDStartTransitionSection(void)
{
    SDPrint("ext:External[pe]");
    SDPrint("notConsumed:External[pe]");
	SDPrint("\n");
	return 0;
}

SMF::tState *SMF::_CreateState(const char *name, int stateID, tFn *entry, const char *entryName, tFn *exit, const char *exitName)
{
    ENTRY_INTERNAL
	tState *state;

    state = new tState();
    FW_FATAL_ASSERT(state != NULL);
    registerGC((void *)state, tStateGCType, 1);

	state->name = name;
	state->stateID = stateID;
	state->enter = entry;
	state->enterName = entryName;
	state->exit = exit;
	state->exitName = exitName;
	state->_this = this;

	return state;
}

/* class implementation */
SMF::tState *SMF::CreateState(const char *name, int stateID, tFn *entry, const char *entryName, tFn *exit, const char *exitName)
{
    ENTRY_INTERNAL
	tState *state;

	state = _CreateState(name, stateID, entry, entryName, exit, exitName);

	SDPrintState(state);

	return state;
}

SMF::tState *SMF::CreateHistoryState(const char *name)
{
    ENTRY_INTERNAL
	tState *state;

	state = _CreateState(name, -1, NULL, NULL, NULL, NULL);
	state->type = isHistoryState;
	return state;
}

SMF::tState *SMF::CreateForkState(const char *name)
{
    ENTRY_INTERNAL
	tState *state;

	state = _CreateState(name, -1, NULL, NULL, NULL, NULL);
	state->type = isForkState;
	SDPrintState(state);
	return state;
}

SMF::tState *SMF::CreateCompoundState(const char *name, int stateID, tFn *entry, const char *entryName, tFn *exit, const char *exitName)
{
    ENTRY_INTERNAL
	tState *state;

	state = CreateState(name, stateID, entry, entryName, exit, exitName);
	state->type = isCompoundState;

	return state;
}

SMF::tState *SMF::CreateFinalState(const char *name, int stateID, tFn *entry, const char *entryName)
{
    ENTRY_INTERNAL
	tState *state;

	state = CreateState(name, stateID, entry, entryName, NULL, NULL);
	state->type = isFinalState;

	return state;
}

void SMF::registerGC(void *ptr, tClassType type, int GCon)
{
    if (GCon) {
        lockGC.lock();
        pointersGC = (tPointerGC *)realloc(pointersGC, sizeof(tPointerGC) * (numberOfPointersGC+1));
        pointersGC[numberOfPointersGC].type = type;
        pointersGC[numberOfPointersGC].ptr = ptr;
        numberOfPointersGC++;
#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
      if(0 == (31 & numberOfPointersGC))
      {
         ETG_TRACE_ERR((" registerGC(): numberOfPointersGC=%u", numberOfPointersGC));
      }
#endif
        lockGC.unlock();
    }
}


void SMF::freeGC()
{
    lockGC.lock();
    for(size_t i=0; i<numberOfPointersGC; i++) {
        switch(pointersGC[i].type) {
            case tEventGCType:
                delete (tEvent *)pointersGC[i].ptr;
                break;
            case tStateGCType:
                delete (tState *)pointersGC[i].ptr;
                break;
            case tTransitionGCType:
                delete (tTransition *)pointersGC[i].ptr;
                break;
            case tStateContextGCType:
                delete (tStateContext *)pointersGC[i].ptr;
                break;
        }
    }
    free(pointersGC);
    pointersGC = NULL;
    numberOfPointersGC = 0;
    lockGC.unlock();
}

SMF::tTransition *SMF::CreateTransition(const char *name, tFn *guard, const char *guardName, tFn *action, const char *actionName, tState *target, int GCon)
{
    ENTRY_INTERNAL
	tTransition *trans;

    trans = new tTransition();
    FW_FATAL_ASSERT (trans != NULL);
    registerGC((void *)trans, tTransitionGCType, GCon);

	trans->name = name;
	trans->guard = guard;
	trans->guardName = guardName;
	trans->action = action;
	trans->actionName = actionName;
	trans->target = (tState_tag *)target;
	trans->_this = this;

	return trans;
}

SMF::tTransition *SMF::CreateDefaultTransition(const char *name, tFn *guard, const char *guardName, tFn *action, const char *actionName, tState *target)
{
    ENTRY_INTERNAL
	tTransition *trans;

	trans = CreateTransition(name, guard, guardName, action, actionName, target);
	trans->type = isDefaultTransition;

	return trans;
}

SMF::tTransition *SMF::CreateEventTransition(tEvent *event, const char *name, tFn *guard, const char *guardName, tFn *action, const char *actionName, tState *target)
{
    ENTRY_INTERNAL
	tTransition *trans;

	trans = CreateTransition(name, guard, guardName, action, actionName, target);
	trans->type = isEventTransition;
	trans->event = event;

	return trans;
}

SMF::tTransition *SMF::CreateEventConditionalTransition(tEvent *event, const char *name, tState *conditionalPosition, tFn *guard, const char *guardName, tFn *condition, const char *conditionName,
														tFn *actionTrue, const char *actionTrueName, tFn *actionFalse, const char *actionFalseName,
														const char *trueName, tState *targetTrue, const char *falseName, tState *targetFalse)
{
    ENTRY_INTERNAL
	tTransition *trans;

	trans = CreateTransition(name, guard, guardName, actionTrue, actionTrueName, targetTrue);
	trans->type = isEventTransition;
	trans->cond = hasCondition;
	trans->condition = condition;
	trans->conditionName = conditionName;
	trans->conditionalPosition = (tState_tag *)conditionalPosition;
	trans->elseAction = actionFalse;
	trans->elseActionName = actionFalseName;
	trans->elseTarget = (tState_tag *)targetFalse;
	trans->trueName = trueName;
	trans->falseName = falseName;
	trans->event = event;

	return trans;
}
SMF::tTransition *SMF::CreateHistoryTransition(const char *name, tFn *guard, const char *guardName, tFn *action, const char *actionName, tState *target)
{
    ENTRY_INTERNAL
	tTransition *trans;

	trans = CreateTransition(name, guard, guardName, action, actionName, target);
	trans->type = isHistoryTransition;

	return trans;
}

int SMF::AddTransition(tState *state, tTransition *trans)
{
    ENTRY_INTERNAL
	/* is it a event transition? */
	if (trans->type == isEventTransition) {

		trans->event->state.push_back((tState_tag *)state);
		trans->event->noOfStates++; // shortcut for later for loop
		trans->event->trans.push_back((tTransition_tag *)trans);
		trans->event->noOfTrans++; // shortcut for later for loop

		state->transitions.push_back(trans);
		state->noOfTransitions++; // shortcut for later for loop
		trans->source = (tState_tag *)state;

		/* inner transition to compound */
		if (trans->target == NULL) {
			trans->pos = isInnerTransition;
		}

		return 0;

	/* it is a normal transition */
	} else {
		state->transitions.push_back(trans);
		state->noOfTransitions++; // shortcut for later for loop
		trans->source = (tState_tag *)state;

		switch(trans->type) {
			case isHistoryTransition:
				state->hasHistory = 1;
				break;
			default:
				/* inner transition to compound */
				if (trans->target == NULL) {
					trans->pos = isInnerTransition;
				}
				break;
		}

		return 0;
	}
}

int SMF::AddState(tState *toCompoundState, tState *state)
{
   ENTRY_INTERNAL
   FW_FATAL_ASSERT(toCompoundState->type == isCompoundState);
   state->compound = toCompoundState;
   return 0;
}

void SMF::SetRoot(tState *state)
{
    ENTRY_INTERNAL

    /* set the root state of all */
	mRootState = state;

	/* set the root context as active always */
	state->context->active = 1;

	/* set the current state in its context */
	state->context->currentState = state;

	/* set the compound state */
	state->context->compoundState = state;

	/* set the default current context to the root context */
	mCurrentContext = state->context;
}

void SMF::SetConcurrent(tState *state)
{
    ENTRY_INTERNAL

    /* this state holds a context for all its children */
    state->holdsContext = 1;

    /* create the context */
    state->context = new tStateContext();
    registerGC((void *)state->context, tStateContextGCType, 1);

    state->hasContext = 1; // this state holds a context

    /* add it to the context directory for looping over all contexts */
    mContextDirectory.push_back(state->context);

    /* set the internal queue name */
    state->context->MQInternalName = new char[strlen("/mq_in_") + strlen(mSMFullName) + 1 + strlen(state->name) + 1];
    strcpy((char *)state->context->MQInternalName, "/mq_in_");
    strcat((char *)state->context->MQInternalName, mSMFullName);
    strcat((char *)state->context->MQInternalName, "_");
    strcat((char *)state->context->MQInternalName, state->name);

    /* some values for message/answer handling */
    state->context->AnswerTimeoutValue = AnswerTimeOutValue;
    state->context->AnswerTimerID = 0;
    state->context->SpecialAnswerTimeoutValue = -1;

    /* set the current state */
    state->context->currentState = state;
    state->context->compoundState = state;
}

int SMF::_Reset()
{
   ENTRY_INTERNAL

   if(mRootState)
   {
      // NOTE: SM has to be moved to final state before else reset does not work properly

      // reset the root state
      SetRoot(mRootState);

      // reset the init states
      for(size_t i = 0; i < mInitedStates.size(); i++)
      {
         mInitedStates[i]->init = mInitedStates[i]->backupInit;
      }

      return 0;
   }

   FW_NORMAL_ASSERT_ALWAYS();

   return FW_ERR_SM_RESET_FAILED;
}

int SMF::Reset(const void *userContext)
{
	ENTRY_INTERNAL

	return Init(userContext); // includes a reset if state machine was init'ed before
}

tResult SMF::ErrorHandler(const tResult error, const tTransition *trans, const char *fnName)
{
   ENTRY
   ETG_TRACE_ERR(("error=%d, transition=%64s, fnName=%64s", error, trans->name, fnName));
   //FW_NORMAL_ASSERT(0);
   return FW_ERR_SM_GENERAL_ERROR;
}

int SMF::Init(const void *userContext)
{
    ENTRY_INTERNAL
	int ret = 0;

    // clear obsolete events from previous
    if(mMQExternal) mMQExternal->Flush();

    // is this state machine already been initialized?
    if (mIsCreated) {

        // then do a reset of this state machine first
        ret = _Reset();
        if (ret) return ret;
    }

    /* set the user context pointer */
    mUserContext = userContext;

    /*
     * do the very first init of this state machine
     */
	CreateComponent();

	SDStartTransitionSection(); // start transistions in SD diagram

	/* the root is always the start of Init */
	tState *compoundState = (tState *)mRootState->context->compoundState;

	/* check if enter action is defined */
	PrintEnter(compoundState);
	if (compoundState->enter) {
		SDPrintEnterAction((tState *)mRootState->context->currentState);
		(compoundState->enter)(compoundState);
	}

	/* check if init has to be run */
	if ((tTransition *)compoundState->init) {
		tTransition *init = compoundState->init;
		compoundState->init = NULL;

		ret = DoTransition(init);

		mIsCreated = 1;

		return 0;
	}

	return FW_ERR_SM_NO_INIT_TRANSITION_IN_STATEMACHINE_DEFINITION;
}

int SMF::IsPartOf(tState *target, tState *compound)
{
    ENTRY_INTERNAL
	if (target->compound == compound) return 1;
	else return 0;
}

SMF::tStateContext *SMF::GetStateContext(tState *state)
{
    ENTRY_INTERNAL

    /* check if a context already found */
    if (state->context) {
        return state->context;
    }

    /* find a state in the parents where the context is already set */
    tState *stateSearch = state->compound;
    vector<tState *> statesWithoutContexts;
    while(stateSearch->context == NULL) {
        statesWithoutContexts.push_back(stateSearch);
        stateSearch = stateSearch->compound;
    }

    /* set the context in the requested state*/
    state->context = stateSearch->context;

    /* set the context in all states which were passed by and did not have a context already */
    for(int i=0; i<(int)statesWithoutContexts.size(); i++) {
        statesWithoutContexts[i]->context = stateSearch->context;
    }

    return state->context;
}

int SMF::DoTransition(tTransition *trans)
{
    ENTRY_INTERNAL
	//int ret;
	tState  *target = (tState *)trans->target;

    /*
     * Get source context
     */
    /* get the source state */
    tState  *sourceState = (tState *)trans->source;
    if (sourceState == NULL) { // if source is NULL: special startup transition, take target as context holder
        sourceState = (tState *)trans->target;
    }
    tStateContext *sourceContext = GetStateContext(sourceState);
    mCurrentContext = sourceContext;

    /* activate the new context */
    sourceContext->active = 1;
#ifdef SMF_ENABLE_EVENT_DEBUGGING
   if(true == _eventDebugging)
   {
      ETG_TRACE_USR1((" DoTransition(): sourceContext->active = 1"));
   }
#endif

    /* pointer to current state and compound state holder for this transition */
    tState **currentStateStorage = (tState **)&(sourceContext->currentState);
    tState **compoundStateStorage = (tState **)&(sourceContext->compoundState);

    /*
     * Get target context
     */
    /* get the target state */
    tState  *targetState = target;
    if (targetState == NULL) { // if target is NULL then internal transition is meant, so source state has context
        targetState = (tState *)trans->source;
    }
    tStateContext *targetContext = GetStateContext(targetState);

    /* activate the new target context */
    targetContext->active = 1;
#ifdef SMF_ENABLE_EVENT_DEBUGGING
   if(true == _eventDebugging)
   {
      ETG_TRACE_USR1((" DoTransition(): targetContext->active = 1"));
   }
#endif

	tFn *action = trans->action;

	tState *lastCurrentState = *currentStateStorage; /* remember last current event for state tracing */
	if (!lastCurrentState) lastCurrentState = *compoundStateStorage;

	tState *stateRoot = NULL; // root state for both other states
	vector<tState *> wayToToState; /* reverse way for to-state to go from root */
	int isExternalSelfTransition = 0; /* this is set if a transition is an external self transition */

	/* set member var for advanced debugging of smf to current transition */
	mCurrentTrans = trans;

	/* check guard */
	PrintGuard(trans);
	if (trans->guard) {
		SDPrintGuard(*currentStateStorage, trans);
		if ((trans->guard)(trans) == 0) {
			return 0;
		}
	}

	/*
	 * if it is a condition, set the target out of the position of the condition bubble
	 */
	if (trans->cond == hasCondition) {

		/* set a new target: the position of the conditional bubble */
		target = (tState *)trans->conditionalPosition;
	}

	/*
	 * if the target is set to the source and it is no condition, then it is a self transition, which is outside of the state
	 */
	if (target == (tState *)trans->source && trans->cond == hasNoCondition) {

		/* remember that for the further processing of exit and enter */
		isExternalSelfTransition = 1;
	}

	/*
	 * if the target of transition is NULL, it is meant as an internal transition.
	 * no enter or exists nor any other stuff is to be done.
	 */
	if (target == NULL) {

		/* call the action for the transition */
		PrintAction(trans);
		SDPrintAction(trans, 0);
		if (action) {

			/* retry loop on error */
			while(1) {
				tResult error;
				if ((error = (action)(trans)) == 0) break;
				if (ErrorHandler(error, trans, trans->actionName)) break; // the current state remains the same, even it is an error
			}
		}

		SDPrintStateTransition(*currentStateStorage, *compoundStateStorage, lastCurrentState, trans);

		/* end here */
		return 0;
	}

	/*
	 * do all exits
	 */

	/*
	 * find the common root for the current state and the target state
	 */
	tState *stateFrom;
	tState *stateTo;

	/* the current state is the beginning of the search */
	stateFrom = (tState *)*currentStateStorage;

	/*
	 * do it as long as there is a compound state above the current state
	 */
	while(stateFrom->compound) {

		/* search in other tree if this compound is also in */
		stateTo = target;

		/* reset the way back list because last time it were not the right way back */
		wayToToState.clear();

		/* walk through the tree */
		while(stateTo->compound) {

			/* compare the from and to state */
			if (stateFrom == stateTo) {

				/* root compound found */
				stateRoot = stateFrom;

				/* break this loop */
				break;
			}

			/* remember way back */
			wayToToState.push_back(stateTo);

			/* step back one compound */
			stateTo = stateTo->compound;
		}

		/* break if root state found */
		if (stateRoot) break;

		/* store the currently leaved state as history in its compound state */
		if (stateFrom->compound) {
			if (stateFrom->compound->hasHistory) {
				stateFrom->compound->history = stateFrom;
			}
		}

		/*
		 * do exits only if source and target context are the same and the state was entered before
		 */
		if (sourceContext == targetContext && stateFrom->entered) {

            /* do the exit transition of the currently leaved state */
            PrintExit(stateFrom);
            if (stateFrom->exit) {
                SDPrintExitAction(*currentStateStorage);

                /* retry loop on error */
                while(1) {
                    tResult error;
                    if ((error = (stateFrom->exit)(stateFrom)) == 0) break;
                    if (ErrorHandler(error, trans, stateFrom->exitName)) break;
                }
            }

            /* this state was exited now */
            stateFrom->entered = 0;

            /* pump all delayed events if the old state to main external queue */
            TransferDelayedEvents(stateFrom);
		}

		/* step back one state and try another search */
		stateFrom = stateFrom->compound;

		/*
		 * re-set the current state only if the target state has the same context
		 */
		if (sourceContext == targetContext) {

            /* correct the current state and the compound state members */
            *currentStateStorage = stateFrom;
            *compoundStateStorage = (*currentStateStorage)->compound;
		}
	}

	/*
	 * if it is an external self transition, do the specific exit here
	 */
	if (isExternalSelfTransition) {

	    /* do this only if state was entered before */
	    if ((*currentStateStorage)->entered) {

            PrintExit(*currentStateStorage);
            if ((*currentStateStorage)->exit) {
                SDPrintExitAction(*currentStateStorage);

                /* retry loop on error */
                while(1) {
                    tResult error;
                    if ((error = ((*currentStateStorage)->exit)(*currentStateStorage)) == 0) break;
                    if (ErrorHandler(error, trans, (*currentStateStorage)->exitName)) break;
                }
            }

            /* this state was exited now */
            (*currentStateStorage)->entered = 0;

            /* pump all delayed events if the old state to main external queue */
            TransferDelayedEvents((*currentStateStorage));
	    }

		/* and set the stateRoot to NULL to force an entry */
		stateRoot = NULL;
	}

	/*
	 * change context to target context (may be the same as source context)
	 * switch the Storages
	 * switch the mCurrentContext
	 */
    mCurrentContext = targetContext;
    currentStateStorage = (tState **)&(targetContext->currentState);
    compoundStateStorage = (tState **)&(targetContext->compoundState);

	/*
	 * set the target state as current state (but is not reached yet)
	 */
	*currentStateStorage = target;
	*compoundStateStorage = (*currentStateStorage)->compound;

	/*
	 * do the action
	 *
	 * now we have leaved all states that where necessary. Next step is to call the action for
	 * the transition. If it is a conditional, there is a special processing:
	 */
	if (trans->cond == hasCondition) {

		PrintConditionAction(trans);
		if (trans->condition) {

			tTransition *conditionalResult;

			SDPrintStateTransition(*currentStateStorage, *compoundStateStorage, lastCurrentState, trans);
			SDPrintCondition(*currentStateStorage, trans);

			/* set the artificial conditional result transition after the result of the conditional callback */
			if ((trans->condition)(trans)) {

				/* on true, take the original target */
				conditionalResult = CreateTransition("TRUE", NULL, NULL, trans->action, trans->actionName, (tState *)trans->target, 0 /* no GC */);
			} else {

				/* on false, take the else-target */
				conditionalResult = CreateTransition("FALSE", NULL, NULL, trans->elseAction, trans->elseActionName, (tState *)trans->elseTarget, 0 /* no GC */);
			}

			/* set the parameter to this new transition */
			conditionalResult->arguments = trans->arguments;

			/* do the conditional result as a new internal transition */
			/*ret = */DoTransition(conditionalResult);

			/* free the artificial transition */
			delete  conditionalResult;

			/* break recursion */
			goto exit_function_noprint;
		}

	/* normal action */
	} else {

		/* call the action for the transition */
		PrintAction(trans);
		SDPrintAction(trans, 0);
		if (action) {

			/* retry loop on error */
			while(1) {
				tResult error;
				if ((error = (action)(trans)) == 0) break;
				if (ErrorHandler(error, trans, trans->actionName)) break;
			}
		}
	}

	/*
	 * do all enters on the way to the target state:
	 */

	/*
	 * was a root state found before? than it was no internal transition and there should be a way to the target state
	 */
	if (stateRoot) {

		/* go way forward to the target state */
		for (int i = (int)wayToToState.size()-1; i >= 0; i--) {

		    /* do the enters only if state was not already entered */
		    if (!wayToToState[i]->entered) {

                /* do the enter actions for all compounds */
                PrintEnter(wayToToState[i]);

                if (wayToToState[i]->enter) {
                    SDPrintEnterAction(*currentStateStorage);
#ifdef SMF_ENABLE_EVENT_DEBUGGING
               if(true == _eventDebugging)
               {
                  ETG_TRACE_USR1((" DoTransition(): enterName=%s", stringIsNeverNull(wayToToState[i]->enterName)));
               }
#endif

                    /* retry loop on error */
                    while(1) {
                        tResult error;
                        if ((error = (wayToToState[i]->enter)(wayToToState[i])) == 0) break;
                        if (ErrorHandler(error, trans, wayToToState[i]->enterName)) break;
                    }
                }

                /* this state was entered now */
                wayToToState[i]->entered = 1;
		    }
#ifdef SMF_ENABLE_EVENT_DEBUGGING
         else
         {
            // state was already entered
            if(true == _eventDebugging)
            {
               if(0 != wayToToState[i]->enter)
               {
                  ETG_TRACE_USR1((" DoTransition(): state=%50s enterName=%s (already entered)", stringIsNeverNull(wayToToState[i]->name), stringIsNeverNull(wayToToState[i]->enterName)));
               }
            }
         }
#endif

			/* correct the current state and the compound state members */
			*currentStateStorage = wayToToState[i];
			*compoundStateStorage = (*currentStateStorage)->compound;
		}

	/* is no root state */
	} else {

		/*
		 * set the target state as current state (now it is reached)
		 */
	    *currentStateStorage = target;
	    *compoundStateStorage = (*currentStateStorage)->compound;

	    /* do an enter only if it was not already entered */
	    if (!(*currentStateStorage)->entered) {

            /* do the enter of the target state itself */
            PrintEnter(*currentStateStorage);
            if ((*currentStateStorage)->enter) {
                SDPrintEnterAction(*currentStateStorage);
#ifdef SMF_ENABLE_EVENT_DEBUGGING
            if(true == _eventDebugging)
            {
               ETG_TRACE_USR1((" DoTransition(): enterName=%s", stringIsNeverNull((*currentStateStorage)->enterName)));
            }
#endif

                /* retry loop on error */
                while(1) {
                    tResult error;
                    if ((error = ((*currentStateStorage)->enter)(*currentStateStorage)) == 0) break;
                    if (ErrorHandler(error, trans, (*currentStateStorage)->enterName)) break;
                }
            }

            /* this state was entered now */
            (*currentStateStorage)->entered = 1;
	    }
	}

	/*
	 * do the special transition INIT if needed
	 */
	if ((tTransition *)(*currentStateStorage)->init) {

		/* set the generated init transition */
		tTransition *init = (*currentStateStorage)->init;

		/* remember: init is done now */
		(*currentStateStorage)->init = NULL;

		SDPrintStateTransition(*currentStateStorage, *compoundStateStorage, lastCurrentState, trans);

		/* do the init transition */
		/*ret = */DoTransition(init);

		/* break recursion */
		goto exit_function_noprint;
	}

	SDPrintStateTransition(*currentStateStorage, *compoundStateStorage, lastCurrentState, trans);

	/*
	 * do the special state HISTORY, if needed:
	 */
	if ((*currentStateStorage)->hasHistory && (*currentStateStorage)->history) {

		/* generate an artificial history transition */
		tTransition *history = CreateTransition("history", NULL, "", NULL, "", (*currentStateStorage)->history, 0 /* no GC */);

		/* do the history transition */
		/*ret = */DoTransition(history);

		delete history;

		/* break recursion */
		goto exit_function_noprint;
	}

exit_function_noprint:

    /* check if the final state is a fork state, tha: do the first outgoing transition */
    if ((*currentStateStorage)->type == isForkState) {
        tTransition *fromFork = (*currentStateStorage)->transitions[0];
        DoTransition(fromFork);
	}

    /* check if final state of top context */
    if ((*currentStateStorage)->type == isFinalState)
    {
        /* stop an running answer timer */
    	if (targetContext->AnswerTimerID) {
    	    targetContext->AnswerTimer.CancelTimer(IN targetContext->AnswerTimerID);
			ETG_TRACE_USR4(("stop Answer timeout timer for SM %20s, id=%d", mSMFullName, (int)((long)targetContext->AnswerTimerID)));
			targetContext->AnswerTimerID = 0;
    	}

    	/* remove all enter states for all states from final state to top of current context */
    	tState *leaveState = (tState *)(*currentStateStorage); // starting at final state
    	while(leaveState) {

    	    /* reset the entered flag for this state */
    	    leaveState->entered = 0;

    	    /* if top of context reached, break */
    	    if (leaveState->hasContext) break;

    	    /* go one step up to next parent */
    	    leaveState = leaveState->compound;
    	}

    	/* if the top state context reaches the final state: end the state machine */
    	if (targetContext == mRootState->context) {
#ifdef SMF_ENABLE_EVENT_DEBUGGING
         if(true == _eventDebugging)
         {
            ETG_TRACE_USR1((" DoTransition(): targetContext == mRootState->context"));
         }
#endif
    	    return STATE_MACHINE_FINISHED;

    	/* if a concurrent state reaches the final state: deactivate the context */
    	} else {
#ifdef SMF_ENABLE_EVENT_DEBUGGING
         if(true == _eventDebugging)
         {
            ETG_TRACE_USR1((" DoTransition(): targetContext->active = 0"));
         }
#endif
    	    targetContext->active = 0;
    	}
    }

    /* reset current context to root context */
    mCurrentContext = mRootState->context;

    /* no final state, return 0 */
    return 0;
}

void SMF::SetInitTransition(tState *state, tTransition *trans)
{
    ENTRY_INTERNAL
    FW_FATAL_ASSERT(state != NULL);
	state->init = trans;
	state->backupInit = trans;
	mInitedStates.push_back(state);
}

SMF::tEvent *SMF::CreateEventInternal(const char *name, int GCon)
{
    ENTRY_INTERNAL
	tEvent *event;

    event = new tEvent();
    FW_FATAL_ASSERT(event != NULL);
    registerGC((void *)event, tEventGCType, GCon);

	event->name = name;

	return event;
}

SMF::tEvent *SMF::CreateEvent(const char *name)
{
	tEvent *event;

	/* create the event */
	event = CreateEventInternal(name);
	if (!event) return NULL;

	/* store this event also in the knownEvent table to establish event sending by name */
	mKnownEvents.push_back(event);
	// debug printf("mKnownEvents.size()=%d\n", mKnownEvents.size());

	return event;
}

int SMF::SetSMName(const char *name)
{
   ENTRY_INTERNAL

#ifdef SMF_ENABLE_EVENT_DEBUGGING
   if((0 != name) && (0 == strcmp("BmControllerOnOffSm", name)))
   {
      _eventDebugging = true;
   }
#endif

    if (mSMName) delete[] mSMName;
	mSMName = new char[strlen(name) + 1];
	strcpy((char *)mSMName, name);

	if (mSMFullName) delete[] mSMFullName;
	mSMFullName = new char[strlen(name) + strlen(mSMNamePostfix) + 3];
	strcpy((char *)mSMFullName, name);
	strcat((char *)mSMFullName, "(");
	strcat((char *)mSMFullName, mSMNamePostfix);
	strcat((char *)mSMFullName, ")");

	if (mMQExternalName) delete[] mMQExternalName;
	mMQExternalName = new char[strlen("/mq_ex_") + strlen(mSMFullName) + 1];
	strcpy((char *)mMQExternalName, "/mq_ex_");
	strcat((char *)mMQExternalName, mSMFullName);

	return 0;
}

const char* SMF::GetSMName(void)
{
   return stringIsNeverNull(mSMName);
}

const char* SMF::GetSMNameFull(void)
{
   return stringIsNeverNull(mSMFullName);
}

int SMF::GetState(void) const
{
   ENTRY_INTERNAL

   FW_IF_NULL_PTR_RETURN_ERROR(mRootState, FW_ERR_SM_NO_CURRENT_STATE);
   FW_IF_NULL_PTR_RETURN_ERROR(mRootState->context, FW_ERR_SM_NO_CURRENT_STATE);
   FW_IF_NULL_PTR_RETURN_ERROR(mRootState->context->currentState, FW_ERR_SM_NO_CURRENT_STATE);

   tState *currentState = (tState *)mRootState->context->currentState;

   return currentState->stateID;
}

void SMF::GetCurrentState(char *stateName, size_t size)
{
   ENTRY_INTERNAL

   FW_IF_NULL_PTR_RETURN(stateName);
   strncpy(stateName, "no-state", size);

   FW_IF_NULL_PTR_RETURN(mRootState);
   FW_IF_NULL_PTR_RETURN(mRootState->context);
   FW_IF_NULL_PTR_RETURN(mRootState->context->currentState);

   tState *currentState = (tState *)mRootState->context->currentState;

   if (currentState->name)
   {
      strncpy(stateName, currentState->name, size);
   }
}

const char *SMF::GetCurrentState()
{
   ENTRY_INTERNAL

   // ensure that a valid string is returned instead of a NULL pointer because this avoids NULL pointer check on caller side

   FW_IF_NULL_PTR_RETURN_ERROR(mRootState, "");
   FW_IF_NULL_PTR_RETURN_ERROR(mRootState->context, "");
   FW_IF_NULL_PTR_RETURN_ERROR(mRootState->context->currentState, "");

   tState *currentState = (tState *)mRootState->context->currentState;

   if(currentState->name)
   {
      return currentState->name;
   }
   else
   {
      return "";
   }
}

tResult SMF::IsInState(tInteger stateEnum)
{
   ENTRY_INTERNAL

   FW_IF_NULL_PTR_RETURN_ERROR(mRootState, 0);
   FW_IF_NULL_PTR_RETURN_ERROR(mRootState->context, 0);
   FW_IF_NULL_PTR_RETURN_ERROR(mRootState->context->currentState, 0);

   tState *current = (tState *)mRootState->context->currentState;

   while(current)
   {
      if (current->stateID == stateEnum) return 1;
      current = current->compound;
   }
   return 0;
}

int SMF::CreateComponent()
{
    ENTRY_INTERNAL

    if (!mMQExternal) mMQExternal = new MessageQueue(mMQExternalName);      // create external queue

    /* create internal queues for all contexts */
    for(int i=0; i<(int)mContextDirectory.size(); i++) {
        tStateContext *context = mContextDirectory[i];
        if (!context->MQInternal) context->MQInternal = new MessageQueue(context->MQInternalName);      // create internal queue
    }

    return 0;
}

int SMF::DecreateComponent()
{
    ENTRY_INTERNAL

    /* loop over all contexts */
    for(int iContext=0; iContext<(int)mContextDirectory.size(); iContext++) {
        tStateContext *context = mContextDirectory[iContext];

        /* cancel a possibly running timer */
        if (context->AnswerTimerID) {
            context->AnswerTimer.CancelTimer(IN context->AnswerTimerID);
            ETG_TRACE_USR4(("stop Answer timeout timer for SM %20s / ctx=%d, id=%d", mSMFullName, iContext, (int)((long)context->AnswerTimerID)));
            context->AnswerTimerID = 0;
        }
    }

    /* flush all queues */
    mMQExternal->Flush();

    /* flush internal queues for all contexts */
    for(int i=0; i<(int)mContextDirectory.size(); i++) {

        tStateContext *context = mContextDirectory[i];
        context->MQInternal->Flush();

        /* Release lock status */
        context->LockStatus = MessageAnswerUnlock;
    }

    return 0;
}

int SMF::sendPrioritizedEvent(const tEvent* event, const int priority, const char* parameters)
{
   ENTRY
   FW_IF_NULL_PTR_RETURN_ERROR(event, INVALID_PARAMETER);
   // parameters can be NULL

   int ret;
   void* Sendbuf;
   size_t bufferSize;

   // check if queue is available
   if (!mMQExternal)
   {
      ETG_TRACE_FATAL(("SendEvent: external queue not created or already decreated due to end of SM"));
      return FW_ERR_SM_NO_EXTERNAL_QUEUE;
   }

   // sendBuffer
   if (parameters)
   {
      bufferSize = strlen(event->name) + strlen(parameters) +2;
      Sendbuf = mMQExternal->CreateMessageBuffer(bufferSize);
      if (!Sendbuf) return FW_ERR_SM_NO_MEM_FOR_QUEUE_MESSAGE;
      strcpy((char *)Sendbuf, event->name);
      strcat((char *)Sendbuf, " ");
      strcat((char *)Sendbuf, parameters);
   }
   else
   {
      bufferSize = strlen(event->name) +1;
      Sendbuf = mMQExternal->CreateMessageBuffer(bufferSize);
      if (!Sendbuf) return FW_ERR_SM_NO_MEM_FOR_QUEUE_MESSAGE;
      strcpy((char *)Sendbuf,event->name);
   }

   // send the message, internal retry loop
   int retry = mRetryCount;
   while(1)
   {
      // try to send message
      ret = pushMessage(*mMQExternal, Sendbuf, bufferSize, priority); // org: mMQExternal->Push(Sendbuf,bufferSize, priority);
      if (ret != 0)
      {
         ETG_TRACE_ERR(("Message: %127s can't be sent to queue: %127s",(char *)Sendbuf, mMQExternalName));
      }
      else
      {
         break;
      }

      // do another retry?
      if (!retry) break;
      ETG_TRACE_ERR(("retry sending to queue: %s", mMQExternalName));
      retry--;

      // sleep before retry
      usleep((useconds_t)mUSSleepTime);
   }
#if OLD_IMPL
   // dropBuffer
   mMQExternal->DropMessage(Sendbuf);
#endif

   return ret;
}

int SMF::SendEvent(const tEvent* event, const char* parameters)
{
   ENTRY
   FW_IF_NULL_PTR_RETURN_ERROR(event, INVALID_PARAMETER);
   // parameters can be NULL
   const int ret = sendPrioritizedEvent(event, Priority_Internal, parameters);
   FW_NORMAL_ASSERT(0 == ret);

   // continue also in case of error because in case of immediate event processing nothing will happen except queue check; do not touch return value
   doEventProcessing();

   return ret;
}

int SMF::SendUrgentEvent(const tEvent* event, const char* parameters)
{
   ENTRY
   FW_IF_NULL_PTR_RETURN_ERROR(event, INVALID_PARAMETER);
   // parameters can be NULL
   const int ret = sendPrioritizedEvent(event, Priority_Urgent, parameters);
   FW_NORMAL_ASSERT(0 == ret);

   // continue also in case of error because in case of immediate event processing nothing will happen except queue check; do not touch return value
   doEventProcessing();

   return ret;
}

int SMF::SendForceEvent(const tEvent* event, const char* parameters)
{
   ENTRY
   FW_IF_NULL_PTR_RETURN_ERROR(event, INVALID_PARAMETER);
   // parameters can be NULL

   // flush the content of the external queue
   if(0 != mMQExternal)
   {
      mMQExternal->Flush();
   }

   return SendUrgentEvent(event, parameters);
}

int SMF::SendEventByName(const char* eventName, const char* parameters)
{
   ENTRY
   FW_IF_NULL_PTR_RETURN_ERROR(eventName, INVALID_PARAMETER);
   FW_IF_NULL_PTR_RETURN_ERROR(eventName[0], SMF_ERR_UNKNOWN_EVENT);
   // parameters can be NULL

   int ret = SMF_ERR_UNKNOWN_EVENT;

   // TODO: Use SendInternalEventByName (Priority_Internal) for all SendEventByName calls
   // search for event
   for(size_t i = 0; i < mKnownEvents.size(); i++)
   {
      // debug printf("mKnownEvents[i]->name: %s\n", mKnownEvents[i]->name);
      if((0 != mKnownEvents[i]) && (0 != mKnownEvents[i]->name) && (0 != mKnownEvents[i]->name[0]) && (0 == strcmp(mKnownEvents[i]->name, eventName)))
      {
         ret = sendPrioritizedEvent(mKnownEvents[i], Priority_External, parameters);
         break;
      }
   }

   FW_NORMAL_ASSERT(0 == ret);

   // continue also in case of error because in case of immediate event processing nothing will happen except queue check; do not touch return value
   doEventProcessing();

   return ret;
}

int SMF::RemoveMessageByName(MessageQueue *queue, const char *messageName)
{
    ENTRY;

    /*
     * remove all messages from the input queue which matches the name given
     */

    /* lock the queue to gain full access */
    queue->DoLock();

    /* loop over all messages to find the ones to be deleted */
    int iMessageNumber = 0;
    // Debug printf("RemoveMessageByName: messageName=%s\n", messageName); fflush(stdout);
    while(true) {

        /* get a message */
        size_t rec_bytes = 0;
        void * RecordBuffer = queue->Peek(iMessageNumber, &rec_bytes);

        /* no more messages */
        if (!RecordBuffer) {
            // Debug printf("RemoveMessageByName: iMessageNumber=%d, no more messages\n", iMessageNumber); fflush(stdout);
            break;
        }
        // Debug printf("RemoveMessageByName: iMessageNumber=%d, RecordBuffer=%s\n", iMessageNumber, (char *)RecordBuffer); fflush(stdout);

        /* check if the message name is present */
        if (!strncmp((const char *)RecordBuffer, messageName, strlen(messageName))) {

            // Debug printf("RemoveMessageByName: message found\n"); fflush(stdout);

            /* remove this message from queue (all others are shifted so the iMessageNumber must not be increased) */
            queue->Remove(iMessageNumber);

        } else {
            /* try next message */
            iMessageNumber++;
        }

#if OLD_IMPL
        /* free memory for RecordBuffer */
        free(RecordBuffer);
#endif
    }

    /* unlock the queue */
    queue->UnLock();

    return FW_NO_ERROR;
}

int SMF::RemoveMessageByName(const char *messageName)
{
    ENTRY;

    /* emove all messages from the input queue which matches the name given */
    RemoveMessageByName(mMQExternal, messageName);

    /* remove all messages from all known delay queues */
    for(unsigned int i=0; i<mAllDelayQueues.size(); i++) {
        RemoveMessageByName(mAllDelayQueues[i], messageName);
    }

    return FW_NO_ERROR;
}

bool SMF::areAnyMessagesWaiting(void)
{
    ENTRY;

    bool messagesWaiting(false);

    mMQExternal->DoLock();

    if (0ull < mMQExternal->GetCurMessagesCount())
    {
       messagesWaiting = true;
    }

    mMQExternal->UnLock();

    if (false == messagesWaiting)
    {
       for (unsigned int i = 0u; i < mAllDelayQueues.size(); ++i)
       {
          mAllDelayQueues[i]->DoLock();

          if (0ull < mAllDelayQueues[i]->GetCurMessagesCount())
          {
             messagesWaiting = true;

             mAllDelayQueues[i]->UnLock();

             break;
          }
          else
          {
             mAllDelayQueues[i]->UnLock();
          }
       }
    }

    ETG_TRACE_USR1(("areAnyMessagesWaiting: there are %20s messages waiting for being processed by %50s",
          (messagesWaiting ? "still" : "no"), mSMFullName));

    return messagesWaiting;
}

#if 0
int SMF::SendInternalEventByName(const char* eventName, const char* parameters)
{
   ENTRY
   FW_IF_NULL_PTR_RETURN_ERROR(eventName, INVALID_PARAMETER);
   FW_IF_NULL_PTR_RETURN_ERROR(eventName[0], SMF_ERR_UNKNOWN_EVENT);
   // parameters can be NULL

   int ret = SMF_ERR_UNKNOWN_EVENT;

   // search for event
   for(size_t i = 0; i < mKnownEvents.size(); i++)
   {
      // debug printf("mKnownEvents[i]->name: %s\n", mKnownEvents[i]->name);
      if((0 != mKnownEvents[i]) && (0 != mKnownEvents[i]->name) && (0 != mKnownEvents[i]->name[0]) && (0 == strcmp(mKnownEvents[i]->name, eventName)))
      {
         ret = sendPrioritizedEvent(mKnownEvents[i], Priority_Internal, parameters);
         break;
      }
   }

   return ret;
}
#endif

#if 0
int SMF::SendAnswer(const char* argument)
{
   ENTRY
   // argument can be NULL

   char *answer;
   char *answer_msg;
   int to = 10000L; // wait time out for the answer message fetched out of queue
   int res;

   // check if current context active
   if (!mCurrentContext)
   {
      ETG_TRACE_ERR(("SendAnswer: no current context"));
      return FW_ERR_SM_NO_CURRENT_CONTEXT;
   }

   // check if queue is created
   if (!mCurrentContext->MQInternal)
   {
      ETG_TRACE_FATAL(("SendAnswer: internal queue not created"));
      return FW_ERR_SM_NO_INTERNAL_QUEUE;
   }

   // read answer from internal queue
   answer=(char *)GetMQmessage(mCurrentContext->MQInternal, "mMQInternal", to);

   // got answer?
   if (answer != NULL)
   {
      // arguments provided?
      if(argument != NULL)
      {
         // assemble answer message
         answer_msg = new char[strlen(answer)+strlen(argument)+2];
         strcpy(answer_msg, answer);
         strcat(answer_msg, " ");
         strcat(answer_msg, argument);

         // send it
         res = Dispatcher::GetInstance().SendMessage(answer_msg);
         delete[] answer_msg;
      }
      else
      {
         // no arguments provided
         // send it
         res = Dispatcher::GetInstance().SendMessage(answer);
      }

      // free the read message
      mCurrentContext->MQInternal->DropMessage(answer);

      // unlock the message / answer mechanism
      mCurrentContext->LockStatus = MessageAnswerUnlock;
      ETG_TRACE_USR1(("SendAnswer: SM %24s: Unlock [MAQueue] for %s", GetSMNameFull(), mCurrentContext->LockMessage));

      //Send an NULL_EVENT to external queue to allow processing of internal queue once external queue is processed
      SendEvent(mNULL_EVENT,NULL);

      return res;
   }
   else
   {
      // error: no message in internal queue
      // unlock mechanism and report error
      mCurrentContext->LockStatus = MessageAnswerUnlock;
      ETG_TRACE_ERR (("SendAnswer: SM %24s: Answer event in internal queue expected - but not found / Unlock [MAQueue] for %s", GetSMNameFull(), mCurrentContext->LockMessage));

      return FW_ERR_SM_FOUND_NO_ANSWER_MESSAGE_TO_SEND;
   }
}
#endif

#if 0
int SMF::SendActionError(const char* argument)
{
   ENTRY
   // argument can be NULL

   char *answer;
   char *error;
   char *error_msg;
   int to = 10000L; // wait time out for the answer message fetched out of queue
   int res;

   // check if current context active
   if (!mCurrentContext)
   {
      ETG_TRACE_ERR(("SendActionError: no current context"));
      return FW_ERR_SM_NO_CURRENT_CONTEXT;
   }

   // check if queue is created
   if (!mCurrentContext->MQInternal)
   {
      ETG_TRACE_FATAL(("SendActionError: internal queue not created for SM %s", GetSMNameFull()));
      ETG_TRACE_ERRMEM(("SendActionError: internal queue not created for SM %s", GetSMNameFull()));
      return FW_ERR_SM_NO_INTERNAL_QUEUE;
   }

   // read answer from internal queue
   answer=(char *)GetMQmessage(mCurrentContext->MQInternal, "mMQInternal", to);

   // got answer?
   if (answer != NULL)
   {
      // generate error answer event
      const char *eventName = "ACTION_ERROR";
      error = new char[strlen(answer)+strlen(eventName)+1];
      strcpy(error, answer);
      // extract event from error message
      char *errorEvent = strstr(error, "::");
      if(errorEvent)
      {
         errorEvent = errorEvent + 2;
         strcpy(errorEvent, eventName);
      }

      // arguments provided?
      if(argument != NULL)
      {
         // assemble answer message
         error_msg = new char[strlen(error)+strlen(argument)+2];
         strcpy(error_msg, error);
         strcat(error_msg, " ");
         strcat(error_msg, argument);

         // send it
         res = Dispatcher::GetInstance().SendMessage(error_msg);
         delete[] error_msg;

         // no arguments provided
      }
      else
      {
         // send it
         res = Dispatcher::GetInstance().SendMessage(error);
      }

      delete[] error;

      // free the read message
      mCurrentContext->MQInternal->DropMessage(answer);

      // unlock the message / answer mechanism
      mCurrentContext->LockStatus=MessageAnswerUnlock;
      ETG_TRACE_USR1(("SendActionError: SM %24s: Unlock [MAQueue] for %s", GetSMNameFull(), mCurrentContext->LockMessage));

      //Send an NULL_EVENT to external queue to allow processing of internal queue once external queue is processed
      SendEvent(mNULL_EVENT,NULL);

      return res;
   }
   else
   {
      // error: no message in internal queue
      // unlock mechanism and report error
      mCurrentContext->LockStatus=MessageAnswerUnlock;
      ETG_TRACE_ERR (("SendActionError: SM %24s: Answer event in internal queue expected - but not found / Unlock [MAQueue] for %s", GetSMNameFull(), mCurrentContext->LockMessage));

      return FW_ERR_SM_FOUND_NO_ANSWER_MESSAGE_TO_SEND;
   }
}
#endif

int SMF::SendEventAnswerByName(const char* eventName, const char* eventAnswerName, const char* parameters)
{
   ENTRY
   FW_IF_NULL_PTR_RETURN_ERROR(eventName, INVALID_PARAMETER);
   FW_IF_NULL_PTR_RETURN_ERROR(eventName[0], SMF_ERR_UNKNOWN_EVENT);
   FW_IF_NULL_PTR_RETURN_ERROR(eventAnswerName, INVALID_PARAMETER);
   // parameters can be NULL

   int ret = SMF_ERR_UNKNOWN_EVENT;

   // search for event
   for(size_t i = 0; i < mKnownEvents.size(); i++)
   {
      // debug printf("mKnownEvents[i]->name: %s\n", mKnownEvents[i]->name);
      if((0 != mKnownEvents[i]) && (0 != mKnownEvents[i]->name) && (0 != mKnownEvents[i]->name[0]) && (0 == strcmp(mKnownEvents[i]->name, eventName)))
      {
         ret = SendEventAnswer(mKnownEvents[i], eventAnswerName, parameters);
         break;
      }
   }

   FW_NORMAL_ASSERT(0 == ret);

   // continue also in case of error because in case of immediate event processing nothing will happen except queue check; do not touch return value
   doEventProcessing();

   return ret;
}

int SMF::SendEventAnswer(const tEvent* event, const char* answer, const char* parameters)
{
   ENTRY
   FW_IF_NULL_PTR_RETURN_ERROR(event, INVALID_PARAMETER);
   FW_IF_NULL_PTR_RETURN_ERROR(answer, INVALID_PARAMETER);
   // parameters can be NULL

   int ret;
   void *Sendbuf;
   size_t bufferSize;

   // loop over all active contexts
   for (int iContext=0; iContext<(int)mContextDirectory.size(); iContext++)
   {
      tStateContext *context = mContextDirectory[iContext];

      // is context active?
      if (!context->active)
      {
         continue;
      }

      // check if queue is available
      if (!context->MQInternal)
      {
         ETG_TRACE_FATAL(("SendEventAnswer: internal queue not created or already decreated due to end of SM %s", GetSMNameFull()));
         ETG_TRACE_ERRMEM(("SendEventAnswer: internal queue not created or already decreated due to end of SM %s", GetSMNameFull()));
         return FW_ERR_SM_NO_INTERNAL_QUEUE;
      }

      // Lock
      context->MQInternalLock.lock();

      // sendBuffer
      if (parameters)
      {
         bufferSize = strlen(event->name) + strlen(parameters) +2;
         Sendbuf = context->MQInternal->CreateMessageBuffer(bufferSize);
         strcpy((char *)Sendbuf, event->name);
         strcat((char *)Sendbuf, " ");
         strcat((char *)Sendbuf, parameters);
      }
      else
      {
         bufferSize = strlen(event->name) +1;
         Sendbuf = context->MQInternal->CreateMessageBuffer(bufferSize);
         strcpy((char *)Sendbuf, event->name);
      }

      ret = pushMessage(*(context->MQInternal), Sendbuf, bufferSize, Priority_Internal); // org: context->MQInternal->Push(Sendbuf,bufferSize, Priority_Internal);
      if (ret != 0)
      {
         ETG_TRACE_ERR(("Message:%127s can't be sent to queue: %127s",(char *)Sendbuf,context->MQInternalName));
      }

#if OLD_IMPL
      // dropBuffer
      context->MQInternal->DropMessage(Sendbuf);
#endif
      // send answer into queue
      Sendbuf = context->MQInternal->CreateMessageBuffer(strlen(answer)+1);
      strcpy((char *)Sendbuf, answer);

      ret = pushMessage(*(context->MQInternal), Sendbuf, strlen(answer)+1, Priority_Internal); // org: context->MQInternal->Push(Sendbuf, strlen(answer)+1,Priority_Internal);
      if (ret != 0)
      {
         ETG_TRACE_ERR(("Message:%127s can't be sent to queue: %127s",(char *)Sendbuf,context->MQInternalName));
      }

#if OLD_IMPL
      // dropBuffer
      context->MQInternal->DropMessage(Sendbuf);
#endif

      //Send an NULL_EVENT to external queue to allow processing of internal queue in the next mainloop cycle
      (void)SendEvent(mNULL_EVENT,NULL);

      // Unlock
      context->MQInternalLock.unlock();

   } // loop over all active contexts

   return 0;
}

int SMF::DelayEvent(void *_trans)
{
	ENTRY_INTERNAL
	tTransition *trans = (tTransition *)_trans;
	void *Sendbuf;
	size_t bufferSize = 0;
	int ret;

	/* has the source state no delay queue? create it */
	if (!((tState *)(trans->source))->delayQueue) {

	    /* generate a name for the delay queue */
	    tGeneralString delayQueueName;
	    strncpy_r(OUT delayQueueName, IN "delayQ_", IN sizeof(tGeneralString));
	    strncat_r(OUT delayQueueName, ((tState *)(trans->source))->name, IN sizeof(tGeneralString));

	    /* create the delay queue */
	    ((tState *)(trans->source))->delayQueue = new MessageQueue(delayQueueName);
	    if (!((tState *)(trans->source))->delayQueue) {
            ETG_TRACE_ERR(("DelayQueue not created"));
            return FW_ERR_SM_NO_DELAY_QUEUE_CREATED;
	    }

	    /* add this queue to the delay queue vector */
	    mAllDelayQueues.push_back(((tState *)(trans->source))->delayQueue);
	}
    MessageQueue *delayQueue = ((tState *)(trans->source))->delayQueue; // simplyfier

	/* are arguments present? */
	if (trans->arguments) { // yes

		/* create the send buffer for delay queue */
	    bufferSize = strlen(trans->event->name) + 1 + strlen(trans->arguments) + 1;
	    Sendbuf = delayQueue->CreateMessageBuffer(bufferSize);
		if (!Sendbuf) {
	        ETG_TRACE_ERR(("Messagebuffer not allocated"));
			return FW_ERR_SM_NO_MEM_FOR_DELAY_QUEUE_MESSAGE;
		}

		strcpy((char *)Sendbuf, trans->event->name);
		strcat((char *)Sendbuf, " ");
		strcat((char *)Sendbuf, trans->arguments);

	} else { // no arguments

		/* create the send buffer for delay queue */
	    bufferSize = strlen(trans->event->name) + 1;
		Sendbuf = delayQueue->CreateMessageBuffer(bufferSize);
		if (!Sendbuf) {
	        ETG_TRACE_ERR(("Messagebuffer not allocated"));
			return FW_ERR_SM_NO_MEM_FOR_DELAY_QUEUE_MESSAGE;
		}

		strcpy((char *)Sendbuf, trans->event->name);
	}

	ETG_TRACE_USR4(("Delaying Event: %s", (char *)Sendbuf));

	/* send the buffer */
	ret = delayQueue->Push(Sendbuf, bufferSize, Priority_Delayed);
	if (ret != 0) {
		ETG_TRACE_ERR(("Message:%127s can't be sent to queue: %127s", (char *)Sendbuf, delayQueue->GetName()));
	}

	// todo: thm3hi: in valgrind the Sendbuf is marked as memory leak, this can only be the case if the delay queue is never flushed or read out

#if OLD_IMPL
	// dropBuffer
	delayQueue->DropMessage(Sendbuf);
#endif

	return ret;
}

int SMF::TransferDelayedEvents(tState *currentState)
{
    ENTRY_INTERNAL
	char *receiveData;
	int to = 2000; //timeout in ms

	/* is a delay queue present? if not, do nothing */
	if (!currentState->delayQueue) {
	    return 0;
	}

	MessageQueue *delayQueue = currentState->delayQueue; // simplyfier

	// loop over delayed messages in the delay queue
	while (delayQueue->GetCurMessagesCount()) {

		// read out the message
		receiveData = (char*)GetMQmessage(delayQueue, "mMQDelay", to);

		// data available
		if (receiveData != NULL) {

			/* put it into external queue */
			char *sendData;

			/* get a send buffer */
			sendData = (char *)mMQExternal->CreateMessageBuffer(strlen(receiveData)+1);

			/* send it */
			if (sendData) {

				strcpy(sendData, receiveData);
				(void)pushMessage(*mMQExternal, sendData, strlen(receiveData)+1, Priority_Delayed); // org: mMQExternal->Push(sendData,strlen(receiveData)+1, Priority_Delayed);
#if OLD_IMPL
				mMQExternal->DropMessage(sendData);
#endif
			} else {
				ETG_TRACE_ERR(("Got no Sendbuffer"));
			}

			/* free the received buffer */
			delayQueue->DropMessage(receiveData);

		} else {
			ETG_TRACE_ERR(("Did not get a receive Buffer"));
		}
	} // loop over all delayed events

    /* remove this queue from the delay queue vector */
	for(unsigned int i=0; i<mAllDelayQueues.size(); i++) {
	    if (mAllDelayQueues[i] == delayQueue) {
	        mAllDelayQueues.erase(mAllDelayQueues.begin()+i);
	        break;
	    }
	}

	/* delay queue is empty now, can be deletes */
	delete delayQueue;
	currentState->delayQueue = NULL;

	return 0;
}

int SMF::NextEventProcess(char *eventName, char *ptrArguments, tStateContext *processingContext /* defaults to NULL */)
{
    ENTRY_INTERNAL
	unsigned int i;
	unsigned int j;
	tTransition *message;
	tState *toCompound;
	tEvent *event = mNULL_EVENT;

	/* search for event */
    for (i=0; i<mKnownEvents.size(); i++) {
        if (!strcmp(mKnownEvents[i]->name, eventName)) {
            event=mKnownEvents[i];
            break;
        }
    }

    /* found the event? */
    if (i == mKnownEvents.size()) return SMF_ERR_UNKNOWN_EVENT;

    /* loop over all active contexts */

    // thoemel
    // printf("mContextDirectory.size()=%d\n", (int)mContextDirectory.size()); fflush(stdout);

    tState *currentState;
    tState *compoundState;
    tResult doTransitionResult = FW_ERR_SM_NOT_CONSUMED;
    for(int iContext=0; iContext<(int)mContextDirectory.size(); iContext++) {
        tStateContext *context = mContextDirectory[iContext];

        /* is context active? */
        if (!context->active) {
#ifdef SMF_ENABLE_EVENT_DEBUGGING
         if(true == _eventDebugging)
         {
            ETG_TRACE_USR1((" NextEventProcess(): context->active == 0"));
         }
#endif
            continue;
        }

        /* is this the context which should be processed only? */
        if (processingContext && context != processingContext) {
#ifdef SMF_ENABLE_EVENT_DEBUGGING
         if(true == _eventDebugging)
         {
         }
#endif
            continue;
        }

        /* get the current state of the current context */
        currentState = (tState *)context->currentState;
        compoundState = (tState *)context->compoundState;

        /* is event registered as release event? */
        if (event == context->ReleaseEvent) {
#ifdef SMF_ENABLE_EVENT_DEBUGGING
         if(true == _eventDebugging)
         {
         }
#endif

            /* clear it and disarm timer */
            ClearReleaseEvent();
        }

        SDPrintEvent(currentState, event, ptrArguments);

        /* check if event can be consumed by current state */
        for (i=0; i<event->noOfStates; i++) {
            if ((tState *)event->state[i] == currentState) {
#ifdef SMF_ENABLE_EVENT_DEBUGGING
            if(true == _eventDebugging)
            {
               ETG_TRACE_USR1((" NextEventProcess(): event=%s", stringIsNeverNull(event->name)));
               ETG_TRACE_USR1((" NextEventProcess(): trans=%s", stringIsNeverNull(((tTransition *)event->trans[i])->name)));
            }
#endif

                /* append userdata to event */
                ((tTransition *)event->trans[i])->arguments = ptrArguments;

                /* fire transition */
                doTransitionResult = DoTransition((tTransition *)event->trans[i]);
                goto cont;
            }
        }

        /*
         * to ensure that all state machines are stopping in time regardless of their design, the STOP_SM message
         * must be processed in any case. So the search after a Delay Event will be skipped for this message:
         */
        if (strcmp(eventName, "STOP_SM")) {

            /* is in the current state a default transition? */
            for (i=0; i<currentState->noOfTransitions; i++) {
                if (currentState->transitions[i] == NULL) {
                    break;
                } else if (currentState->transitions[i]->type == isDefaultTransition) {

                    tEvent *artificialEvent;
                    tResult res;

                    /* create an artificial event just for this call to pass the original event to the default transition */
                    artificialEvent = CreateEventInternal(eventName, 0 /* no GC */ );
                    currentState->transitions[i]->event = artificialEvent;

                    /* append userdata to event */
                    currentState->transitions[i]->arguments = ptrArguments;

                    const bool delayed_event = currentState->transitions[i]->actionName != NULL && strcmp(currentState->transitions[i]->actionName, "DelayEvent");
                    res = DoTransition(currentState->transitions[i]);

                    delete artificialEvent;

                    if(!res && delayed_event) { //exclude: Default / DelayEvent
                       res = FW_ERR_SM_NOT_CONSUMED;
                    }

                    doTransitionResult = res;
                    goto cont;
                }
            }
        } // if skip DelayEvent search for forced STOP_SM event

        /* transition known to compound state(s)? */
        toCompound = compoundState;

        // loop over compound hierarchy
        while(toCompound) {

            /* loop over states known by this event */
            for (i=0; i<event->noOfStates; i++) {

                // is current test compound known by the current event?
                if (toCompound == (tState *)event->state[i]) {

                    message = (tTransition *)event->trans[i];

                    // search the message in the current test compound
                    for (j=0; j<toCompound->transitions.size(); j++) {
                        if (toCompound->transitions[j] == NULL) {
                            break;
                        } else if (toCompound->transitions[j] == message) {

                            /* append userdata to event */
                            message->arguments = ptrArguments;

                            doTransitionResult = DoTransition(message);
                            goto cont;
                        }
                    }
                }
            }

            /* is in the compound a default transition defined? */
            for (i=0; i<toCompound->noOfTransitions; i++) {
                if (toCompound->transitions[i] == NULL) {
                    break;
                } else if (toCompound->transitions[i]->type == isDefaultTransition) {

                    tEvent *artificialEvent;
                    tResult res;

                    /* create an artificial event just for this call to pass the original event to the default transition */
                    artificialEvent = CreateEventInternal(eventName, 0 /* no GC */);
                    toCompound->transitions[i]->event = artificialEvent;

                    /* append userdata to event */
                    toCompound->transitions[i]->arguments = ptrArguments;

                    const bool delayed_event = toCompound->transitions[i]->actionName != NULL && strcmp(toCompound->transitions[i]->actionName, "DelayEvent");

                    res = DoTransition(toCompound->transitions[i]);

                    delete artificialEvent;

                    if(!res && delayed_event) { //exclude: Default / DelayEvent
                        res = FW_ERR_SM_NOT_CONSUMED;
                    }

                    doTransitionResult = res;
                    goto cont;
                }
            }

            /* next compound */
            toCompound = toCompound->compound;
        }

cont:
        /* break the loop if this is the context which should be processed only? */
        if (processingContext && context != processingContext) {
            break;
        }

    } // loop over all active contexts

    /* was the transition not consumed by any state? */
    if (doTransitionResult == FW_ERR_SM_NOT_CONSUMED) {

        /* event not yet consumed */
        SDPrintNotConsumedEvent(event);
        {
            char cbuf[1024];
            snprintf(cbuf, sizeof(cbuf), "%s: notConsumed", event->name);
            Expect(cbuf);
        }
    }

	return doTransitionResult;
}

int SMF::CheckForExternalMessage(bool* messagesProcessed /*= NULL*/)
{
    ENTRY_INTERNAL
    char *receiveData;
    int ret = 0;

    /* check if queue is still valid, if not, trace it and end this state machine */
    if (!mMQExternal) {
        ETG_TRACE_FATAL(("not expected: external queue already closed - finishing state machine %s", GetSMNameFull()));
        ETG_TRACE_ERRMEM(("not expected: external queue already closed - finishing state machine %s", GetSMNameFull()));
        return STATE_MACHINE_FINISHED;
    }

	// check external queue and wait until message is available
    receiveData = (char *)GetMQmessage(mMQExternal, "mMQExternal", 0);

    if (receiveData != NULL)
    {
        char *posArguments;

        // find delimiter between event and argument
        posArguments = strstr(receiveData, " ");

        // check if arguments are presen
        if (posArguments) {
        	*posArguments = 0; // seperate the event name from the argument
        	posArguments++; // points now to the arguments
        }

        // check if it was NOT a wake up message
        if (strcmp(receiveData, mNULL_EVENT->name))
        {
            // 2017-03-01: extension for global lock approach: protect event processing
            if(_globalLock)
            {
               (void)_globalLock->lock();
            }

            // is an argument present?
            if (posArguments)
            {
                ret = NextEventProcess(receiveData, posArguments);
            }
            else
            {
                ret = NextEventProcess(receiveData, NULL);
            }

            // 2017-03-01: extension for global lock approach: protect event processing
            if(_globalLock)
            {
               _globalLock->unlock();
            }
        }

        // free the received message
        mMQExternal->DropMessage(receiveData);

        // 2015-08-10: extension for lock and thread free SM
        if(messagesProcessed)
        {
           *messagesProcessed = true;
        }
    } else {
       // 2015-08-10: extension for lock and thread free SM
       if(true != _lockingEnabled)
       {
          // "no message" is a valid use case in case of no message received
       }
       else
       {
          ETG_TRACE_ERR(("GetMQmessage was aborted"));
       }
    }

    return ret;
}

int SMF::StateMachine_Main()
{
   ENTRY_INTERNAL

   // check for disabled thread free SM settings
   FW_NORMAL_ASSERT(true == _lockingEnabled);
   FW_NORMAL_ASSERT(false == _automaticProcessing);

   int result;

   //message/answer events
   result = CheckForInternalMessage();

   if(result != STATE_MACHINE_FINISHED)
   {
      //simple events (blocking)
      result = CheckForExternalMessage();
   }

   if(STATE_MACHINE_FINISHED == result)
   {
      /* de-register at dispatcher */
      Dispatcher::GetInstance().DeRegister(this);

      /* clear the release event - delete answer timeout */
      ClearReleaseEvent();

      /* release all the queues in use as the state machine is finished */
      DecreateComponent();

      ETG_TRACE_USR1(("Statemachine (%s) is finished",GetSMNameFull()));
   }
   return result;
}

void* SMF::GetMQmessage(MessageQueue* mq, const char *nameOfQueue, int TimeOut)
{
    ENTRY_INTERNAL
	size_t rec_bytes = 0;

    /* check if message queue was created */
    if (mq == NULL) {
        ETG_TRACE_FATAL(("message queue not created: %s", nameOfQueue));
        return NULL;
    }

    // 2015-08-10: extension for lock and thread free SM
    if(true != _lockingEnabled)
    {
       // no timeout but check if there are messages in queue before trying to read
       if(0 == mq->GetCurMessagesCount())
       {
          // no messages => return now
          return NULL;
       }
    }

    /* wait for one record in queue */
	void * RecordBuffer = mq->WaitForMessage(&rec_bytes, TimeOut);

	/* did not received anything? (timeout?) */
	if( RecordBuffer == NULL) {
		return NULL;
	}

	/* check if the received bytes match to the string len */
	if (rec_bytes != (strlen((char*)RecordBuffer) + 1))
	{
		ETG_TRACE_FATAL(("Receiving byte error: expect:%d, received:%d (%127s) - in queue: %s",
				rec_bytes, strlen((char*) RecordBuffer) + 1, (char *)RecordBuffer, nameOfQueue));
	}

	/* return the pointer to the buffer */
	return RecordBuffer ;
}

int SMF::CheckForInternalMessage(bool* messagesProcessed /*= NULL*/)
{
    ENTRY_INTERNAL

    tResult res = 0;

    /* loop over all active contexts */
    for(int iContext=0; iContext<(int)mContextDirectory.size(); iContext++) {
        tStateContext *context = mContextDirectory[iContext];

        /* is context active? */
        if (!context->active) {
#ifdef SMF_ENABLE_EVENT_DEBUGGING
         if(true == _eventDebugging)
         {
            ETG_TRACE_USR1((" CheckForInternalMessage(): context->active == 0"));
         }
#endif
            continue;
        }

        /* check if queue is still valid, if not, trace it and end this state machine */
        if (!context->MQInternal) {
            ETG_TRACE_FATAL(("not expected: internal queue already closed - finishing state machine %s", GetSMNameFull()));
            ETG_TRACE_ERRMEM(("not expected: internal queue already closed - finishing state machine %s", GetSMNameFull()));
            continue;
        }

        // is mechanism locked?
        if(context->LockStatus != MessageAnswerLock){

            char *receiveData;
            int to = 2000; //timeout in ms

            // check if there are messages in the internal queue
            if (context->MQInternal->GetCurMessagesCount()) {

                // read out the message
                receiveData = (char*)GetMQmessage(context->MQInternal, "mMQInternal", to);

                // receive data available
                if (receiveData != NULL) {

                    char *posArguments;

                    // lock the message/answer mechanism
                    context->LockStatus = MessageAnswerLock;

                    strncpy_r(OUT context->LockMessage, IN receiveData, sizeof(context->LockMessage));
                    ETG_TRACE_USR1(("CheckForInternalMessage: SM %24s locked [MAQueue] for %s", GetSMNameFull(), receiveData));

                    // get the position of the arguments
                    posArguments = strstr(receiveData, " ");

                    // arguments present?
                    if (posArguments) {
                        *posArguments = 0; // separate arguments from message name
                        posArguments++; // now the pointer points to the arguments
                    }

                    // 2017-03-01: extension for global lock approach: protect event processing
                    if(_globalLock)
                    {
                       (void)_globalLock->lock();
                    }

                    /* process the message in the context */
                    if (posArguments) { // arguments present?
                        res = NextEventProcess(receiveData, posArguments, context);
                    } else {
                        res = NextEventProcess(receiveData, NULL, context);
                    }

                    // 2017-03-01: extension for global lock approach: protect event processing
                    if(_globalLock)
                    {
                       _globalLock->unlock();
                    }

                    // free the received message
                    context->MQInternal->DropMessage(receiveData);

                    //check if MessageAnswer was consumed
                    if(res == FW_ERR_SM_NOT_CONSUMED) {
                        ETG_TRACE_ERR(("Message not consumed"));
                        /*
                         * message from message/answer pair could not be consumed
                         * read the answer away from queue and drop it
                         */

                        /* read answer from internal queue */
                        char *answer = (char *)GetMQmessage(context->MQInternal, "mMQInternal", to);
                        context->MQInternal->DropMessage(answer); // and throw it away

                        // unlock the message / answer mechanism
                        context->LockStatus=MessageAnswerUnlock;

                    } else {

                        // ETG_TRACE_USR2(("Message consumed"));
                    }
                } else {
                    ETG_TRACE_ERR(("not expected: No message in internal queue"));
                }

                // 2015-08-10: extension for lock and thread free SM
                if(messagesProcessed)
                {
                   *messagesProcessed = true;
                }
            }
        } else {
            ETG_TRACE_USR1(("CheckForInternalMessage: SM %24s is still locked [MAQueue] for %s", GetSMNameFull(), context->LockMessage));
        }

    } // loop over all active contexts

	return res;
}

bool SMF::TimerCallBack(timer_t timerID , void* instance ,const void *userData)
{
    ENTRY_INTERNAL
    (void)userData;
	SMF *self = (SMF*)instance;

	char *smName = (char *)self->mSMFullName;
	if (!smName) {
	    smName = (char *)"*DEAD*";
	}
    ETG_TRACE_USR4(("call TimerCallBack for timeout timer for SM %128s, id=%d", smName, (int)((long)timerID)));

    // send the time out message
    self->EventAnswerTimeOut();

    return 0;
}

void SMF::EventAnswerTimeOut()
{
   ENTRY_INTERNAL

   ETG_TRACE_ERR(("Answer takes too long: sending ANSWER_TIMEOUT"));

   // check the members
   if(0 == mMQExternal)
   {
      ETG_TRACE_ERRMEM((" #CONN: SMF: 0 == mMQExternal"));
      return;
   }

   void* Sendbuf = mMQExternal->CreateMessageBuffer(strlen("ANSWER_TIMEOUT") + 1);
   if(0 == Sendbuf)
   {
      ETG_TRACE_ERRMEM((" #CONN: SMF: %s: out of memory", stringIsNeverNull(mMQExternalName)));
      return;
   }

   (void)strcpy((char *)Sendbuf, "ANSWER_TIMEOUT");

   const int ret = pushMessage(*mMQExternal, Sendbuf, strlen("ANSWER_TIMEOUT") + 1, Priority_AnwerTimeOut); // org: mMQExternal->Push(Sendbuf,strlen("ANSWER_TIMEOUT") + 1, Priority_AnwerTimeOut);
   if(0 != ret)
   {
      ETG_TRACE_ERR(("Message: %127s can't be sent to queue: %127s", (char *)Sendbuf, stringIsNeverNull(mMQExternalName)));
   }

#if OLD_IMPL
   // dropBuffer
   mMQExternal->DropMessage(Sendbuf);
#endif
}

int SMF::SetAnswerTimeout(int TimeOut)
{
    ENTRY_INTERNAL

    if (!mCurrentContext) {
        return FW_ERR_SM_NO_CURRENT_CONTEXT;
    }

    mCurrentContext->AnswerTimeoutValue=TimeOut;

	return 0;
}

#if 0
int SMF::DoEventAnswer(const char *sendMessage, const char *parameter, const void *userContext)
{
	ENTRY
	int ret = 0;
	char *messageToSend;
	char *answerMessage;
	const char *answerMessageName = "SUCCESS_REQUEST";

	/* at the first time this SM is used */
	if (!mIsCreated) {

		/* create the request and answer state machine */
		Create();

		/* init it */
		ret = Init(userContext);
		if (ret) return ret;

	} else {

		// reset it
		ret = Reset(userContext);
		if (ret) return ret;
	}

	/* register SM at Dispatcher */
	Dispatcher::GetInstance().Register(this);

	/* assemble the message to send */
	if (parameter && strlen(parameter) > 0) {
		messageToSend = (char *)malloc(strlen(sendMessage) + strlen(parameter) + 2);
		if (!messageToSend) return FW_ERR_SM_NO_MEM;
		strcpy(messageToSend, sendMessage);
		strcat(messageToSend, " ");
		strcat(messageToSend, parameter);
	} else {
		messageToSend = (char *)malloc(strlen(sendMessage) + 1);
		if (!messageToSend) return FW_ERR_SM_NO_MEM;
		strcpy(messageToSend, sendMessage);
	}

	/* assemble the answer message */
	answerMessage = (char *)malloc(strlen(answerMessageName) + strlen(GetSMNameFull()) + 3);
	strcpy(answerMessage, GetSMNameFull());
	strcat(answerMessage, "::");
	strcat(answerMessage, answerMessageName);

	/* register the release event */
	// thoemel: is done in the SendMessageAnswer call of Dispatcher

	/* do the message / answer request */
	ret = Dispatcher::GetInstance().SendMessageAnswer(messageToSend, answerMessage);

	/* message sending worked: */
	if (ret == 0) {

		/* while loop until it ends with final state */
		while(STATE_MACHINE_FINISHED != StateMachine_Main()){};
	}

	/* free memory */
	free(messageToSend);
	free(answerMessage);

	/* cancel a possibly running timer */
	if (mRootState->context->AnswerTimerID) {
	    mRootState->context->AnswerTimer.CancelTimer(IN mRootState->context->AnswerTimerID);
		ETG_TRACE_USR4(("stop Answer timeout timer for SM %20s / rootContext, id=%d", mSMFullName, (int)((long)mRootState->context->AnswerTimerID)));
		mRootState->context->AnswerTimerID = 0;
	}

	/* end */
	return 0;
}
#endif

tResult SMF::RegisterReleaseEvent(const char *event, const char * parameter, const int specialTimeoutValue)
{
	ENTRY
	for (unsigned int i=0; i<mKnownEvents.size(); i++) {
		if (!strcmp(mKnownEvents[i]->name, event)) {
			return RegisterReleaseEvent(mKnownEvents[i], parameter, specialTimeoutValue);
		}
	}

	return SMF_ERR_UNKNOWN_EVENT;
}

tResult SMF::RegisterReleaseEvent(const tEvent *event, const char * parameter, const int specialTimeoutValue )
{
	ENTRY

	if (!mCurrentContext) {
	    return FW_ERR_SM_NO_CURRENT_CONTEXT;
	}

    /* clear it and disarm timer */
    ClearReleaseEvent();

    mCurrentContext->ReleaseEvent = event;
    mCurrentContext->SpecialAnswerTimeoutValue = specialTimeoutValue;

	if (parameter) {
		strncpy_r(mCurrentContext->ReleaseEventParameter, parameter,
				sizeof(mCurrentContext->ReleaseEventParameter));
	}

	int timeOutValue = specialTimeoutValue >= 0 ? specialTimeoutValue : mCurrentContext->AnswerTimeoutValue;

	// start the answer timeout timer
	if (timeOutValue) {
	    mCurrentContext->AnswerTimer.StartTimer(OUT mCurrentContext->AnswerTimerID, IN timeOutValue, 0L, IN this, IN &TimerCallBack, IN (void *)mCurrentContext->AnswerTimerID);
		ETG_TRACE_USR4(("start Answer timeout timer for SM %20s, id=%d, timeout=%d", mSMFullName, (int)((long)mCurrentContext->AnswerTimerID), timeOutValue));
	}

	return 0;
}

tResult SMF::ClearReleaseEvent()
{
    ENTRY

    if (!mCurrentContext) {
        return FW_ERR_SM_NO_CURRENT_CONTEXT;
    }

    /* is any event registered as release event? */
    if (mCurrentContext->ReleaseEvent) {
        const bool cancelTimer = mCurrentContext->SpecialAnswerTimeoutValue > 0 || (mCurrentContext->SpecialAnswerTimeoutValue == -1 && mCurrentContext->AnswerTimeoutValue > 0);
        mCurrentContext->ReleaseEvent = NULL;
        mCurrentContext->ReleaseEventParameter[0] = 0;
        mCurrentContext->SpecialAnswerTimeoutValue = -1;

        // cancel answer timeout timer
        if (cancelTimer && mCurrentContext->AnswerTimerID) {
            ETG_TRACE_USR4(("stop Answer timeout timer for SM %20s, id=%d", mSMFullName, (int)((long)mCurrentContext->AnswerTimerID)));
            mCurrentContext->AnswerTimer.CancelTimer(IN mCurrentContext->AnswerTimerID);
            mCurrentContext->AnswerTimerID = 0;
        }
    }

    return 0;
}

tResult SMF::ReleaseWaiting()
{
	ENTRY
	tResult res;

	if (!mCurrentContext) {
	    return FW_ERR_SM_NO_CURRENT_CONTEXT;
	}

	if(mCurrentContext->ReleaseEvent) {
	    res = SendEvent(mCurrentContext->ReleaseEvent, mCurrentContext->ReleaseEventParameter);
	    if (res) return res;
	}
	else {
	    ETG_TRACE_ERR(("release event is NULL -> cannot release it"));
	}

	return 0;
}

tResult SMF::SetRetryCount(int retryCount)
{
	ENTRY
	mRetryCount = retryCount;
	return 0;
}

tResult SMF::SetRetryWaitTime(unsigned long retryWaitTimeUS)
{
	ENTRY
	mUSSleepTime = retryWaitTimeUS;
	return 0;
}

char *SMF::Marshal(char *serialized, const size_t size, const char *format, ...)
{
    va_list vl;
    va_start(vl, format);
    char *bufferPtr;

    bufferPtr = Marshal(serialized, size, MARSHAL_SEPARATOR, format, vl);

    va_end(vl);

    return bufferPtr;
}

char *SMF::Marshal(char *serialized, const size_t size, const unsigned char separator, const char *format, ...)
{
    va_list vl;
    va_start(vl, format);
    char *bufferPtr;

    bufferPtr = Marshal(serialized, size, separator, format, vl);

    va_end(vl);

    return bufferPtr;
}

char *SMF::MarshalToUtf8(char *serialized, const size_t size, const unsigned char separator, const char *format, ...)
{
   char* pBuf = new char[size + 1];
   if(0 == pBuf)
   {
      ETG_TRACE_ERRMEM((" #CONN: SMF: Out of Memory"));
      return 0;
   }

   va_list vl;
   va_start(vl, format);

   Marshal(pBuf, size, separator, format, vl);
   va_end(vl);

   //convert to UTF8
   toUtf8Fake(OUT serialized, IN size, IN pBuf);
   delete [] pBuf;

   return serialized;
}

char *SMF::Marshal(char *serialized, const size_t size, const unsigned char separator, const char *format, va_list vl)
{
	char *fmt = (char *)format;
	unsigned char *ser = (unsigned char *)serialized;
	unsigned char *serEnd = (unsigned char *)serialized + size;
	char *c;

	/* init */
	*ser = 0;

	/* loop over format and arguments */
	while(*fmt) {

		switch(*fmt) {
		case 't': // text string
		    c = (char *)va_arg(vl, char *);
		    while(c != NULL && *c != 0) {
				*ser++ = *c++;
				if (ser == serEnd) {
					*ser = 0;
					return serialized;
				}
			}
			*ser++ = separator;
			*ser = 0;
			break;
		case 'i': // integer
			int integer;
			if (ser >= (serEnd - 16)) {
				*ser = 0;
				return serialized;
			}
			integer = va_arg(vl, int);
			ser = (unsigned char *)itoa(integer, (char *)ser, MARSHAL_BASE);
			*ser++ = separator;
			*ser = 0;
			break;
		case 'l': // unsigned long long
		   uint64_t ulonglong;
			if (ser >= (serEnd - 16)) {
				*ser = 0;
				return serialized;
			}
			ulonglong = va_arg(vl, uint64_t);
			ser = (unsigned char *)ulltoa(ulonglong, (char *)ser, MARSHAL_BASE);
			*ser++ = separator;
			*ser = 0;
			break;
		case 'p': // pointer
			void *pointer;
			if (ser >= (serEnd - 16)) {
				*ser = 0;
				return serialized;
			}
			pointer = va_arg(vl, void *);
			ser = (unsigned char *)lltoa((long long)pointer, (char *)ser, MARSHAL_BASE);
			*ser++ = separator;
			*ser = 0;
			break;
		default:
		    break;
		}

		/* next format */
		fmt++;
	}

	*ser = 0;
	return serialized;
}

tResult SMF::UnMarshal(const char *serialized, const char *format, ...)
{
    va_list vl;
    va_start(vl, format);
    tResult result;

    result = UnMarshal(serialized, MARSHAL_SEPARATOR, format, vl);

    va_end(vl);
    return result;
}

tResult SMF::UnMarshal(const char *serialized, const unsigned char separator, const char *format, ...)
{
    va_list vl;
    va_start(vl, format);
    tResult result;

    result = UnMarshal(serialized, separator, format, vl);

    va_end(vl);
    return result;
}

tResult SMF::UnMarshalFromUtf8(const char *serialized, const unsigned char separator, const char *format, ...)
{
   const size_t size = strlen(serialized) + 1;
   char* pBuf = new char[size];
   if(0 == pBuf)
   {
      ETG_TRACE_ERRMEM((" #CONN: SMF: Out of Memory"));
      return 0;
   }

   va_list vl;
   va_start(vl, format);

   //convert from UTF8
   fromUtf8Fake(OUT pBuf, IN size, IN serialized);

   const tResult result = UnMarshal(pBuf, separator, format, vl);
   va_end(vl);

   delete [] pBuf;
   return result;
}

tResult SMF::UnMarshal(const char *serialized, const unsigned char separator, const char *format, va_list vl)
{
	char *fmt = (char *)format;
	unsigned char *ser = (unsigned char *)serialized;
	char *c;

	/* loop over format and arguments */
	while(*fmt) {

		switch(*fmt) {
		case 'a': // take all parameters as one string
		    c = (char *)va_arg(vl, char *);
			while(*ser != 0) {
				*c++ = *ser++;
			}
			*c = 0;
			if (*ser == 0) return 0;
			ser++;
			break;
		case 't': // text string
		    c = (char *)va_arg(vl, char *);
		    while(*ser != separator && *ser != 0) {
				*c++ = *ser++;
			}
			*c = 0;
            if (*ser == 0) return 0;
			ser++;
			break;
		case 'p': // pointer
			void * *pointer;
			pointer = va_arg(vl, void **);
			if (sizeof(void *) == sizeof(unsigned long long)) {
				*pointer = (void *)strtoq((char *)ser, (char **)&ser, MARSHAL_BASE);
			} else {
				*pointer = (void *)strtol((char *)ser, (char **)&ser, MARSHAL_BASE);
			}
            if (*ser == 0) return 0;
			ser++;
			break;
		case 'i': // integer
			int *integer;
			integer = va_arg(vl, int *);
			*integer = (int)strtol((char *)ser, (char **)&ser, MARSHAL_BASE);
            if (*ser == 0) return 0;
			ser++;
			break;
		case 'l': // unsigned long long
			uint64_t *ulonglong;
			ulonglong = va_arg(vl, uint64_t *);
			*ulonglong = (uint64_t)strtoull((char *)ser, (char **)&ser, MARSHAL_BASE);
			if (*ser == 0) return 0;
			ser++;
			break;
		default:
			break;
		}

		/* next format */
		fmt++;
	}
	return 0;
}

tResult SMF::GetTargetState(OUT tState &state)
{
    if (mCurrentTrans->target) {
        state = *(tState *)(mCurrentTrans->target);
    } else if (mCurrentTrans->source) {
        state = *(tState *)(mCurrentTrans->source);
    } else {
        return -1;
    }

    return 0;
}

// 2015-08-10: extension for lock and thread free SM
void SMF::disableAllLocks(const bool automaticProcessing /*= false*/)
{
   _lockingEnabled = false;
   _automaticProcessing = automaticProcessing;

   // thread free SM together with global lock is not allowed
   FW_NORMAL_ASSERT(0 == _globalLock);
}

// 2015-08-10: extension for lock and thread free SM
tResult SMF::StateMachine_Main_Passive(bool& messagesProcessed)
{
   ENTRY_INTERNAL

   int result;
   bool intMessagesProcessed = false;
   bool extMessagesProcessed = false;

   // message/answer events
   // if there are no messages in internal queues the return value will be 0; but in case of success 0 will be returned too; maybe add a flag indicating that messages were processed
   result = CheckForInternalMessage(&intMessagesProcessed);

   // ETG_TRACE_USR1(("StateMachine_Main_Passive(): result(int)=%d intMessagesProcessed=%d", result, intMessagesProcessed));

   if (result != STATE_MACHINE_FINISHED) {

   //simple events (blocking)
       result = CheckForExternalMessage(&extMessagesProcessed);
       // ETG_TRACE_USR1(("StateMachine_Main_Passive(): result(ext)=%d extMessagesProcessed=%d", result, extMessagesProcessed));
   }

   if(STATE_MACHINE_FINISHED == result)
   {
       /* de-register at dispatcher */
       Dispatcher::GetInstance().DeRegister(this);

       /* clear the release event - delete answer timeout */
       ClearReleaseEvent();

       /* release all the queues in use as the state machine is finished */
       DecreateComponent();

       ETG_TRACE_USR1(("Statemachine (%s) is finished",GetSMNameFull()));
   }

   if((intMessagesProcessed) || (extMessagesProcessed))
   {
      messagesProcessed = true;
   }
   else
   {
      messagesProcessed = false;
   }

   return result;
}

void SMF::setGlobalLock(Lock* inputLock)
{
   _globalLock = inputLock;

   FW_NORMAL_ASSERT(0 != _globalLock);

   ETG_TRACE_COMP((" setGlobalLock(): _globalLock=0x%x", (uintptr_t)_globalLock));

   // check for mixed settings of SM with and without thread
   FW_NORMAL_ASSERT(true == _lockingEnabled);
}

void SMF::registerMaster(::fw::IEventMaster* master, const unsigned int priority)
{
   FW_IF_NULL_PTR_RETURN(master);

   _eventMaster = master;
   _eventPriority = priority;
   disableAllLocks();
}

void SMF::processEvent(void)
{
   tResult result;
   bool msgProcessed = true;

   while(true == msgProcessed)
   {
      msgProcessed = false;
      // ETG_TRACE_USR1((" doSmProcessing(): START"));
      result = StateMachine_Main_Passive(msgProcessed);
      /*
       *  0: SUCCESS
       * 14: FW_ERR_SM_NOT_CONSUMED
       * -2: STATE_MACHINE_FINISHED
       */
      if(0 == result)
      {
         // SUCCESS => OK
         ETG_TRACE_USR4((" processEvent(): result=SUCCESS msgProcessed=%d", msgProcessed));
      }
      else if(STATE_MACHINE_FINISHED == result)
      {
         // STATE_MACHINE_FINISHED => OK
         ETG_TRACE_USR4((" processEvent(): result=STATE_MACHINE_FINISHED msgProcessed=%d", msgProcessed));
         msgProcessed = false;
      }
      else if(FW_ERR_SM_NOT_CONSUMED == result)
      {
         // FW_ERR_SM_NOT_CONSUMED => NOK (we have to check)
         ETG_TRACE_ERR((" processEvent(): result=FW_ERR_SM_NOT_CONSUMED msgProcessed=%d", msgProcessed));
         FW_NORMAL_ASSERT_ALWAYS();
      }
      else
      {
         // any other unexpected error => NOK (we have to check)
         ETG_TRACE_ERR((" processEvent(): result=%d msgProcessed=%d", result, msgProcessed));
         FW_NORMAL_ASSERT_ALWAYS();
      }
   }
}

tResult SMF::pushMessage(MessageQueue& queue, const void* message, size_t msgSize, int priority)
{
   const tResult ret = queue.Push(message, msgSize, priority);

   if(0 != _eventMaster)
   {
      // trigger event for event master only in case of pushing message was successful
      if(0 == ret)
      {
         _eventMaster->push(this, _eventPriority);
      }
   }

   return ret;
}

void SMF::doEventProcessing(void)
{
   if(false == _automaticProcessing)
   {
      return;
   }

#if 0

   /*
    * use case:
    * - thread 1 is active
    * - thread 2 is only blocked at the beginning or end of this function
    * - con: it is not ensured that event was processed before this function call returns (possible scenario):
    *    # thread 1 is doing event processing
    *    # thread 2 pushes event and calls this function
    *    # thread 2 returns because event processing is active
    *    # event from thread 2 is processed in context of thread 1
    * - _eventProcessingLock shall not be static
    */

   bool returnNow;

   (void)_eventProcessingLock.lock();

   // check if event processing is already ongoing
   if(true == _eventProcessingActive)
   {
      // return now
      returnNow = true;
      // but mark event as pending
      _eventProcessingPending = true;
   }
   else
   {
      // continue
      returnNow = false;
      // and reset event pending flag
      _eventProcessingPending = false;
      // mark event processing as active
      _eventProcessingActive = true;
   }

   _eventProcessingLock.unlock();

   if(true == returnNow)
   {
      return;
   }

   bool next(true);

   while(true == next)
   {
      // passive SM handling
      tResult result;
      bool msgProcessed(true);

      while(true == msgProcessed)
      {
         msgProcessed = false;

         result = StateMachine_Main_Passive(msgProcessed);
         /*
          *  0: SUCCESS
          * 14: FW_ERR_SM_NOT_CONSUMED
          * -2: STATE_MACHINE_FINISHED
          */
         if(0 == result)
         {
            // SUCCESS => OK
            ETG_TRACE_USR4((" doEventProcessing(): result=SUCCESS msgProcessed=%d sm=%s", msgProcessed, GetSMNameFull()));
         }
         else if(STATE_MACHINE_FINISHED == result)
         {
            // STATE_MACHINE_FINISHED => OK
            ETG_TRACE_USR4((" doEventProcessing(): result=STATE_MACHINE_FINISHED msgProcessed=%d sm=%s", msgProcessed, GetSMNameFull()));
            msgProcessed = false;
         }
         else if(FW_ERR_SM_NOT_CONSUMED == result)
         {
            // FW_ERR_SM_NOT_CONSUMED => NOK (we have to check)
            ETG_TRACE_ERR((" doEventProcessing(): result=FW_ERR_SM_NOT_CONSUMED msgProcessed=%d sm=%s", msgProcessed, GetSMNameFull()));
            FW_NORMAL_ASSERT_ALWAYS();
         }
         else
         {
            // any other unexpected error => NOK (we have to check)
            ETG_TRACE_ERR((" doEventProcessing(): result=%d msgProcessed=%d sm=%s", result, msgProcessed, GetSMNameFull()));
            FW_NORMAL_ASSERT_ALWAYS();
         }
      }

      (void)_eventProcessingLock.lock();

      // check for pending event
      if(true == _eventProcessingPending)
      {
         // loop again
         // reset pending flag
         _eventProcessingPending = false;
      }
      else
      {
         // end loop
         next = false;
         // reset event processing flag
         _eventProcessingActive = false;
      }

      _eventProcessingLock.unlock();
   }

#else

   /*
    * use case:
    * - thread 1 is active
    * - thread 2 is completely blocked until thread 1 is finished with this function
    * - pro: it is ensured that event was processed before this function call returns
    * - note: it can happen that event from thread 2 is processed in context of thread 1
    * - _eventProcessingLock must be static to avoid dead lock situation
    */

   (void)_eventProcessingLock.lock();

   _eventLevelCounter++;

   ETG_TRACE_USR4((" doEventProcessing(): --- ENTER: level=%u sm=%s", _eventLevelCounter, GetSMNameFull()));

   // check if event processing is already ongoing (needed for recursive calls)
   if(true == _eventProcessingActive)
   {
      ETG_TRACE_USR4((" doEventProcessing(): --- ALREADY ACTIVE: level=%u sm=%s", _eventLevelCounter, GetSMNameFull()));

      // do nothing
   }
   else
   {
      // continue
      // mark event processing as active
      _eventProcessingActive = true;

      // passive SM handling
      tResult result;
      bool msgProcessed(true);

      while(true == msgProcessed)
      {
         msgProcessed = false;

         result = StateMachine_Main_Passive(msgProcessed);
         /*
          *  0: SUCCESS
          * 14: FW_ERR_SM_NOT_CONSUMED
          * -2: STATE_MACHINE_FINISHED
          */
         if(0 == result)
         {
            // SUCCESS => OK
            ETG_TRACE_USR4((" doEventProcessing(): result=SUCCESS msgProcessed=%d sm=%s", msgProcessed, GetSMNameFull()));
         }
         else if(STATE_MACHINE_FINISHED == result)
         {
            // STATE_MACHINE_FINISHED => OK
            ETG_TRACE_USR4((" doEventProcessing(): result=STATE_MACHINE_FINISHED msgProcessed=%d sm=%s", msgProcessed, GetSMNameFull()));
            msgProcessed = false;
         }
         else if(FW_ERR_SM_NOT_CONSUMED == result)
         {
            // FW_ERR_SM_NOT_CONSUMED => NOK (we have to check)
            ETG_TRACE_ERR((" doEventProcessing(): result=FW_ERR_SM_NOT_CONSUMED msgProcessed=%d sm=%s", msgProcessed, GetSMNameFull()));
            // happens too often --- FW_NORMAL_ASSERT_ALWAYS();
         }
         else
         {
            // any other unexpected error => NOK (we have to check)
            ETG_TRACE_ERR((" doEventProcessing(): result=%d msgProcessed=%d sm=%s", result, msgProcessed, GetSMNameFull()));
            FW_NORMAL_ASSERT_ALWAYS();
         }
      }

      // reset event processing flag
      _eventProcessingActive = false;
   }

   ETG_TRACE_USR4((" doEventProcessing(): --- EXIT: level=%u sm=%s", _eventLevelCounter, GetSMNameFull()));

   if(_eventLevelCounter) _eventLevelCounter--;

   _eventProcessingLock.unlock();

#endif
}
