/**
 * @file FwTestCommandData.cpp
 *
 * @par SW-Component
 * Framework
 *
 * @brief Test command data.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of test command data.
 */

#include "FwTestCommandData.h"
#include <cstring>

namespace fw {

TestCommandData::TestCommandData()
{
   _string[0] = '\0';
}

TestCommandData::~TestCommandData()
{
}

unsigned char TestCommandData::getU8Value(const unsigned char* data) const
{
   if(0 == data)
   {
      return 0;
   }

   return data[0];
}

unsigned short int TestCommandData::getU16Value(const unsigned char* data) const
{
   if(0 == data)
   {
      return 0;
   }

   return (unsigned short int)((data[0] << 8) | data[1]);
}

unsigned int TestCommandData::getU32Value(const unsigned char* data) const
{
   if(0 == data)
   {
      return 0;
   }

   return (((unsigned int)data[0]) << 24) | (((unsigned int)data[1]) << 16) | (((unsigned int)data[2]) << 8) | ((unsigned int)data[3]);
}

const char* TestCommandData::getStringValue(const unsigned char* data, const unsigned int length)
{
   if(0 == data)
   {
      return "";
   }

   const unsigned char* start = data;
   unsigned int l = length;

   if(sizeof(_string) <= length)
   {
      l = sizeof(_string) - 1;
   }

   if('"' == data[0])
   {
      if(0 < l)
      {
         --l;
      }
      ++start;
   }

   (void)strncpy(_string, (const char*)start, l);
   _string[l] = '\0';

   if('"' == data[0])
   {
      size_t k = strlen(_string);
      if(0 < k)
      {
         --k;
         if('"' == _string[k])
         {
            _string[k] = '\0';
         }
      }
   }

   return _string;
}

} //fw
