/**
 * @file FwErrmemPrint.cpp
 *
 * @par SW-Component
 * Framework
 *
 * @brief Error memory print.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Error memory print implementation.
 */

#include "FwErrmemPrint.h"
#include "TraceDefinitions.h"
#include "FwTrace.h"

#include <cstdio>
#include <cstring>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CONN_FRAMEWORK_GENERAL
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/FwErrmemPrint.cpp.trc.h"
#endif
#endif

namespace fw {

ErrmemPrint::ErrmemPrint()
{
}

ErrmemPrint::ErrmemPrint(const char* leadingPart, const char* expression, const unsigned int lineNumber, const char* fileName)
{
   const char* printLeadingPart(leadingPart ? leadingPart : "#CONN:");
   const char* printExpression(expression ? expression : "<empty>");
   const char* printFileName(fileName ? fileName : "<no file>");
   char buffer[230] = { 0 };

   const size_t currentSizeWithoutFileName(24 + strlen(printLeadingPart) + strlen(printExpression));
   const size_t sizeFileName(strlen(printFileName));
   const char* printFileNameStart(printFileName);

   if(sizeof(buffer) <= currentSizeWithoutFileName)
   {
      // no space for file name => will be handled by snprintf function itself
      printFileNameStart = "";
   }
   else
   {
      // remaining space for file name: sizeof(buffer) - currentSizeWithoutFileName
      if((sizeof(buffer) - currentSizeWithoutFileName) >= sizeFileName)
      {
         // enough space for file name
      }
      else
      {
         // not enough space for file name
         printFileNameStart += (sizeFileName - (sizeof(buffer) - currentSizeWithoutFileName));
      }
   }

   (void)snprintf(buffer, sizeof(buffer), "%s [%s] (Line=%u File=%s)", printLeadingPart, printExpression, lineNumber, printFileNameStart);

   ETG_TRACE_ERRMEM((" %s", buffer));
}

ErrmemPrint::~ErrmemPrint()
{
}

} //fw
