/**
 * @file FwAssert.cpp
 *
 * @par SW-Component
 * Framework
 *
 * @brief Assert definition.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Assert function is defined here.
 */

#include "FwAssert.h"

#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

#define OSAL_S_IMPORT_INTERFACE_TYPES
#include "osal_if.h"

#if OSAL_OS == OSAL_LINUX

// for next part check: \ai_osal_common\components\osal\include\osansi.h
extern "C" void OSAL_vAssertFunction(const char* exp, const char* file, unsigned int line);

namespace fw {

void AssertFunction(const char* exp, const char* file, const unsigned int line)
{
   OSAL_vAssertFunction(exp, file, line);
}

} //fw

#endif // OSAL_OS == OSAL_LINUX

#endif // VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
