/*
 * Utils.h
 *
 *  Created on: Feb 14, 2013
 *      Author:
 */

#ifndef UTILS_H_
#define UTILS_H_

#include "TraceDefinitions.h"
#include "FwAssert.h"

/**
 * macros to mark parameters data flow direction
 */
#define IN
#define OUT
#define INOUT

/**
 * definiton of the media player assert call
 */
#include <stdio.h>
#include <string>
using namespace std;

/* start of replacement section MP to FW */
#define MP_FATAL_ASSERT FW_FATAL_ASSERT
#define MP_NORMAL_ASSERT FW_NORMAL_ASSERT
/* end of replacement section MP to FW */

char *itoa(int value, char *c, int base);
char *lltoa(long long value, char *c, int base);
char *ulltoa(unsigned long long value, char *c, int base);
int toUtf8Fake(char *outBuffer, const size_t outBufferLen, const char *inBuffer);
int fromUtf8Fake(char *outBuffer, const size_t outBufferLen, const char *inBuffer);
char *strncat_r(char *dest, const char *src, size_t sizeOfDest);
char *strncpy_r(char *dest, const char *src, size_t sizeOfDest);
char *strupper(char *s);
char *strlower(char *s);
char *strtrim(char *str);
string base64_encode(unsigned char const* , unsigned int len);
string base64_decode(string const& s);
void hexDump(FILE *fp, const char *desc, void *addr, int len);
int exists(const char *fileName);

#endif /* UTILS_H_ */
