/*
 * Lock.h
 *
 *  Created on: Aug 22, 2012
 *      Author: tritonsu
 */
#ifndef LOCK_H_
#define LOCK_H_

#ifdef WIN32
#include <windows.h>
#endif

#ifdef __linux__
#include <pthread.h>
#include <assert.h>
#include <errno.h>
#endif

#include <stdio.h>

class Lock
{
public:
    Lock();
    Lock(const bool reentrant, const unsigned int sec);
    int lock();
    int tryLock();
    void unlock();
    virtual int setNotReantrant();
    virtual void setTimeout(const unsigned int sec);
    unsigned int getTimeout() {return mToValue;};
    virtual ~Lock();
    int locked() {return isLocked;};

private:
    unsigned int mToValue;
    unsigned int isLocked;
    pthread_mutex_t mutex;
};

// lock without timeout (mToValue=0) but reentrant
class LockForever : public Lock
{
public:
    LockForever();
    virtual ~LockForever();
    virtual int setNotReantrant();
    virtual void setTimeout(const unsigned int sec);
};

// lock without timeout (mToValue=0) and non reentrant
class LockForeverAndNonReentrant : public Lock
{
public:
    LockForeverAndNonReentrant();
    virtual ~LockForeverAndNonReentrant();
    virtual int setNotReantrant();
    virtual void setTimeout(const unsigned int sec);
};

class Locker {
public:
    Locker(Lock * pMutex) :
        mpMutex(pMutex) {
        if (mpMutex) {
            mpMutex->lock();
        }
    };

    ~Locker() {
        if (mpMutex) {
            mpMutex->unlock();
        }
    };

private:
    Lock* mpMutex;
};

#endif /* LOCK_H_ */
