/**
 * @file FwTestCommandServer.h
 *
 * @par SW-Component
 * Framework
 *
 * @brief Test command server.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of test command server.
 */

#ifndef _FW_TEST_COMMAND_SERVER_H_
#define _FW_TEST_COMMAND_SERVER_H_

#include <set>

namespace fw {

// class forward declarations
class ITestCommandClient;

/**
 *
 */
class TestCommandServer
{
public:
   /**
    * Get instance of test command server (reference).
    *
    * @return = reference to test command server object
    */
   static TestCommandServer& getInstance(void);

   /**
    * Initialize test command server. Internal callback handler will be registered for test command reception.
    *
    * @param[in] channel: trace channel id
    */
   void create(const unsigned int channel);

   /**
    * Deinitialize test command server. Internal callback handler will be deregistered.
    * HINT: All client handler must be deregistered before.
    */
   void destroy(void);

   /**
    * Register client handler.
    *
    * @param[in] client: client handler
    */
   void registerClient(ITestCommandClient* client) const;

   /**
    * Deregister client handler.
    *
    * @param[in] client: client handler
    */
   void deregisterClient(ITestCommandClient* client) const;

private:
   /**
    * Default constructor. Private!!!
    */
   TestCommandServer();

   /**
    * Destructor. Private!!!
    */
   virtual ~TestCommandServer();

   static ::std::set< ITestCommandClient* > _clients; /**< client list */
   bool _created; /**< flag indicating that initialization is done */
   unsigned int _channel; /**< trace channel id */

   /**
    * Trace callback handler.
    *
    * @param[in] data: test command
    */
   static void traceCallback(const unsigned char* data);
};

} //fw

#endif //_FW_TEST_COMMAND_SERVER_H_
