/**
 * @file FwSingleThread.h
 *
 * @par SW-Component
 * Framework
 *
 * @brief Single thread.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Single thread declaration.
 */

#ifndef _FW_SINGLE_THREAD_H_
#define _FW_SINGLE_THREAD_H_

#include "FwSemaphore.h"

#include <pthread.h>
#include <string>

namespace fw {

// class forward declarations
class ISingleThreadFunction;

/**
 *
 */
class SingleThread
{
public:
   /**
    * Default constructor.
    */
   SingleThread();

   /**
    * Destructor.
    */
   virtual ~SingleThread();

   /**
    * Start thread execution.
    *
    * @param[in] threadFunctionIf: thread function interface
    * @param[in] threadName: thread name
    * @param[in] arguments: arguments
    */
   void start(ISingleThreadFunction* threadFunctionIf, const ::std::string& threadName, void* arguments);

   /**
    * Stop thread execution.
    */
   void stop(void);

private:
   ISingleThreadFunction* _threadIf; /**< thread interface */
   pthread_t _handle; /**< thread handle */
   ::std::string _name; /**< thread name */
   void* _context; /**< context (arguments) */
   Semaphore _semaphore; /**< semaphore to wait for thread termination */

   /**
    * Internal thread to be used with pthread_create.
    *
    * @param[in] context: context (arguments)
    *
    * @return = 0
    */
   static void* internalThread(void* context);
};

} //fw

#endif //_FW_SINGLE_THREAD_H_
