/**
 * @file FwSemaphore.h
 *
 * @par SW-Component
 * Framework
 *
 * @brief Semaphore handling.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Semaphore handling declaration.
 */

#ifndef _FW_SEMAPHORE_H_
#define _FW_SEMAPHORE_H_

#include <semaphore.h>

namespace fw {

/**
 *
 */
class Semaphore
{
public:
   /**
    * Default constructor.
    */
   Semaphore();

   /**
    * Destructor.
    */
   virtual ~Semaphore();

   /**
    * Create.
    * <BR><B>ATTENTION: This method shall be called before semaphore is used for post() and wait() calls.</B>
    */
   void create(void);

   /**
    * Destroy.
    */
   void destroy(void);

   /**
    * Post.
    */
   void post(void);

   /**
    * Wait.
    */
   void wait(void);

private:
   bool _created; /**< created flag */
   sem_t _sem; /**< semaphore */
};

} //fw

#endif //_FW_SEMAPHORE_H_
