/**
 * @file FwISmTimerCallback.h
 *
 * @par SW-Component
 * Framework
 *
 * @brief Interface definition for SM timer callback.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for SM timer callback.
 */

#ifndef _FW_I_SM_TIMER_CALLBACK_H_
#define _FW_I_SM_TIMER_CALLBACK_H_

namespace fw {

/**
 *
 */
class ISmTimerCallback
{
public:
   /**
    * Destructor.
    */
   virtual ~ISmTimerCallback() {}

   /**
    * Handle SM timer callback.
    *
    * @param[in] message: message containing event data for SM
    */
   virtual void handleSmTimerCallback(const char* message) = 0;
};

} //fw

#endif //_FW_I_SM_TIMER_CALLBACK_H_
