/**
 * @file FwEventMaster.h
 *
 * @par SW-Component
 * Framework
 *
 * @brief Event master.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Event master declaration.
 */

#ifndef _FW_EVENT_MASTER_H_
#define _FW_EVENT_MASTER_H_

#include "FwIEventMaster.h"
#include "FwISingleThreadFunction.h"
#include "FwSingleThread.h"
#include "FwLock.h"
#include "FwSemaphore.h"

#include <vector>
#include <queue>
#include <string>

namespace fw {

/**
 *
 */
class EventMaster : public IEventMaster, public ISingleThreadFunction
{
public:
   /**
    * Default constructor.
    */
   EventMaster();

   /**
    * Destructor.
    */
   ~EventMaster();

   virtual void create(const ::std::string& threadName, const unsigned int numberPriorities = 1);

   virtual void destroy(void);

   virtual void push(IEventHandler* eventHandler, const unsigned int priority);

   virtual void threadFunction(void* arguments);

private:
   bool _created; /**< created flag */
   SingleThread _thread; /**< thread */
   LockForeverAndNonReentrant _lock; /**< lock */
   ::std::vector< ::std::queue< IEventHandler* > > _eventLists; /**< event lists */
   bool _terminate; /**< terminate flag */
   Semaphore _eventSem; /**< event semaphore */
   const ::std::string _defaultThreadName; /**< default thread name */
};

} //fw

#endif //_FW_EVENT_MASTER_H_
