
#ifndef _FUNCTION_TRACER_H_
#define _FUNCTION_TRACER_H_

/*
 * general switches:
 */
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#define FT_ON 0 /* = 1: function tracing switched on, = 0: off */
#else
#define FT_ON 0 /* = 1: function tracing switched on, = 0: off */
#endif


#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
typedef unsigned short tClassTypeFunc;
#else
typedef  const char * tClassTypeFunc;
#endif

typedef enum
{
   SYSTEM      = 3,
   COMPONENT   = 4,
   USER_1      = 5,
   USER_2      = 6,
   USER_3      = 7,
   USER_4      = 8
}tTraceLevel;


class FunctionTracer
{
	public:
        FunctionTracer(tClassTypeFunc cls, const char *name);			
		FunctionTracer(tClassTypeFunc cls, const char *name, int traceLevel);
		virtual ~FunctionTracer();
			
	private:
		FunctionTracer() {};

		const char *mName;
		int mTraceLevel;
        tClassTypeFunc mCls;
};

#if FT_ON

#define ENTRY           FunctionTracer  _t(ETG_DEFAULT_TRACE_CLASS,__PRETTY_FUNCTION__);
#define ENTRY_USR1      FunctionTracer  _t(ETG_DEFAULT_TRACE_CLASS,__PRETTY_FUNCTION__,USER_1);
#define ENTRY_USR2      FunctionTracer  _t(ETG_DEFAULT_TRACE_CLASS,__PRETTY_FUNCTION__,USER_2);
#define ENTRY_USR3      FunctionTracer  _t(ETG_DEFAULT_TRACE_CLASS,__PRETTY_FUNCTION__,USER_3);
#define ENTRY_USR4      FunctionTracer  _t(ETG_DEFAULT_TRACE_CLASS,__PRETTY_FUNCTION__,USER_4);
#define ENTRY_SYSTEM    FunctionTracer  _t(ETG_DEFAULT_TRACE_CLASS,__PRETTY_FUNCTION__,SYSTEM);
#define ENTRY_COMPONENT FunctionTracer  _t(ETG_DEFAULT_TRACE_CLASS,__PRETTY_FUNCTION__,COMPONENT);

#define ENTRY_INTERNAL  ENTRY_USR4

#else // (FT_ON) function tracing off

#define ENTRY

#define ENTRY_USR1
#define ENTRY_USR2
#define ENTRY_USR3
#define ENTRY_USR4
#define ENTRY_SYSTEM
#define ENTRY_COMPONENT

#define ENTRY_INTERNAL

#endif // FT_ON

#endif // #ifndef _FUNCTION_TRACER_H_
