/*
 * Framework_Errorcodes.h
 *
 *  Created on: Mar 22, 2013
 *      Author: tritonsu
 */

#ifndef FRAMEWORK_ERRORCODES_H_
#define FRAMEWORK_ERRORCODES_H_

/* start of replacement section MP to FW */
#define MP_NO_ERROR FW_NO_ERROR
#define MP_ERR_SM_GENERAL_ERROR  FW_ERR_SM_GENERAL_ERROR
#define MP_ERR_SM_RESET_FAILED FW_ERR_SM_RESET_FAILED
#define MP_ERR_SM_NO_INIT_TRANSITION_IN_STATEMACHINE_DEFINITION FW_ERR_SM_NO_INIT_TRANSITION_IN_STATEMACHINE_DEFINITION
#define MP_ERR_SM_NO_CURRENT_STATE FW_ERR_SM_NO_CURRENT_STATE
#define MP_ERR_SM_NO_EXTERNAL_QUEUE FW_ERR_SM_NO_EXTERNAL_QUEUE
#define MP_ERR_SM_NO_INTERNAL_QUEUE FW_ERR_SM_NO_INTERNAL_QUEUE
#define MP_ERR_SM_NO_DELAY_QUEUE FW_ERR_SM_NO_DELAY_QUEUE
#define MP_ERR_SM_NO_MEM_FOR_QUEUE_MESSAGE FW_ERR_SM_NO_MEM_FOR_QUEUE_MESSAGE
#define MP_ERR_SM_FOUND_NO_ANSWER_MESSAGE_TO_SEND FW_ERR_SM_FOUND_NO_ANSWER_MESSAGE_TO_SEND
#define MP_ERR_SM_NO_MEM_FOR_DELAY_QUEUE_MESSAGE FW_ERR_SM_NO_MEM_FOR_DELAY_QUEUE_MESSAGE
#define MP_ERR_SM_NO_DELAY_QUEUE_CREATED FW_ERR_SM_NO_DELAY_QUEUE_CREATED
#define MP_ERR_SM_NO_MEM FW_ERR_SM_NO_MEM
#define MP_ERR_SM_NOT_CONSUMED FW_ERR_SM_NOT_CONSUMED
#define MP_ERR_SM_NO_CURRENT_CONTEXT FW_ERR_SM_NO_CURRENT_CONTEXT
#define MP_ERR_QF_NO_FREE_QUEUE FW_ERR_QF_NO_FREE_QUEUE
#define MP_ERR_QF_UNKNOWN_QUEUE FW_ERR_QF_UNKNOWN_QUEUE
#define MP_ERR_DISP_GEN_ERROR FW_ERR_DISP_GEN_ERROR
#define MP_ERR_DISP_NO_MEM FW_ERR_DISP_NO_MEM
#define MP_ERR_DISP_SM_NOT_REGISTERED FW_ERR_DISP_SM_NOT_REGISTERED
#define MP_ERR_DISP_WRONG_ADRESS_FORMAT FW_ERR_DISP_WRONG_ADRESS_FORMAT
#define MP_ERR_DISP_SPAWN_RECV_THREAD FW_ERR_DISP_SPAWN_RECV_THREAD
#define MP_ERR_DISP_OPEN_DBUS FW_ERR_DISP_OPEN_DBUS
#define MP_ERR_DISP_DBUS_NO_MEM FW_ERR_DISP_DBUS_NO_MEM
#define MP_ERR_DISP_DBUS_NO_MEM_FOR_ARG FW_ERR_DISP_DBUS_NO_MEM_FOR_ARG
#define MP_ERR_DISP_DBUS_SEND FW_ERR_DISP_DBUS_SEND
#define MP_ERR_TF_NOT_INIT FW_ERR_TF_NOT_INIT
#define MP_ERR_UTF8_UNKNOWN_CHARACTER_FORMAT FW_ERR_UTF8_UNKNOWN_CHARACTER_FORMAT
#define MP_ERR_MISC_TIMEOUT FW_ERR_MISC_TIMEOUT
#define MP_LAST_ERROR_CODE FW_LAST_ERROR_CODE
/* end of replacement section MP to FW */

/*
 * error code enumeration
 */
typedef enum {

    FW_NO_ERROR,

    /* State machine error codes */
    SMF_ERR_UNKNOWN_EVENT = 1,
    FW_ERR_SM_GENERAL_ERROR ,
    FW_ERR_SM_RESET_FAILED,
    FW_ERR_SM_NO_INIT_TRANSITION_IN_STATEMACHINE_DEFINITION,
    FW_ERR_SM_NO_CURRENT_STATE,
    FW_ERR_SM_NO_EXTERNAL_QUEUE,
    FW_ERR_SM_NO_INTERNAL_QUEUE,
    FW_ERR_SM_NO_DELAY_QUEUE,
    FW_ERR_SM_NO_MEM_FOR_QUEUE_MESSAGE,
    FW_ERR_SM_FOUND_NO_ANSWER_MESSAGE_TO_SEND,
    FW_ERR_SM_NO_MEM_FOR_DELAY_QUEUE_MESSAGE,
    FW_ERR_SM_NO_DELAY_QUEUE_CREATED,
    FW_ERR_SM_NO_MEM,
    FW_ERR_SM_NOT_CONSUMED,
    FW_ERR_SM_NO_CURRENT_CONTEXT,

    /* queue factory */
    FW_ERR_QF_NO_FREE_QUEUE = 100,
    FW_ERR_QF_UNKNOWN_QUEUE,

    /* Dispatcher error codes */
    FW_ERR_DISP_GEN_ERROR = 200,
    FW_ERR_DISP_NO_MEM,
    FW_ERR_DISP_SM_NOT_REGISTERED,
    FW_ERR_DISP_WRONG_ADRESS_FORMAT,
    FW_ERR_DISP_SPAWN_RECV_THREAD,
    FW_ERR_DISP_OPEN_DBUS,
    FW_ERR_DISP_DBUS_NO_MEM,
    FW_ERR_DISP_DBUS_NO_MEM_FOR_ARG,
    FW_ERR_DISP_DBUS_SEND,

    /* thread factory */
    FW_ERR_TF_NOT_INIT = 300,

    /* utf8 */
    FW_ERR_UTF8_UNKNOWN_CHARACTER_FORMAT = 400,

    /* misc */
    FW_ERR_MISC_TIMEOUT = 500,

    FW_LAST_ERROR_CODE
} tFwError;

#endif /* FRAMEWORK_ERRORCODES_H_ */
