/**
 * @file BoschRegistry.h
 *
 * @par SW-Component
 * Framework
 *
 * @brief Bosch registry handling.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Bosch registry handling.
 */

#ifndef _BOSCH_REGISTRY_H_
#define _BOSCH_REGISTRY_H_

#include <string>

#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif

namespace fw {

/**
 *
 */
class BoschRegistry
{
public:
   /**
    * Default constructor.
    */
   BoschRegistry();

   /**
    * Destructor.
    */
   virtual ~BoschRegistry();

   /**
    * Open registry.
    *
    * @param[in] registryPath: registry path
    */
   void open(const ::std::string& registryPath);

   /**
    * Close registry.
    */
   void close(void);

   /**
    * Write registry entry.
    *
    * @param[in] key: key
    * @param[in] value: value
    */
   void write(const ::std::string& key, const ::std::string& value) const;

   /**
    * Read registry entry.
    *
    * @param[out] value: value
    * @param[in] key: key
    *
    * @return = true: reading success, false: reading failed
    */
   bool read(::std::string& value, const ::std::string& key) const;

private:
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
   OSAL_tIODescriptor _fd; /**< descriptor */
#else
   int counter; /**< counter */
#endif
};

} //fw

#endif //_BOSCH_REGISTRY_H_
