/*
 * BaseTypes.h
 *
 *  Created on: Feb 18, 2013
 *      Author: Dinesh
 */

#ifndef BASETYPES_H_
#define BASETYPES_H_

#include <stdint.h> // using <cstdint> compiler complains that std=c++0x or -std=gnu++0x compiler option must be enabled

/***********************
 * Base type definitions
 ***********************/
#if 0
/**
 * Type declaration of a general unsigned integer
 */
typedef unsigned int tUInt;
typedef unsigned int UInt;

/**
 * Type declaration of a general boolean
 */
typedef int tBoolean;
typedef int Boolean;

/**
 * this typedef is for the output wrapper only
 */
typedef unsigned char tBool;
typedef unsigned char Bool;

/**
 * Type declaration of a general signed 8 bit integer
 */
typedef signed char tS8;
typedef signed char S8;

/**
 * Type declaration of a general unsigned 8 bit integer
 */
typedef unsigned char tU8;
typedef unsigned char U8;

/**
 * Type declaration of a general unsigned 16 bit integer
 */
typedef unsigned short tU16;
typedef unsigned short U16;

/**
 * Type declaration of a general unsigned 32 bit integer
 */
#if (defined VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT) || (__WORDSIZE == 64)
typedef unsigned int tU32; /* required int is  32 bit value*/
typedef unsigned int U32; /* required int is  32 bit value*/
#else
typedef unsigned long tU32; /* required int is  32 bit value*/
typedef unsigned long U32; /* required int is  32 bit value*/
#endif

/**
 * Type declaration of a general signed 32 bit integer
 */
typedef signed int tS32;
typedef signed int S32;

/**
 * Type declaration of a general signed 64 bit integer
 */
typedef int64_t tS64;
typedef int64_t S64;

/**
 * Type declaration of a general unsigned 64 bit integer
 */
typedef uint64_t tU64;
typedef uint64_t U64;
#endif

/**
 * Type declaration of a test string
 */
typedef char tTestString[256];
#define tTestString_format "t"

#define TTESTSTRING_FORMAT tTestString_format

typedef char TestString[256];
#define TESTSTRING_FORMAT "t"

/**
 * Type declaration of a general string
 */
typedef char tGeneralString[256];
typedef char GeneralString[256];

/**
 * Type declaration for a special parameter for the request/response state machine to fetch all parameters as one string
 * Also used as general type for all parameter sent via SMF
 */
typedef char tAllParameters[4096];
#define tAllParameters_format "a"

#define TALLPARAMETERS_FORMAT tAllParameters_format

typedef char AllParameters[4096];
#define ALLPARAMETERS_FORMAT "a"


/**
 * Type declaration for return value of a function
 */
typedef int tResult;
typedef int Result;

/**
 * Type declaration of a general signed integer
 */
typedef int tInteger;
#define tInteger_format "i"
#define tInteger_init 0

#define TINTEGER_FORMAT tInteger_format
#define TINTEGER_INIT tInteger_init

typedef int Integer;
#define INTEGER_FORMAT "i"
#define INTEGER_INIT 0


#endif /* BASETYPES_H_ */
