/**
 * @file WblDbusWifiSetupFactory.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Wbl instance factory for WifiSetup.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wbl instance factory for WifiSetup.
 */

#include "WblDbusWifiSetupFactory.h"
#include "WblDbusWifiSetupProxyIf.h"

namespace ccdbusif {
namespace wbl {

WblDbusWifiSetupFactory::WblDbusWifiSetupFactory() :
_proxy(0),
_testProxy(0)
{
}

WblDbusWifiSetupFactory::~WblDbusWifiSetupFactory()
{
   _proxy = 0;
   _testProxy = 0;
}

WblDbusWifiSetupFactory& WblDbusWifiSetupFactory::getInstance(void)
{
   static WblDbusWifiSetupFactory factory;
   return factory;
}

IWblDbusWifiSetupSendRequestIf* WblDbusWifiSetupFactory::getProxy(ICcDbusIfControllerClient* client)
{
   if(0 != _proxy)
   {
      // already created
   }
   else
   {
      _proxy = new WblDbusWifiSetupProxyIf(client, _testProxy);
   }

   return _proxy;
}

void WblDbusWifiSetupFactory::destroyProxy(void)
{
   if(0 != _proxy)
   {
      delete _proxy;
      _proxy = 0;
   }
}

void WblDbusWifiSetupFactory::setProxyForTesting(IWblDbusWifiSetupTestProxyIf* testProxy)
{
   _testProxy = testProxy;
}

} //wbl
} //ccdbusif
