/**
 * @file WblDbusLastIntendedModeProxyIf.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Wbl DBUS proxy for LastIntendedMode.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wbl DBUS proxy for LastIntendedMode.
 */

#include "WblDbusLastIntendedModeProxyIf.h"
#include "WblDbusParser.h"
#include "TraceClasses.h"
#include "FwAssert.h"
#include "FwTrace.h"

using namespace ::asf::core;
using namespace ::org::bosch::wbl::LastIntendedMode;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCDBUSIF_COMMON
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/WblDbusLastIntendedModeProxyIf.cpp.trc.h"
#endif
#endif

//#define PRINT_THREAD_INFO
#undef PRINT_THREAD_INFO

namespace ccdbusif {
namespace wbl {

WblDbusLastIntendedModeProxyIf::WblDbusLastIntendedModeProxyIf(ICcDbusIfControllerClient* client) :
DbusBaseProxyIf< IWblDbusLastIntendedModeCallbackIf, LastIntendedModeProxy, IWblDbusLastIntendedModeTestProxyIf >(client)
{
}

WblDbusLastIntendedModeProxyIf::WblDbusLastIntendedModeProxyIf(ICcDbusIfControllerClient* client, IWblDbusLastIntendedModeTestProxyIf* testProxyIf) :
DbusBaseProxyIf< IWblDbusLastIntendedModeCallbackIf, LastIntendedModeProxy, IWblDbusLastIntendedModeTestProxyIf >(client, testProxyIf)
{
}

WblDbusLastIntendedModeProxyIf::~WblDbusLastIntendedModeProxyIf()
{
}

void WblDbusLastIntendedModeProxyIf::onAvailable(const boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange)
{
   for(size_t i = 0; i < getProxyListSize(); i++)
   {
      ::boost::shared_ptr< LastIntendedModeProxy >* proxyPtr(getProxy(i));
      if(0 != proxyPtr)
      {
         ::boost::shared_ptr< LastIntendedModeProxy >& myProxy = *proxyPtr;
         if((0 != myProxy.get()) && (proxy == myProxy))
         {
            (void)myProxy->sendLastIntendedModeRegister(*this);

            internalOnAvailable(ServiceState__Available == stateChange.getCurrentState(), myProxy->getDBusObjectPath(), myProxy->getDBusBusName(), convertConnectorOption2BusType(myProxy->getConnectorOptions()));
            break;
         }
      }
   }
}

void WblDbusLastIntendedModeProxyIf::onUnavailable(const boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange)
{
   for(size_t i = 0; i < getProxyListSize(); i++)
   {
      ::boost::shared_ptr< LastIntendedModeProxy >* proxyPtr(getProxy(i));
      if(0 != proxyPtr)
      {
         ::boost::shared_ptr< LastIntendedModeProxy >& myProxy = *proxyPtr;
         if((0 != myProxy.get()) && (proxy == myProxy))
         {
            myProxy->sendDeregisterAll();

            internalOnUnavailable(ServiceState__Available == stateChange.getCurrentState(), myProxy->getDBusObjectPath(), myProxy->getDBusBusName(), convertConnectorOption2BusType(myProxy->getConnectorOptions()));
            break;
         }
      }
   }
}

void WblDbusLastIntendedModeProxyIf::handleSetCallback(IWblDbusLastIntendedModeCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const DbusBusType busType /*= BUS_TYPE_SYSTEM*/)
{
   (void)(objPath);
   (void)(busName);
   (void)(busType);
   storeCallback(callbackIf, enableProxy, callbackId); // independent of path, name, type => update status to all
}

void WblDbusLastIntendedModeProxyIf::handleCreateProxy(const unsigned int callbackId, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const DbusBusType busType /*= BUS_TYPE_SYSTEM*/)
{
   internalCreateProxy(callbackId, objPath, busName, busType);
}

void WblDbusLastIntendedModeProxyIf::handleDestroyProxy(const unsigned int callbackId, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const DbusBusType busType /*= BUS_TYPE_SYSTEM*/)
{
   internalDestroyProxy(callbackId, objPath, busName, busType);
}

void WblDbusLastIntendedModeProxyIf::handleDestroyAllProxies(void)
{
   internalDestroyAllProxies();
}

void WblDbusLastIntendedModeProxyIf::handleDestroyAllRuntimeProxies(void)
{
   internalDestroyAllRuntimeProxies();
}

IDestroyAllProxies* WblDbusLastIntendedModeProxyIf::getDestroyer(void)
{
   return this;
}

void WblDbusLastIntendedModeProxyIf::setCallbackIf(IWblDbusLastIntendedModeCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const DbusBusType busType /*= BUS_TYPE_SYSTEM*/)
{
   processSetCallback(this, callbackIf, enableProxy, callbackId, objPath, busName, busType);
}

void WblDbusLastIntendedModeProxyIf::createProxyIf(const unsigned int callbackId, const bool createDirectly /*= false*/, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const DbusBusType busType /*= BUS_TYPE_SYSTEM*/)
{
   processCreateProxy(this, createDirectly, callbackId, objPath, busName, busType);
}

void WblDbusLastIntendedModeProxyIf::destroyProxyIf(const unsigned int callbackId, const bool createDirectly /*= false*/, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const DbusBusType busType /*= BUS_TYPE_SYSTEM*/)
{
   processDestroyProxy(this, createDirectly, callbackId, objPath, busName, busType);
}

act_t WblDbusLastIntendedModeProxyIf::sendLastIntendedModeGet(const unsigned int callbackId)
{
#ifdef PRINT_THREAD_INFO
   printThreadInfo("LastIntendedMode");
#endif

   act_t retAct(DEFAULT_ACT);

   if(0 != _testProxyIf)
   {
      if(true == isTestProxyAvailable()) // independent of path, name, type
      {
         retAct = _testProxyIf->sendLastIntendedModeGet(*this);
      }
   }
   else
   {
      ::boost::shared_ptr< LastIntendedModeProxy > proxy;
      if(true == isProxyAvailable(proxy)) // independent of path, name, type
      {
         retAct = proxy->sendLastIntendedModeGet(*this);
      }
   }

   addAct(callbackId, retAct);

   return retAct;
}

void WblDbusLastIntendedModeProxyIf::onLastIntendedModeError(const ::boost::shared_ptr< LastIntendedModeProxy >& proxy, const ::boost::shared_ptr< LastIntendedModeError >& error)
{
   onLastIntendedModeErrorCb(error, proxy->getDBusObjectPath(), proxy->getDBusBusName(), convertConnectorOption2BusType(proxy->getConnectorOptions()), proxy->getInterfaceName());
}

void WblDbusLastIntendedModeProxyIf::onLastIntendedModeUpdate(const ::boost::shared_ptr< LastIntendedModeProxy >& proxy, const ::boost::shared_ptr< LastIntendedModeUpdate >& update)
{
   onLastIntendedModeUpdateCb(update, proxy->getDBusObjectPath(), proxy->getDBusBusName(), convertConnectorOption2BusType(proxy->getConnectorOptions()), proxy->getInterfaceName());
}

void WblDbusLastIntendedModeProxyIf::onAvailableCb(const bool available, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const DbusBusType busType /*= BUS_TYPE_SYSTEM*/)
{
   internalOnAvailable(available, objPath, busName, busType);
}

void WblDbusLastIntendedModeProxyIf::onUnavailableCb(const bool available, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const DbusBusType busType /*= BUS_TYPE_SYSTEM*/)
{
   internalOnUnavailable(available, objPath, busName, busType);
}

void WblDbusLastIntendedModeProxyIf::onLastIntendedModeErrorCb(const ::boost::shared_ptr< LastIntendedModeError >& error, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const DbusBusType busType /*= BUS_TYPE_SYSTEM*/, const ::std::string& interfaceName /*= ::std::string()*/)
{
   IWblDbusLastIntendedModeCallbackIf* callback;
   callback = removeActAndFindCallback(error->getAct());
   if(0 != callback)
   {
      callback->onLastIntendedModeErrorCb(error, objPath, busName, busType, interfaceName);
   }
   else
   {
      for(size_t i = 0; i < getCallbackListSize(); i++)
      {
         callback = getCallbackEntry(i);
         if(0 != callback)
         {
            callback->onLastIntendedModeErrorCb(error, objPath, busName, busType, interfaceName);
         }
      }
   }
}

void WblDbusLastIntendedModeProxyIf::onLastIntendedModeUpdateCb(const ::boost::shared_ptr< LastIntendedModeUpdate >& update, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const DbusBusType busType /*= BUS_TYPE_SYSTEM*/, const ::std::string& interfaceName /*= ::std::string()*/)
{
   IWblDbusLastIntendedModeCallbackIf* callback;
   callback = removeActAndFindCallback(update->getAct());
   if(0 != callback)
   {
      callback->onLastIntendedModeUpdateCb(update, objPath, busName, busType, interfaceName);
   }
   else
   {
      for(size_t i = 0; i < getCallbackListSize(); i++)
      {
         callback = getCallbackEntry(i);
         if(0 != callback)
         {
            callback->onLastIntendedModeUpdateCb(update, objPath, busName, busType, interfaceName);
         }
      }
   }
}

void WblDbusLastIntendedModeProxyIf::internalCreateProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType)
{
#ifdef PRINT_THREAD_INFO
   printThreadInfo("LastIntendedMode");
#endif

   wbl::WblDbusParser parser;
   const ::std::string& port(parser.getPort(wbl::IF_LAST_INTENDED_MODE));
   const ::std::string& path(parser.getObjectPath(wbl::IF_LAST_INTENDED_MODE));
   const ::std::string& name(parser.getBusName(wbl::IF_LAST_INTENDED_MODE));
   const DbusBusType type(parser.getBusType(wbl::IF_LAST_INTENDED_MODE));

   // check if proxy is available
   if(false == isProxyAvailable()) // independent of path, name, type
   {
      ETG_TRACE_USR3((" internalCreateProxy(): LastIntendedMode: callbackId=%u busType=%d busName=%20s objPath=%s (create)", callbackId, busType, busName.c_str(), objPath.c_str()));

      // create proxy
      if(0 != _testProxyIf)
      {
         createTestProxy(port, path, name, type, *this);
         addTestProxy(); // independent of path, name, type
      }
      else
      {
         ::boost::shared_ptr< LastIntendedModeProxy > proxy = createProxy(port, path, name, type, *this);
         addProxy(proxy); // independent of path, name, type
      }
   }
   else
   {
      ETG_TRACE_USR3((" internalCreateProxy(): LastIntendedMode: callbackId=%u busType=%d busName=%20s objPath=%s (already done)", callbackId, busType, busName.c_str(), objPath.c_str()));

      // proxy creation was already started; either service is available or creation is ongoing
      updateCurrentAvailableStatus(callbackId, getCreationState() /* independent of path, name, type */, path, name, type);
   }
}

void WblDbusLastIntendedModeProxyIf::internalDestroyProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType)
{
#ifdef PRINT_THREAD_INFO
   printThreadInfo("LastIntendedMode");
#endif

   // HINT: destroying runtime proxy is not possible because ASF is storing a proxy "reference" internally; therefore reset() call will not causing destruction of proxy
   // HINT: due to this we explicitly have to call sendDeregisterAll() to force removing of signal registration (DBUS: member=RemoveMatch)
   // HINT: sendDeregisterAll() is automatically called during destruction of proxy
   // HINT: sendDeregisterAll() is not provided by all proxies

   // check if proxy is available
   if(true == isProxyAvailable()) // independent of path, name, type
   {
      ETG_TRACE_USR3((" internalDestroyProxy(): LastIntendedMode: callbackId=%u busType=%d busName=%20s objPath=%s (destroy)", callbackId, busType, busName.c_str(), objPath.c_str()));

      // destroy proxy
      if(0 != _testProxyIf)
      {
         wbl::WblDbusParser parser;
         const ::std::string& path(parser.getObjectPath(wbl::IF_LAST_INTENDED_MODE));
         const ::std::string& name(parser.getBusName(wbl::IF_LAST_INTENDED_MODE));
         const DbusBusType type(parser.getBusType(wbl::IF_LAST_INTENDED_MODE));

         destroyTestProxy(path, name, type);
         removeTestProxy(); // independent of path, name, type
      }
      else
      {
         ::boost::shared_ptr< LastIntendedModeProxy >* proxyPtr(getProxy()); // independent of path, name, type
         if(0 != proxyPtr)
         {
            ::boost::shared_ptr< LastIntendedModeProxy >& proxy = *proxyPtr;
            proxy->sendDeregisterAll();
         }
         removeProxy(); // independent of path, name, type
      }
   }
   else
   {
      ETG_TRACE_USR3((" internalDestroyProxy(): LastIntendedMode: callbackId=%u busType=%d busName=%20s objPath=%s (already done)", callbackId, busType, busName.c_str(), objPath.c_str()));
   }

   // NOTE: check following: second callback is registered, anything to do?
}

void WblDbusLastIntendedModeProxyIf::internalDestroyAllProxies(void)
{
#ifdef PRINT_THREAD_INFO
   printThreadInfo("LastIntendedMode");
#endif

   // HINT: sendDeregisterAll() is not provided by all proxies

   ETG_TRACE_USR3((" internalDestroyAllProxies(): LastIntendedMode"));

   // destroy all proxies
   if(0 != _testProxyIf)
   {
      destroyAllTestProxies();
      removeAllTestProxies();
   }
   else
   {
      for(size_t i = 0; i < getProxyListSize(); i++)
      {
         ::boost::shared_ptr< LastIntendedModeProxy >* proxyPtr(getProxy(i));
         if(0 != proxyPtr)
         {
            ::boost::shared_ptr< LastIntendedModeProxy >& proxy = *proxyPtr;
            proxy->sendDeregisterAll();
         }
      }
      removeAllProxies();
   }

   // remove callback information
   removeCallbacks();
}

void WblDbusLastIntendedModeProxyIf::internalDestroyAllRuntimeProxies(void)
{
   // HINT: sendDeregisterAll() is not provided by all proxies

   ETG_TRACE_USR3((" internalDestroyAllRuntimeProxies(): LastIntendedMode"));

   // destroy all runtime proxies
   // nothing to do because this is a static proxy

   // do not remove callback information
}

void WblDbusLastIntendedModeProxyIf::internalOnAvailable(const bool available, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType)
{
#ifdef PRINT_THREAD_INFO
   printThreadInfo("LastIntendedMode");
#endif

   ETG_TRACE_USR3((" internalOnAvailable(): LastIntendedMode"));

   // inform all matching callback handler
   setCreationState(available); // independent of path, name, type
   updateAvailableStatusToAll(available, objPath, busName, busType); // independent of path, name, type => update status to all
}

void WblDbusLastIntendedModeProxyIf::internalOnUnavailable(const bool available, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType)
{
#ifdef PRINT_THREAD_INFO
   printThreadInfo("LastIntendedMode");
#endif

   ETG_TRACE_USR3((" internalOnUnavailable(): LastIntendedMode"));

   // inform all matching callback handler
   setCreationState(available); // independent of path, name, type
   updateUnavailableStatusToAll(available, objPath, busName, busType); // independent of path, name, type => update status to all
}

} //wbl
} //ccdbusif
