/**
 * @file WblDbusConflictManagementFactory.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Wbl instance factory for ConflictManagement.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wbl instance factory for ConflictManagement.
 */

#include "WblDbusConflictManagementFactory.h"
#include "WblDbusConflictManagementProxyIf.h"

namespace ccdbusif {
namespace wbl {

WblDbusConflictManagementFactory::WblDbusConflictManagementFactory() :
_proxy(0),
_testProxy(0)
{
}

WblDbusConflictManagementFactory::~WblDbusConflictManagementFactory()
{
   _proxy = 0;
   _testProxy = 0;
}

WblDbusConflictManagementFactory& WblDbusConflictManagementFactory::getInstance(void)
{
   static WblDbusConflictManagementFactory factory;
   return factory;
}

IWblDbusConflictManagementSendRequestIf* WblDbusConflictManagementFactory::getProxy(ICcDbusIfControllerClient* client)
{
   if(0 != _proxy)
   {
      // already created
   }
   else
   {
      _proxy = new WblDbusConflictManagementProxyIf(client, _testProxy);
   }

   return _proxy;
}

void WblDbusConflictManagementFactory::destroyProxy(void)
{
   if(0 != _proxy)
   {
      delete _proxy;
      _proxy = 0;
   }
}

void WblDbusConflictManagementFactory::setProxyForTesting(IWblDbusConflictManagementTestProxyIf* testProxy)
{
   _testProxy = testProxy;
}

} //wbl
} //ccdbusif
