/**
 * @file WblDbusWifiSetupProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Wbl DBUS proxy for WifiSetup.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wbl DBUS proxy for WifiSetup.
 */

#ifndef _WBL_DBUS_WIFI_SETUP_PROXY_IF_H_
#define _WBL_DBUS_WIFI_SETUP_PROXY_IF_H_

#include "ISetCallback.h"
#include "ICreateProxy.h"
#include "IDestroyProxy.h"
#include "IDestroyAllProxies.h"
#include "IWblDbusWifiSetupSendRequestIf.h"
#include "IWblDbusWifiSetupCallbackIf.h"
#include "IWblDbusWifiSetupTestProxyIf.h"
#include "DbusBaseProxyIf.h"

#include "asf/core/Proxy.h" // ServiceAvailableIF
#include "org/bosch/wbl/wifisetupProxy.h"

using namespace ::asf::core;
using namespace ::org::bosch::wbl::wifisetup;

namespace ccdbusif {
namespace wbl {

/**
 * WifiSetup proxy class for Wbl interface.
 */
class WblDbusWifiSetupProxyIf :
   public ServiceAvailableIF,
   public ISetCallback< IWblDbusWifiSetupCallbackIf >,
   public ICreateProxy,
   public IDestroyProxy,
   public IDestroyAllProxies,
   public IWblDbusWifiSetupSendRequestIf,
   public DeAuthenticateStationCallbackIF,
   public ManageBandwidthCallbackIF,
   public SetRestrictionsCallbackIF,
   public ModeCallbackIF,
   public InterfaceCallbackIF,
   public MacAddressCallbackIF,
   public PowerStateCallbackIF,
   public PowerFailureReasonCallbackIF,
   public FrequencyCallbackIF,
   public CurrentOperatingChannelCallbackIF,
   public APConfigCallbackIF,
   public RestrictionsCallbackIF,
   public SupportedFrequenciesCallbackIF,
#ifdef VARIANT_S_FTR_ENABLE_CONNECTION_STATUS
   public ConnectionStatusCallbackIF,
#endif
   public IWblDbusWifiSetupCallbackIf,
   public DbusBaseProxyIf< IWblDbusWifiSetupCallbackIf, WifisetupProxy, IWblDbusWifiSetupTestProxyIf >
{
public:
   WblDbusWifiSetupProxyIf(ICcDbusIfControllerClient* client);

   WblDbusWifiSetupProxyIf(ICcDbusIfControllerClient* client, IWblDbusWifiSetupTestProxyIf* testProxyIf);

   virtual ~WblDbusWifiSetupProxyIf();

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange);

   virtual void onUnavailable(const boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   virtual void handleSetCallback(IWblDbusWifiSetupCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleCreateProxy(const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleDestroyProxy(const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleDestroyAllProxies(void);

   virtual void handleDestroyAllRuntimeProxies(void);

   // IWblDbusWifiSetupSendRequestIf implementation --- start
   virtual IDestroyAllProxies* getDestroyer(void);

   virtual void setCallbackIf(IWblDbusWifiSetupCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void createProxyIf(const unsigned int callbackId, const bool createDirectly = false, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void destroyProxyIf(const unsigned int callbackId, const bool createDirectly = false, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual act_t sendDeAuthenticateStationRequest(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& macAddress, const ::std::string& deAuthenticationMode);

   virtual act_t sendManageBandwidthRequest(const unsigned int callbackId, const ::std::string& objPath, bool allocate, const ::std::string& address, const unsigned int bandwidth);

   virtual act_t sendSetRestrictionsRequest(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& technology, const ::std::string& restriction);

   virtual act_t sendModeGet(const unsigned int callbackId, const ::std::string& objPath);

   virtual act_t sendInterfaceGet(const unsigned int callbackId, const ::std::string& objPath);

   virtual act_t sendMacAddressGet(const unsigned int callbackId, const ::std::string& objPath);

   virtual act_t sendPowerStateGet(const unsigned int callbackId, const ::std::string& objPath);

   virtual act_t sendPowerFailureReasonGet(const unsigned int callbackId, const ::std::string& objPath);

   virtual act_t sendFrequencyGet(const unsigned int callbackId, const ::std::string& objPath);

   virtual act_t sendCurrentOperatingChannelGet(const unsigned int callbackId, const ::std::string& objPath);

   virtual act_t sendAPConfigGet(const unsigned int callbackId, const ::std::string& objPath);

   virtual act_t sendRestrictionsGet(const unsigned int callbackId, const ::std::string& objPath);

   virtual act_t sendSupportedFrequenciesGet(const unsigned int callbackId, const ::std::string& objPath);

   virtual act_t sendConnectionStatusGet(const unsigned int callbackId, const ::std::string& objPath);
   // IWblDbusWifiSetupSendRequestIf implementation --- end

   // CallbackIF implementation --- start
   virtual void onDeAuthenticateStationError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< DeAuthenticateStationError >& error);

   virtual void onDeAuthenticateStationResponse(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< DeAuthenticateStationResponse >& response);

   virtual void onManageBandwidthError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< ManageBandwidthError >& error);

   virtual void onManageBandwidthResponse(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< ManageBandwidthResponse >& response);

   virtual void onSetRestrictionsError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< SetRestrictionsError >& error);

   virtual void onSetRestrictionsResponse(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< SetRestrictionsResponse >& response);

   virtual void onModeError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< ModeError >& error);

   virtual void onModeUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< ModeUpdate >& update);

   virtual void onInterfaceError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< InterfaceError >& error);

   virtual void onInterfaceUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< InterfaceUpdate >& update);

   virtual void onMacAddressError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< MacAddressError >& error);

   virtual void onMacAddressUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< MacAddressUpdate >& update);

   virtual void onPowerStateError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< PowerStateError >& error);

   virtual void onPowerStateUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< PowerStateUpdate >& update);

   virtual void onPowerFailureReasonError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< PowerFailureReasonError >& error);

   virtual void onPowerFailureReasonUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< PowerFailureReasonUpdate >& update);

   virtual void onFrequencyError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< FrequencyError >& error);

   virtual void onFrequencyUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< FrequencyUpdate >& update);

   virtual void onCurrentOperatingChannelError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< CurrentOperatingChannelError >& error);

   virtual void onCurrentOperatingChannelUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< CurrentOperatingChannelUpdate >& update);

   virtual void onAPConfigError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< APConfigError >& error);

   virtual void onAPConfigUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< APConfigUpdate >& update);

   virtual void onRestrictionsError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< RestrictionsError >& error);

   virtual void onRestrictionsUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< RestrictionsUpdate >& update);

   virtual void onSupportedFrequenciesError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< SupportedFrequenciesError >& error);

   virtual void onSupportedFrequenciesUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< SupportedFrequenciesUpdate >& update);

#ifdef VARIANT_S_FTR_ENABLE_CONNECTION_STATUS
   virtual void onConnectionStatusError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< ConnectionStatusError >& error);

   virtual void onConnectionStatusUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< ConnectionStatusUpdate >& update);
#endif
   // CallbackIF implementation --- end

   // IWblDbusWifiSetupCallbackIf implementation --- start
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void onDeAuthenticateStationErrorCb(const ::boost::shared_ptr< DeAuthenticateStationError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeAuthenticateStationResponseCb(const ::boost::shared_ptr< DeAuthenticateStationResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onManageBandwidthErrorCb(const ::boost::shared_ptr< ManageBandwidthError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onManageBandwidthResponseCb(const ::boost::shared_ptr< ManageBandwidthResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onSetRestrictionsErrorCb(const ::boost::shared_ptr< SetRestrictionsError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onSetRestrictionsResponseCb(const ::boost::shared_ptr< SetRestrictionsResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onModeErrorCb(const ::boost::shared_ptr< ModeError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onModeUpdateCb(const ::boost::shared_ptr< ModeUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onInterfaceErrorCb(const ::boost::shared_ptr< InterfaceError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onInterfaceUpdateCb(const ::boost::shared_ptr< InterfaceUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onMacAddressErrorCb(const ::boost::shared_ptr< MacAddressError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onMacAddressUpdateCb(const ::boost::shared_ptr< MacAddressUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onPowerStateErrorCb(const ::boost::shared_ptr< PowerStateError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onPowerStateUpdateCb(const ::boost::shared_ptr< PowerStateUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onPowerFailureReasonErrorCb(const ::boost::shared_ptr< PowerFailureReasonError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onPowerFailureReasonUpdateCb(const ::boost::shared_ptr< PowerFailureReasonUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onFrequencyErrorCb(const ::boost::shared_ptr< FrequencyError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onFrequencyUpdateCb(const ::boost::shared_ptr< FrequencyUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onCurrentOperatingChannelErrorCb(const ::boost::shared_ptr< CurrentOperatingChannelError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onCurrentOperatingChannelUpdateCb(const ::boost::shared_ptr< CurrentOperatingChannelUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onAPConfigErrorCb(const ::boost::shared_ptr< APConfigError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onAPConfigUpdateCb(const ::boost::shared_ptr< APConfigUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onRestrictionsErrorCb(const ::boost::shared_ptr< RestrictionsError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onRestrictionsUpdateCb(const ::boost::shared_ptr< RestrictionsUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onSupportedFrequenciesErrorCb(const ::boost::shared_ptr< SupportedFrequenciesError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onSupportedFrequenciesUpdateCb(const ::boost::shared_ptr< SupportedFrequenciesUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

#ifdef VARIANT_S_FTR_ENABLE_CONNECTION_STATUS
   virtual void onConnectionStatusErrorCb(const ::boost::shared_ptr< ConnectionStatusError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onConnectionStatusUpdateCb(const ::boost::shared_ptr< ConnectionStatusUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());
#endif
   // IWblDbusWifiSetupCallbackIf implementation --- end

protected:
   virtual void internalCreateProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   virtual void internalDestroyProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   virtual void internalDestroyAllProxies(void);

   virtual void internalDestroyAllRuntimeProxies(void);

   void internalOnAvailable(const bool available, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   void internalOnUnavailable(const bool available, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);
};

} //wbl
} //ccdbusif

#endif //_WBL_DBUS_WIFI_SETUP_PROXY_IF_H_
