/**
 * @file WblDbusWifiSetupProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Wbl DBUS Properties for WifiSetup.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wbl DBUS Properties for WifiSetup.
 */

#ifndef _WBL_DBUS_WIFI_SETUP_PROPERTIES_H_
#define _WBL_DBUS_WIFI_SETUP_PROPERTIES_H_

#include "DbusProperties.h"
#include "WblDbusTypes.h"

namespace ccdbusif {
namespace wbl {

/**
 * WifiSetup properties class for Wbl interface.
 */
class WblDbusWifiSetupProperties : public DbusProperties
{
public:
   WblDbusWifiSetupProperties();
   virtual ~WblDbusWifiSetupProperties();
};

} //wbl
} //ccdbusif

#endif //_WBL_DBUS_WIFI_SETUP_PROPERTIES_H_
