/**
 * @file WblDbusLastIntendedModeProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Wbl DBUS Properties for LastIntendedMode.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wbl DBUS Properties for LastIntendedMode.
 */

#ifndef _WBL_DBUS_LAST_INTENDED_MODE_PROPERTIES_H_
#define _WBL_DBUS_LAST_INTENDED_MODE_PROPERTIES_H_

#include "DbusProperties.h"
#include "WblDbusTypes.h"

namespace ccdbusif {
namespace wbl {

/**
 * LastIntendedMode properties class for Wbl interface.
 */
class WblDbusLastIntendedModeProperties : public DbusProperties
{
public:
   WblDbusLastIntendedModeProperties();
   virtual ~WblDbusLastIntendedModeProperties();

   LastIntendedModeProperty getProperty2Enum(const ::std::string& value) const;
   const ::std::string& getProperty2String(const LastIntendedModeProperty value) const;
   const ::std::string& getProperty2StringTrace(const LastIntendedModeProperty value) const;

   PowerState getPowerState2Enum(const ::std::string& value) const;
   const ::std::string& getPowerState2String(const PowerState value) const;
   const ::std::string& getPowerState2StringTrace(const PowerState value) const;

   WiFiMode getWiFiMode2Enum(const ::std::string& value) const;
   const ::std::string& getWiFiMode2String(const WiFiMode value) const;
   const ::std::string& getWiFiMode2StringTrace(const WiFiMode value) const;

   WiFiFrequency getWiFiFrequency2Enum(const ::std::string& value) const;
   const ::std::string& getWiFiFrequency2String(const WiFiFrequency value) const;
   const ::std::string& getWiFiFrequency2StringTrace(const WiFiFrequency value) const;

   WiFiType getWiFiType2Enum(const ::std::string& value) const;
   const ::std::string& getWiFiType2String(const WiFiType value) const;
   const ::std::string& getWiFiType2StringTrace(const WiFiType value) const;

   SupportedSetting getSupportedSetting2Enum(const ::std::string& value) const;
   const ::std::string& getSupportedSetting2String(const SupportedSetting value) const;
   const ::std::string& getSupportedSetting2StringTrace(const SupportedSetting value) const;

private:
   const ::std::string _propertyLastIntendedMode;
   const ::std::string _propertyAPConfig;
   const ::std::string _propertyPowerState;
   const ::std::string _propertyWifiMode;
   const ::std::string _propertyFrequency;
   const ::std::string _propertyType;
   const ::std::string _propertySPITechnologies;
   const ::std::string _propertyCarPlayWireless;
   const ::std::string _propertyAndroidAutoWireless;
   const ::std::string _propertyConnectionStatus;
   const ::std::string _propertyConnected;
   const ::std::string _propertyHealthIndicator;

   const ::std::string _statePoweringOn;
   const ::std::string _statePoweredOn;
   const ::std::string _statePoweringOff;
   const ::std::string _statePoweredOff;
   const ::std::string _statePowerFailure;
   const ::std::string _stateDeviceUnavailable;
   const ::std::string _stateDeviceAvailable;
   const ::std::string _stateUnknown;

   const ::std::string _modeSTA;
   const ::std::string _modeAP;
   const ::std::string _modeP2P;
   const ::std::string _modeALL;

   const ::std::string _frequency2_4_GHz;
   const ::std::string _frequency5_GHz;

   const ::std::string _typeCarPlayWireless;
   const ::std::string _typeAndroidAutoWireless;
   const ::std::string _typeNormal;
   const ::std::string _typeRestricted;
   const ::std::string _typeUnknown;

   const ::std::string _settingNotAllowed;
   const ::std::string _settingAllowed;
   const ::std::string _settingAllowedWithLimitations;

   ::std::map< std::string, int > _state2EnumList; /**< map with supported value for power state + enum pairs */
   ::std::map< int, const std::string* > _enum2StateList; /**< map with enum + supported value for power state pairs */

   ::std::map< std::string, int > _mode2EnumList; /**< map with supported value for WiFi mode + enum pairs */
   ::std::map< int, const std::string* > _enum2ModeList; /**< map with enum + supported value for WiFi mode pairs */

   ::std::map< std::string, int > _frequency2EnumList; /**< map with supported value for frequency + enum pairs */
   ::std::map< int, const std::string* > _enum2FrequencyList; /**< map with enum + supported value for frequency pairs */

   ::std::map< std::string, int > _type2EnumList; /**< map with supported value for type + enum pairs */
   ::std::map< int, const std::string* > _enum2TypeList; /**< map with enum + supported value for type pairs */

   ::std::map< std::string, int > _setting2EnumList; /**< map with supported value for supported settings + enum pairs */
   ::std::map< int, const std::string* > _enum2SettingList; /**< map with enum + supported value for supported settings pairs */
};

} //wbl
} //ccdbusif

#endif //_WBL_DBUS_LAST_INTENDED_MODE_PROPERTIES_H_
